package com.thebeastshop.pegasus.channelservice.controller.member;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.commdata.service.CommAddressService;
import com.thebeastshop.commdata.vo.CommDistrictVO;
import com.thebeastshop.common.utils.ValidationUtil;
import com.thebeastshop.kit.kafka.producer.KafkaProducerClient;
import com.thebeastshop.message.vo.SingleSmsTemplateVO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.utils.BeanUtil;
import com.thebeastshop.member.dto.ChangePasswdDTO;
import com.thebeastshop.member.dto.LoginDTO;
import com.thebeastshop.member.dto.MemberLoginQueryCondDTO;
import com.thebeastshop.member.dto.RegisterDTO;
import com.thebeastshop.member.dto.SimilarMemberDTO;
import com.thebeastshop.member.dto.VerifyMobileDTO;
import com.thebeastshop.member.enums.LoginTypeEnum;
import com.thebeastshop.member.enums.RegisterSourceEnum;
import com.thebeastshop.member.service.MemberLoginQueryService;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.service.MemberService;
import com.thebeastshop.member.service.point.MemberPointService;
import com.thebeastshop.member.vo.MemberLoginVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.member.vo.VerifiedVO;
import com.thebeastshop.member.vo.point.MemberPointVO;
import com.thebeastshop.message.enums.MsgTypeEnum;
import com.thebeastshop.message.enums.PublishTypeEnum;
import com.thebeastshop.message.service.MsgSendService;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.MemberAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.model.ChnserAccount;
import com.thebeastshop.pegasus.channelservice.service.ChnserAccountService;
import com.thebeastshop.pegasus.channelservice.vo.member.MemberCreateVO;
import com.thebeastshop.pegasus.channelservice.vo.member.MemberEditVO;
import com.thebeastshop.pegasus.channelservice.vo.member.MemberQueryVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpMemberVO;

@Controller("CommonMemberController")
@RequestMapping("/api/member")
public class MemberController {

	Logger logger = LoggerFactory.getLogger(MemberController.class);

	private PegasusChannelServiceFacade pcInstance=PegasusChannelServiceFacade.getInstance();
	
	@Autowired
	private MemberAdapter memberAdapter;
	
	@Autowired
	private MemberService memberService;
	
	@Autowired
	private MemberQueryService memberQueryService;
	
	@Autowired
	private MemberLoginQueryService memberLoginQueryService;
	
	@Autowired
    private MemberPointService memberPointService;
	
	@Autowired
	private ChnserAccountService chnserAccountService;

	@Autowired
	private KafkaProducerClient kafkaProducerClient;

	@Autowired
	private MsgSendService msgSendService;

	@Autowired
	private CommAddressService commAddressService;

	private OpMemberVO toMemberVO(MemberVO member, Integer loginType){
		MemberPointVO memberPointVO = memberPointService.getMemberPointVO(member.getId(), member.getCode());
		OpMemberVO memberVO = BeanUtil.buildFrom(member, OpMemberVO.class);
		memberVO.setPoint(memberPointVO.getCommonMemberPointValid().doubleValue());
		memberVO.setHistoryPoint(memberPointVO.getExpirelevelMemberPoint().doubleValue());
		memberVO.setMemberType(loginType);
		BigDecimal expenseValid = memberPointService.findAvailablePointByCode(member.getId(), member.getCode());
		if(expenseValid!=null){
			memberVO.setExpenseValid(expenseValid);
		}else{
			memberVO.setExpenseValid(BigDecimal.ZERO);
		}
		if(member.getDistrictId()!=null&&member.getDistrictId()>0){
			CommDistrictVO commonDistrict=commAddressService.findDistrictById(member.getDistrictId().intValue());
			if(commonDistrict!=null){
				//FULL_NAME 全名，国家-省-市-区
			  String fullName=	commonDistrict.getFullName();
			  if(StringUtils.isNotBlank(fullName)){
				String []names=  fullName.split("-");
				if(names!=null&&names.length==4){
					memberVO.setProvince(names[1]);
					memberVO.setCity(names[2]);
					memberVO.setDistrict(names[3]);
				}
			  }
			}
		}
		return memberVO;
	}

	/***
	 * 用户登录接口
	 * @param code
	 * @param data
	 * @return
	 * 对应 /beast_site/user/login
	 */
	@ApiAuth
	@RequestMapping(value="/login")
	@ResponseBody
	public JsonApiResult login(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		JSONObject json= JSONObject.parseObject(data);
		String userName=json.getString("username");
		String password=json.getString("password");
		if(StringUtils.isBlank(userName)||StringUtils.isBlank(password)){
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
		
		Integer loginType = getMemberType(userName);
		if(loginType<0){
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_NOT_EXIST.getCode(), ErrorCode.USER_LOGIN_NOT_EXIST.getMesage());
		}
		
		 LoginDTO loginVO=new LoginDTO();
		 loginVO.setLoginId(userName);
		 loginVO.setPasswd(password);
		 loginVO.setLoginType(loginType);
		 loginVO.setChannelCode(code);
		 loginVO.setAccessWay(AccessWayEnum.PC.getCode());
		 ServiceResp<MemberVO> resp = memberService.login(loginVO);
		 if(null==resp || !resp.isSuccess()){
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), resp != null ? resp.getRespMsg() : ErrorCode.USER_LOGIN_FAILED.getMesage());
		 }
		 
		 MemberQueryVO memberQueryVO=memberAdapter.common2website(resp.getBean(), loginType);

		 return JsonApiResult.ofSuccessResult(memberQueryVO);
	}

	/***
	 * 手机用户注册
	 * @param code
	 * @param data
	 * @return
	 * 对应 /beast_site/user/mobile/reg
	 */
	@ApiAuth
	@RequestMapping(value="/mobile/register")
	@ResponseBody
	public JsonApiResult mobileRegister(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		MemberCreateVO memberCreateVO=JSONObject.parseObject(data,MemberCreateVO.class);
		RegisterDTO memberRegisterDTO=new RegisterDTO();
		memberRegisterDTO.setGender(memberCreateVO.getSex());
		memberRegisterDTO.setMobile(memberCreateVO.getMobile());
		memberRegisterDTO.setLoginType(LoginTypeEnum.MOBILE.getCode());
		memberRegisterDTO.setNickName(memberCreateVO.getName());
		memberRegisterDTO.setPassword(memberCreateVO.getPassword());
		memberRegisterDTO.setRegisterSource(RegisterSourceEnum.PC.getCode());
		memberRegisterDTO.setTitle(memberCreateVO.getTitle());
		memberRegisterDTO.setLoginId(memberCreateVO.getMobile());
		memberRegisterDTO.setBirthday(memberCreateVO.getBirthday());
		memberRegisterDTO.setChannelCode(code);
		memberRegisterDTO.setAccessWay(AccessWayEnum.PC.getCode());
		ServiceResp<MemberVO> resp = memberService.register(memberRegisterDTO);
		if(resp ==null || !resp.isSuccess()){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), resp != null ? resp.getRespMsg() : ErrorCode.USER_LOGIN_FAILED.getMesage());	
		}
		// 注册成功发送短信通知
		SingleSmsTemplateVO smsTemplateVO  = new SingleSmsTemplateVO();
		smsTemplateVO.setMsgTo(memberCreateVO.getMobile());
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("passwd", memberCreateVO.getPassword());
		smsTemplateVO.setTemplateName("REGISTER_SUCCESS_IPOS");
		smsTemplateVO.setParams(params);
		smsTemplateVO.setMsgType(MsgTypeEnum.SmsMsg);
		smsTemplateVO.setPublishType(PublishTypeEnum.IDENTIFYING_CODE);
		msgSendService.sendInterfaceVOTemplate(Arrays.asList(smsTemplateVO));

		MemberQueryVO memberQueryVO = memberAdapter.common2website(resp.getBean(), memberRegisterDTO.getLoginType());
		return JsonApiResult.ofSuccessResult(memberQueryVO);
	}
	
	
	/***
	 * 更新用户信息接口
	 * @param code
	 * @param data
	 * @return
	 * 对应 /beast_site/user/update
	 */
	@ApiAuth
	@RequestMapping(value="/update")
	@ResponseBody
	public JsonApiResult update(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		MemberEditVO memberEditVO=JSONObject.parseObject(data,MemberEditVO.class);
		MemberVO memberUpdateVO = new MemberVO();
		memberUpdateVO.setAddress(memberEditVO.getStreet());
		memberUpdateVO.setConstellation(memberEditVO.getConstellation());
		memberUpdateVO.setDegree(memberEditVO.getDegree());
		memberUpdateVO.setId(memberEditVO.getMemberId());
		memberUpdateVO.setMobile(memberEditVO.getMagentoMobile());
		memberUpdateVO.setNickName(memberEditVO.getMagentoName());
		memberUpdateVO.setDistrictId(memberEditVO.getDistrictId());
		memberUpdateVO.setJob(memberEditVO.getProfession());
		memberUpdateVO.setTitle(memberEditVO.getTitle());
		memberUpdateVO.setZipCode(memberEditVO.getZip());
		memberUpdateVO.setPhone(memberEditVO.getMagentoPhone());
		memberUpdateVO.setBirthday(memberEditVO.getBirthday());
		ServiceResp<Object> resp = memberService.modifyMember(memberUpdateVO);
		if(resp!=null && resp.isSuccess()){
			return JsonApiResult.ofSuccessResult(true);
		}
		return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
	}
	
	/***
	 * 根据用户id查询用户信息接口
	 * @param code
	 * @param data
	 * @return
	 * 对应/beast_site/user/info
	 */
	@ApiAuth
	@RequestMapping(value="/info")
	@ResponseBody
	public JsonApiResult userInfo(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject jsonData=JSONObject.parseObject(data);
		Long memberId=jsonData.getLong("memberId");
		if(memberId==null||memberId<1){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		MemberVO memberVO = memberQueryService.getById(memberId);
		if(memberVO==null){
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		MemberQueryVO vo=memberAdapter.common2website(memberVO);
		return JsonApiResult.ofSuccessResult(vo);
	}
	
	/***
	 * 邮件账户重置密码验证链接
	 * @param code
	 * @param data
	 * @return
	 * 对应 /beast_site/mail/notice/resetpwd
	 */
	@ApiAuth
	@RequestMapping(value="/mail/resetpwd/link")
	@ResponseBody
	public JsonApiResult emailRestpwdLink(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject jsonData=JSONObject.parseObject(data);
		String email=jsonData.getString("email");
		String emailContent=jsonData.getString("emailContent");
		if(StringUtils.isBlank(email)||StringUtils.isBlank(emailContent)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		
		if(pcInstance.sendMail(email, emailContent)){
		    return JsonApiResult.ofSuccessResult(true);
		}
		return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
	}
	
	/***
	 * 邮件账户重置密码
	 * @param code
	 * @param data
	 * @return
	 * 对应 /beast_site/mail/resetpwd
	 */
	@ApiAuth
	@RequestMapping(value="/mail/resetpwd")
	@ResponseBody
	public JsonApiResult emailRestpwd(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject jsonData=JSONObject.parseObject(data);
		String email=jsonData.getString("email");
		String newPwd=jsonData.getString("newPassword");
		if(StringUtils.isBlank(email)||StringUtils.isBlank(newPwd)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		ChangePasswdDTO dto = new ChangePasswdDTO();
		dto.setLoginType(LoginTypeEnum.EMAIL.getCode());
		dto.setLoginId(email);
		dto.setNewPasswd(newPwd);
		ServiceResp<Boolean> resp = memberService.changePasswd(dto);
		if(resp != null && resp.isSuccess()){
			return JsonApiResult.ofSuccessResult(resp.getBean());
		}
		return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
	}
	
	
	/***
	 * 编辑信息 根据旧密码。重置密码 
	 * @param code
	 * @param data
	 * @return
	 * 对应/beast_site/user/resetpwd
	 */
	@ApiAuth
	@RequestMapping(value="/resetpwd")
	@ResponseBody
	public JsonApiResult restPwd(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject jsonData=JSONObject.parseObject(data);
		String loginId=jsonData.getString("account");
		String oldPwd=jsonData.getString("oldPassword");
		String newPwd=jsonData.getString("newPassword");
		if(StringUtils.isBlank(loginId)||StringUtils.isBlank(oldPwd)||StringUtils.isBlank(newPwd)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		Integer memberType=getMemberType(loginId);
		if(memberType !=-1){
			ChangePasswdDTO dto = new ChangePasswdDTO();
			dto.setLoginType(memberType);
			dto.setLoginId(loginId);
			dto.setOldPasswd(oldPwd);
			dto.setNewPasswd(newPwd);
			ServiceResp<Boolean> resp = memberService.changePasswd(dto);
			if(resp != null && resp.isSuccess() && resp.getBean()){
				return JsonApiResult.ofSuccessResult(true);
			}
		}
		return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), ErrorCode.USER_LOGIN_FAILED.getMesage());
	}
	
	/***
	 * 根据手机号。重置密码 
	 * @param code
	 * @param data
	 * @return
	 * 对应/beast_site/user/mobile/resetpwd
	 */
	@ApiAuth
	@RequestMapping(value="/mobile/resetpwd")
	@ResponseBody
	public JsonApiResult mobileResetpwd(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject jsonData=JSONObject.parseObject(data);
		String mobile=jsonData.getString("mobile");
		String newPwd=jsonData.getString("newPassword");
		if(StringUtils.isBlank(mobile)||StringUtils.isBlank(newPwd)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		ChangePasswdDTO dto = new ChangePasswdDTO();
		dto.setLoginType(LoginTypeEnum.MOBILE.getCode());
		dto.setLoginId(mobile);
		dto.setNewPasswd(newPwd);
		ServiceResp<Boolean> resp = memberService.changePasswd(dto);
		if(resp != null && resp.isSuccess() && resp.getBean()){
			// 注册成功发送短信通知
			SingleSmsTemplateVO smsTemplateVO  = new SingleSmsTemplateVO();
			smsTemplateVO.setMsgTo(mobile);
			Map<String, Object> params = new HashMap<String, Object>();
	        params.put("passwd", newPwd);
			/**
			 * 短信传入模板参数
			 */
			smsTemplateVO.setTemplateName("PASSWD_EDIT");
			smsTemplateVO.setParams(params);

			smsTemplateVO.setMsgType(MsgTypeEnum.SmsMsg);
			smsTemplateVO.setPublishType(PublishTypeEnum.IDENTIFYING_CODE);
			msgSendService.sendInterfaceVOTemplate(Arrays.asList(smsTemplateVO));

	    	return JsonApiResult.ofSuccessResult(true);
	    }
		return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
	}
	
	/***
	 *微博登陆
	 * @param code
	 * @param data
	 * @return
	 * 对应/beast_site/user/weibo/login
	 */
	@ApiAuth
	@RequestMapping(value="/weibo/login")
	@ResponseBody
	public JsonApiResult weiboLogin(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject jsonData = JSONObject.parseObject(data);
		String weiboId = jsonData.getString("wbId");
		if (StringUtils.isBlank(weiboId)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		LoginDTO loginVO = new LoginDTO();
		loginVO.setLoginId(weiboId);
		loginVO.setLoginType(LoginTypeEnum.WEIBO.getCode());
		loginVO.setChannelCode(code);
		loginVO.setAccessWay(AccessWayEnum.PC.getCode());
		ServiceResp<MemberVO> resp = memberService.login(loginVO);
		if (null == resp || !resp.isSuccess()) {
			return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
		}
		MemberQueryVO vo = memberAdapter.common2website(resp.getBean(), LoginTypeEnum.WEIBO.getCode());
		return JsonApiResult.ofSuccessResult(vo);
	}
	
	/***
	 *微信登陆
	 * @param code
	 * @param data
	 * @return
	 * 
	 */
	@ApiAuth
	@RequestMapping(value="/weixin/login")
	@ResponseBody
	public JsonApiResult weixinLogin(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		logger.info("微信登录，code={}, data={}", code, data);
		JSONObject jsonData=JSONObject.parseObject(data);
		String weixinId=jsonData.getString("wxId");
		String nickName=jsonData.getString("nickName");
		if(StringUtils.isBlank(nickName)){
			nickName="微信用户";
		}
		String unionId = jsonData.getString("unionId");
		
		if("null".equals(unionId)){
			unionId = null;
		}
		if(StringUtils.isBlank(weixinId)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		LoginDTO loginVO = new LoginDTO();
		loginVO.setLoginId(weixinId);
		loginVO.setLoginType(LoginTypeEnum.WEIXIN.getCode());
		loginVO.setUnionId(unionId);
		loginVO.setNickName(nickName);
		loginVO.setChannelCode(code);
		loginVO.setAccessWay(AccessWayEnum.WAP.getCode());
		ServiceResp<MemberVO> resp = memberService.login(loginVO);
		if (null == resp || !resp.isSuccess()) {
			return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
		}
		MemberQueryVO vo=memberAdapter.common2website(resp.getBean(), LoginTypeEnum.WEIXIN.getCode());
		return JsonApiResult.ofSuccessResult(vo);
	}
	
	/***
	 * 根据用户登陆名称，返回用户类型,只有手机用户和邮箱用户，可以根据旧密码，修改新密码
	 * @param loginId
	 * @return
	 */
	private Integer getMemberType(String loginId){
		if(ValidationUtil.isEmail(loginId)){
			return LoginTypeEnum.EMAIL.getCode();
		}
		if(ValidationUtil.isMobile(loginId)){
			return LoginTypeEnum.MOBILE.getCode();
		}
		return -1;
	}
	
	/***
	 * 查询类似是同一个用户的会员
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value="/similarMember")
	@ResponseBody
	public JsonApiResult similarMember(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject json=JSONObject.parseObject(data);
		String loginId=json.getString("loginId");
		if(StringUtils.isBlank(loginId)){
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
		
		Integer loginType = getMemberType(loginId);
		if(loginType<0){
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
		SimilarMemberDTO dto = new SimilarMemberDTO();
		dto.setLoginId(loginId);
		dto.setLoginType(loginType);
		dto.setChannelCode(code);
		MemberVO memberVo = memberQueryService.getSimilarMember(dto);
		if(null==memberVo){
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		 MemberQueryVO userVO=memberAdapter.common2website(memberVo);
		 return JsonApiResult.ofSuccessResult(userVO);
	}
	
	/***
	 * 根据手机号或者邮箱。查询用户(最多凡返回三个)
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value="/searchList")
	@ResponseBody
	public JsonApiResult searchList(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		JSONObject json = JSONObject.parseObject(data);
		String username = json.getString("username");

		if (StringUtils.isBlank(username)) {
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(),
					ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
		List<OpMemberVO> list = null;
		List<MemberVO> members = memberQueryService.getMemberByCellPhoneOrEmail(username);
		if (CollectionUtils.isNotEmpty(members)) {
			list = Lists.newArrayListWithExpectedSize(members.size());
			MemberLoginQueryCondDTO cond = null;
			Integer loginType = null;
			for (MemberVO member : members) {
				//cond = new MemberLoginQueryCondDTO();
				//cond.setMemberId(member.getId());
				//cond.setLoginTypes(Lists.newArrayList(LoginTypeEnum.EMAIL.getCode(), LoginTypeEnum.MOBILE.getCode()));
				List<MemberLoginVO> logins = memberLoginQueryService.getByMemberId(member.getId());
				if (CollectionUtils.isNotEmpty(logins)) {
					loginType = logins.get(0).getLoginType();
					for(MemberLoginVO vo:logins){
						if(vo.getLoginType()==1){
							loginType = vo.getLoginType();
						}
					}
				} else {
					loginType = null;
				}
				list.add(toMemberVO(member, loginType));
			}
		}
		return JsonApiResult.ofSuccessResult(list);
	}
	
	/***
	 * 实体店登陆
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value="/shoplogin")
	@ResponseBody
	public JsonApiResult shopUserLogin(@RequestParam("CODE") String code,@RequestParam("DATA") String data){
		JSONObject jsonData=JSONObject.parseObject(data);

		String signKey=jsonData.getString("signKey");
		if(StringUtils.isBlank(signKey)){
			return JsonApiResult.ofErrorResult(ErrorCode.AUTHFAILED_MISS_PARAMS.getCode(), ErrorCode.AUTHFAILED_MISS_PARAMS.getMesage());
		
		}
		
		ChnserAccount chnserAccount = chnserAccountService.login(code, signKey);

		if(chnserAccount!=null){
		    return JsonApiResult.ofSuccessResult(chnserAccount);
			
		}
		
		return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(),ErrorCode.USER_LOGIN_FAILED.getMesage());
	}
	
	/***
	 * 会员绑定手机号
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/bindCellphone")
	@ResponseBody
	public JsonApiResult bindCellphone(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {

		JSONObject json = JSONObject.parseObject(data);
		Long memberId = json.getLong("memberId");
		String cellphone = json.getString("cellphone");
		if (memberId == null || StringUtils.isBlank(cellphone)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					(ErrorCode.PARAMS_ILLEGAL.getMesage()));
		}
		VerifyMobileDTO dto = new VerifyMobileDTO();
		dto.setMemberId(memberId);
		dto.setVerifiedMobile(cellphone);
		dto.setChannelCode(code);
		dto.setAccessWay(AccessWayEnum.PC.getCode());
		ServiceResp<VerifiedVO> resp = memberService.verifyMobile(dto);
		if (null != resp && resp.isSuccess()) {
			// 如果为true 这发送所有的卡券
			try {
				kafkaProducerClient.send("coupon_send",memberId);
			} catch (Exception e) {

			}
			return JsonApiResult.ofSuccessResult(true);
		}
		return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), (ErrorCode.PARAMS_ILLEGAL.getMesage()));
	}
	
	/***
	 * 根据手机号或者邮箱。查询用户
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value="/searchByLoginId")
	@ResponseBody
	public JsonApiResult searchByLoginId(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		JSONObject json= JSONObject.parseObject(data);
		String loginId=json.getString("loginId");
	
		if(StringUtils.isBlank(loginId)){
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
         if(getMemberType(loginId)==-1){
        	 return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
         }
         OpMemberVO memberVO = null;
         MemberLoginQueryCondDTO dto = new MemberLoginQueryCondDTO();
         dto.setLoginId(loginId);
         dto.setLoginType(getMemberType(loginId));
         List<MemberLoginVO> list = memberLoginQueryService.getByCond(dto);
         if(CollectionUtils.isNotEmpty(list)){
        	 MemberLoginVO memberLogin=list.get(0);
        	 memberVO = toMemberVO(memberQueryService.getById(memberLogin.getMemberId()), memberLogin.getLoginType()) ;
         }
         if(null==memberVO){
    		 return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_NOT_EXIST.getCode(), ErrorCode.USER_LOGIN_NOT_EXIST.getMesage());
    	 }
		 return JsonApiResult.ofSuccessResult(memberVO);
	}
}
