package com.thebeastshop.pegasus.channelservice.controller.member;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

import com.thebeastshop.member.util.DateTool;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.member.dto.LoginDTO;
import com.thebeastshop.member.enums.LoginTypeEnum;
import com.thebeastshop.member.service.MemberLoginQueryService;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.service.MemberService;
import com.thebeastshop.member.service.point.MemberPointService;
import com.thebeastshop.member.vo.MemberLoginVO;
import com.thebeastshop.member.vo.point.MemberPointVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.component.support.service.RedisService;

/**
 * 这是给前端人得到 官网的 用户信息的接口
 * create by com.thebeastshop.pegasus.channelservice.controller.member trunk :author lijing
 * User:lijing
 * DATE : 2017/3/24
 * TIME : 11:30
 * trunk.
 */
@Controller
@RequestMapping("/front/")
public class FrontMemberController {
    /***logger 日志*/
    private final static Logger logger = LoggerFactory.getLogger(FrontMemberController.class);
    @Autowired
    private MemberQueryService memberQueryService;
    @Autowired
    private MemberLoginQueryService memberLoginQueryService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private MemberPointService memberPointService;
    /**redis*/
    protected static final RedisService redisService = ComponentServiceLoader.getBean(RedisService.class);
    /***
     * 官网redis key
     */
    private static final String PC_REDIS_SESSION_KEY = "SESSION_ID_";
    /***
     * 得到官网用户信息
     * @param sessionId
     * @return  包装的vo 和memberVO 一样
     */
    @RequestMapping(value="/loginUser",method = RequestMethod.GET)
    @ResponseBody
    public JsonApiResult login(@RequestParam("sessionId") String sessionId){
       try{
           if(StringUtils.isBlank(sessionId)){
               return JsonApiResult.ofErrorResult(400,"参数错误!");
           }
           String memberId= redisService.get(PC_REDIS_SESSION_KEY + sessionId);
           if(StringUtils.isBlank(memberId)){
               return JsonApiResult.ofErrorResult(400,"用户不存在!");
           }
           com.thebeastshop.member.vo.MemberVO member = memberQueryService.getById(Long.valueOf(memberId));
           List<MemberLoginVO> logins = new ArrayList<>();
           if(null != member){
        	   logins.addAll(memberLoginQueryService.getByMemberId(member.getId()));
           }
           MemberVO memberVO = convertMemberVO(member,logins);
           return JsonApiResult.ofSuccessResult(memberVO);
       }catch (Exception e){
           logger.error("查询官网用户信息错误 e={}",e);
           return JsonApiResult.ofErrorResult(404,"系统错误");
       }
    }
    /**
     * 微信登陆  给前端用的
     * @param code
     * @param data
     * @return
     */
    @ApiAuth
    @RequestMapping(value="/weixinlogin")
    @ResponseBody
    public JsonApiResult weixinlogin(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
        JSONObject jsonData=JSONObject.parseObject(data);
        String weixinId=jsonData.getString("wxId");
        String nickName=jsonData.getString("nickName");
        String unionId = jsonData.getString("unionId");
        
        if("null".equals(unionId)){
			unionId = null;
		}
        if(StringUtils.isBlank(weixinId)){
            return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),ErrorCode.PARAMS_ILLEGAL.getMesage());
        }
        if(StringUtils.isBlank(nickName)){
            nickName="微信用户";
        }
        LoginDTO loginVO = new LoginDTO();
        loginVO.setLoginId(weixinId);
        loginVO.setLoginType(LoginTypeEnum.WEIXIN.getCode());
        loginVO.setUnionId(unionId);
        loginVO.setNickName(nickName);
        loginVO.setChannelCode(code);
        loginVO.setAccessWay(AccessWayEnum.PC.getCode());
        ServiceResp<com.thebeastshop.member.vo.MemberVO> resp = memberService.login(loginVO);
        if (null == resp || !resp.isSuccess()) {
            return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
        }
        com.thebeastshop.member.vo.MemberVO member = resp.getBean();
        List<MemberLoginVO> logins = new ArrayList<>();
        if(null != member){
            logins.addAll(memberLoginQueryService.getByMemberId(member.getId()));
        }
        MemberVO memberVOr = convertMemberVO(member, logins);
        if(null != memberVOr && null != member) {
            memberVOr.setMemberId(member.getId());
        }
            return JsonApiResult.ofSuccessResult(memberVOr);
    }

    /**
     * 转换对象 为 app 的VO 给前端
     * @param member
     * @param opMemberLoginList
     * @return
     */
    private MemberVO convertMemberVO(com.thebeastshop.member.vo.MemberVO member,List<MemberLoginVO> opMemberLoginList){
            MemberVO memberVO =  null;
               if(null != member){
                   memberVO = new MemberVO();
                   // ==============loginMethods==============
                   List<MemberVO.LoginMethod> loginMethods = memberVO.getLoginMethods();
                   if (CollectionUtils.isNotEmpty(opMemberLoginList)) {
                       for (MemberLoginVO memberLogin : opMemberLoginList) {
                           if (memberLogin != null) {
                        	   LoginTypeEnum loginType = LoginTypeEnum.getEnumByCode(memberLogin.getLoginType());
                               String mobileCode = StringUtils.isNotBlank(memberLogin.getMobileCode())
                                       ? memberLogin.getMobileCode() : "+86";
                               MemberVO.LoginMethod e = new MemberVO.LoginMethod(loginType, memberLogin.getLoginId(), memberLogin.getUnionId(),
                                       mobileCode);
                               loginMethods.add(e);
                           }
                       }
                   }
                   // ==============id==============
                   memberVO.setId(member.getCode());
                   // ==============createTime==============
                   memberVO.setCreateTime(member.getRegisterTime());
                   // ==============profile==============
                   MemberVO.ProfileVO profile = memberVO.getProfile();
                   if (member.getNickName() != null) {
                       profile.setNickName(member.getNickName());
                   }
                   if (member.getAvatarUrl() != null) {
                       profile.setAvatarUrl(member.getAvatarUrl());
                   }
                   if (member.getBirthday() != null) {
                       String data = DateTool.date2String(member.getBirthday(),DateTool.FORMAT_DATE);
                       profile.setBirthday(data);
                       profile.setBirthdayEditable(false);
                   } else {
                       profile.setBirthdayEditable(true);
                   }
                   MemberVO.TitleVO titleVO = new MemberVO.TitleVO();
                   if (member.getTitle() != null) {
                       setTitleVOContent(member.getTitle(),titleVO);
                   }
                   profile.setTitle(titleVO);
                   // ==============mobile==============
                   if (StringUtils.isNotBlank(member.getVerifiedMobile())) {
                       memberVO.setMobile(member.getVerifiedMobile());
                   }
                   // ==============mobileAreaCode==============
                   if (StringUtils.isNotBlank(member.getMobileCode())) {
                       memberVO.setMobileAreaCode(member.getMobileCode());
                   } else {
                       memberVO.setMobileAreaCode("+86");
                   }
                   // ==============level==============
                   if (member.getMemberLevel() != null) {
                       MemberVO.LevelVO levelVO = memberVO.getLevel();
                       setMemberLevel(member.getMemberLevel(),levelVO);
                   }
                   // ==============point==============
                   MemberPointVO memberPoint = memberPointService.getMemberPointVO(member.getId(), member.getCode());
                   if (memberPoint.getCommonMemberPointValid() != null) {
                       memberVO.setPoint(memberPoint.getCommonMemberPointValid().setScale(0, RoundingMode.HALF_UP));// 积分四舍五入保留整数
                   } else {
                       memberVO.setPoint(BigDecimal.ZERO);
                   }
                   // =================================
                   return memberVO;
               }

            return memberVO;
    }

    /**
     * 设置标题 内容
     * @param titleId
     * @param titleVO
     */
    private void setTitleVOContent(Integer titleId,MemberVO.TitleVO titleVO){
        if(null != titleId){
            int c = titleId.intValue();
            switch (c) {
                case 1:
                    titleVO.setId(1);
                    titleVO.setName("先生");
                    break;
                case 2:
                    titleVO.setId(2);
                    titleVO.setName("女士");
                    break;
                case 3:
                    titleVO.setId(3);
                    titleVO.setName("小姐");
                    break;
                case 4:
                    titleVO.setId(4);
                    titleVO.setName("保密");
                    break;
            }
        }
    }
    /**
     * 设置等级
     * @param memberLevel
     * @param levelVO
     */
    private void setMemberLevel(Integer memberLevel,MemberVO.LevelVO levelVO){
        if(null != memberLevel){
            int c = memberLevel.intValue();
            switch (c){
                case -1 : levelVO.setId(-1);levelVO.setName("注册会员");break;
                case 0 : levelVO.setId(0);levelVO.setName("松鼠会员");break;
                case 1 : levelVO.setId(1);levelVO.setName("小猫会员");break;
                case 2 : levelVO.setId(2);levelVO.setName("老虎会员");break;
                case 3 : levelVO.setId(3);levelVO.setName("大象会员");break;
            }
        }
    }


}
