package com.thebeastshop.pegasus.channelservice.controller.lottery;

import java.math.RoundingMode;
import java.util.List;

import com.thebeastshop.common.utils.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.campaign.cond.LotteryActivityDto;
import com.thebeastshop.campaign.cond.LotteryActivityExtraChanceDto;
import com.thebeastshop.campaign.enums.ChanceSourceEnum;
import com.thebeastshop.campaign.exception.LotteryActivityErrorEnum;
import com.thebeastshop.campaign.service.LotteryActivityQueryService;
import com.thebeastshop.campaign.service.LotteryActivityService;
import com.thebeastshop.campaign.vo.LotteryActivityDrawResultVO;
import com.thebeastshop.campaign.vo.LotteryActivityRecordVO;
import com.thebeastshop.campaign.vo.LotteryActivityVO;
import com.thebeastshop.campaign.vo.LotteryInterestGoodsVO;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.service.point.MemberPointService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.member.vo.point.MemberPointVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartInterestAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.redenvelope.RedEnvelopeAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.redenvelope.RedEnvelopeReceivedAdapter;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.pegasus.channelservice.model.OrderRedEnvelope;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelope;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.common.utils.NullUtil;
import com.thebeastshop.scm.vo.interest.InterestGoodsGetVO;
import com.thebeastshop.support.enums.LotteryType;
import com.thebeastshop.support.util.SensitiveInfoUtils;
import com.thebeastshop.support.vo.lottery.DrawLotteryVO;
import com.thebeastshop.support.vo.lottery.LotteryAwardVO;
import com.thebeastshop.support.vo.lottery.LotteryPrizeVO;
import com.thebeastshop.support.vo.lottery.LotteryRecordVO;
import com.thebeastshop.support.vo.lottery.LotteryScrollRecordVO;
import com.thebeastshop.support.vo.lottery.OrderPrizeVO;
import com.thebeastshop.support.vo.lottery.ScratchLotteryAwardVO;
import com.thebeastshop.support.vo.lottery.ScratchLotteryVO;

/**
 * 抽奖服务(针对APP端) Created by feilong.gao on 2016/12/5.
 */
@Controller
@RequestMapping("api/app/lottery")
public class LotteryController {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	LotteryActivityService lotteryActivityService;
	@Autowired
	LotteryActivityQueryService lotteryActivityQueryService;

	@Autowired
	private RedEnvelopeAdapter redEnvelopeAdapter;
	@Autowired
	private MemberQueryService memberQueryService;
	@Autowired
	private MemberPointService memberPointService;
	@Autowired
	private RedEnvelopeReceivedAdapter redEnvelopeReceivedAdapter;
	@Autowired
	private CartInterestAdapter cartInterestAdapter;

	private final PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();

	/**
	 * 抽奖
	 *
	 * @param code
	 * @param data
	 * @return
	 * @throws Exception
	 */
	@ApiAuth
	@RequestMapping("/draw")
	@ResponseBody
	public JsonApiResult draw(@RequestParam("CODE") final String code, @RequestParam("DATA") final String data)
			throws Exception {
		JSONObject jsonData = JSON.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		Integer activityId = jsonData.getInteger("activityId");
		String sysId = jsonData.getString("sysId");
		LotteryActivityDto paramDto = new LotteryActivityDto();
		paramDto.setMemberId(memberId.intValue());
		paramDto.setLotteryActivityId(activityId);
		paramDto.setSysId(sysId);
		MemberVO member = memberQueryService.getById(memberId);

		DrawLotteryVO result = null;
		LotteryActivityDrawResultVO resultVO = lotteryActivityService.drawLottery(paramDto);
		result = convertDrawLottery(resultVO);
		if (result.getWin()) {
			if (LotteryType.PRIZE_TYPE_PRODUCT.getCode()
					.equalsIgnoreCase(resultVO.getLotteryActivityRecordVO().getType())) {
				LotteryInterestGoodsVO lotteryInterestGoodsGetVO = resultVO.getLotteryActivityRecordVO()
						.getInterestGoodsVO();
				if (null == lotteryInterestGoodsGetVO) {
					throw new ChannelException(400, "奖品已发完");
				}
				InterestGoodsGetVO interestGoodsGetVO = new InterestGoodsGetVO();
				BeanUtils.copyProperties(lotteryInterestGoodsGetVO, interestGoodsGetVO);
				cartInterestAdapter.saveInterest2Cart(Long.parseLong(memberId.toString()), interestGoodsGetVO);
			}
		}
		if (null != member) {
			MemberPointVO memberPoint = memberPointService.getMemberPointVO(member.getId(), member.getCode());
			if (memberPoint.getCommonMemberPointValid() != null) {
				result.setPoints(memberPoint.getCommonMemberPointValid().setScale(0, RoundingMode.HALF_UP).intValue());// 积分四舍五入保留整数
			}
		}
		return JsonApiResult.ofSuccessResult(result);
	}

	/**
	 * 刮刮乐抽奖
	 *
	 * @param code
	 * @param data
	 * @return
	 * @throws Exception
	 */
	@ApiAuth
	@RequestMapping("/scratchDraw")
	@ResponseBody
	public JsonApiResult scratchDraw(@RequestParam("CODE") final String code, @RequestParam("DATA") final String data)
			throws Exception {
		logger.info("入参：{}", data);
		JSONObject jsonData = JSON.parseObject(data);
		ScratchLotteryVO scratchLotteryVO = new ScratchLotteryVO();
		Long memberId = jsonData.getLong("memberId");
		Integer activityId = jsonData.getInteger("activityId");
		String orderCode = jsonData.getString("orderCode");
		MemberVO member = memberQueryService.getById(memberId);
		OrderRedEnvelope orderRedEnvelope = redEnvelopeAdapter.getOrderState(orderCode, member.getCode());
		if (orderRedEnvelope.isCanDraw()) {
			LotteryActivityDrawResultVO resultVO = LotteryActivityDrawResultVO.newInstanceFail(null);
			try {
				LotteryActivityDto paramVO = new LotteryActivityDto();
				paramVO.setMemberId(memberId.intValue());
				paramVO.setLotteryActivityId(activityId);
				paramVO.setSysId(orderCode);
				paramVO.setCityName(orderRedEnvelope.getOrderCityName());
				logger.info("调用抽奖服务入参：{}", paramVO);
				resultVO = lotteryActivityService.drawLottery(paramVO);
			} catch (Exception e) {
				logger.error("抽奖服务调用异常：", e);
			}
			logger.info("抽奖结果：{}", resultVO);
			if (resultVO.getLotteryActivityException() == null) {
				LotteryActivityRecordVO recordVO = resultVO.getLotteryActivityRecordVO();
				OrderPrizeVO orderPrizeVO = new OrderPrizeVO();
				if (recordVO != null) {
					orderPrizeVO.setDesc(recordVO.getAwardContent());
					orderPrizeVO.setType(recordVO.getType());
					if (LotteryType.PRIZE_TYPE_PRODUCT.getCode().equalsIgnoreCase(recordVO.getType())) {
						orderPrizeVO.setProductId(recordVO.getTypeNum());
					}
				} else {
					if (orderRedEnvelope.isOverSea()) {
						redEnvelopeReceivedAdapter.sendCoupons(member.getId(), 223L);
						orderPrizeVO.setDesc("50元红包现金抵用券");
						orderPrizeVO.setType(LotteryType.PRIZE_TYPE_COUPON.getCode());
					} else {
						orderPrizeVO.setDesc("野兽派精致小礼");
						orderPrizeVO.setType(LotteryType.PRIZE_TYPE_PRODUCT.getCode());
						orderPrizeVO.setProductId("PROD4");
					}
					logger.info("发放四等奖：订单[{}] memberCode[{}] 发放奖品[{}]", orderCode, member.getCode(),
							JSON.toJSONString(orderPrizeVO));
				}
				scratchLotteryVO.setPrize(orderPrizeVO);
				// 根据订单id查询订单
				OpSalesOrderVO order = pcInstance.orderDetail(member.getCode(), orderCode);
				RedEnvelope red = redEnvelopeAdapter.createRedEnvenlope(orderCode,
						member.getCode(), memberId);
				String shareCode = red.getId().toString();
				scratchLotteryVO.setShareId(shareCode);
			} else {
				logger.info("抽奖错误信息：", resultVO.getLotteryActivityException().getErrorMsg());
				return JsonApiResult.ofErrorResult(403, resultVO.getLotteryActivityException().getErrorMsg());
			}
		} else {
			logger.info("该订单不能领奖");
			return JsonApiResult.ofErrorResult(403, "非法的订单状态");
		}
		logger.info("返回参数：" + JSON.toJSONString(scratchLotteryVO));
		return JsonApiResult.ofSuccessResult(scratchLotteryVO);
	}

	/**
	 * 刮刮乐抽奖
	 *
	 * @param code
	 * @param data
	 * @return
	 * @throws Exception
	 */
	@ApiAuth
	@RequestMapping("/scratchLottery")
	@ResponseBody
	public JsonApiResult scratchLottery(@RequestParam("CODE") final String code,
			@RequestParam("DATA") final String data) throws Exception {
		logger.info("入参：{}", data);
		JSONObject jsonData = JSON.parseObject(data);
		ScratchLotteryAwardVO award = new ScratchLotteryAwardVO();
		Long memberId = jsonData.getLong("memberId");
		Integer activityId = jsonData.getInteger("lotteryId");
		String orderCode = jsonData.getString("orderCode");
		MemberVO member = memberQueryService.getById(memberId);
		LotteryActivityDrawResultVO resultVO = LotteryActivityDrawResultVO.newInstanceFail(null);
		try {
			LotteryActivityDto paramVO = new LotteryActivityDto();
			paramVO.setMemberId(memberId.intValue());
			paramVO.setLotteryActivityId(activityId);
			paramVO.setSysId(orderCode);
			logger.info("调用抽奖服务入参：{}", paramVO);
			resultVO = lotteryActivityService.drawLottery(paramVO);
		} catch (Exception e) {
			logger.error("抽奖服务调用异常：", e);
		}
		logger.info("抽奖结果：{}", resultVO);
		if (resultVO.getLotteryActivityException() == null) {
			LotteryActivityRecordVO recordVO = resultVO.getLotteryActivityRecordVO();
			if (recordVO != null) {
				award.setDesc(recordVO.getAwardContent());
				award.setName(recordVO.getAwardName());
				award.setType(recordVO.getType());
			} else {
				award = null;
			}
		} else {
			logger.info("抽奖错误信息：", resultVO.getLotteryActivityException().getErrorMsg());
			return JsonApiResult.ofErrorResult(403, resultVO.getLotteryActivityException().getErrorMsg());
		}
		logger.info("返回参数：" + JSON.toJSONString(award));
		return JsonApiResult.ofSuccessResult(award);
	}

	@ApiAuth
	@RequestMapping("/canDraw")
	@ResponseBody
	public JsonApiResult canDrawLottery(@RequestParam("CODE") final String code,
			@RequestParam("DATA") final String data) throws Exception {
		JSONObject jsonData = JSON.parseObject(data);
		Integer memberId = jsonData.getInteger("memberId");
		Integer activityId = jsonData.getInteger("activityId");
		boolean isQueryRecord = jsonData.getBoolean("isQueryRecord");
		String sysId = jsonData.getString("sysId");
		MemberVO member = memberQueryService.getById(memberId.longValue());
		// 返回不能抽奖原因
		LotteryActivityErrorEnum failReason = lotteryActivityQueryService.checkDrawLottery(memberId, activityId, sysId);
		DrawLotteryVO drawLotteryVO = new DrawLotteryVO();
		drawLotteryVO.setCanDraw(true);
		if (null != failReason) {
			drawLotteryVO.setCanDraw(false);
			drawLotteryVO.setFailReason(failReason.getErrorMsg());
		} else {
			LotteryActivityVO lotteryActivityVO = lotteryActivityQueryService.byLotteryActivityId(activityId);
			drawLotteryVO.setConsumePoint(lotteryActivityVO.getConsumePoint());
		}
		if (isQueryRecord) {
			List<LotteryActivityRecordVO> winList = lotteryActivityQueryService.winList(memberId, activityId);
			drawLotteryVO.setLotteryRecords(converLotteryRecord(winList));
		}
		if (null != member) {
			MemberPointVO memberPoint = memberPointService.getMemberPointVO(member.getId(), member.getCode());
			if (memberPoint.getCommonMemberPointValid() != null) {
				drawLotteryVO.setPoints(
						memberPoint.getCommonMemberPointValid().setScale(0, RoundingMode.HALF_UP).intValue());// 积分四舍五入保留整数
			}
		}
		return JsonApiResult.ofSuccessResult(drawLotteryVO);
	}

	@RequestMapping("/scrollRecord")
	@ResponseBody
	public JsonApiResult record(@RequestParam("CODE") final String code, @RequestParam("DATA") final String data)
			throws Exception {
		JSONObject jsonData = JSON.parseObject(data);
		Integer limit = jsonData.getInteger("limit");
		Integer activityId = jsonData.getInteger("activityId");
		List<LotteryActivityRecordVO> winList = lotteryActivityQueryService.queryLastWinRecord(limit,activityId);
		List<LotteryScrollRecordVO> result = convertLotteryScrollRecord(winList);
		return JsonApiResult.ofSuccessResult(result);
	}

	@RequestMapping("/queryWinInfo")
	@ResponseBody
	public JsonApiResult queryWinInfo(@RequestParam("CODE") final String code, @RequestParam("DATA") final String data)
			throws Exception {
		JSONObject jsonData = JSON.parseObject(data);
		Integer recordId = jsonData.getInteger("recordId");
		LotteryActivityRecordVO queryRecordVO = lotteryActivityQueryService.byLotteryActivityPrizeRecordId(recordId);
		LotteryRecordVO result = converLotteryRecord(queryRecordVO);
		return JsonApiResult.ofSuccessResult(result);
	}

	@ApiAuth
	@RequestMapping("/canAddLotteryNumber")
	@ResponseBody
	public JsonApiResult canAddLotteryNumber(@RequestParam("CODE") final String code,
			@RequestParam("DATA") final String data) throws Exception {
		JSONObject jsonData = JSON.parseObject(data);
		Integer memberId = jsonData.getInteger("memberId");
		Integer activityId = jsonData.getInteger("activityId");
		LotteryActivityExtraChanceDto extraChanceDto = new LotteryActivityExtraChanceDto();
		extraChanceDto.setLotteryActivityId(activityId);
		extraChanceDto.setMemberId(memberId);
		extraChanceDto.setSysId(activityId.toString());
		extraChanceDto.setSource(ChanceSourceEnum.SOURCE_SHARE.name());
		LotteryActivityErrorEnum failReason = lotteryActivityQueryService.checkAddExtraChance(extraChanceDto);
		logger.info("canAddLotteryNumber campaign.lotteryService.checkAddExtraChance 服务返回：{}", failReason);
		if (null != failReason) {
			return JsonApiResult.ofErrorResult(400, failReason.getErrorMsg());
		}
		return JsonApiResult.ofSuccessResult(true);
	}

	@ApiAuth
	@RequestMapping("/addLotteryNumber")
	@ResponseBody
	public JsonApiResult addLotteryNumber(@RequestParam("CODE") final String code,
			@RequestParam("DATA") final String data) throws Exception {
		JSONObject jsonData = JSON.parseObject(data);
		Integer memberId = jsonData.getInteger("memberId");
		Integer activityId = jsonData.getInteger("activityId");
		LotteryActivityExtraChanceDto extraChanceDto = new LotteryActivityExtraChanceDto();
		extraChanceDto.setLotteryActivityId(activityId);
		extraChanceDto.setMemberId(memberId);
		extraChanceDto.setSysId(activityId.toString());
		extraChanceDto.setSource(ChanceSourceEnum.SOURCE_SHARE.name());
		ServiceResp<String> resp = lotteryActivityService.addExtraChance(extraChanceDto);
		logger.info("canAddLotteryNumber campaign.lotteryService.addExtraChance服务返回：{}", resp);
		if (resp.isFailure()) {
			return JsonApiResult.ofErrorResult(400, "增加抽奖次数失败，请稍后再试");
		}
		return JsonApiResult.ofSuccessResult(resp.isSuccess());
	}

	/**
	 * 抽奖记录列表
	 *
	 * @param sourceObjs
	 * @return
	 */
	private List<LotteryRecordVO> converLotteryRecord(List<LotteryActivityRecordVO> sourceObjs) {
		List<LotteryRecordVO> targetObjs = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(sourceObjs)) {
			for (LotteryActivityRecordVO sourceObj : sourceObjs) {
				targetObjs.add(this.converLotteryRecord(sourceObj));
			}
		}
		return targetObjs;
	}

	/**
	 * 抽奖记录对象转换
	 *
	 * @param sourceObj
	 * @return
	 */
	private LotteryRecordVO converLotteryRecord(LotteryActivityRecordVO sourceObj) {
		LotteryRecordVO targetObj = new LotteryRecordVO();
		if (NullUtil.isNotNull(sourceObj)) {
			LotteryRecordVO detailVO = new LotteryRecordVO();
			detailVO.setDrawTime(sourceObj.getCreateTime());
			detailVO.setPrizeRecordId(sourceObj.getLotteryActivityPrizeRecordId().longValue());
			// 设置奖品项
			LotteryAwardVO awardVO = new LotteryAwardVO();
			if(!NumberUtil.isNullOrZero(sourceObj.getAwardId())){
				awardVO.setAwardId(sourceObj.getAwardId().longValue());
			}
			awardVO.setAwardName(sourceObj.getAwardName());
			awardVO.setContent(sourceObj.getAwardContent());
			// 设置奖品
			LotteryPrizeVO prizeVO = new LotteryPrizeVO();
			prizeVO.setType(sourceObj.getType());
			prizeVO.setTypeDesc(LotteryType.getDesc(sourceObj.getType()));
			prizeVO.setValue(sourceObj.getTypeNum());
			if (LotteryType.PRIZE_TYPE_PRODUCT.getCode().equalsIgnoreCase(sourceObj.getType())) {
				prizeVO.setValue(sourceObj.getProductCode());
			} else {
				prizeVO.setValue(sourceObj.getTypeNum());
			}
			prizeVO.setCouponSampleName(sourceObj.getCouponSampleName());
			awardVO.setPrizes(Lists.<LotteryPrizeVO> newArrayList(prizeVO));
			// 设置中奖信息
			targetObj.setAward(awardVO);
			targetObj.setPrizeRecordId(sourceObj.getLotteryActivityPrizeRecordId().longValue());
			targetObj.setDrawTime(sourceObj.getCreateTime());
			if (StringUtils.isNotBlank(sourceObj.getMemberNickName())) {
				targetObj.setMemberNickName(sourceObj.getMemberNickName());
			} else {
				targetObj.setMemberNickName(SensitiveInfoUtils.mobilePhone(sourceObj.getMemberMobile()));
			}
		}
		return targetObj;
	}

	/**
	 * 抽奖记录列表
	 *
	 * @param sourceObjs
	 * @return
	 */
	private List<LotteryScrollRecordVO> convertLotteryScrollRecord(List<LotteryActivityRecordVO> sourceObjs) {
		List<LotteryScrollRecordVO> targetObjs = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(sourceObjs)) {
			for (LotteryActivityRecordVO sourceObj : sourceObjs) {
				targetObjs.add(this.convertLotteryScrollRecord(sourceObj));
			}
		}
		return targetObjs;
	}

	/**
	 * 抽奖记录对象转换 滚动展示记录
	 *
	 * @param sourceObj
	 * @return
	 */
	private LotteryScrollRecordVO convertLotteryScrollRecord(LotteryActivityRecordVO sourceObj) {
		LotteryScrollRecordVO targetObj = new LotteryScrollRecordVO();
		if (NullUtil.isNotNull(sourceObj)) {
			if (StringUtils.isNotBlank(sourceObj.getMemberNickName())) {
				targetObj.setMemberNickName(sourceObj.getMemberNickName());
			} else {
				targetObj.setMemberNickName(SensitiveInfoUtils.mobilePhone(sourceObj.getMemberMobile()));
			}
			targetObj.setCouponSampleName(sourceObj.getCouponSampleName());
			targetObj.setType(sourceObj.getType());
			targetObj.setTypeDesc(LotteryType.getDesc(sourceObj.getType()));
			if (LotteryType.PRIZE_TYPE_PRODUCT.getCode().equalsIgnoreCase(sourceObj.getType())) {
				targetObj.setValue(sourceObj.getProductCode());
			} else {
				targetObj.setValue(sourceObj.getTypeNum());
			}
			targetObj.setAwardName(sourceObj.getAwardName());
		}
		return targetObj;
	}

	/**
	 * 抽奖信息转换
	 *
	 * @param sourceObj
	 * @return
	 */
	private DrawLotteryVO convertDrawLottery(LotteryActivityDrawResultVO sourceObj) {
		DrawLotteryVO targetObj = new DrawLotteryVO();

		if (NullUtil.isNotNull(sourceObj)) {
			targetObj.setCanDraw(false);
			targetObj.setWin(false);
			if (sourceObj.getLotteryActivityException() != null) {
				targetObj.setFailReason(sourceObj.getLotteryActivityException().getErrorMsg());
				return targetObj;
			} else {
				targetObj.setCanDraw(true);
			}

			LotteryActivityRecordVO recordVO = sourceObj.getLotteryActivityRecordVO();
			if (NullUtil.isNull(recordVO)) {
				targetObj.setFailReason("送你一朵安慰的花，好运一会儿就来了");
			} else {
				targetObj.setWin(true);
				LotteryRecordVO detailVO = new LotteryRecordVO();
				detailVO.setDrawTime(recordVO.getCreateTime());
				detailVO.setPrizeRecordId(recordVO.getLotteryActivityPrizeRecordId().longValue());
				if (StringUtils.isNotBlank(recordVO.getMemberNickName())) {
					detailVO.setMemberNickName(recordVO.getMemberNickName());
				} else {
					detailVO.setMemberNickName(SensitiveInfoUtils.mobilePhone(recordVO.getMemberNickName()));
				}
				// 设置奖品项
				LotteryAwardVO awardVO = new LotteryAwardVO();
				if(!NumberUtil.isNullOrZero(recordVO.getAwardId())){
					awardVO.setAwardId(recordVO.getAwardId().longValue());
				}
				awardVO.setAwardName(recordVO.getAwardName());
				awardVO.setContent(recordVO.getAwardContent());
				// 设置奖品
				LotteryPrizeVO prizeVO = new LotteryPrizeVO();
				prizeVO.setType(recordVO.getType());
				prizeVO.setTypeDesc(LotteryType.getDesc(recordVO.getType()));
				if (LotteryType.PRIZE_TYPE_PRODUCT.getCode().equalsIgnoreCase(recordVO.getType())) {
					prizeVO.setValue(recordVO.getProductCode());
				} else {
					prizeVO.setValue(recordVO.getTypeNum());
				}
				prizeVO.setCouponSampleName(recordVO.getCouponSampleName());
				awardVO.setPrizes(Lists.<LotteryPrizeVO> newArrayList(prizeVO));
				// 设置中奖信息
				detailVO.setAward(awardVO);
				targetObj.setLotteryRecord(detailVO);
				targetObj.setWin(true);

			}
		}
		return targetObj;
	}

}
