package com.thebeastshop.pegasus.channelservice.controller.logistics.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.service.CartService;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.member.service.MemberAddressService;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberAddressVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.logistics.LogisticsAdapter;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.support.enums.LogisticsType;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.logistics.DeliverableDTO;
import com.thebeastshop.support.vo.logistics.DeliverableVO;
import com.thebeastshop.support.vo.logistics.LogisticsDetailVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.List;

/**
 * 物流接口（目前针对app端）
 * 
 * @author Paul-xiong
 *
 */
@Controller("AppLogistics")
@RequestMapping("api/app/logistics")
@ResponseBody
public class LogisticsController {
	@Autowired
	private MemberQueryService memberQueryService;
	@Autowired
	private MemberAddressService addressService;

	// private ChannelService channelService =
	// ComponentServiceLoader.getBean(ChannelService.class);

	@Autowired
	private CartService cartService;

	@Autowired
	private McPsSpvService mcPsSpvService;

	@Autowired
	private McPsProductService mcPsProductService;

	@Autowired
	private LogisticsAdapter logisticsAdapter;
	@Autowired
	private McOpChannelService mcOpChannelService;

	/**
	 * 获取一个物流信息
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/detail")
	public JsonApiResult getLogistics(@RequestParam("CODE") final String code,
			@RequestParam("DATA") final String data) {
		final JSONObject jsonData = JSON.parseObject(data);
		// 物流单号
		final String logisticsCode = jsonData.getString("logisticsCode");
		// 物流类型
		final LogisticsType type = LogisticsType.valueOf(jsonData.getString("type"));

		LogisticsDetailVO detail = logisticsAdapter.getLogisticsDetail(logisticsCode, type);
		return JsonApiResult.ofSuccessResult(detail);
	}

	/**
	 * 获取可配送信息
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/deliverable")
	public JsonApiResult getDeliverableTime(@RequestParam("CODE") final String code,
			@RequestParam("DATA") final String data) {
		final JSONObject jsonData = JSON.parseObject(data);
		// 会员id
		final Long memberId = jsonData.getLong("memberId");
		MemberVO member = memberQueryService.getById(memberId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		//
		DeliverableDTO deliverableDTO = JSON.parseObject(jsonData.getString("deliverableDTO"), DeliverableDTO.class);

		DeliverableVO deliverableTimeVO = null;

		// 是否有海淘商品
		boolean hasOverSea = false;

		List<CartProductPackVO> packVOs = deliverableDTO.getPacks();
		if (CollectionUtils.isNotEmpty(packVOs) && deliverableDTO.getAddressId() != null) {
			MemberAddressVO address = addressService.getById(deliverableDTO.getAddressId());
			List<Long> packIds = Lists.newArrayListWithExpectedSize(packVOs.size());
			List<CartProductPack> packs = Lists.newArrayList();
			for (CartProductPackVO packVO : packVOs) {
				if (packVO.getId() != null) {
					packIds.add(packVO.getId());
				} else {
					if (packVO.getSpv() != null && packVO.getSpv().getId() != null) {
						MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
						PsMatchCampaignCond spvCond = new PsMatchCampaignCond();
						spvCond.setChannelCode(code);
						spvCond.setAccessWay(accessWay.getCode());
						spvCond.setMemberLevel(member.getMemberLevel());
						spvCond.setMatchCampaign(true);
						spvCond.setDiscount(memberLevel.getLevelAmountCondition());
						spvCond.setPagenum(Integer.MAX_VALUE);
						PsSpvVO spv = mcPsSpvService.findBySpvIds(Arrays.asList(packVO.getSpv().getId()), spvCond)
								.get(0);
						PsProductCond cond = new PsProductCond();
						cond.setChannelCode(code);
						cond.setId(spv.getProductId().toString());
						cond.setAccessWay(accessWay.getCode());
						cond.setMemberLevel(member.getMemberLevel());
						cond.setMatchCampaign(true);
                        cond.setChannelCode(code);
						spvCond.setPagenum(Integer.MAX_VALUE);
						PsProductVO product = mcPsProductService.findByCond(cond, true).get(0);
						if (spv != null) {
							CartProductPack e = new CartProductPack();
							e.setSpvId(spv.getSpvId());
							e.setSpv(spv);
							e.setProductId(spv.getProductId());
							if (product != null && hasOverSea == false) {
								// 判断商品是否是
								if (product.getCrossBorderFlag() != null && product.getCrossBorderFlag() == 1) {
									hasOverSea = true;
								}
							}
							e.setProduct(product);
							e.setOwnerId(member.getId());
							e.setSource(CartPackSourceEnum.RAW);
							e.setCount(packVO.getCount());
							e.setFactProductPrice(spv.getSalesPrice());
							e.setValid(true);
							packs.add(e);
						}
					}
				}
			}
			if (CollectionUtils.isNotEmpty(packIds)) {
				packs.addAll(cartService.getPacksByIds(member, packIds, accessWay, opChannel.getCode()));
			}
			deliverableTimeVO = logisticsAdapter.getDeliverableNew(packs, address, member, accessWay, opChannel, null,
					hasOverSea, null);
		}

		return JsonApiResult.ofSuccessResult(deliverableTimeVO);
	}
}