package com.thebeastshop.pegasus.channelservice.controller.logistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderLogisticActivityVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderLogisticVO;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.vo.LogisticActivityVO;
import com.thebeastshop.pegasus.service.operation.vo.LogisticVO;
import com.thebeastshop.pegasus.service.operation.vo.ResponseVO;

@Controller("LogisticsController")
@RequestMapping("/api/Logistics")
public class LogisticsController {

	private PegasusOperationServiceFacade poInstance = PegasusOperationServiceFacade.getInstance();

	@RequestMapping("/searchLogistic")
	@ResponseBody
	public JsonApiResult searchLogistic(String deliveryCode, int type) {

		List<OrderLogisticActivityVO> activitles = new ArrayList<OrderLogisticActivityVO>();
		
		if(StringUtils.isBlank(deliveryCode)|| type==0){
			JsonApiResult.ofErrorResult(-100, "参数有误");
		}
		
		
		// 物流状态
		ResponseVO responseVO = poInstance.searchLogistic(deliveryCode, type);

		if (responseVO.getMeta().getErrno() == 0) {
			if (responseVO.getResult().getData() != null) {

				LogisticVO logisticVO = (LogisticVO) responseVO.getResult().getData();
				OrderLogisticVO orderLlogisticVO = new OrderLogisticVO();

				if (CollectionUtils.isNotEmpty(logisticVO.getActivities())) {

					OrderLogisticActivityVO orderLogisticActivityVO = null;
					for (LogisticActivityVO lg : logisticVO.getActivities()) {
						orderLogisticActivityVO = new OrderLogisticActivityVO();
						orderLogisticActivityVO.setAddress(lg.getAddress());
						orderLogisticActivityVO.setDatetime(lg.getDatetime());
						orderLogisticActivityVO.setDetails(lg.getDetails());
						orderLogisticActivityVO.setScan(lg.getScan());
						activitles.add(orderLogisticActivityVO);
					}

					// 倒序
					Collections.reverse(activitles);
					orderLlogisticVO.setActivities(activitles);

				}

			}

		}

		return JsonApiResult.ofSuccessResult(activitles);
	}
}
