package com.thebeastshop.pegasus.channelservice.controller.lesson;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.course.dto.FrontBeastCourseDTO;
import com.thebeastshop.course.service.FrontBeastCourseService;
import com.thebeastshop.course.vo.FrontBeastCourseVO;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.lesson.BeastLessonAdapter;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.support.vo.lesson.CourseInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

/**
 * Created by GFL on 2019/3/7.
 */
@Controller("LessonController")
@RequestMapping("/api/lesson")
public class LessonController {


    @Autowired
    MemberQueryService memberQueryService;

    @Autowired
    McOpChannelService mcOpChannelService;

    @Autowired
    BeastLessonAdapter beastLessonAdapter;

    @Autowired
    FrontBeastCourseService frontBeastCourseService;

    /**
     * 获取一个课程详情
     *
     * @param
     */
    @RequestMapping(path = "/getCourse", method = RequestMethod.GET)
    @ResponseStatus(HttpStatus.OK)
    @ResponseBody
    public JsonApiResult getCourse(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {

        JSONObject jsonData = JSONObject.parseObject(data);
        String productCode = jsonData.getString("productCode");// product code
        Long memberId = jsonData.getLong("memberId");
        AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
        MemberVO member = memberQueryService.getById(memberId);
        OpChannelVO opChannel = mcOpChannelService.findByCode(code);


        FrontBeastCourseDTO courseCond = new FrontBeastCourseDTO();
        courseCond.setProdCode(productCode);
        courseCond.setMemberCode(member.getCode());
        ServiceResp<FrontBeastCourseVO> courseResp = frontBeastCourseService.getBeastCourseDetailByCond(courseCond);
        if (courseResp.isFailure()) {
            return JsonApiResult.ofErrorResult(500, courseResp.getRespMsg());
        }
        FrontBeastCourseVO frontBeastCourseVO = courseResp.getBean();
        if (null == frontBeastCourseVO) {
            return JsonApiResult.ofErrorResult(400, "课堂不存在");
        }

        CourseInfo courseInfo = beastLessonAdapter.getCourseInfoByProduct(frontBeastCourseVO, productCode, member, opChannel, accessWay);
        return JsonApiResult.ofSuccessResult(courseInfo);
    }

}
