package com.thebeastshop.pegasus.channelservice.controller.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import com.thebeastshop.pegasus.channelservice.constants.PegasusConstants;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.vo.item.ItemDescVO;
import com.thebeastshop.pegasus.channelservice.vo.item.ItemVO;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsDynmContentVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.service.operation.model.OpProduct;
import com.thebeastshop.pegasus.channelservice.util.PriceUtil;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.stock.vo.SSkuStockVO;

@Controller("WeixinItemController")
@RequestMapping("/api/weixin/item")
public class WeixinItemController {

	@Autowired
	private McPsProductService mcPsProductService;
	@Autowired
	private McPsSkuService mcPsSkuService;
	@Autowired
	private McOpChannelService mcOpChannelService;
	
	@Autowired
	private SPresaleService sPresaleService;
	@Autowired
    private SStockService sStockService;

	/**
	 * 根据sku查询商品
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/product/syncbysku
	 */
	@ApiAuth
	@RequestMapping(value = "/itembysku")
	@ResponseBody
	public JsonApiResult itembysku(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		// 取得sku
		String skuCode = jsonData.getString("skuCode");
		
		PsProductVO psProductVO = mcPsProductService.findProdBySkuCode(skuCode);
		if(psProductVO == null){
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), "未查到相应的product");
		}
		
		PsSkuVO psSkuVO = mcPsSkuService.findBySkuCode(skuCode);
		if(psSkuVO == null){
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), "未查到相应的sku");
		}
		ItemVO vo = setItemVO(psProductVO,psSkuVO,code);
		return JsonApiResult.ofSuccessResult(vo);
	}
	
	private ItemVO setItemVO(PsProductVO psProductVO,PsSkuVO psSkuVO,String code){
		
		ItemVO vo = new ItemVO();
		vo.setBigImgUrl(imageUrl(psProductVO.getPicDetail()));
		vo.setBrandId(psSkuVO.getBrandId());
		vo.setBrandName(psSkuVO.getBrandNameCN());
		vo.setCartImgUrl(imageUrl(psProductVO.getPicThumb()));
		//vo.setDeliveryCityIds(deliveryCityIds);
		//vo.setDeliveryDates(deliveryDates);
		vo.setSubstituteName(psSkuVO.getSkuCateName());
		vo.setSubstituteType(psProductVO.getSkuCategoryDesc());
		vo.setId(psSkuVO.getSkuId());
		//vo.setInvisibleOnWeb(invisibleOnWeb);
		//vo.setListPrice(listPrice);
		vo.setName(psSkuVO.getSkuNameCN());
		vo.setCrossBorderFlag(psSkuVO.getCrossBorderFlag());//跨境通
		if(OpProduct.EP_TYPE_SELF==psProductVO.getExpressType()){
			vo.setPickScope("SELF");
		}else if(OpProduct.EP_TYPE_FED==psProductVO.getExpressType()){
			vo.setPickScope("FEDEX24");
		}
		
		// 是否可以使用积分  积分抵扣规则，0不可抵扣1部分抵扣2全部抵扣
		vo.setPointChangeEnable(psSkuVO.getPointDeductRule());
		// 积分对换金额
		vo.setPointPrice(psSkuVO.getPointDuductPrice()
				.doubleValue());
		// 积分
		vo.setPointValue(psSkuVO.getPointDeductPoint().doubleValue());
		
		if (psProductVO.getDynmContents() != null
				&& psProductVO.getDynmContents().size() > 0) {
			
			ItemDescVO itemDescVO = null;
			List<ItemDescVO> product_description = new ArrayList<ItemDescVO>();
			for (PsDynmContentVO entity : psProductVO.getDynmContents()) {
				itemDescVO = new ItemDescVO();
				// 描述内容
				itemDescVO.setContent(entity.getContent());
				// 描述类型名称
				itemDescVO.setEnglishName(entity.getTitleEn());
				// 描述类型英文名称
				itemDescVO.setName(entity.getTitleCn());
				// 排序
				itemDescVO.setOrder(entity.getSort());
				// 描述类型对应的magento的字段
				itemDescVO.setMagentoField(entity.getContentType());

				product_description.add(itemDescVO);
			}

			vo.setProductDescription(product_description);
		}
		
		vo.setProductEnName(psProductVO.getNameCn());
		vo.setRemarkEnable(psSkuVO.getCanRemark());
		//vo.setWeixinImgUrl(weixinImgUrl);
		
		if (psProductVO.getCanSaleSku(code) != null
				&& psProductVO.getCanSaleSku(code).contains(
						psSkuVO.getSkuCode())) {
			// 可售
			vo.setSaleOk(1);
		} else {
			// 不可售
			vo.setSaleOk(0);
		}
		
		//vo.setShopIds(shopIds);
		vo.setSkuCode(psSkuVO.getSkuCode());
		vo.setSmallImgUrl(imageUrl(psProductVO.getPicList()));

		vo.setPrice(psSkuVO.getSalesPrice());
		//该产品是否可以VIP打折,官网 1表示可以打折,0表示不可以打折
		if(psProductVO.getAllowVipDiscount()== PegasusConstants.YES){
			
			vo.setVipEnable(1);
			//vip价格
			vo.setVipPrice(PriceUtil.getLevelPrice(new BigDecimal(psSkuVO.getSalesPrice()),1).doubleValue());
			//vvip价格
			vo.setVvipPrice(PriceUtil.getLevelPrice(new BigDecimal(psSkuVO.getSalesPrice()),2).doubleValue());
		}else{
			vo.setVipEnable(0);
			//vip价格
			vo.setVipPrice(psSkuVO.getSalesPrice().doubleValue());
			//vvip价格
			vo.setVvipPrice(psSkuVO.getSalesPrice().doubleValue());
		}
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		// 未取到渠道仓库
		if (opChannel == null
				|| StringUtils.isBlank(opChannel.getWarehouseForSales())) {
			vo.setQuantity(0);
		}else{
			// 根据sku,仓库code查出库存
//			WhInvVO whInvVO = pwInstance.findCanUseQttBySkuCodeAndWarehouseCode(vo.getSkuCode(),
//							opChannel.getWarehouseForSales());
	//		Integer quantity=whInvVO.getCanUseInv();
			Integer quantity = 0;
			SSkuStockVO sSkuStockVO = sStockService.getSkuStock(vo.getSkuCode(),opChannel.getWarehouseForSales());
			
			if(sSkuStockVO!=null){
				quantity =sSkuStockVO.getCanUseQuantity();
			}
			
			//增加预售判断。先判断物理库存，再判断预售库存，返回的库存为两个值之和 added by fs 20151127
			final SPresaleSaleInvVO preSaleInvVO = sPresaleService.findCanUseQttBySkuCode(vo.getSkuCode(), null);
			if(preSaleInvVO!=null){
				quantity=quantity+preSaleInvVO.getCanUseInv();
			}
			
			vo.setQuantity(quantity);
		}
		
		return vo;
	}
	
	public String imageUrl(String imageUrl){
		String url=imageUrl;
		if(!StringUtils.isBlank(imageUrl)){
			
			if(imageUrl.indexOf("http://")>=0){
				url=imageUrl;
			}else{
				//url="http://oss.thebeastshop.com/"+imageUrl;
				  url="http://img.thebeastshop.com/"+imageUrl;
			}
			
		}
		
		return url;
	}
}
