package com.thebeastshop.pegasus.channelservice.controller.item;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.beast.clog.agent.log.ILog;
import com.beast.clog.agent.log.LogManager;
import com.thebeastshop.member.util.DateTool;
import com.thebeastshop.pegasus.channelservice.controller.order.app.OrderController;
import com.thebeastshop.scm.es.RecommendSceneTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.MoreObjects;
import com.thebeastshop.campaign.enums.FactorTypeEnum;
import com.thebeastshop.campaign.service.CampaignLimitService;
import com.thebeastshop.campaign.vo.CampaignStreamVO;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.forcast.dto.SubscribeReq;
import com.thebeastshop.forcast.enums.ResultState;
import com.thebeastshop.forcast.enums.SubscribeEnum;
import com.thebeastshop.forcast.service.ForcastService;
import com.thebeastshop.forcast.vo.ForcastVO;
import com.thebeastshop.forcast.vo.LevelInfo;
import com.thebeastshop.forcast.vo.SubscribeResp;
import com.thebeastshop.member.constant.MemberConstant;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.ItemAdpter;
import com.thebeastshop.pegasus.channelservice.adapter.StockAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.price.PriceAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.ForecastAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.util.ConstUtil;
import com.thebeastshop.pegasus.channelservice.util.DateUtil;
import com.thebeastshop.pegasus.channelservice.vo.SpvPriceVO;
import com.thebeastshop.pegasus.channelservice.vo.ipos.CategorySkuVO;
import com.thebeastshop.pegasus.channelservice.vo.ipos.CategorySkusVO;
import com.thebeastshop.pegasus.channelservice.vo.ipos.PresaleSaleVO;
import com.thebeastshop.pegasus.channelservice.vo.item.AdvanceVO;
import com.thebeastshop.pegasus.channelservice.vo.item.AttributeVO;
import com.thebeastshop.pegasus.channelservice.vo.item.AttributeValueVO;
import com.thebeastshop.pegasus.channelservice.vo.item.FiltrateProdVO;
import com.thebeastshop.pegasus.channelservice.vo.item.ProductCampaignVO;
import com.thebeastshop.pegasus.channelservice.vo.item.ProductItemVO;
import com.thebeastshop.pegasus.channelservice.vo.item.SkuCombinationItemVO;
import com.thebeastshop.pegasus.channelservice.vo.item.SkuItemDetailVO;
import com.thebeastshop.pegasus.channelservice.vo.item.SkuItemVO;
import com.thebeastshop.pegasus.channelservice.vo.item.SkuVO;
import com.thebeastshop.pegasus.channelservice.vo.item.SnapActivityVO;
import com.thebeastshop.pegasus.channelservice.vo.item.SpvItemVO;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.merchandise.IService.IRecommendService;
import com.thebeastshop.pegasus.merchandise.cond.ProdSearchCond;
import com.thebeastshop.pegasus.merchandise.cond.PsCampaignSearchCond;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.cond.TrackSearchDataCond;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McOpProdDynmcontDetailsService;
import com.thebeastshop.pegasus.merchandise.service.McPcsBrandService;
import com.thebeastshop.pegasus.merchandise.service.McPcsCopywriterService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.OpLabelVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProdDynmDetailVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProdDynmDetailsSaveVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProdDynmTitleVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsBrandVO;
import com.thebeastshop.pegasus.merchandise.vo.ProductCopywriterVO;
import com.thebeastshop.pegasus.merchandise.vo.PsAttributeVO;
import com.thebeastshop.pegasus.merchandise.vo.PsAttributeValueVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsChnStockVO;
import com.thebeastshop.pegasus.merchandise.vo.PsDynmContentVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.price.service.PrsPriceService;
import com.thebeastshop.price.vo.PrsCalcProductDTO;
import com.thebeastshop.price.vo.PrsMemberVO;
import com.thebeastshop.price.vo.PrsProductPriceResultVO;
import com.thebeastshop.price.vo.PrsProductVO;
import com.thebeastshop.scm.vo.recommend.OrderFinishRecommendParamVO;
import com.thebeastshop.scm.vo.recommend.RecommendParamVO;
import com.thebeastshop.stock.dto.SPreparedStockQueryDTO;
import com.thebeastshop.stock.enums.SPresaleChannelTypeEnum;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SPreparedStockVO;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.stock.vo.SPresaleVO;
import com.thebeastshop.stock.vo.SSkuStockVO;
import com.thebeastshop.support.vo.product.SpvVO.Quota;
import com.thebeastshop.support.vo.stock.StoreStockVO;

@Controller("CommonItemController")
@RequestMapping("/api/item")
public class ItemController {

	private final static Logger log = LoggerFactory.getLogger(ItemController.class);
	private final ILog clog = LogManager.getLogger(ItemController.class);

	@Autowired
	private MemberQueryService memberQueryService;
	@Autowired
	private ItemAdpter itemAdpter;
	@Autowired
	private McPsProductService mcPsProductService;
	@Autowired
	private McPsSkuService mcPsSkuService;
	@Autowired
	private McOpChannelService mcOpChannelService;
	@Autowired
	private IRecommendService recommendService;
	@Autowired
	private McPcsBrandService mcPcsBrandService;
	@Autowired
	private SPresaleService sPresaleService;
	@Autowired
	private SStockService sStockService;

	@Autowired
	private CampaignLimitService campaignLimitService;

	@Autowired
	private McOpProdDynmcontDetailsService mcOpProdDynmcontDetailsService;

	@Autowired
	private ForecastAdapter forecastAdapter;

	@Autowired
	private ForcastService forcastService;

	@Autowired
	private PriceAdapter priceAdapter;

	@Autowired
	private McPcsCopywriterService mcPcsCopywriterService;

	@Autowired
	private PrsPriceService prsPriceService;

	@Autowired
	private StockAdapter stockAdapter;

	/**
	 * 获取多个商品的库存
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/product/stockvirtual
	 */
	// @ApiAuth
	@RequestMapping(value = "/product/deatilSkuVO")
	@ResponseBody
	public JsonApiResult deatilSkuVO(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSON.parseObject(data);
		Integer memberLevel = jsonData.getInteger("memberLevel");
		Integer accessWay = jsonData.getInteger("accessWay");
		List<String> skus = JSON.parseArray(jsonData.getString("skuCodes"), String.class);
		// JSONArray skuArray =
		// List<String> skus = Lists.newArrayList();
		//
		// for (int i = 0; i < skuArray.size(); i++) {
		// skus.add(skuArray.getString(i));
		// }

		if (skus == null || skus.size() <= 0) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		// 未取到渠道仓库
		if (opChannel == null || StringUtils.isBlank(opChannel.getWarehouseForSales())) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		Map<String, SkuVO> map = new HashMap<String, SkuVO>();

		// PsProductCond ppCond = new PsProductCond();
		//
		// ppCond.setCodes(skus);
		// ppCond.setMatchCampaign(true);
		// ppCond.setMemberLevel(memberLevel);
		// ppCond.setAccessWay(accessWay);

		// List<PsProductVO> productList =
		// pubInstance.findPsProductByCond(ppCond);

		List<ProductCampaignVO> pcs = null;
		ProductCampaignVO pc = null;

		PsMatchCampaignCond cond = new PsMatchCampaignCond();

		cond.setChannelCode(code);
		cond.setAccessWay(accessWay);
		cond.setMemberLevel(memberLevel);
		cond.setMatchCampaign(true);
		MemberLevelEnum level = MemberLevelEnum.getEnumByCode(memberLevel);
		cond.setDiscount(level.getLevelAmountCondition());

		for (String skuCode : skus) {
			SkuVO skuVO = new SkuVO();
			// 增加预售判断。先判断物理库存，再判断预售库存，返回的库存为两个值之和 added by fs 20151127
			SPresaleSaleInvVO preSaleInvVO = sPresaleService.findCanUseQttBySkuCode(skuCode, null);

			if (preSaleInvVO == null) {
				preSaleInvVO = new SPresaleSaleInvVO();
			}

			PsSkuVO sku = mcPsSkuService.findBySkuCode(skuCode);

			if (sku != null) {
				sku = mcPsProductService.calculateDiscountPrice(sku, cond);
				skuVO.setPrice(BigDecimal.valueOf(sku.getSalesPrice()));

				if (sku.getDiscountPrice() != null && skuVO.getPrice().compareTo(sku.getDiscountPrice()) != 0) {
					skuVO.setDiscountPrice(sku.getDiscountPrice().setScale(2, RoundingMode.HALF_UP));
				}

				List<PsCampaignVO> campList = sku.getCampaignList();
				if (!CollectionUtils.isEmpty(campList)) {
					pcs = new ArrayList<>();
					for (PsCampaignVO bean : campList) {
						if (DiscountType.OFF.id.equals(bean.getDiscountTypeId())) {
							continue;
						}
						pc = new ProductCampaignVO();
						pc.setCreateTime(bean.getCreateTime());
						pc.setCumulative(bean.getCumulative());

						pc.setDiscountTypeId(bean.getDiscountTypeId());

						pc.setDiscountTypeName(bean.getDiscountTypeName());
						pc.setExpireTime(bean.getExpireTime());
						pc.setId(bean.getId());
						pc.setName(bean.getName());
						pc.setProductScopeId(bean.getProductScopeId());
						pc.setSkuCode(sku.getSkuCode());
						pc.setStartTime(bean.getStartTime());
						pc.setTitle(bean.getTitle());
						pcs.add(pc);
					}
					skuVO.setProductCampaignVOs(pcs);
				}
			}

			if (sku != null && sku.getIsJit() != null && sku.getIsJit() == 1) {
				skuVO.setQuantity(1);

			} else {
				Integer quantity = 0;
				// 如果是鲜花
				// if(ConstUtil.immortalFlower.contains(skuCode)){
				// WhInvVO whInvVO =
				// pwInstance.findCanUseQttBySkuCodeAndWarehouseCode(skuCode,
				// ConstUtil.flowerWarehouseCode);
				// quantity = whInvVO.getCanUseInv();
				// }else{
				// 根据sku,仓库code查出库存
				// WhInvVO whInvVO =
				// pwInstance.findCanUseQttBySkuCodeAndWarehouseCode(skuCode,
				// opChannel.getWarehouseForSales());

				SSkuStockVO sSkuStockVO = sStockService.getSkuStock(skuCode, opChannel.getWarehouseForSales());

				if (sSkuStockVO != null) {
					quantity = sSkuStockVO.getCanUseQuantity();
				}

				// }

				quantity = quantity + preSaleInvVO.getCanUseInv();

				skuVO.setQuantity(quantity);

				skuVO.setPlanedDeliveryDate(preSaleInvVO.getPlanedDeliveryDate());

				// List<PsCampaignVO> campList = sku.getCampaignList();
				// if(!CollectionUtils.isEmpty(campList)){
				// for(PsCampaignVO bean:campList){
				// pc = new ProductCampaignVO();
				// pc.setCreateTime(bean.getCreateTime());
				// pc.setCumulative(bean.getCumulative());
				// pc.setDiscountTypeId(bean.getDiscountTypeId());
				// pc.setDiscountTypeName(bean.getDiscountTypeName());
				// pc.setExpireTime(bean.getExpireTime());
				// pc.setId(bean.getId());
				// pc.setName(bean.getName());
				// pc.setProductScopeId(bean.getProductScopeId());
				// pc.setSkuCode(sku.getSkuCode());
				// pc.setStartTime(bean.getStartTime());
				// pc.setTitle(bean.getTitle());
				// pcs.add(pc);
				// }
				// skuVO.setProductCampaignVOs(pcs);
				// }
				// break;
			}
			map.put(skuCode, skuVO);
		}
		return JsonApiResult.ofSuccessResult(map);

		/*
		 * if(!CollectionUtils.isEmpty(productList)){ pcs = new ArrayList<>();
		 * for(PsProductVO ppvo:productList){ if(
		 * ppvo.getSkuCodes().contains(skuCode)){ List<PsCampaignVO> prodList =
		 * ppvo.getCampaignList(); if(!CollectionUtils.isEmpty(prodList)){
		 * for(PsCampaignVO bean:prodList){ pc = new ProductCampaignVO();
		 * pc.setCreateTime(bean.getCreateTime());
		 * pc.setCumulative(bean.getCumulative());
		 * pc.setDiscountTypeId(bean.getDiscountTypeId());
		 * pc.setDiscountTypeName(bean.getDiscountTypeName());
		 * pc.setExpireTime(bean.getExpireTime()); pc.setId(bean.getId());
		 * pc.setName(bean.getName());
		 * pc.setProductScopeId(bean.getProductScopeId());
		 * pc.setSkuCode(ppvo.getCode()); pc.setStartTime(bean.getStartTime());
		 * pc.setTitle(bean.getTitle()); pcs.add(pc); }
		 * 
		 * skuVO.setProductCampaignVOs(pcs); } break; } } } } }
		 */

	}

	/**
	 * 根据sku 取得实际和预存数量
	 * 
	 * @param code
	 * @param data
	 * @return JsonApiResult
	 */
	@ApiAuth
	@RequestMapping(value = "/checkQuantity")
	@ResponseBody
	public JsonApiResult checkQuantity(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {

		List<String> skus = JSONObject.parseArray(data, String.class);

		if (CollectionUtils.isEmpty(skus)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), "数据请求错误");
		}
		Map<String, PresaleSaleVO> map = new HashMap<String, PresaleSaleVO>();

		PresaleSaleVO vo = null;
		// 取得所有sku预算
		Map<String, SPresaleSaleInvVO> mapOp = sPresaleService.findCanUseQttBySkuCodes(skus, null);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		Map<String, SSkuStockVO> mapPw = sStockService.getSkuStocks(skus, opChannel.getWarehouseForSales());

		Map<String, SPresaleVO> opvMap = sPresaleService.findAvaliableBySkuCodes(skus, false);

		SSkuStockVO pw = null;
		SPresaleSaleInvVO op = null;
		SPresaleVO opv = null;
		for (int i = 0; i < skus.size(); i++) {

			vo = new PresaleSaleVO();
			vo.setSkuCode(skus.get(i));

			if (mapOp != null) {
				op = mapOp.get(skus.get(i));
				if (op != null) {
					// 预售库存
					vo.setPresellQuantity(op.getCanUseInv());
				} else {
					vo.setPresellQuantity(0);
				}

			}
			// 预计发货日期
			if (mapPw != null) {
				opv = opvMap.get(skus.get(i));
				if (opv != null) {
					vo.setPresellDate(opv.getPlanedDeliveryDateStr());
				}

			}

			if (mapPw != null) {
				pw = mapPw.get(skus.get(i));
				if (pw != null) {
					// 实际库存
					vo.setQuantity(pw.getCanUseQuantity());
				} else {
					// 实际库存
					vo.setQuantity(0);
				}
			}

			map.put(skus.get(i), vo);
		}

		return JsonApiResult.ofSuccessResult(map);
	}

	/**
	 * 获取本周新品
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/product/currWeekNewProductItems
	 */
	@ApiAuth
	@RequestMapping(value = "/product/currWeekNewProductItems")
	@ResponseBody
	public JsonApiResult currWeekNewProductItems(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		log.info("[currWeekNewProductItems] {}", data);
		Map<String, Date> dateRange = makeDateRangeParam(CURR_WEEK_NEW_PROD);
		return productItemsWeekRange(code, data, dateRange);
	}

	/**
	 * 获取本周新品
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/product/currWeekNewProductItems
	 */
	@ApiAuth
	@RequestMapping(value = "/product/currWeekNewProds")
	@ResponseBody
	public JsonApiResult currWeekNewProds(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		log.info("[currWeekNewProductItems] {}", data);
		Map<String, Date> dateRange = makeDateRangeParam(CURR_WEEK_NEW_PROD);
		return productItemsWeekRangeNew(code, data, dateRange);
	}

	/**
	 * 获取上周新品回顾
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/product/lastWeekReviewProd
	 */
	@ApiAuth
	@RequestMapping(value = "/product/lastWeekReviewProd")
	@ResponseBody
	public JsonApiResult lastWeekReviewProd(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		log.info("[lastWeekReviewProd] {}", data);
		Map<String, Date> dateRange = makeDateRangeParam(LAST_WEEK_REVIEW_PROD);
		return productItemsWeekRange(code, data, dateRange);
	}

	/**
	 * 获取上周新品回顾
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/product/lastWeekReviewProd
	 */
	@ApiAuth
	@RequestMapping(value = "/product/lastWeekProds")
	@ResponseBody
	public JsonApiResult lastWeekProds(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		log.info("[lastWeekReviewProd] {}", data);
		Map<String, Date> dateRange = makeDateRangeParam(LAST_WEEK_REVIEW_PROD);
		return productItemsWeekRangeNew(code, data, dateRange);
	}

	private JsonApiResult productItemsWeekRange(String code, String data, Map<String, Date> dateRange) {
		JSONObject jsonData = JSONObject.parseObject(data);
		String currpage = jsonData.getString("currpage");
		String pagenum = jsonData.getString("pagenum");
		Boolean matchCampaign = jsonData.getBoolean("matchCampaign");
		Integer memberLevel = jsonData.getInteger("memberLevel");
		Integer accessWay = jsonData.getInteger("accessWay");

		if (StringUtils.isBlank(currpage)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		if (StringUtils.isBlank(pagenum)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		List<CategorySkuVO> cateSkus = new ArrayList<CategorySkuVO>();
		PsMatchCampaignCond matchCampaignCond = null;
		if (matchCampaign != null && matchCampaign) {
			matchCampaignCond = new PsMatchCampaignCond();
			matchCampaignCond.setChannelCode(code);
			matchCampaignCond.setMatchCampaign(true);
			matchCampaignCond.setMemberLevel(memberLevel);
			matchCampaignCond.setAccessWay(accessWay);
			matchCampaignCond.setDiscount(MemberLevelEnum.getEnumByCode(memberLevel).getLevelAmountCondition());
		}

		List<PsProductVO> productList = null;
		productList = mcPsProductService.findByChnCodeCateCodeCreateTime(code, dateRange, matchCampaignCond,
				Integer.valueOf(currpage), Integer.valueOf(pagenum));
		if (CollectionUtils.isEmpty(productList)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}

		List<ProductCampaignVO> pcs = null;
		ProductCampaignVO pc = null;
		log.info("productList.size:" + productList.size());
		for (PsProductVO product : productList) {
			// 添加 Product Code
			CategorySkuVO skuVO2 = new CategorySkuVO();
			// if (product.getSkuCodes().size() == 1) {
			// String skuCode = product.getSkuCodes().get(0);
			// skuVO2.setSku(skuCode);
			// log.info("产品[productId]:"+product.getId()+"
			// [product.getSkuCodes[0]]:"+skuCode);
			// }else{
			skuVO2.setSku(product.getCode());
			// log.info("产品[productId]:"+product.getId()+"
			// [productCode]:"+product.getCode());

			// }

			if (product.getDiscountPrice() != null
					&& product.getListPrice().compareTo(product.getDiscountPrice()) != 0) {
				skuVO2.setDiscountPrice(product.getDiscountPrice().setScale(2, RoundingMode.HALF_UP));
			}
			skuVO2.setPrice(product.getListPrice().setScale(2, RoundingMode.HALF_UP).doubleValue());

			if (product.getCombined()) {
				skuVO2.setPrice(product.getOriginalPrice().setScale(2, RoundingMode.HALF_UP).doubleValue());
			} else {
				skuVO2.setPrice(product.getListPrice().setScale(2, RoundingMode.HALF_UP).doubleValue());
			}

			if (CollectionUtils.isNotEmpty(product.getStocks())) {
				for (PsChnStockVO psChnStockVO : product.getStocks()) {
					if ("CHN2018".equals(psChnStockVO.getChnCode())) {
						// 无库存
						if (psChnStockVO.getSoldOut() == 1) {
							skuVO2.setQuantity(0);
						} else {
							// 有库存
							skuVO2.setQuantity(1);
						}
						break;
					}

				}
			}
			List<PsCampaignVO> prodList = product.getCampaignList();
			pcs = new ArrayList<>();
			List<Integer> types = new ArrayList<>();
			if (!CollectionUtils.isEmpty(prodList)) {
				for (PsCampaignVO bean : prodList) {
					if (DiscountType.OFF.id.equals(bean.getDiscountTypeId())) {
						continue;
					}
					if (types.contains(bean.getDiscountTypeId())) {
						continue;
					}
					pc = new ProductCampaignVO();
					pc.setCreateTime(bean.getCreateTime());
					pc.setCumulative(bean.getCumulative());
					pc.setDiscountTypeId(bean.getDiscountTypeId());
					types.add(bean.getDiscountTypeId());
					pc.setDiscountTypeName(bean.getDiscountTypeName());
					pc.setExpireTime(bean.getExpireTime());
					pc.setId(bean.getId());
					pc.setName(bean.getName());
					pc.setProductScopeId(bean.getProductScopeId());
					pc.setSkuCode(product.getCode());
					pc.setStartTime(bean.getStartTime());
					pc.setTitle(bean.getTitle());
					pcs.add(pc);
				}
				skuVO2.setProductCampaignVOs(pcs);
			}

			// 处理预告活动
			if (product.getPsAdvanceCampaignVO() != null) {
				PsCampaignVO pcVO = product.getPsAdvanceCampaignVO().getAdvanceCampaignList().get(0);
				AdvanceVO advanceVO = new AdvanceVO();
				advanceVO.setAdvanceEndTime(pcVO.getExpireTime());
				advanceVO.setAdvanceName(pcVO.getAdvanceName());
				advanceVO.setMaxPrice(product.getPsAdvanceCampaignVO().getMaxPrice());
				advanceVO.setMinPrice(product.getPsAdvanceCampaignVO().getMinPrice());
				advanceVO.setAdvancePriceTitle(pcVO.getAdvancePriceTitle());
				advanceVO.setAdvanceStartTime(pcVO.getStartTime());
				advanceVO.setApprovalState(pcVO.getApprovalState());
				advanceVO.setIsAdvance(pcVO.getAdvance());
				skuVO2.setAdvanceVO(advanceVO);
			}

			cateSkus.add(skuVO2);

			log.info("产品[productId]:" + product.getId() + "  [productCode]:" + product.getCode());
		}

		if (CollectionUtils.isEmpty(cateSkus)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}

		CategorySkusVO vo = new CategorySkusVO();
		vo.setProductCount(productList.size());
		vo.setCateSkus(cateSkus);

		log.info("FIND PROD NUM: {}", productList.size());

		return JsonApiResult.ofSuccessResult(vo);
	}

	private static final String CURR_WEEK_NEW_PROD = "currWeekNewProd";
	private static final String LAST_WEEK_REVIEW_PROD = "lastWeekReviewProd";

	private static Map<String, Date> makeDateRangeParam(String bannerType) {
		Map<String, Date> dateRange = new HashMap<String, Date>();
		if (bannerType.equals(CURR_WEEK_NEW_PROD)) {
			// 本周新品 (上周一0:0:0——上周日23:59:59)
			// dateRange.put("createTimeStart",
			// DateUtil.dayStart(DateUtil.getLastWeek(Calendar.MONDAY,1)));
			// dateRange.put("createTimeEnd",
			// DateUtil.dayEnd(DateUtil.getLastWeek(Calendar.SUNDAY,1)));

			// 本周新品 (上周一0:0:0——本周日23:59:59)
			dateRange.put("createTimeStart", DateUtil.dayStart(DateUtil.getLastWeek(Calendar.MONDAY, 1)));
			dateRange.put("createTimeEnd", DateUtil.dayEnd(DateUtil.getCurrWeek(Calendar.SUNDAY)));
		} else if (bannerType.equals(LAST_WEEK_REVIEW_PROD)) {
			// 上周回顾 (上上周一0:0:0——上上周日23:59:59)
			dateRange.put("createTimeStart", DateUtil.dayStart(DateUtil.getLastWeek(Calendar.MONDAY, 2)));
			dateRange.put("createTimeEnd", DateUtil.dayEnd(DateUtil.getLastWeek(Calendar.SUNDAY, 2)));
		}
		log.info("[dateRange]:" + dateRange.entrySet().toString());
		return dateRange;
	}

	public static void main(String[] args) {
		makeDateRangeParam(LAST_WEEK_REVIEW_PROD);
	}

	/**
	 * 根据关键字搜索
	 * 
	 * @param code
	 * @param data
	 * @return JsonApiResult
	 */
	@ApiAuth
	@RequestMapping(value = "/searchKeyword")
	@ResponseBody
	public JsonApiResult searchKeyword(@RequestParam("CODE") String code, @RequestParam("DATA") String data)
			throws UnsupportedEncodingException {
		JSONObject jsonData = JSONObject.parseObject(data);
		String currpage = jsonData.getString("currpage");

		String pagenum = jsonData.getString("pagenum");
		Boolean matchCampaign = jsonData.getBoolean("matchCampaign");
		// 海淘
		Boolean isCrossBorder = jsonData.getBoolean("isCrossBorder");
		// 折扣
		Boolean isDiscount = jsonData.getBoolean("isDiscount");

		Integer memberLevel = jsonData.getInteger("memberLevel");

		Long memberId = jsonData.getLong("memberId");
		// 渠道
		Integer accessWay = jsonData.getInteger("accessWay");
		// 关键字
		String keyword = jsonData.getString("keyword");
		// 单一品牌
		String brandId = jsonData.getString("brandId");
		// 品牌集合
		String brandIds = jsonData.getString("brandIds");
		List<String> brandIdsList = null;
		// 标签集合
		String labelIds = jsonData.getString("labelIds");
		List<String> labelIdsList = null;
		// 排序条件
		String sortField = jsonData.getString("sortField");
		// 排序规则
		String sortOrder = jsonData.getString("sortOrder");
		// 分类
		String cateCode = jsonData.getString("cateCode");

		FiltrateProdVO filtrateProdVO = new FiltrateProdVO();

		ProdSearchCond prodSearchCondVO = new ProdSearchCond();

		prodSearchCondVO.setChannelCode(code);

		if (BooleanUtils.isTrue(isCrossBorder)) {
			prodSearchCondVO.setIsCrossBorder(true);
		}
		if (!StringUtils.isBlank(brandId)) {
			List<String> list = new ArrayList<>();
			list.add(brandId);
			prodSearchCondVO.setBrandId(brandId);
			prodSearchCondVO.setBrandIds(list);
		}
		if (!StringUtils.isBlank(cateCode)) {
			List<String> codes = new ArrayList<>();
			codes.add(cateCode);
			prodSearchCondVO.setCategoryCodes(codes);
		} else {
			prodSearchCondVO.setKeywords(keyword);
		}

		if (!StringUtils.isBlank(sortField)) {
			prodSearchCondVO.setSortField(sortField);
		}
		if (!StringUtils.isBlank(sortOrder)) {
			prodSearchCondVO.setSortOrder(sortOrder);
		}

		// 品牌集合
		if (StringUtils.isNotBlank(brandIds)) {
			String[] brandArray = brandIds.split(",");
			brandIdsList = Arrays.asList(brandArray);
			prodSearchCondVO.setBrandIds(brandIdsList);
		}

		// 标签集合
		if (StringUtils.isNotBlank(labelIds)) {
			String[] labelArray = labelIds.split(",");
			labelIdsList = Arrays.asList(labelArray);
			prodSearchCondVO.setLabelIds(labelIdsList);
		}

		if (StringUtils.isBlank(currpage)) {
			currpage = "1";
		}

		if (StringUtils.isBlank(pagenum)) {
			pagenum = "20";
		}

		Integer intPagenum = Integer.valueOf(pagenum);
		Integer intCurrpage = Integer.valueOf(currpage);
		// 总数
		Long total = 1L;

		prodSearchCondVO.setSize(intPagenum);
		Integer from = (intCurrpage - 1) * intPagenum;

		prodSearchCondVO.setFrom(from);

		// 打点参数
		TrackSearchDataCond trackCond = new TrackSearchDataCond();
		trackCond.setMemberId(memberId);
		trackCond.setAccessWay(AccessWayEnum.PC.getCode().shortValue());
		trackCond.setChannelCode(code);
		trackCond.setMemberLevel(memberLevel.shortValue());
		prodSearchCondVO.setTrackSearchDataCond(trackCond);

		PsMatchCampaignCond matchCampaignCond = null;
		if (matchCampaign != null && matchCampaign) {
			matchCampaignCond = new PsMatchCampaignCond();
			matchCampaignCond.setChannelCode(code);
			matchCampaignCond.setMatchCampaign(true);
			matchCampaignCond.setMemberLevel(memberLevel);
			matchCampaignCond.setAccessWay(accessWay);
			matchCampaignCond.setDiscount(MemberLevelEnum.getEnumByCode(memberLevel).getLevelAmountCondition());
		}

		List<PcsBrandVO> brands = null;
		List<OpLabelVO> labels = null;
		if (BooleanUtils.isTrue(isDiscount)) {
			brands = mcPsProductService.queryDiscountCategoryBrandLabel(
					createProdSearchCond(code, null, null, labelIdsList), matchCampaignCond).getBrands();
			labels = mcPsProductService.queryDiscountCategoryBrandLabel(
					createProdSearchCond(code, null, brandIdsList, null), matchCampaignCond).getLabels();
		} else if (BooleanUtils.isTrue(isCrossBorder)) {
			brands = mcPsProductService
					.queryCrossBorderCategoryBrandLabel(createProdSearchCond(code, null, null, labelIdsList))
					.getBrands();
			labels = mcPsProductService
					.queryCrossBorderCategoryBrandLabel(createProdSearchCond(code, null, brandIdsList, null))
					.getLabels();
		} else if (StringUtils.isNotBlank(cateCode)) {
			brands = mcPsProductService
					.queryCategoryBrandLabelByCodes(
							createProdSearchCond(code, Collections.singletonList(cateCode), null, labelIdsList))
					.getBrands();
			labels = mcPsProductService
					.queryCategoryBrandLabelByCodes(
							createProdSearchCond(code, Collections.singletonList(cateCode), brandIdsList, null))
					.getLabels();
		}
		filtrateProdVO.setBrands(brands);
		filtrateProdVO.setLabels(labels);

		// 查询商品
		long start = System.currentTimeMillis();
		List<PsProductVO> productList;
		if (BooleanUtils.isTrue(isCrossBorder)) {
			productList = mcPsProductService.findCrossBorderListByProdSearchCondVO(code, matchCampaignCond,
					prodSearchCondVO);
		} else if (BooleanUtils.isTrue(isDiscount)) {
			productList = mcPsProductService.findDiscountListByProdSearchCondVO(code, matchCampaignCond,
					prodSearchCondVO);
		} else if (CollectionUtils.isNotEmpty(prodSearchCondVO.getBrandIds())) {
			productList = mcPsProductService.findBrandsListByProdSearchCondVO(code, matchCampaignCond,
					prodSearchCondVO);
		} else {
			productList = mcPsProductService.findByProdSearchCondVO(code, matchCampaignCond, prodSearchCondVO);
		}
		long end = System.currentTimeMillis();

		log.info("获取商品查询页面信息：耗时{}ms {}", Long.valueOf(end - start),
				MoreObjects.toStringHelper(ProdSearchCond.class).add("channelCode", prodSearchCondVO.getChannelCode())
						.add("categoryCodes", prodSearchCondVO.getCategoryCodes())
						.add("brandIds", prodSearchCondVO.getBrandIds()).add("labelIds", prodSearchCondVO.getLabelIds())
						.add("isCrossBorder", prodSearchCondVO.getIsCrossBorder())
						.add("Keywords", prodSearchCondVO.getKeywords()));

		if (CollectionUtils.isEmpty(productList)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}

		List<String> prodList = new ArrayList<>();

		MemberVO member = null;
		if (memberId != null) {
			member = memberQueryService.getById(memberId);

		} else {
			member = memberQueryService.getById(1L);
		}

		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		AccessWayEnum accessWay2 = AccessWayEnum.getEnumByCode(accessWay);
		// PrsCalcProductDTO arg0 = new PrsCalcProductDTO();
		// PrsMemberVO arg1 = convert4MemberVO(member,
		// getNewcomerFlag(memberId));
		// arg0.setAccessWay(AccessWayEnum.getEnumByCode(accessWay2.getCode()));
		// arg0.setChannelCode(opChannel.getCode());
		// arg0.setMemberVO(arg1);
		//
		// List<PrsProductVO> prsProductVOList = new ArrayList<>();
		//
		// Map<String, List<PsSkuVO>> mapProductId =
		// itemAdpter.GetSkusByProducts(productList);
		// for (PsProductVO bean : productList) {
		// PrsProductVO product = itemAdpter.assembleProduct(bean,
		// mapProductId.get(bean.getId()), member);
		// prsProductVOList.add(product);
		// }
		//
		// arg0.setProductVOList(prsProductVOList);
		// arg0.setCampaignLimitList(itemAdpter.getPrsCampLimit4ProdsList(productList));
		// Map<Long, PrsProductPriceResultVO> priceVos =
		// prsPriceService.calculatePrs4ProductList(arg0);

		// Map<Long, SpvPriceVO> spvMap =
		// priceAdapter.getProductsPricesForWWW(productList, member, opChannel,
		// accessWay2);

		// ProductItemVO pi = null;
		// ProductCampaignVO pc = null;

		// List<String> skuCodes = new ArrayList<>();
		// List<String> codes = new ArrayList<>();
		// Map<String, SSkuStockVO> stockMap = new HashMap<>();
		// if (CollectionUtils.isNotEmpty(productList)) {
		// for (PsProductVO pp : productList) {
		// codes.add(pp.getCode());
		// if (CollectionUtils.isNotEmpty(pp.getSpvList())) {
		// for (PsSpvVO psSpv : pp.getSpvList()) {
		// if (psSpv.getCombined()) {
		// for (PsSkuCombinationVO sc : psSpv.getSkuCombinationList()) {
		// skuCodes.add(sc.getSubSkuCode());
		// }
		// } else {
		// skuCodes.add(psSpv.getSkuCode());
		// }
		//
		// }
		//
		// }
		// }
		//
		// stockMap.putAll(sStockService.getSkuStocks(skuCodes,
		// opChannel.getWarehouseForSales()));
		// }

		// for (PsProductVO pp : productList) {
		// total = pp.getTotal();
		// pi = new ProductItemVO();
		// if (CollectionUtils.isNotEmpty(pp.getBrands())) {
		// pi.setBrandId(pp.getBrands().get(0).getBrandId());
		// pi.setBrandName(pp.getBrands().get(0).getBrandName());
		// }
		//
		// pi.setId(pp.getId());
		// pi.setListIcon(pp.getLargeIconList());
		// pi.setNameZh(pp.getNameCn());
		//
		// if (pp.getCombined()) {
		// pi.setPrice(pp.getOriginalPrice());
		// } else {
		// pi.setPrice(pp.getListPrice());
		// }
		//
		// if (StringUtils.isBlank(pp.getPicList())) {
		// pi.setSmallImgUrl("http://img.thebeastshop.com/js/grey.gif" +
		// pp.getPicList());
		// } else {
		// pi.setSmallImgUrl("http://img.thebeastshop.com/" + pp.getPicList());
		// }
		// List<ProductCampaignVO> pcs = new ArrayList<>();
		// List<Integer> types = new ArrayList<>();
		//
		// pi.setDiscountPrice(pi.getPrice());
		// if (pi.getDiscountPrice() == null) {
		// pi.setDiscountPrice(BigDecimal.ZERO);
		// }
		//
		// PrsProductPriceResultVO priceVo =
		// priceVos.get(Long.parseLong(pp.getId()));
		//
		// Map<Long, BigDecimal> mapSpv = itemAdpter.combineSpvPrice(priceVo);
		// if (CollectionUtils.isNotEmpty(pp.getSpvList())) {
		//
		// for (PsSpvVO psSpv : pp.getSpvList()) {
		//
		// // 判断商品有无库存
		// boolean discountPriceBool = true;
		//
		// BigDecimal spvDiscountPrice = mapSpv.get(psSpv.getSpvId());
		// if (spvDiscountPrice == null) {
		// spvDiscountPrice = psSpv.getDiscountPrice();
		// log.error("商品价格有误sprId={}", psSpv.getSpvId());
		//
		// } else {
		//
		// if (psSpv.getCombined()) {
		// for (PsSkuCombinationVO sc : psSpv.getSkuCombinationList()) {
		// SSkuStockVO sSkuStockVO = stockMap.get(sc.getSubSkuCode());
		// if (sSkuStockVO.getCanUseQuantity() <= 0) {
		// discountPriceBool = false;
		// break;
		//
		// }
		// }
		//
		// } else {
		// SSkuStockVO sSkuStockVO = stockMap.get(psSpv.getSkuCode());
		// if (sSkuStockVO.getCanUseQuantity() <= 0) {
		// discountPriceBool = false;
		//
		// }
		//
		// }
		//
		// }
		//
		// if (discountPriceBool) {
		// if (pi.getDiscountPrice().doubleValue() >
		// spvDiscountPrice.doubleValue()) {
		// pi.setDiscountPrice(spvDiscountPrice);
		// }
		// }
		//
		// // activityDesc 文案顺序:抢购-》预告-》后台配置
		// ProductCopywriterVO productCopywriterVO =
		// activiyDescMap.get(pp.getCode());
		//
		// if (productCopywriterVO != null) {
		// // 设置活动预告
		// pi.setActivityDesc(productCopywriterVO.getContent());
		// }
		//
		// // 处理预告活动
		// if (pp.getPsAdvanceCampaignVO() != null) {
		// PsCampaignVO pcVO =
		// pp.getPsAdvanceCampaignVO().getAdvanceCampaignList().get(0);
		// AdvanceVO advanceVO = new AdvanceVO();
		// advanceVO.setAdvanceEndTime(pcVO.getExpireTime());
		// advanceVO.setAdvanceName(pcVO.getAdvanceName());
		// advanceVO.setMaxPrice(pp.getPsAdvanceCampaignVO().getMaxPrice());
		// advanceVO.setMinPrice(pp.getPsAdvanceCampaignVO().getMinPrice());
		// advanceVO.setAdvancePriceTitle(pcVO.getAdvancePriceTitle());
		// advanceVO.setAdvanceStartTime(pcVO.getStartTime());
		// advanceVO.setApprovalState(pcVO.getApprovalState());
		// advanceVO.setIsAdvance(pcVO.getAdvance());
		//
		// String activityDesc = pcVO.getAdvancePriceTitle();
		// List<PsCampaignSectionVO> sectionList =
		// pcVO.getCampaignSectionList();
		// if (null != sectionList && CollectionUtils.isNotEmpty(sectionList) &&
		// sectionList.size() == 1) {
		// PsCampaignSectionVO section = sectionList.get(0);
		// if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_AMOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_AMOUNT.getId()))
		// {
		// activityDesc = activityDesc + " ￥" + section.getFactor();
		// } else if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_DISCOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_DISCOUNT.getId()))
		// {
		// activityDesc = activityDesc + " " + section.getFactor() + "折";
		// }
		// }
		//
		// pi.setActivityDesc(activityDesc);
		// pi.setAdvanceVO(advanceVO);
		// }
		//
		// if (!CollectionUtils.isEmpty(psSpv.getCampaignList())) {
		// for (PsCampaignVO bean : psSpv.getCampaignList()) {
		// if (DiscountType.PANIC_BUY.id.equals(bean.getDiscountTypeId())) {
		//
		// pi.setIsPanicBuy(1);
		// pc = new ProductCampaignVO();
		// pc.setCreateTime(bean.getCreateTime());
		// pc.setCumulative(bean.getCumulative());
		// pc.setDiscountTypeId(bean.getDiscountTypeId());
		// types.add(bean.getDiscountTypeId());
		// pc.setDiscountTypeName(bean.getDiscountTypeName());
		// pc.setExpireTime(bean.getExpireTime());
		// pc.setId(bean.getId());
		// pc.setName(bean.getName());
		// pc.setProductScopeId(bean.getProductScopeId());
		// pc.setSkuCode(pp.getCode());
		// pc.setStartTime(bean.getStartTime());
		// pc.setTitle(bean.getTitle());
		// pcs.add(pc);
		//
		// String activityDesc = bean.getTitle();
		// List<PsCampaignSectionVO> sectionList =
		// bean.getCampaignSectionList();
		//
		// if (null != sectionList && CollectionUtils.isNotEmpty(sectionList)
		// && sectionList.size() == 1) {
		// PsCampaignSectionVO section = sectionList.get(0);
		// if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_AMOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_AMOUNT.getId()))
		// {
		// activityDesc = activityDesc + " ￥" + section.getFactor();
		// } else if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_DISCOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_DISCOUNT.getId()))
		// {
		// activityDesc = activityDesc + " " + section.getFactor() + "折";
		// }
		// }
		//
		// pi.setActivityDesc(activityDesc);
		//
		// break;
		// }
		// }
		//
		// // 添加活动
		// pi.setProductCampaignVOs(pcs);
		// }
		// }
		//
		// }
		//
		// if (CollectionUtils.isNotEmpty(pp.getStocks())) {
		//
		// for (PsChnStockVO psChnStockVO : pp.getStocks()) {
		// if ("CHN2018".equals(psChnStockVO.getChnCode())) {
		// // 无库存
		// if (psChnStockVO.getSoldOut() == 1) {
		// pi.setQuantity(0);
		// } else {
		// // 有库存
		// pi.setQuantity(1);
		// }
		// break;
		// }
		//
		// }
		//
		// }
		//
		// // 是否支持VIP折扣，1是0否
		// pi.setAllowVipDiscount(pp.getAllowVipDiscount());
		// pi.setShortDescription(pp.getDescription());
		// pi.setCode(pp.getCode());
		//
		// productItemVOList.add(pi);
		// prodList.add(pi.getCode());
		// }

		List<ProductItemVO> productItemVOList = setProductPrice(productList, member, opChannel, accessWay2);

		for (PsProductVO item : productList) {
			total = item.getTotal();
			prodList.add(item.getCode());
		}

		setNewAttribute(productItemVOList, memberLevel, prodList);

		// 判断是否到了最后一页
		if (productItemVOList.size() < intPagenum) {
			filtrateProdVO.setLastPage(true);
		} else {

			Long totalPage = (total / intPagenum) + 1;

			if (totalPage <= intCurrpage) {
				filtrateProdVO.setLastPage(true);
			}
		}

		filtrateProdVO.setProdItems(productItemVOList);
		return JsonApiResult.ofSuccessResult(filtrateProdVO);

	}

	private ProdSearchCond createProdSearchCond(String channelCode, List<String> categoryCodes, List<String> brandIds,
			List<String> labelIds) {
		ProdSearchCond prodSearchCond = new ProdSearchCond();
		prodSearchCond.setChannelCode(channelCode);
		prodSearchCond.setCategoryCodes(categoryCodes);
		// prodSearchCond.setBrandIds(brandIds);
		// prodSearchCond.setLabelIds(labelIds);
		prodSearchCond.setSelectedBrandIds(brandIds);
		// prodSearchCond.setSelectedcategoryCodes(categoryCodes);
		prodSearchCond.setSelectedLabelIds(labelIds);
		return prodSearchCond;
	}

	/**
	 * 获取商品详情
	 *
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/product/currWeekNewProductItems
	 */
	// @ApiAuth
	@RequestMapping(value = "/product/detail")
	@ResponseBody
	public JsonApiResult detail(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		log.info("获取商品详情页面信息,code={},data={}", code, data);
		JSONObject jsonData = JSONObject.parseObject(data);

		Boolean matchCampaign = jsonData.getBoolean("matchCampaign");
		Integer memberLevel = jsonData.getInteger("memberLevel");
		String memberCode = jsonData.getString("memberCode");
		Integer accessWay = jsonData.getInteger("accessWay");
		String productCode = jsonData.getString("keyword");

		// 判断是否是app专享商品
		boolean isAppProduct = false;
		try {
			if (StringUtils.isBlank(productCode)) {
				return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
						ErrorCode.PARAMS_ILLEGAL.getMesage());
			}
			BigDecimal discountAmount = MemberLevelEnum.getEnumByCode(memberLevel).getLevelAmountCondition();
			PsMatchCampaignCond psMatchCampaignCond = new PsMatchCampaignCond();

			psMatchCampaignCond.setChannelCode(code);
			psMatchCampaignCond.setMatchCampaign(true);
			psMatchCampaignCond.setMemberLevel(memberLevel);
			psMatchCampaignCond.setAccessWay(accessWay);
			psMatchCampaignCond.setDiscount(discountAmount);
			PsProductVO product = null;
			try {
				product = mcPsProductService.getProductDetailByCode(code, productCode, psMatchCampaignCond);
			} catch (Exception e) {
				log.info("查询商品服务  详情  报错 e={}", e);
			}

			if (product == null) {
				log.info("商品位空");
				return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
						ErrorCode.DATA_NOT_FOUND.getMesage());
			}
			/*
			 * if(product==null){ product =
			 * mcPsProductService.findProdBySkuCode(productCode);
			 * if(product==null){ return
			 * JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
			 * ErrorCode.DATA_NOT_FOUND.getMesage()); }
			 * 
			 * }
			 */
			// 判断是不是 app 渠道如果商品是app 渠道则修改为app code
			if (null != product && CollectionUtils.isNotEmpty(product.getOnShelfChnCodes())
					&& product.getOnShelfChnCodes().size() == 1
					&& "CHN2049".equals(product.getOnShelfChnCodes().get(0))) {
				code = product.getOnShelfChnCodes().get(0);
				isAppProduct = true;
				log.info("这个是app 专享的商品 ====code={}", code);
			}

			// 如果是定制商品设为app专享

			OpChannelVO opChannel = mcOpChannelService.findByCode(code);
			// 未取到渠道仓库
			if (opChannel == null || StringUtils.isBlank(opChannel.getWarehouseForSales())) {
				return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
						ErrorCode.DATA_NOT_FOUND.getMesage());
			}
			ProductItemVO vo = new ProductItemVO();
			vo.setIsAppProduct(isAppProduct);

			MemberVO member = null;
			if (StringUtils.isNotBlank(memberCode)) {
				member = memberQueryService.getByCode(memberCode);

			} else {
				member = memberQueryService.getById(1L);
			}

			List<PsProductVO> prods = new ArrayList<>();
			prods.add(product);

			AccessWayEnum accessWay2 = AccessWayEnum.getEnumByCode(accessWay);
			Map<Long, SpvPriceVO> spvMap = priceAdapter.getProductsPricesForWWW(prods, member, opChannel, accessWay2);

			// 判断是否是组合商品 或则是 普通商品
			// 这里是 普通商品 也叫 单品
			if (product.getCombined()) {
				vo.setCombined(true);
				setCombinationProduct(opChannel, vo, product, code, memberLevel, accessWay, matchCampaign, memberCode,
						spvMap);
			} else {
				// 设置普通商品 或者 单品
				vo.setCombined(false);
				setSingleProduct(opChannel, vo, product, code, memberLevel, accessWay, matchCampaign, memberCode,
						spvMap);
			}

			// 判断月送鲜花商品库存
			// if (product.getIsMonthSend() != null && product.getIsMonthSend()
			// == 1) {
			//
			// List<String> canSaleSku = product.getCanSaleSku(code);
			// if (CollectionUtils.isNotEmpty(canSaleSku)) {
			// for (String skuCode : canSaleSku) {
			// PcsFlowerDeliveryDate pcsFlowerDeliveryDate =
			// instance.getFlowerStockAndDate(new SFlowerMonthlyQueryDTO(),
			// DateUtil.getNow(), code);
			// if (pcsFlowerDeliveryDate.isCanSale()) {
			// vo.setQuantity(1);
			// break;
			// }
			// }
			//
			// }
			//
			// }

			try {
				forecastAdapter.setPrevue(vo, memberCode);
			} catch (Exception e) {
				log.info("设置预告信息报错， e={}", e);
			}

			return JsonApiResult.ofSuccessResult(vo);
		} catch (Exception e) {
			log.info("查询错误 e={}", e);
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());

		}

	}

	/**
	 * 设置组合商品的信息
	 * 
	 * @param opChannelVO
	 * @param vo
	 * @param product
	 * @param code
	 * @param memberLevel
	 * @param accessWay
	 * @param matchCampaign
	 */
	public void setCombinationProduct(OpChannelVO opChannelVO, ProductItemVO vo, PsProductVO product, String code,
			Integer memberLevel, Integer accessWay, Boolean matchCampaign, String memberCode,
			Map<Long, SpvPriceVO> spvMap) {
		log.info("设置 组合商品 的信息");
		// 设置通用的product 信息
		setProductItemProduct(vo, product, code);
		// 取得可售的sku
		List<String> canSaleSkus = (product.getCanSaleSku(code) == null ? new ArrayList<String>()
				: product.getCanSaleSku(code));
		// 取得可见的sku
		List<String> canSeeSkus = (product.getCanSeeSku(code) == null ? new ArrayList<String>()
				: product.getCanSeeSku(code));
		// attributeList
		setCombinationAttributeList(product, vo);
		// 设置spv 基础信息
		if (CollectionUtils.isNotEmpty(product.getSpvList())) {
			List<SpvItemVO> spvItemVOs = new ArrayList<>();

			Map<String, BigDecimal> advancePrice = new HashMap<>();
			for (PsSpvVO psSpvVO : product.getSpvList()) {
				// 设置SpvItemVO
				SpvItemVO spvItemVO = setSpvItemVO(psSpvVO, product, memberLevel, accessWay,
						MemberLevelEnum.getEnumByCode(memberLevel).getLevelAmountCondition(), opChannelVO, memberCode,
						spvMap, advancePrice);
				// 设置组合商品的 spv属性
				setCombinationSpvVO(spvItemVO, psSpvVO, product);
				// 设置skuCombinationList 信息
				List<SkuCombinationItemVO> skuCombinationItemVOs = new ArrayList<>();
				for (PsSkuCombinationVO psSkuCombinationVOpsSpvVO : psSpvVO.getSkuCombinationList()) {
					SkuCombinationItemVO skuCombinationItemVO = new SkuCombinationItemVO();
					skuCombinationItemVO.setQuantity(psSkuCombinationVOpsSpvVO.getQuantity());
					skuCombinationItemVO.setSubSkuCode(psSkuCombinationVOpsSpvVO.getSubSkuCode());
					skuCombinationItemVO.setSpvId(psSpvVO.getSpvId());

					/** 查询sku */
					PsSkuVO skuVO = psSkuCombinationVOpsSpvVO.getSubSkuVO();// mcPsSkuService.findBySkuCode(psSkuCombinationVOpsSpvVO.getSubSkuCode());
					if (null != skuVO) {
						// 设置skuItemVo
						log.info("组合商品的 skuVO 信息 code={}", skuVO.getSkuCode());
						SkuItemVO skuItemVO = setSkuItem(memberLevel, accessWay, matchCampaign, vo, psSpvVO,
								canSaleSkus, canSeeSkus, opChannelVO, product, skuVO, 2);
						// 设置库存
						skuItemVO.setQuantity(setSkuStock(opChannelVO, skuVO.getSkuCode(), skuItemVO, skuVO, 2));
						skuCombinationItemVO.setSubSkuVO(skuItemVO);
						skuCombinationItemVOs.add(skuCombinationItemVO);
					} else {
						log.info("skuVO 为空 psSpvVO.getSKuCode={}", psSpvVO.getSkuCode());
					}

				}
				spvItemVO.setSkuCombinationList(skuCombinationItemVOs);
				// 设置库存和是否可销 和可见
				setCombinationStockAndSeeSale(spvItemVO);
				// 库存预警
				spvItemVO.setStockWarn(stockAdapter.stockWarn(spvItemVO.getStock()));
				spvItemVOs.add(spvItemVO);
			}
			vo.setSpvItems(spvItemVOs);
		} else {
			log.info("spv list 为空 es的");
		}
	}

	/**
	 * 设置组合商品的spv库存数量和 是否可见可销售
	 * 
	 * @author lijing
	 * @param spvItemVO
	 */
	private void setCombinationStockAndSeeSale(SpvItemVO spvItemVO) {
		if (null != spvItemVO) {
			int count = 0;
			int canSee = 0;
			int canSale = 0;
			if (CollectionUtils.isNotEmpty(spvItemVO.getSkuCombinationList())) {
				if (spvItemVO.getSkuCombinationList().get(0).getQuantity() != null
						&& spvItemVO.getSkuCombinationList().get(0).getSubSkuVO().getQuantity().intValue() < spvItemVO
								.getSkuCombinationList().get(0).getQuantity().intValue()) {
					count = 0;
				} else {
					if (spvItemVO.getSkuCombinationList().get(0).getQuantity() != null) {
						count = (spvItemVO.getSkuCombinationList().get(0).getSubSkuVO().getQuantity().intValue()
								/ spvItemVO.getSkuCombinationList().get(0).getQuantity().intValue());
					}
				}
				canSee = spvItemVO.getSkuCombinationList().get(0).getSubSkuVO().getIsSee();
				canSale = spvItemVO.getSkuCombinationList().get(0).getSubSkuVO().getIsSale();

				for (int i = 1; i < spvItemVO.getSkuCombinationList().size(); i++) {
					int countTemp = 0;
					// 判断了起售数量 小于就是0
					if (spvItemVO.getSkuCombinationList().get(i).getQuantity() != null
							&& spvItemVO.getSkuCombinationList().get(i).getSubSkuVO().getQuantity()
									.intValue() >= spvItemVO.getSkuCombinationList().get(i).getQuantity().intValue()
							&& spvItemVO.getSkuCombinationList().get(i).getSubSkuVO().getQuantity().intValue() != 0) {
						countTemp = (spvItemVO.getSkuCombinationList().get(i).getSubSkuVO().getQuantity().intValue()
								/ spvItemVO.getSkuCombinationList().get(i).getQuantity().intValue());
					}
					if (count != 0 && count > countTemp) {
						count = countTemp;
					}
					if (canSee != 0) {
						spvItemVO.getSkuCombinationList().get(i).getSubSkuVO().getIsSee();
					}

					if (canSale != 0) {
						spvItemVO.getSkuCombinationList().get(i).getSubSkuVO().getIsSale();
					}

					if (canSale == 0 && canSale == 0 && count == 0) {
						break;
					}
				}
			}
			spvItemVO.setStock(count);
			spvItemVO.setCanSee(canSee);
			spvItemVO.setCanSale(canSale);
		}
	}

	/**
	 * 设置组合商品的其他spv属性
	 * 
	 * @author lijing
	 * @param spvItemVo
	 *            vo
	 * @param spvVO
	 *            spvvo
	 * @param product
	 */
	private void setCombinationSpvVO(SpvItemVO spvItemVo, PsSpvVO spvVO, PsProductVO product) {
		if (null != spvItemVo && null != spvVO) {
			spvItemVo.setSalesPrice(spvVO.getOriginalPrice());
			spvItemVo.setCostPrice(spvVO.getCostPrice());
			spvItemVo.setCombined(spvVO.getCombined());
			spvItemVo.setAttrJSONText(spvVO.getAttrs());
			spvItemVo.setAttrValues(spvVO.getAttrValues());

			// spvItemVo.setDiscountPrice(spvVO.getDiscountPrice());
		}
	}

	/**
	 * 设置 List<AttributeVO> 的信息
	 * 
	 * @Author lijing
	 * @param productVO
	 *            商品
	 */
	private void setCombinationAttributeList(PsProductVO productVO, ProductItemVO vo) {
		if (null != productVO && null != vo && CollectionUtils.isNotEmpty(productVO.getAttributeList())) {
			List<AttributeVO> attributeVOs = new ArrayList<>();
			for (PsAttributeVO psAttributeVO : productVO.getAttributeList()) {
				AttributeVO attributeVO = new AttributeVO();
				attributeVO.setCombined(psAttributeVO.getCombined());
				attributeVO.setGroupName(psAttributeVO.getGroupName());
				attributeVO.setId(psAttributeVO.getAttrId());
				attributeVO.setName(psAttributeVO.getName());
				List<AttributeValueVO> attributeValueVOs = new ArrayList<>();
				if (CollectionUtils.isNotEmpty(psAttributeVO.getAttributeValues())) {
					for (PsAttributeValueVO psAttributeValueVO : psAttributeVO.getAttributeValues()) {
						AttributeValueVO attributeValueVO = new AttributeValueVO();
						attributeValueVO.setId(psAttributeValueVO.getId());
						attributeValueVO.setValueText(psAttributeValueVO.getValue());
						attributeValueVO.setQuantity(psAttributeValueVO.getQuantity());
						attributeValueVOs.add(attributeValueVO);
					}
				}
				attributeVO.setAttributeValueList(attributeValueVOs);
				Iterator<Map.Entry<String, PsAttributeValueVO>> entries = psAttributeVO.getAttributeValueMap()
						.entrySet().iterator();
				Map<String, AttributeValueVO> map = new LinkedHashMap<>();
				while (entries.hasNext()) {
					Map.Entry<String, PsAttributeValueVO> entry = entries.next();
					PsAttributeValueVO psAttributeValueVO = entry.getValue();
					AttributeValueVO attributeValueVO = new AttributeValueVO();
					if (null != psAttributeValueVO) {
						attributeValueVO.setId(psAttributeValueVO.getId());
						attributeValueVO.setValueText(psAttributeValueVO.getValue());
						attributeValueVO.setQuantity(psAttributeValueVO.getQuantity());
					}
					map.put(entry.getKey(), attributeValueVO);
				}
				attributeVO.setAttributeValueMap(map);

				attributeVOs.add(attributeVO);
			}
			vo.setAttributeList(attributeVOs);
		}
	}

	/**
	 * 设置单品的信息 也就是普通商品
	 * 
	 * @Author lijing
	 * @param opChannelVO
	 *            渠道vo
	 * @param vo
	 *            productItemVo
	 * @param product
	 *            es 商品信息
	 * @param code
	 *            渠道code
	 */
	public void setSingleProduct(OpChannelVO opChannelVO, ProductItemVO vo, PsProductVO product, String code,
			Integer memberLevel, Integer accessWay, Boolean matchCampaign, String memberCode,
			Map<Long, SpvPriceVO> spvMap) {
		log.info("设置单品的信息");
		// 设置通用的product 信息
		setProductItemProduct(vo, product, code);
		// 取得可售的sku
		List<String> canSaleSkus = (product.getCanSaleSku(code) == null ? new ArrayList<String>()
				: product.getCanSaleSku(code));
		// 取得可见的sku
		List<String> canSeeSkus = (product.getCanSeeSku(code) == null ? new ArrayList<String>()
				: product.getCanSeeSku(code));
		// 设置sku属性
		if (CollectionUtils.isNotEmpty(product.getSpvList())) {
			List<SpvItemVO> spvItemVOs = new ArrayList<>();
			List<SkuItemVO> skuItems = new ArrayList<>();
			Map<String, BigDecimal> advancePrice = new HashMap<>();
			for (PsSpvVO psSpvVO : product.getSpvList()) {
				// 设置SpvItemVO
				SpvItemVO spvItemVO = setSpvItemVO(psSpvVO, product, memberLevel, accessWay,
						MemberLevelEnum.getEnumByCode(memberLevel).getLevelAmountCondition(), opChannelVO, memberCode,
						spvMap, advancePrice);
				/** 查询sku */
				PsSkuVO skuVO = psSpvVO.getSkuVO();// mcPsSkuService.findBySkuCode(psSpvVO.getSkuCode());
				// 设置skuItemVo
				if (null != skuVO) {
					SkuItemVO skuItemVO = setSkuItem(memberLevel, accessWay, matchCampaign, vo, psSpvVO, canSaleSkus,
							canSeeSkus, opChannelVO, product, skuVO, 1);
					// 设置库存
					if (skuVO.getIsJit() == 1) {
						// skuItemVO.setQuantity(Integer.MAX_VALUE);
						skuItemVO.setQuantity(999);

						if (skuVO.getDeliveryPeriod() == null) {
							// 存在交期的时候
							skuItemVO.setDeliveryPeriod(0);
						} else {
							// 存在交期的时候
							skuItemVO.setDeliveryPeriod(skuVO.getDeliveryPeriod());
						}
						SPresaleSaleInvVO preSaleInvVO = sPresaleService.findCanUseQttBySkuCode(skuVO.getSkuCode(),
								null);

						if (preSaleInvVO != null) {

							skuItemVO.setPlanedDeliveryDateStr(
									DateTool.date2String(preSaleInvVO.getPlanedDeliveryDate(), DateTool.FORMAT_DATE));
							skuItemVO.setPlanedDeliveryDate(preSaleInvVO.getPlanedDeliveryDate());
						}
					} else {
						skuItemVO.setQuantity(setSkuStock(opChannelVO, skuVO.getSkuCode(), skuItemVO, skuVO, 1));
					}

					// 设置sku 集合
					spvItemVO.setCanSale(skuItemVO.getIsSale());
					spvItemVO.setCanSee(skuItemVO.getIsSee());
					// 库存预警
					spvItemVO.setStockWarn(stockAdapter.stockWarn(spvItemVO.getStock()));
					skuItems.add(skuItemVO);
					spvItemVO.setSkuVO(skuItemVO);
					spvItemVOs.add(spvItemVO);

					// 定制商品
					if (skuVO.getCanCustomize() != null && skuVO.getCanCustomize() == 1) {
						vo.setIsAppProduct(true);
					}

				} else {
					log.info("skuVO 为空 psSpvVO.getSKuCode={}", psSpvVO.getSkuCode());
				}

				if (advancePrice.size() > 0 && vo.getAdvanceVO() != null) {

					vo.getAdvanceVO().setAdvancePrice(advancePrice.get("minPrice"));
					vo.getAdvanceVO().setMinPrice(advancePrice.get("minPrice"));
					vo.getAdvanceVO().setMaxPrice(advancePrice.get("maxPrice"));
				}

			}
			vo.setSkuItems(skuItems);
			vo.setSpvItems(spvItemVOs);

		} else {
			log.info("product spvList为空");
		}
	}

	/**
	 * 设置spvItemVO
	 * 
	 * @author lijing
	 * @param spvVO
	 *            spvVo
	 * @param prouct
	 *            productvo
	 * @param memberLevel
	 *            会员等级
	 * @param accessWay
	 * @param discountAmount
	 * @param opChannelVO
	 *            渠道
	 * @return
	 */
	public SpvItemVO setSpvItemVO(PsSpvVO spvVO, PsProductVO prouct, Integer memberLevel, Integer accessWay,
			BigDecimal discountAmount, OpChannelVO opChannelVO, String memberCode, Map<Long, SpvPriceVO> spvMap,
			Map<String, BigDecimal> advancePrice) {
		SpvItemVO spvItemVO = new SpvItemVO();
		if (null != spvVO) {

			SpvPriceVO sp = spvMap.get(spvVO.getSpvId());

			if (sp == null) {

				log.error("商品价格有误,spvId:" + spvVO.getSpvId());

			} else {
				spvItemVO.setDiscountPrice(sp.getDiscountPrice());
				// 设置预告价格
				if (CollectionUtils.isNotEmpty(spvVO.getAdvanceCampaignList())) {
					PsCampaignVO pcVO = spvVO.getAdvanceCampaignList().get(0);
					AdvanceVO advanceVO = new AdvanceVO();
					advanceVO.setAdvanceEndTime(pcVO.getExpireTime());
					advanceVO.setAdvanceName(pcVO.getAdvanceName());
					advanceVO.setAdvancePriceTitle(pcVO.getAdvancePriceTitle());
					advanceVO.setAdvanceStartTime(pcVO.getStartTime());
					advanceVO.setApprovalState(pcVO.getApprovalState());
					advanceVO.setIsAdvance(pcVO.getAdvance());
					if (spvVO.getAdvancePrice() != null) {
						advanceVO.setAdvancePrice(sp.getAdvancePrice());

						if (advancePrice.get("minPrice") != null) {
							if (advancePrice.get("minPrice").doubleValue() > advanceVO.getAdvancePrice()
									.doubleValue()) {
								advancePrice.put("minPrice", advanceVO.getAdvancePrice());
							}
						} else {
							advancePrice.put("minPrice", advanceVO.getAdvancePrice());
						}

						if (advancePrice.get("maxPrice") != null) {
							if (advancePrice.get("maxPrice").doubleValue() < advanceVO.getAdvancePrice()
									.doubleValue()) {
								advancePrice.put("maxPrice", advanceVO.getAdvancePrice());
							}
						} else {
							advancePrice.put("maxPrice", advanceVO.getAdvancePrice());
						}

					}
					spvItemVO.setAdvanceVO(advanceVO);
				}

			}

			spvItemVO.setMinAmount(spvVO.getMinAmount());
			spvItemVO.setId(spvVO.getSpvId());
			spvItemVO.setCombined(spvVO.getCombined());
			spvItemVO.setProductCode(prouct.getCode());
			spvItemVO.setProductName(prouct.getNameCn());
			spvItemVO.setSkuCode(spvVO.getSkuCode());
			spvItemVO.setStock(spvVO.getCanUseQuantity());
			if (prouct.getCombined()) {
				spvItemVO.setSalesPrice(spvVO.getOriginalPrice());
			} else {
				spvItemVO.setSalesPrice(spvVO.getSalesPrice());
			}

			spvItemVO.setOriginalPrice(spvVO.getOriginalPrice());

			if (spvItemVO.getDiscountPrice() == null) {
				spvItemVO.setDiscountPrice(spvVO.getSalesPrice());
			}
			spvItemVO.setForBidVipDisReson(sp.getForBidVipDisReaSon());
			/*
			 * PsMatchCampaignCond psMatchCampaignCond = new
			 * PsMatchCampaignCond();
			 * psMatchCampaignCond.setMemberLevel(memberLevel);
			 * psMatchCampaignCond.setAccessWay(accessWay);
			 * psMatchCampaignCond.setDiscount(discountAmount);
			 * psMatchCampaignCond.setMatchCampaign(true); spvVO =
			 * mcPsProductService.calculateDiscountPrice(prouct,spvVO,
			 * psMatchCampaignCond); if(null != spvItemVO) {
			 */

			/* } */

			/** 得到抢购活动东西 */
			if (CollectionUtils.isNotEmpty(spvVO.getCampaignList())) {
				String warehouseCangCocd = getWarehouseCang(opChannelVO, spvVO.getSkuCode(), spvVO.getSkuVO());
				if (StringUtils.isNotBlank(warehouseCangCocd)) {
					spvItemVO.setSnapActivityVOs(convertSnapActivitys(spvVO, warehouseCangCocd, memberCode));
				} else {
					log.error("仓库code 为空   warehouseCangCode", warehouseCangCocd);
				}
			}
		}
		return spvItemVO;
	}

	/**
	 * 组合抢购活动
	 * 
	 * @param psSpvVO
	 *            spv
	 * @param warehouseCangCode
	 *            仓库code
	 * @return
	 */
	private List<SnapActivityVO> convertSnapActivitys(PsSpvVO psSpvVO, String warehouseCangCode, String memberCode) {
		List<SnapActivityVO> snapActivityVOs = new ArrayList<>();
		for (PsCampaignVO psCampaignVO : psSpvVO.getCampaignList()) {
			if (null != psCampaignVO && null != psCampaignVO.getDiscountTypeId()
					&& psCampaignVO.getDiscountTypeId() == DiscountType.PANIC_BUY.getId()) {
				// 转换抢购vo
				SnapActivityVO snapActivityVO = new SnapActivityVO();
				snapActivityVO.setCode(psCampaignVO.getCode());// 重新设置
				snapActivityVO.setDiscountTypeId(psCampaignVO.getDiscountTypeId());
				snapActivityVO.setExpireTime(psCampaignVO.getExpireTime());
				snapActivityVO.setName(psCampaignVO.getName());
				snapActivityVO.setId(psCampaignVO.getId());
				snapActivityVO.setStartTime(psCampaignVO.getStartTime());
				snapActivityVO.setTitle(psCampaignVO.getTitle());
				snapActivityVO.setState(psCampaignVO.getState());
				CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
				campaignStreamVO.setCampaignCode(psCampaignVO.getCode());
				campaignStreamVO.setSkuCode(psSpvVO.getSkuCode());

				ServiceResp<Integer> resp = campaignLimitService.getPanicLeftAmount(campaignStreamVO);
				Integer snapActivityStock = resp.getBean();
				if (snapActivityStock == null) {
					snapActivityStock = 0;
				}
				// Integer snapActivityStock =
				// pwinnerStance.getPanicBuyCampaignOccupy(warehouseCangCode,
				// psCampaignVO.getCode(), psSpvVO.getSkuCode());

				// snapActivityVO.setStock(snapActivityStock == null ? 0 :
				// snapActivityStock.intValue());//去调用库存

				log.info("psSpvVO.getCanUseQuantity()=========" + psSpvVO.getCanUseQuantity());
				// SPresaleSaleInvVO preSaleInvVO =
				// sPresaleService.findCanUseQttBySkuCode(psSpvVO.getSkuCode(),
				// null);
				snapActivityVO.setStock(psSpvVO.getCanUseQuantity());
				if (snapActivityStock != null && snapActivityStock == -1) {

					// if(preSaleInvVO != null){

					// log.info("1
					// preSaleInvVO.getCanUseInv())========="+preSaleInvVO.getCanUseInv());
					// // 不限制库存
					// snapActivityVO.setStock(psSpvVO.getCanUseQuantity()+preSaleInvVO.getCanUseInv());
					//
					// }else{
					// 不限制库存
					snapActivityVO.setStock(psSpvVO.getCanUseQuantity());
					// }

				} else {
					// if(preSaleInvVO != null){
					// log.info("2
					// preSaleInvVO.getCanUseInv())========="+preSaleInvVO.getCanUseInv());
					// if(psSpvVO.getCanUseQuantity()+preSaleInvVO.getCanUseInv()<
					// snapActivityStock){
					// snapActivityVO.setStock(psSpvVO.getCanUseQuantity()+preSaleInvVO.getCanUseInv());
					// }else{
					// snapActivityVO.setStock(snapActivityStock);
					// }
					// }else{
					if (psSpvVO.getCanUseQuantity() < snapActivityStock) {
						snapActivityVO.setStock(psSpvVO.getCanUseQuantity());
					} else {
						snapActivityVO.setStock(snapActivityStock);
					}
					// }

				}
				// snapActivityStock = 0;
				//// SPreparedStockQueryDTO dto = new SPreparedStockQueryDTO();
				//// dto.setSkuCode(psSpvVO.getSkuCode());
				//// dto.setBusinessCode(psCampaignVO.getCode());
				//// dto.setWarehouseCode(warehouseCangCode);
				//// dto.setOccupyType(SStockOccupyTypeEnum.CAMPAIGN_OUT);
				//
				// SSkuStockVO sSkuStockVO =
				// sStockService.getSkuStock(psSpvVO.getSkuCode(),
				// warehouseCangCode);
				//
				// // 增加预售判断。先判断物理库存，再判断预售库存，返回的库存为两个值之和 added by fs 20151127
				// SPresaleSaleInvVO preSaleInvVO =
				// sPresaleService.findCanUseQttBySkuCode(psSpvVO.getSkuCode(),
				// null);
				// // 这里暂时不支付抢购
				// //SPreparedStockVO sPreparedStockVO =
				// sStockService.getPreparedQuantity(dto);
				//
				// if (sSkuStockVO != null) {
				// log.info("sSkuStockVO.getCanUseQuantity(========="+sSkuStockVO.getCanUseQuantity());
				// snapActivityStock = sSkuStockVO.getCanUseQuantity();
				//
				// if (preSaleInvVO != null) {
				// log.info("preSaleInvVO.getCanUseInv()(========="+preSaleInvVO.getCanUseInv());
				// snapActivityVO.setStock(snapActivityStock+preSaleInvVO.getCanUseInv());
				//
				// }
				//
				// } else {
				// snapActivityVO.setStock(psSpvVO.getCanUseQuantity());
				// }
				//
				// }

				// 判断抢购商品是否限购数量
				if (psCampaignVO.getLimitAmount() != null && psCampaignVO.getLimitAmount() > 0) {

					log.info("判断抢购商品是否限购数量(=========" + psCampaignVO.getLimitAmount());

					Quota quota = new Quota();
					if (StringUtils.isNotEmpty(memberCode)) {
						CampaignStreamVO campStream = new CampaignStreamVO();
						campStream.setSkuCode(psSpvVO.getSkuCode());
						campStream.setCampaignCode(psCampaignVO.getCode());
						campStream.setMemberCode(memberCode);
						ServiceResp<Integer> leftResp = campaignLimitService.getPanicPerUserLeftAmount(campStream);
						int left = 0;
						if (leftResp.isSuccess() && leftResp.getBean() != null) {
							left = leftResp.getBean();
						}

						// int left =
						// poInstance.sumPanicBuyLimitAmount(psCampaignVO.getStartTime(),
						// psCampaignVO.getExpireTime(), memberCode,
						// psSpvVO.getSkuCode());
						quota.setLeft(left);
					} else {
						quota.setLeft(quota.getTotal());
					}

					quota.setTotal(psCampaignVO.getLimitAmount());
					snapActivityVO.setQuota(quota);
				}

				snapActivityVOs.add(snapActivityVO);
			}
		}
		log.info("抢购活动的 信息 snapActivityVOs={}", snapActivityVOs);
		return snapActivityVOs;
	}

	/**
	 * 设置skuItemVO
	 * 
	 * @author lijing
	 * @param memberLevel
	 *            用户等级
	 * @param accessWay
	 *            访问渠道
	 * @param matchCampaign
	 *            是否匹配活动
	 * @param vo
	 *            productItemVo
	 * @param psSpvVO
	 *            psSpvVO
	 * @param canSaleSkus
	 *            可售的sku集合
	 * @param canSeeSkus
	 *            可见的sku集合
	 * @param opChannelVO
	 *            渠道
	 * @param productVO
	 *            product
	 * @param sku
	 *            SkuVo
	 * @param type
	 *            1 普通 2 组合商品
	 * @return
	 */
	private SkuItemVO setSkuItem(Integer memberLevel, Integer accessWay, Boolean matchCampaign, ProductItemVO vo,
			PsSpvVO psSpvVO, List<String> canSaleSkus, List<String> canSeeSkus, OpChannelVO opChannelVO,
			PsProductVO productVO, PsSkuVO sku, int type) {
		SkuItemVO skuItem = new SkuItemVO();
		PsMatchCampaignCond cond = new PsMatchCampaignCond();
		cond.setChannelCode(opChannelVO.getCode());
		cond.setAccessWay(accessWay);
		cond.setMemberLevel(memberLevel);
		cond.setMatchCampaign(matchCampaign);
		cond.setDiscount(MemberLevelEnum.getEnumByCode(memberLevel).getLevelAmountCondition());

		if (null != sku) {
			if (vo.getBrandId() == null) {
				vo.setBrandId(sku.getBrandId());
				vo.setBrandName(sku.getBrandName());
				vo.setBrandCountryName(sku.getBrandCountryName());
			}
			/*
			 * if(type == 1) { sku =
			 * mcPsProductService.calculateDiscountPrice(sku, cond); }else{ sku
			 * = mcPsProductService.calculateDiscountPrice(productVO,sku,cond);
			 * }
			 */
			vo.setCrossBorderFlag(sku.getCrossBorderFlag());
			skuItem = new SkuItemVO();
			skuItem.setCode(psSpvVO.getSkuCode());
			if (type == 1) {
				if (psSpvVO.getDiscountPrice() != null) {
					skuItem.setDiscountPrice(psSpvVO.getDiscountPrice().setScale(2, RoundingMode.HALF_UP));
				}
			}
			skuItem.setPrice(psSpvVO.getSalesPrice().setScale(2, RoundingMode.HALF_UP));
			skuItem.setName(sku.getSkuName());
			skuItem.setNameCh(sku.getSkuNameCN());
			skuItem.setId(sku.getSkuId());
			skuItem.setCateName(sku.getSkuCateName());
			skuItem.setDeliveryPeriod(sku.getDeliveryPeriod());
			skuItem.setIsJit(sku.getIsJit());
			if (skuItem.getIsJit() == null) {
				skuItem.setIsJit(0);
			}
			SPresaleSaleInvVO preSaleInvVO = sPresaleService.findCanUseQttBySkuCode(sku.getSkuCode(), null);

			if (preSaleInvVO != null) {

				skuItem.setPlanedDeliveryDateStr(
						DateTool.date2String(preSaleInvVO.getPlanedDeliveryDate(), DateTool.FORMAT_DATE));
				skuItem.setPlanedDeliveryDate(preSaleInvVO.getPlanedDeliveryDate());
			}
			/*
			 * if(canSaleSkus.contains(psSpvVO.getSkuCode())){
			 * skuItem.setIsSale(1); }
			 * if(canSeeSkus.contains(psSpvVO.getSkuCode())){
			 * skuItem.setIsSee(1); }
			 */
			// 龚俊说的都是可见可销不用判断
			skuItem.setIsSale(1);
			skuItem.setIsSee(1);

			if (sku.getWhetherLogistics() != null && sku.getWhetherLogistics() == 1) {
				vo.setWhetherLogistics(sku.getWhetherLogistics());
			}

			if (sku.getWhetherVirtual() != null && sku.getWhetherVirtual() == 1) {
				vo.setWhetherVirtual(sku.getWhetherVirtual());
			}
			if (productVO.getCode().equals(psSpvVO.getSkuCode())) {
				skuItem.setIsDefault(1);
			}
		}
		return skuItem;
	}

	/**
	 * 得到 warehouse的仓库
	 * 
	 * @param opChannelVO
	 * @param skuCode
	 * @param skuVO
	 * @return
	 */
	private String getWarehouseCang(OpChannelVO opChannelVO, String skuCode, PsSkuVO skuVO) {
		// if(null != skuVO) {
		// if (ConstUtil.immortalFlower.contains(skuCode)) {
		// return ConstUtil.flowerWarehouseCode;
		// } else {
		return opChannelVO.getWarehouseForSales();
		// }
		// }
		// return "";
	}

	/**
	 * 设置库存
	 * 
	 * @Author lijing
	 * @param opChannelVO
	 *            渠道
	 * @param skuCode
	 *            skuCode
	 * @param skuItemVO
	 *            需要设置的值
	 * @param skuVO
	 *            skuvo
	 * @param productType
	 *            商品类型 1 代表普通商品 2 代表 组合商品(一期 不走预售库存)
	 * @return
	 */
	private Integer setSkuStock(OpChannelVO opChannelVO, String skuCode, SkuItemVO skuItemVO, PsSkuVO skuVO,
			int productType) {
		if (null != skuVO) {
			if (productType != 2) {
				SPresaleSaleInvVO preSaleInvVO = sPresaleService.findCanUseQttBySkuCode(skuCode, null);
				// 预售库存
				if (preSaleInvVO != null) {
					skuItemVO.setPlanedDeliveryDateStr(
							DateTool.date2String(preSaleInvVO.getPlanedDeliveryDate(), DateTool.FORMAT_DATE));
					skuItemVO.setPlanedDeliveryDate(preSaleInvVO.getPlanedDeliveryDate());
					if (preSaleInvVO.getAvailQuantity() > 0) {
						return preSaleInvVO.getAvailQuantity();
					}
				}
			}
			// 渠道销售仓
			SSkuStockVO sSkuStockVO = sStockService.getSkuStock(skuCode, opChannelVO.getWarehouseForSales());
			if (sSkuStockVO.getCanUseQuantity() != null && sSkuStockVO.getCanUseQuantity() > 0) {
				return sSkuStockVO.getCanUseQuantity();
			}
		}
		return 0;
	}

	/**
	 *
	 * @Author lijing 把es 查询出来的数据设置到 productItemVO中
	 * @param vo
	 *            productItemVO 设置的值 对象
	 * @param productVO
	 *            es product 信息
	 * @param code
	 *            渠道code
	 */
	public void setProductItemProduct(ProductItemVO vo, PsProductVO productVO, String code) {
		if (null != vo && null != productVO && StringUtils.isNotBlank(code)) {
			// 设置活动的信息
			if (!CollectionUtils.isEmpty(productVO.getCampaignList())) {
				ProductCampaignVO pc = null;
				List<ProductCampaignVO> pcs = new ArrayList<>();
				for (PsCampaignVO bean : productVO.getCampaignList()) {

					// 袋子活动编码
					if (ConstUtil.excludeCampaigns.contains(bean.getCode())) {
						continue;
					}

					pc = new ProductCampaignVO();
					pc.setCreateTime(bean.getCreateTime());
					pc.setCumulative(bean.getCumulative());
					pc.setDiscountTypeId(bean.getDiscountTypeId());
					pc.setDiscountTypeName(bean.getDiscountTypeName());
					pc.setExpireTime(bean.getExpireTime());
					pc.setId(bean.getId());
					pc.setName(bean.getName());
					pc.setProductScopeId(bean.getProductScopeId());
					pc.setSkuCode(productVO.getCode());
					pc.setStartTime(bean.getStartTime());
					pc.setTitle(bean.getTitle());
					pcs.add(pc);
				}
				// 添加活动
				vo.setProductCampaignVOs(pcs);
			}
			// 设置其他的product 属性
			vo.setDiscountPrice(productVO.getDiscountPrice());
			vo.setId(productVO.getId());
			vo.setListIcon(productVO.getLargeIconList());
			vo.setNameZh(productVO.getNameCn());
			vo.setExpressType(productVO.getExpressType());
			vo.setName(productVO.getName());
			vo.setCode(productVO.getCode());
			vo.setTagList(productVO.getPsTags());
			vo.setDetailIcon(productVO.getSmallIconList());
			vo.setDetailImageList(productVO.getPicDetailMuls());
			vo.setSkuCategoryDesc(productVO.getSkuCategoryDesc());
			vo.setPicThumb(productVO.getPicThumb());
			vo.setBigImgUrl(productVO.getPicDetail());
			vo.setShortDescription(productVO.getDescription());

			// 设置品牌
			if (CollectionUtils.isNotEmpty(productVO.getBrands())) {
				vo.setBrandId(productVO.getBrands().get(0).getBrandId());
				vo.setBrandName(productVO.getBrands().get(0).getBrandName());
				vo.setBrandCountryName(productVO.getBrands().get(0).getBrandCountryName());
			}

			// 设置动态内容（全部走新的，老的动态内容没有了，alexzchen 20200428）
			log.info("设置动态内容");
			OpProdDynmDetailsSaveVO opProdDynmDetailsSaveVO = mcOpProdDynmcontDetailsService.getByProductCode(productVO.getCode());
			if (opProdDynmDetailsSaveVO != null && CollectionUtils.isNotEmpty(opProdDynmDetailsSaveVO.getAllDynmDetail())) {
				List<PsDynmContentVO> dynms = new ArrayList<>();
				PsDynmContentVO psDynmContentVO = null;

				for (OpProdDynmTitleVO opProdDynmTitleVO : opProdDynmDetailsSaveVO.getAllDynmDetail()) {
					psDynmContentVO = new PsDynmContentVO();

					if (CollectionUtils.isNotEmpty(opProdDynmTitleVO.getDynmDtatails())) {
						StringBuilder sb = new StringBuilder();

						for (OpProdDynmDetailVO opProdDynmDetailVO : opProdDynmTitleVO.getDynmDtatails()) {
							//'1-图片 2-文字 3表格'
							if (opProdDynmDetailVO.getDynmType() == 1) {    	// 图片类型
								if ("规格参数".equals(opProdDynmTitleVO.getTitleCn()) || "品牌故事".equals(opProdDynmTitleVO.getTitleCn())) {        //只有规格参数展示图片。品牌故事也要展示 20200528
									sb.append("<img width='100%' src='");
									sb.append("http://img.thebeastshop.com/" + opProdDynmDetailVO.getDynmContent());
									sb.append("'>");
								}
							} else if (opProdDynmDetailVO.getDynmType() == 2) {		//文字类型时
								if (StringUtils.isNotBlank(opProdDynmDetailVO.getDynmContent())) {

									String dynmContent = opProdDynmDetailVO.getDynmContent().replaceAll("\\\\r\\\\n", "\n");

									sb.append(dynmContent.replaceAll("\n", "</br>"));
									sb.append("</br>");
								}
							} else if (opProdDynmDetailVO.getDynmType() == 3) {    // 表格类型时

								if (StringUtils.isNotBlank(opProdDynmDetailVO.getDynmTitle())) {
									sb.append("<span style='float:left'>");
									sb.append(opProdDynmDetailVO.getDynmTitle());
									sb.append("：");
									sb.append("</span>");
								}
								if (StringUtils.isNotBlank(opProdDynmDetailVO.getDynmContent())) {
									sb.append("<span style='display:inline-block;'>");
									String dynmContent = opProdDynmDetailVO.getDynmContent().replaceAll("\\\\r\\\\n", "\n");
									sb.append(dynmContent.replaceAll("\n", "</br>"));
									sb.append("</span>");
								}
								sb.append("</br>");
							}
						}
						psDynmContentVO.setContent(sb.toString());
						psDynmContentVO.setTitleCn(opProdDynmTitleVO.getTitleCn());
						psDynmContentVO.setTitleEn(opProdDynmTitleVO.getTitleEn());

						if (StringUtils.isNotBlank(psDynmContentVO.getContent())) {
							dynms.add(psDynmContentVO);
						}

					}

				}
				vo.setItemDescs(dynms);
			}

			// 设置价格
			vo.setPrice(productVO.getListPrice());
			vo.setSmallImgUrl("http://img.thebeastshop.com/" + productVO.getPicList());
			if (!vo.getIsAppProduct()) {
				// 是否上架
				if (productVO.getOnShelfChnCodes().contains(code)) {
					vo.setIsShelf(1);
				}
				// 是否可售
				if (productVO.getChnSaleChnCodes().contains(code)) {
					vo.setIsSale(1);
				}
			}

			// 是否支持VIP折扣，1是0否
			vo.setAllowVipDiscount(productVO.getAllowVipDiscount());

			// 处理预告活动
			if (productVO.getPsAdvanceCampaignVO() != null) {
				PsCampaignVO pcVO = productVO.getPsAdvanceCampaignVO().getAdvanceCampaignList().get(0);
				AdvanceVO advanceVO = new AdvanceVO();
				advanceVO.setAdvanceEndTime(pcVO.getExpireTime());
				advanceVO.setAdvanceName(pcVO.getAdvanceName());
				advanceVO.setMaxPrice(productVO.getPsAdvanceCampaignVO().getMaxPrice());
				advanceVO.setMinPrice(productVO.getPsAdvanceCampaignVO().getMinPrice());
				advanceVO.setAdvancePriceTitle(pcVO.getAdvancePriceTitle());
				advanceVO.setAdvanceStartTime(pcVO.getStartTime());
				advanceVO.setApprovalState(pcVO.getApprovalState());
				advanceVO.setIsAdvance(pcVO.getAdvance());
				vo.setAdvanceVO(advanceVO);
			}

			// 是否是月送鲜花
			vo.setIsMonthSend(productVO.getIsMonthSend());
		} else {
			log.info("===设置 product 的 setProductItemProduct的参数为空");
		}
	}

	/**
	 * 根据关键字搜索
	 *
	 * @param code
	 * @param data
	 * @return JsonApiResult
	 */
	@ApiAuth
	@RequestMapping(value = "/product/favlist")
	@ResponseBody
	public JsonApiResult favlist(@RequestParam("CODE") String code, @RequestParam("DATA") String data)
			throws UnsupportedEncodingException {
		JSONObject jsonData = JSONObject.parseObject(data);
		String prodListStr = jsonData.getString("keyword");
		Boolean matchCampaign = jsonData.getBoolean("matchCampaign");
		Integer memberLevel = jsonData.getInteger("memberLevel");
		Integer accessWay = jsonData.getInteger("accessWay");
		if (StringUtils.isBlank(prodListStr)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		/** productCodes */
		List<String> prodList = JSON.parseArray(prodListStr, String.class);
		// 查询商品产生
		PsProductCond matchCampaignCond = null;
		BigDecimal discountAmount = BigDecimal.ZERO;
		if (matchCampaign != null && matchCampaign) {
			matchCampaignCond = new PsProductCond();
			matchCampaignCond.setChannelCode(code);
			matchCampaignCond.setMatchCampaign(true);
			matchCampaignCond.setMemberLevel(memberLevel);
			matchCampaignCond.setAccessWay(accessWay);
			matchCampaignCond.setCodes(prodList);
			discountAmount = MemberLevelEnum.getEnumByCode(memberLevel).getLevelAmountCondition();
			matchCampaignCond.setDiscount(discountAmount);
			matchCampaignCond.setChannelCode(code);
		}
		// 查询商品
		List<PsProductVO> producs = mcPsProductService.findByCond(matchCampaignCond, false);
		if (CollectionUtils.isEmpty(producs)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		Map<String, ProductItemVO> productItemVOList = new HashMap<String, ProductItemVO>();

		Long memberId = jsonData.getLong("memberId");
		MemberVO member = null;
		if (memberId != null) {
			member = memberQueryService.getById(memberId);

		} else {

			log.error("favlist memberId == null");
			// 默认会员
			member = memberQueryService.getById(1L);
		}
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);

		// ProductItemVO pi = null;
		// for (PsProductVO pp : producs) {
		//
		// if (CollectionUtils.isEmpty(pp.getChnCanSeeSKu())) {
		// continue;
		// }
		//
		// pi = new ProductItemVO();
		// if (CollectionUtils.isNotEmpty(pp.getBrands())) {
		// pi.setBrandId(pp.getBrands().get(0).getBrandId());
		// pi.setBrandName(pp.getBrands().get(0).getBrandName());
		// } else {
		// pi.setBrandName("");
		// }
		// pi.setDiscountPrice(pp.getDiscountPrice());
		// pi.setId(pp.getId());
		// pi.setListIcon(pp.getLargeIconList());
		// pi.setNameZh(pp.getNameCn());
		// if (pp.getCombined()) {
		// pi.setPrice(pp.getOriginalPrice());
		// } else {
		// pi.setPrice(pp.getListPrice());
		// }
		// if (StringUtils.isBlank(pp.getPicList())) {
		// pi.setSmallImgUrl("http://img.thebeastshop.com/js/grey.gif" +
		// pp.getPicList());
		// } else {
		// pi.setSmallImgUrl("http://img.thebeastshop.com/" + pp.getPicList());
		// }
		// // 库存判断
		// if (CollectionUtils.isNotEmpty(pp.getStocks())) {
		// for (PsChnStockVO psChnStockVO : pp.getStocks()) {
		// if ("CHN2018".equals(psChnStockVO.getChnCode())) {
		// // 无库存
		// if (psChnStockVO.getSoldOut() == 1) {
		// pi.setQuantity(0);
		// } else {
		// // 有库存
		// pi.setQuantity(1);
		// }
		// break;
		// }
		//
		// }
		// }
		// // 是否上架
		// if (pp.getOnShelfChnCodes().contains(code)) {
		// pi.setIsShelf(1);
		// }
		// // 是否可售
		// if (pp.getChnSaleChnCodes().contains(code)) {
		// pi.setIsSale(1);
		// }
		// pi.setShortDescription(pp.getDescription());
		// pi.setCode(pp.getCode());
		//
		// // 是否支持VIP折扣，1是0否
		// pi.setAllowVipDiscount(pp.getAllowVipDiscount());
		//
		// /** 描述 */
		// List<PsDynmContentVO> psDynmContentVOsDetail = new ArrayList<>();
		// if (CollectionUtils.isNotEmpty(pp.getDynmContents())) {
		// for (PsDynmContentVO psDynmContentVO : pp.getDynmContents()) {
		// if (null != psDynmContentVO &&
		// "DETAILS".equalsIgnoreCase(psDynmContentVO.getTitleEn())) {
		// psDynmContentVOsDetail.add(psDynmContentVO);
		// break;
		// }
		// }
		// }
		//
		// // 处理预告活动
		// if (pp.getPsAdvanceCampaignVO() != null) {
		// PsCampaignVO pcVO =
		// pp.getPsAdvanceCampaignVO().getAdvanceCampaignList().get(0);
		// AdvanceVO advanceVO = new AdvanceVO();
		// advanceVO.setAdvanceEndTime(pcVO.getExpireTime());
		// advanceVO.setAdvanceName(pcVO.getAdvanceName());
		// advanceVO.setMaxPrice(pp.getPsAdvanceCampaignVO().getMaxPrice());
		// advanceVO.setMinPrice(pp.getPsAdvanceCampaignVO().getMinPrice());
		// advanceVO.setAdvancePriceTitle(pcVO.getAdvancePriceTitle());
		// advanceVO.setAdvanceStartTime(pcVO.getStartTime());
		// advanceVO.setApprovalState(pcVO.getApprovalState());
		// advanceVO.setIsAdvance(pcVO.getAdvance());
		// pi.setAdvanceVO(advanceVO);
		// }
		//
		// pi.setItemDescs(psDynmContentVOsDetail);
		// // if(CollectionUtils.isNotEmpty(pp.getChnCanSeeSKu())){
		// productItemVOList.put(pp.getCode(), pi);
		// // }
		// }
		AccessWayEnum accessWay2 = AccessWayEnum.getEnumByCode(accessWay);
		List<ProductItemVO> itemVOList = setProductPrice(producs, member, opChannel, accessWay2);

		for (ProductItemVO item : itemVOList) {
			productItemVOList.put(item.getCode(), item);
		}

		return JsonApiResult.ofSuccessResult(productItemVOList);
	}

	/**
	 * 根据prod搜索
	 *
	 * @param code
	 * @param data
	 * @return JsonApiResult
	 */
	@ApiAuth
	@RequestMapping(value = "/product/list")
	@ResponseBody
	public JsonApiResult list(@RequestParam("CODE") String code, @RequestParam("DATA") String data)
			throws UnsupportedEncodingException {
		JSONObject jsonData = JSONObject.parseObject(data);

		String prodListStr = jsonData.getString("keyword");
		String currpageStr = jsonData.getString("currpage");
		String pagenumStr = jsonData.getString("pagenum");
		Boolean matchCampaign = jsonData.getBoolean("matchCampaign");
		Integer memberLevel = jsonData.getInteger("memberLevel");
		Integer accessWay = jsonData.getInteger("accessWay");
		Long memberId = jsonData.getLong("memberId");
		int currpage = 1;
		int pagenum = 20;

		if (StringUtils.isBlank(prodListStr)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		List<String> prodList = JSON.parseArray(prodListStr, String.class);

		log.info("/product/list->currpage===" + currpage);

		PsMatchCampaignCond matchCampaignCond = null;
		BigDecimal discountAmount = BigDecimal.ZERO;

		if (!StringUtils.isBlank(currpageStr)) {
			currpage = Integer.valueOf(currpageStr);
		}
		if (!StringUtils.isBlank(pagenumStr)) {
			pagenum = Integer.valueOf(pagenumStr);
		}

		if (matchCampaign != null && matchCampaign) {
			matchCampaignCond = new PsMatchCampaignCond();
			matchCampaignCond.setChannelCode(code);
			matchCampaignCond.setMatchCampaign(true);
			matchCampaignCond.setMemberLevel(memberLevel);
			matchCampaignCond.setAccessWay(accessWay);

			discountAmount = MemberLevelEnum.getEnumByCode(memberLevel).getLevelAmountCondition();
			matchCampaignCond.setDiscount(discountAmount);

			matchCampaignCond.setCurrpage(currpage);

			matchCampaignCond.setPagenum(pagenum);

		}

		List<PsProductVO> productList = mcPsProductService.findListPageByCodes(code, prodList, matchCampaignCond,
				currpage, pagenum);

		MemberVO member = null;
		if (memberId != null) {
			member = memberQueryService.getById(memberId);

		} else {
			member = memberQueryService.getById(1L);
		}
		//
		// List<PrsProductVO> prsProductVOList = new ArrayList<>();
		//
		// PrsCalcProductDTO arg0 = new PrsCalcProductDTO();
		// Map<String, List<PsSkuVO>> mapProductId =
		// itemAdpter.GetSkusByProducts(productList);
		// for (PsProductVO bean : productList) {
		// PrsProductVO product = itemAdpter.assembleProduct(bean,
		// mapProductId.get(bean.getId()), member);
		// prsProductVOList.add(product);
		// }
		//
		// arg0.setProductVOList(prsProductVOList);
		// arg0.setCampaignLimitList(itemAdpter.getPrsCampLimit4ProdsList(productList));
		// Map<Long, PrsProductPriceResultVO> priceVos =
		// prsPriceService.calculatePrs4ProductList(arg0);
		// // List<PsProductVO> producs =
		// // mcPsProductService.findByCond(matchCampaignCond,true);
		//
		// // List<PsProductVO> productList =
		// // mcPsProductService.calculateDiscountPrice( producs, memberLevel,
		// // accessWay, discountAmount);
		//
		// if (CollectionUtils.isEmpty(productList)) {
		// return
		// JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
		// ErrorCode.DATA_NOT_FOUND.getMesage());
		// }
		//
		Map<String, ProductItemVO> productItemVOList = new HashMap<String, ProductItemVO>();
		//
		// ProductItemVO pi = null;
		// ProductCampaignVO pc = null;
		// List<String> codes = new ArrayList<>();
		// for (PsProductVO pp : productList) {
		// codes.add(pp.getCode());
		// }

		// 取得商品的活动配置描述
		// Map<String, ProductCopywriterVO> activiyDescMap = new HashMap<>();
		// Map<String, ProductCopywriterVO> map =
		// mcPcsCopywriterService.selectProductCopywriterByProdCodes(codes);
		// if (map != null && map.size() > 0) {
		// activiyDescMap.putAll(map);
		// }
		//
		// for (PsProductVO pp : productList) {
		//
		// if (CollectionUtils.isEmpty(pp.getChnCanSeeSKu())) {
		// continue;
		// }
		//
		// pi = new ProductItemVO();
		// if (CollectionUtils.isNotEmpty(pp.getBrands())) {
		// pi.setBrandId(pp.getBrands().get(0).getBrandId());
		// pi.setBrandName(pp.getBrands().get(0).getBrandName());
		// } else {
		// pi.setBrandName("");
		// }
		//
		// PrsProductPriceResultVO priceVo =
		// priceVos.get(Long.parseLong(pp.getId()));
		//
		// pi.setId(pp.getId());
		// pi.setListIcon(pp.getLargeIconList());
		// pi.setNameZh(pp.getNameCn());
		// if (pp.getCombined()) {
		// pi.setPrice(pp.getOriginalPrice());
		// } else {
		// pi.setPrice(pp.getListPrice());
		// }
		//
		// pi.setDiscountPrice(pi.getPrice());
		// if (StringUtils.isBlank(pp.getPicList())) {
		// pi.setSmallImgUrl("http://img.thebeastshop.com/js/grey.gif" +
		// pp.getPicList());
		// } else {
		// pi.setSmallImgUrl("http://img.thebeastshop.com/" + pp.getPicList());
		// }
		//
		// List<ProductCampaignVO> pcs = new ArrayList<>();
		//
		// if (CollectionUtils.isNotEmpty(pp.getStocks())) {
		// for (PsChnStockVO psChnStockVO : pp.getStocks()) {
		// if ("CHN2018".equals(psChnStockVO.getChnCode())) {
		// // 无库存
		// if (psChnStockVO.getSoldOut() == 1) {
		// pi.setQuantity(0);
		// } else {
		// // 有库存
		// pi.setQuantity(1);
		// }
		// break;
		// }
		//
		// }
		// }
		//
		// for (PsSpvVO psSpv : pp.getSpvList()) {
		//
		// Map<Long, BigDecimal> mapSpv = itemAdpter.combineSpvPrice(priceVo);
		// BigDecimal spvDiscountPrice = mapSpv.get(psSpv.getSpvId());
		// if (spvDiscountPrice == null) {
		// spvDiscountPrice = psSpv.getDiscountPrice();
		// log.error("商品价格有误sprId={}", psSpv.getSpvId());
		//
		// } else {
		//
		// if (psSpv.getPsStockVO().getCanUseQuantity() > 0) {
		//
		// if (pi.getDiscountPrice().doubleValue() >
		// spvDiscountPrice.doubleValue()) {
		// pi.setDiscountPrice(spvDiscountPrice);
		// }
		// }
		//
		// }
		//
		// }
		//
		// // activityDesc 文案顺序:抢购-》预告-》后台配置
		// ProductCopywriterVO productCopywriterVO =
		// activiyDescMap.get(pp.getCode());
		//
		// if (productCopywriterVO != null) {
		// // 设置活动预告
		// pi.setActivityDesc(productCopywriterVO.getContent());
		// }
		//
		// // 处理预告活动
		// if (pp.getPsAdvanceCampaignVO() != null) {
		// PsCampaignVO pcVO =
		// pp.getPsAdvanceCampaignVO().getAdvanceCampaignList().get(0);
		// AdvanceVO advanceVO = new AdvanceVO();
		// advanceVO.setAdvanceEndTime(pcVO.getExpireTime());
		// advanceVO.setAdvanceName(pcVO.getAdvanceName());
		// advanceVO.setMaxPrice(pp.getPsAdvanceCampaignVO().getMaxPrice());
		// advanceVO.setMinPrice(pp.getPsAdvanceCampaignVO().getMinPrice());
		// advanceVO.setAdvancePriceTitle(pcVO.getAdvancePriceTitle());
		// advanceVO.setAdvanceStartTime(pcVO.getStartTime());
		// advanceVO.setApprovalState(pcVO.getApprovalState());
		// advanceVO.setIsAdvance(pcVO.getAdvance());
		//
		// String activityDesc = pcVO.getAdvancePriceTitle();
		// List<PsCampaignSectionVO> sectionList =
		// pcVO.getCampaignSectionList();
		// if (null != sectionList && CollectionUtils.isNotEmpty(sectionList) &&
		// sectionList.size() == 1) {
		// PsCampaignSectionVO section = sectionList.get(0);
		// if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_AMOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_AMOUNT.getId()))
		// {
		// activityDesc = activityDesc + " ￥" + section.getFactor();
		// } else if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_DISCOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_DISCOUNT.getId()))
		// {
		// activityDesc = activityDesc + " " + section.getFactor() + "折";
		// }
		// }
		//
		// pi.setActivityDesc(activityDesc);
		// pi.setAdvanceVO(advanceVO);
		// }
		// if (CollectionUtils.isNotEmpty(pp.getSpvList())) {
		//
		// for (PsSpvVO psSpv : pp.getSpvList()) {
		// if (!CollectionUtils.isEmpty(psSpv.getCampaignList())) {
		// for (PsCampaignVO bean : psSpv.getCampaignList()) {
		// if (DiscountType.PANIC_BUY.id.equals(bean.getDiscountTypeId())) {
		// pi.setIsPanicBuy(1);
		// pc = new ProductCampaignVO();
		// pc.setCreateTime(bean.getCreateTime());
		// pc.setCumulative(bean.getCumulative());
		// pc.setDiscountTypeId(bean.getDiscountTypeId());
		//
		// pc.setDiscountTypeName(bean.getDiscountTypeName());
		// pc.setExpireTime(bean.getExpireTime());
		// pc.setId(bean.getId());
		// pc.setName(bean.getName());
		// pc.setProductScopeId(bean.getProductScopeId());
		// pc.setSkuCode(pp.getCode());
		// pc.setStartTime(bean.getStartTime());
		// pc.setTitle(bean.getTitle());
		//
		// String activityDesc = bean.getTitle();
		// List<PsCampaignSectionVO> sectionList =
		// bean.getCampaignSectionList();
		//
		// if (null != sectionList && CollectionUtils.isNotEmpty(sectionList)
		// && sectionList.size() == 1) {
		// PsCampaignSectionVO section = sectionList.get(0);
		// if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_AMOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_AMOUNT.getId()))
		// {
		// activityDesc = activityDesc + " ￥" + section.getFactor();
		// } else if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_DISCOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_DISCOUNT.getId()))
		// {
		// activityDesc = activityDesc + " " + section.getFactor() + "折";
		// }
		// }
		// pi.setActivityDesc(activityDesc);
		//
		// pcs.add(pc);
		//
		// if (pi.getQuantity() <= 0) {
		// OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		// SPreparedStockQueryDTO dto = new SPreparedStockQueryDTO();
		// dto.setSkuCode(psSpv.getSkuCode());
		// dto.setBusinessCode(bean.getCode());
		// dto.setWarehouseCode(opChannel.getWarehouseForSales());
		// dto.setOccupyType(SStockOccupyTypeEnum.CAMPAIGN_OUT);
		// // 这里暂时不支付抢购
		// SPreparedStockVO sPreparedStockVO =
		// sStockService.getPreparedQuantity(dto);
		//
		// if (sPreparedStockVO != null &&
		// sPreparedStockVO.getPreparedQuantity() != null) {
		// pi.setQuantity(sPreparedStockVO.getPreparedQuantity());
		// }
		//
		// }
		//
		// break;
		// }
		// }
		//
		// // 添加活动
		// pi.setProductCampaignVOs(pcs);
		// }
		// }
		//
		// }
		//
		// // 是否上架
		// if (pp.getOnShelfChnCodes().contains(code)) {
		// pi.setIsShelf(1);
		// }
		// // 是否可售
		// if (pp.getChnSaleChnCodes().contains(code)) {
		// pi.setIsSale(1);
		// }
		//
		// pi.setShortDescription(pp.getDescription());
		// pi.setCode(pp.getCode());
		// // 是否支持VIP折扣，1是0否
		// pi.setAllowVipDiscount(pp.getAllowVipDiscount());
		//
		// // if(CollectionUtils.isNotEmpty(pp.getChnCanSeeSKu())){
		// productItemVOList.put(pp.getCode(), pi);
		// // }
		//
		// }

		AccessWayEnum accessWay2 = AccessWayEnum.getEnumByCode(accessWay);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		List<ProductItemVO> itemVOList = setProductPrice(productList, member, opChannel, accessWay2);

		for (ProductItemVO item : itemVOList) {
			productItemVOList.put(item.getCode(), item);
		}

		if (productItemVOList != null && productItemVOList.size() > 0) {
			List<ProductItemVO> list = new ArrayList<>();
			list.addAll(productItemVOList.values());
			setNewAttribute(list, memberLevel, prodList);
		}
		return JsonApiResult.ofSuccessResult(productItemVOList);

	}

	private JsonApiResult productItemsWeekRangeNew(String code, String data, Map<String, Date> dateRange) {
		JSONObject jsonData = JSONObject.parseObject(data);
		String currpage = jsonData.getString("currpage");
		String pagenum = jsonData.getString("pagenum");
		Boolean matchCampaign = jsonData.getBoolean("matchCampaign");
		Integer memberLevel = jsonData.getInteger("memberLevel");
		Integer accessWay = jsonData.getInteger("accessWay");

		if (StringUtils.isBlank(currpage)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		if (StringUtils.isBlank(pagenum)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		PsMatchCampaignCond matchCampaignCond = null;
		if (matchCampaign != null && matchCampaign) {
			matchCampaignCond = new PsMatchCampaignCond();
			matchCampaignCond.setChannelCode(code);
			matchCampaignCond.setMatchCampaign(true);
			matchCampaignCond.setMemberLevel(memberLevel);
			matchCampaignCond.setAccessWay(accessWay);
			matchCampaignCond.setDiscount(MemberLevelEnum.getEnumByCode(memberLevel).getLevelAmountCondition());
		}

		List<PsProductVO> productList = null;
		productList = mcPsProductService.findByChnCodeCateCodeCreateTime(code, dateRange, matchCampaignCond,
				Integer.valueOf(currpage), Integer.valueOf(pagenum));
		if (CollectionUtils.isEmpty(productList)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}

		// List<String> codes = new ArrayList<>();
		// for (PsProductVO pp : productList) {
		// codes.add(pp.getCode());
		// }

		// 取得商品的活动配置描述
		// Map<String, ProductCopywriterVO> activiyDescMap = new HashMap<>();
		// Map<String, ProductCopywriterVO> map =
		// mcPcsCopywriterService.selectProductCopywriterByProdCodes(codes);
		// if (map != null && map.size() > 0) {
		// activiyDescMap.putAll(map);
		// }
		// List<ProductItemVO> productItemVOList = new
		// ArrayList<ProductItemVO>();

		// ProductItemVO pi = null;
		// for (PsProductVO pp : productList) {
		//
		// pi = new ProductItemVO();
		// if (CollectionUtils.isNotEmpty(pp.getBrands())) {
		// pi.setBrandId(pp.getBrands().get(0).getBrandId());
		// pi.setBrandName(pp.getBrands().get(0).getBrandName());
		// }
		//
		// pi.setDiscountPrice(pp.getDiscountPrice());
		// pi.setId(pp.getId());
		// pi.setListIcon(pp.getLargeIconList());
		// pi.setNameZh(pp.getNameCn());
		// // pi.setPrice(pp.getListPrice());
		//
		// if (pp.getCombined()) {
		// pi.setPrice(pp.getOriginalPrice());
		// } else {
		// pi.setPrice(pp.getListPrice());
		// }
		//
		// if (StringUtils.isBlank(pp.getPicList())) {
		// pi.setSmallImgUrl("http://img.thebeastshop.com/js/grey.gif" +
		// pp.getPicList());
		// } else {
		// pi.setSmallImgUrl("http://img.thebeastshop.com/" + pp.getPicList());
		// }
		//
		// if (CollectionUtils.isNotEmpty(pp.getStocks())) {
		// for (PsChnStockVO psChnStockVO : pp.getStocks()) {
		// if ("CHN2018".equals(psChnStockVO.getChnCode())) {
		// // 无库存
		// if (psChnStockVO.getSoldOut() == 1) {
		// pi.setQuantity(0);
		// } else {
		// // 有库存
		// pi.setQuantity(1);
		// }
		// break;
		// }
		//
		// }
		// }
		//
		// pi.setShortDescription(pp.getDescription());
		// pi.setCode(pp.getCode());
		// // 是否支持VIP折扣，1是0否
		// pi.setAllowVipDiscount(pp.getAllowVipDiscount());
		//
		// // activityDesc 文案顺序:抢购-》预告-》后台配置
		// ProductCopywriterVO productCopywriterVO =
		// activiyDescMap.get(pp.getCode());
		//
		// if (productCopywriterVO != null) {
		// // 设置活动预告
		// pi.setActivityDesc(productCopywriterVO.getContent());
		// }
		//
		// // 处理预告活动
		// if (pp.getPsAdvanceCampaignVO() != null) {
		// PsCampaignVO pcVO =
		// pp.getPsAdvanceCampaignVO().getAdvanceCampaignList().get(0);
		// AdvanceVO advanceVO = new AdvanceVO();
		// advanceVO.setAdvanceEndTime(pcVO.getExpireTime());
		// advanceVO.setAdvanceName(pcVO.getAdvanceName());
		// advanceVO.setMaxPrice(pp.getPsAdvanceCampaignVO().getMaxPrice());
		// advanceVO.setMinPrice(pp.getPsAdvanceCampaignVO().getMinPrice());
		// advanceVO.setAdvancePriceTitle(pcVO.getAdvancePriceTitle());
		// advanceVO.setAdvanceStartTime(pcVO.getStartTime());
		// advanceVO.setApprovalState(pcVO.getApprovalState());
		// advanceVO.setIsAdvance(pcVO.getAdvance());
		// pi.setAdvanceVO(advanceVO);
		// String activityDesc = pcVO.getAdvancePriceTitle();
		// List<PsCampaignSectionVO> sectionList =
		// pcVO.getCampaignSectionList();
		// if (null != sectionList && CollectionUtils.isNotEmpty(sectionList) &&
		// sectionList.size() == 1) {
		// PsCampaignSectionVO section = sectionList.get(0);
		// if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_AMOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_AMOUNT.getId()))
		// {
		// activityDesc = activityDesc + " ￥" + section.getFactor();
		// } else if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_DISCOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_DISCOUNT.getId()))
		// {
		// activityDesc = activityDesc + " " + section.getFactor() + "折";
		// }
		// }
		// pi.setActivityDesc(pcVO.getAdvancePriceTitle());
		// }
		//
		// if (CollectionUtils.isNotEmpty(pp.getSpvList())) {
		// ProductCampaignVO pc = null;
		// List<ProductCampaignVO> pcs = new ArrayList<>();
		// for (PsSpvVO psSpv : pp.getSpvList()) {
		// if (!CollectionUtils.isEmpty(psSpv.getCampaignList())) {
		// for (PsCampaignVO bean : psSpv.getCampaignList()) {
		// if (DiscountType.PANIC_BUY.id.equals(bean.getDiscountTypeId())) {
		// pi.setIsPanicBuy(1);
		// pc = new ProductCampaignVO();
		// pc.setCreateTime(bean.getCreateTime());
		// pc.setCumulative(bean.getCumulative());
		// pc.setDiscountTypeId(bean.getDiscountTypeId());
		//
		// pc.setDiscountTypeName(bean.getDiscountTypeName());
		// pc.setExpireTime(bean.getExpireTime());
		// pc.setId(bean.getId());
		// pc.setName(bean.getName());
		// pc.setProductScopeId(bean.getProductScopeId());
		// pc.setSkuCode(pp.getCode());
		// pc.setStartTime(bean.getStartTime());
		// pc.setTitle(bean.getTitle());
		// pcs.add(pc);
		// String activityDesc = bean.getTitle();
		// List<PsCampaignSectionVO> sectionList =
		// bean.getCampaignSectionList();
		//
		// if (null != sectionList && CollectionUtils.isNotEmpty(sectionList)
		// && sectionList.size() == 1) {
		// PsCampaignSectionVO section = sectionList.get(0);
		// if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_AMOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_AMOUNT.getId()))
		// {
		// activityDesc = activityDesc + " ￥" + section.getFactor();
		// } else if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_DISCOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_DISCOUNT.getId()))
		// {
		// activityDesc = activityDesc + " " + section.getFactor() + "折";
		// }
		// }
		// pi.setActivityDesc(activityDesc);
		// break;
		// }
		// }
		//
		// // 添加活动
		// pi.setProductCampaignVOs(pcs);
		// }
		// }
		//
		// }
		//
		// productItemVOList.add(pi);
		// prodList.add(pi.getCode());
		// }

		Long memberId = jsonData.getLong("memberId");
		MemberVO member = null;
		if (memberId != null) {
			member = memberQueryService.getById(memberId);

		} else {

			log.error("favlist memberId == null");
			// 默认会员
			member = memberQueryService.getById(1L);
		}
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		AccessWayEnum accessWay2 = AccessWayEnum.getEnumByCode(accessWay);
		List<ProductItemVO> productItemVOList = setProductPrice(productList, member, opChannel, accessWay2);

		List<String> prodList = new ArrayList<>();
		for (ProductItemVO item : productItemVOList) {
			prodList.add(item.getCode());
		}

		setNewAttribute(productItemVOList, memberLevel, prodList);
		log.info("FIND PROD NUM: {}", productItemVOList.size());

		return JsonApiResult.ofSuccessResult(productItemVOList);
	}

	/**
	 * 推荐商品
	 *
	 * @param code
	 * @param data
	 * @return JsonApiResult
	 */
	@ApiAuth
	@RequestMapping(value = "/productRecommendation")
	@ResponseBody
	public JsonApiResult productRecommendation(@RequestParam("CODE") String code, @RequestParam("DATA") String data)
			throws UnsupportedEncodingException {
		clog.info("商品推荐参数，data="+data);
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		String distinguish = jsonData.getString("distinguish");
		String currpage = jsonData.getString("currpage");
		String pagenum = jsonData.getString("pagenum");
		String productCode = jsonData.getString("productCodes");
		Integer accessWay = jsonData.getInteger("accessWay");
		String campaignIdsStr = jsonData.getString("campaignIds");
		String orderCode = jsonData.getString("orderCode");
		String productCodesStr = jsonData.getString("productCodes");
		Integer memberLevel = 0;
		BigDecimal bdayDiscountRatio = BigDecimal.valueOf(1);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		MemberVO member = null;
		if (memberId != null) {
			member = memberQueryService.getById(memberId);
			if (member != null) {
				memberLevel = member.getMemberLevel();
				bdayDiscountRatio = member.getBdayDiscountRatio();
			}
		} else {
			// 默认会员
			member = memberQueryService.getById(1L);
		}

		Integer limitSize = 0;
		if (StringUtils.isNotBlank(pagenum)) {
			limitSize = Integer.valueOf(pagenum);
		}
		BigDecimal discount = MemberLevelEnum.getEnumByCode(memberLevel).getLevelAmountCondition();

		RecommendParamVO paramVO = new RecommendParamVO();
		paramVO.setAccessWay(accessWay);
		paramVO.setDiscount(discount);
		paramVO.setMemberLevel(memberLevel);
		paramVO.setLimitSize(limitSize);
		paramVO.setChnCode(code);
		paramVO.setBdDiscount(bdayDiscountRatio);
		if (member!=null){
			paramVO.setMemberCode(member.getCode());
		}

		List<PsProductVO> productList = null;
		// 运费凑单推荐
		if ("carriageOrder".equals(distinguish)) {
			paramVO.setType(RecommendParamVO.Type.ADD_ON_ITEM);
			productList = recommendService.autoRecommend(paramVO);
			// 活动凑单推荐
		} else if ("activityOrder".equals(distinguish)) {

			PsCampaignSearchCond matchCampaignCond = new PsCampaignSearchCond();
			matchCampaignCond.setMemberLevel(memberLevel);
			matchCampaignCond.setAccessWay(accessWay);
			matchCampaignCond.setDiscount(discount);
			matchCampaignCond.setSize(Integer.valueOf(pagenum));
			Integer from = (Integer.valueOf(currpage) - 1) * Integer.valueOf(pagenum);
			matchCampaignCond.setFrom(from);
			matchCampaignCond.setChannelCode(code);
			matchCampaignCond.setBdDiscount(bdayDiscountRatio);
			if (!StringUtils.isBlank(campaignIdsStr)) {
				List<Long> campaignIds = new ArrayList<>();
				String[] array = campaignIdsStr.split(",");
				for (String str : array) {
					campaignIds.add(Long.valueOf(str));
				}

				matchCampaignCond.setCampaignIds(campaignIds);
			}

			productList = mcPsProductService.findByCampaignSearchCond(matchCampaignCond);
		} else if ("recommendDetailProdList".equals(distinguish)) {
			paramVO.setProductCode(productCode);
			paramVO.setType(RecommendParamVO.Type.PROD_DETAIL);
			paramVO.setRecommendSceneTypeEnum(RecommendSceneTypeEnum.PRODUCT_DETAIL);		//阿里云智能推荐新增
			productList = recommendService.autoRecommend(paramVO);
			List<String> codes = productList.stream().map(a->a.getCode()).collect(Collectors.toList());
			// 订单完成时商品推荐
		} else if ("recommendOrderFinishProdList".equals(distinguish)) {
			OrderFinishRecommendParamVO orderParamVO = new OrderFinishRecommendParamVO();

			orderParamVO.setMemberLevel(memberLevel);
			orderParamVO.setAccessWay(accessWay);
			orderParamVO.setDiscount(discount);
			orderParamVO.setLimitSize(limitSize);
			orderParamVO.setChnCode(code);

			List<String> prods = itemAdpter.getProductCodes(orderCode, code);

			if (CollectionUtils.isEmpty(prods)) {
				return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
						ErrorCode.DATA_NOT_FOUND.getMesage());
			}

			orderParamVO.setProductCodes(prods);
			orderParamVO.setBdDiscount(bdayDiscountRatio);
			productList = recommendService.orderFinishRecommend(orderParamVO);

			// 默认时推荐商品
		} else if ("recommendProdList".equals(distinguish)) {
			paramVO.setRecommendSceneTypeEnum(RecommendSceneTypeEnum.CART);		//阿里云智能推荐新增
			productList = recommendService.getShoppingCartProcutList(paramVO);
		} else if ("recommendOrderProdList".equals(distinguish)) {

			OrderFinishRecommendParamVO orderParamVO = new OrderFinishRecommendParamVO();

			orderParamVO.setMemberLevel(memberLevel);
			orderParamVO.setAccessWay(accessWay);
			orderParamVO.setDiscount(discount);
			orderParamVO.setLimitSize(limitSize);
			orderParamVO.setChnCode(code);
			orderParamVO.setBdDiscount(bdayDiscountRatio);
			if (!StringUtils.isBlank(productCodesStr)) {
				String[] array = productCodesStr.split(",");
				orderParamVO.setProductCodes(Arrays.asList(array));
			}
			productList = recommendService.orderFinishRecommend(orderParamVO);
		}

		if (CollectionUtils.isEmpty(productList)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}

		// List<ProductItemVO> productItemVOList = new
		// ArrayList<ProductItemVO>();
		// List<String> prodList = new ArrayList<>();
		// ProductItemVO pi = null;
		//
		// if (memberId == null) {
		//
		// member = memberQueryService.getById(1L);
		// }
		//
		// AccessWayEnum accessWay2 = AccessWayEnum.getEnumByCode(accessWay);
		// Map<Long, SpvPriceVO> spvMap =
		// priceAdapter.getProductsPricesForWWW(productList, member, opChannel,
		// accessWay2);

		// List<String> codes = new ArrayList<>();
		// for (PsProductVO pp : productList) {
		// codes.add(pp.getCode());
		// }

		// 取得商品的活动配置描述
		// Map<String, ProductCopywriterVO> activiyDescMap = new HashMap<>();
		// Map<String, ProductCopywriterVO> map =
		// mcPcsCopywriterService.selectProductCopywriterByProdCodes(codes);
		// if (map != null && map.size() > 0) {
		// activiyDescMap.putAll(map);
		// }

		// for (PsProductVO pp : productList) {
		//
		// pi = new ProductItemVO();
		// if (CollectionUtils.isNotEmpty(pp.getBrands())) {
		// pi.setBrandId(pp.getBrands().get(0).getBrandId());
		// pi.setBrandName(pp.getBrands().get(0).getBrandName());
		// }
		//
		// pi.setDiscountPrice(BigDecimal.ZERO);
		// for (PsSpvVO psSpv : pp.getSpvList()) {
		//
		// SpvPriceVO sp = spvMap.get(psSpv.getSpvId());
		// if (sp == null) {
		// log.error("商品价格有误sprId={}", psSpv.getSpvId());
		// pi.setDiscountPrice(pp.getDiscountPrice());
		// } else {
		// if (pi.getDiscountPrice().doubleValue() >
		// sp.getDiscountPrice().doubleValue()) {
		// pi.setDiscountPrice(sp.getDiscountPrice());
		// }
		// }
		// }
		//
		// // if (member != null && member.isInBdayDiscountTime()) {// 生日折扣改价格
		// // if (pp.getAllowBdDiscount() == 1) {
		// //
		// //
		// pp.setDiscountPrice(PriceUtil.keepToCent(pp.getBdDiscountPrice()));
		// // }
		// // }
		//
		// pi.setId(pp.getId());
		// pi.setListIcon(pp.getLargeIconList());
		// pi.setNameZh(pp.getNameCn());
		// if (pp.getCombined()) {
		// pi.setPrice(pp.getOriginalPrice());
		// } else {
		// pi.setPrice(pp.getListPrice());
		// }
		// if (StringUtils.isBlank(pp.getPicList())) {
		// pi.setSmallImgUrl("http://img.thebeastshop.com/js/grey.gif" +
		// pp.getPicList());
		// } else {
		// pi.setSmallImgUrl("http://img.thebeastshop.com/" + pp.getPicList());
		// }
		//
		// if (CollectionUtils.isNotEmpty(pp.getStocks())) {
		// for (PsChnStockVO psChnStockVO : pp.getStocks()) {
		// if ("CHN2018".equals(psChnStockVO.getChnCode())) {
		// // 无库存
		// if (psChnStockVO.getSoldOut() == 1) {
		// pi.setQuantity(0);
		// } else {
		// // 有库存
		// pi.setQuantity(1);
		// }
		// break;
		// }
		//
		// }
		// }
		//
		// pi.setShortDescription(pp.getDescription());
		// pi.setCode(pp.getCode());
		// // 是否支持VIP折扣，1是0否
		// pi.setAllowVipDiscount(pp.getAllowVipDiscount());
		//
		// // activityDesc 文案顺序:抢购-》预告-》后台配置
		// ProductCopywriterVO productCopywriterVO =
		// activiyDescMap.get(pp.getCode());
		//
		// if (productCopywriterVO != null) {
		// // 设置活动预告
		// pi.setActivityDesc(productCopywriterVO.getContent());
		// }
		//
		// // 处理预告活动
		// if (pp.getPsAdvanceCampaignVO() != null) {
		// PsCampaignVO pcVO =
		// pp.getPsAdvanceCampaignVO().getAdvanceCampaignList().get(0);
		// AdvanceVO advanceVO = new AdvanceVO();
		// advanceVO.setAdvanceEndTime(pcVO.getExpireTime());
		// advanceVO.setAdvanceName(pcVO.getAdvanceName());
		// advanceVO.setMaxPrice(pp.getPsAdvanceCampaignVO().getMaxPrice());
		// advanceVO.setMinPrice(pp.getPsAdvanceCampaignVO().getMinPrice());
		// advanceVO.setAdvancePriceTitle(pcVO.getAdvancePriceTitle());
		// advanceVO.setAdvanceStartTime(pcVO.getStartTime());
		// advanceVO.setApprovalState(pcVO.getApprovalState());
		// advanceVO.setIsAdvance(pcVO.getAdvance());
		//
		// String activityDesc = pcVO.getAdvancePriceTitle();
		// List<PsCampaignSectionVO> sectionList =
		// pcVO.getCampaignSectionList();
		// if (null != sectionList && CollectionUtils.isNotEmpty(sectionList) &&
		// sectionList.size() == 1) {
		// PsCampaignSectionVO section = sectionList.get(0);
		// if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_AMOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_AMOUNT.getId()))
		// {
		// activityDesc = activityDesc + " ￥" + section.getFactor();
		// } else if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_DISCOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_DISCOUNT.getId()))
		// {
		// activityDesc = activityDesc + " " + section.getFactor() + "折";
		// }
		// }
		//
		// pi.setActivityDesc(activityDesc);
		//
		// pi.setAdvanceVO(advanceVO);
		// }
		//
		// if (CollectionUtils.isNotEmpty(pp.getSpvList())) {
		// ProductCampaignVO pc = null;
		// List<ProductCampaignVO> pcs = new ArrayList<>();
		// for (PsSpvVO psSpv : pp.getSpvList()) {
		// if (!CollectionUtils.isEmpty(psSpv.getCampaignList())) {
		// for (PsCampaignVO bean : psSpv.getCampaignList()) {
		// if (DiscountType.PANIC_BUY.id.equals(bean.getDiscountTypeId())) {
		// pi.setIsPanicBuy(1);
		// pc = new ProductCampaignVO();
		// pc.setCreateTime(bean.getCreateTime());
		// pc.setCumulative(bean.getCumulative());
		// pc.setDiscountTypeId(bean.getDiscountTypeId());
		//
		// pc.setDiscountTypeName(bean.getDiscountTypeName());
		// pc.setExpireTime(bean.getExpireTime());
		// pc.setId(bean.getId());
		// pc.setName(bean.getName());
		// pc.setProductScopeId(bean.getProductScopeId());
		// pc.setSkuCode(pp.getCode());
		// pc.setStartTime(bean.getStartTime());
		// pc.setTitle(bean.getTitle());
		// pcs.add(pc);
		// String activityDesc = bean.getTitle();
		// List<PsCampaignSectionVO> sectionList =
		// bean.getCampaignSectionList();
		//
		// if (null != sectionList && CollectionUtils.isNotEmpty(sectionList)
		// && sectionList.size() == 1) {
		// PsCampaignSectionVO section = sectionList.get(0);
		// if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_AMOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_AMOUNT.getId()))
		// {
		// activityDesc = activityDesc + " ￥" + section.getFactor();
		// } else if
		// (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_DISCOUNT.getId())
		// ||
		// section.getFactorType().equals(FactorTypeEnum.FIXED_DISCOUNT.getId()))
		// {
		// activityDesc = activityDesc + " " + section.getFactor() + "折";
		// }
		// }
		// pi.setActivityDesc(bean.getTitle());
		// break;
		// }
		// }
		//
		// // 添加活动
		// pi.setProductCampaignVOs(pcs);
		// }
		// }
		//
		// }
		//
		// productItemVOList.add(pi);
		// prodList.add(pi.getCode());
		// }
		FiltrateProdVO filtrateProdVO = new FiltrateProdVO();

		AccessWayEnum accessWay2 = AccessWayEnum.getEnumByCode(accessWay);
		List<ProductItemVO> productItemVOList = setProductPrice(productList, member, opChannel, accessWay2);
		List<String> prodList = new ArrayList<>();

		for (ProductItemVO item : productItemVOList) {
			prodList.add(item.getCode());
		}

		setNewAttribute(productItemVOList, memberLevel, prodList);
		filtrateProdVO.setProdItems(productItemVOList);
		return JsonApiResult.ofSuccessResult(filtrateProdVO);

	}

	/**
	 * 根据sku查询商品
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/product/syncbysku
	 */
	@ApiAuth
	@RequestMapping(value = "/itemDetail")
	@ResponseBody
	public JsonApiResult itembysku(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		// 取得sku
		String skuCode = jsonData.getString("code");

		// 根据skuCode查询
		PsProductVO psProductVO = mcPsProductService.findProdBySkuCode(skuCode);

		if (psProductVO == null) {
			// 根据prod Code查询
			psProductVO = mcPsProductService.findProdByCode(skuCode);
			if (psProductVO == null) {
				// 查组合prod
				psProductVO = mcPsProductService.findProdBySkuCode(skuCode, true);
				if (psProductVO == null) {
					return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), "未查到相应的product");
				}

			}

		}

		PsSkuVO psSkuVO = mcPsSkuService.findBySkuCode(skuCode);
		// if(psSkuVO == null){
		// return
		// JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
		// "未查到相应的sku");
		// }
		SkuItemDetailVO vo = setItemVO(psProductVO, psSkuVO, code);
		return JsonApiResult.ofSuccessResult(vo);
	}

	/**
	 * 根据sku查询商品
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/product/syncbysku
	 */
	// @ApiAuth
	// @RequestMapping(value = "/occupy")
	// @ResponseBody
	// public JsonApiResult occupy(@RequestParam("CODE") String code,
	// @RequestParam("DATA") String data) {
	// WareHouseVO wareHouseVO = JSON.parseObject(data, WareHouseVO.class);
	//
	// try {
	// itemAdpter.occupy(wareHouseVO);
	// } catch (Exception e) {
	// return
	// JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(),e.getLocalizedMessage());
	// }
	//
	// return JsonApiResult.ofSuccessResult("成功");
	// }

	/**
	 * 根据id查询品牌
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/product/syncbysku
	 */
	@ApiAuth
	@RequestMapping(value = "/findBrandById")
	@ResponseBody
	public JsonApiResult findBrandById(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		// 取得sku
		String brandId = jsonData.getString("brandId");

		if (!StringUtils.isBlank(brandId)) {
			PcsBrandVO pcsBrandVO = mcPcsBrandService.findById(Long.valueOf(brandId));

			return JsonApiResult.ofSuccessResult(pcsBrandVO);
		}
		return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());

	}

	/**
	 * 根据id查询品牌
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/product/syncbysku
	 */
	@ApiAuth
	@RequestMapping(value = "/forecastStatus")
	@ResponseBody
	public JsonApiResult forecastStatus(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {

		JSONObject jsonData = JSONObject.parseObject(data);
		// 取得sku
		Long memberId = jsonData.getLong("memberId");
		String productName = jsonData.getString("productName");
		String forecastId = jsonData.getString("forecastId");
		String productCode = jsonData.getString("productCode");
		String memberCode = jsonData.getString("memberCode");
		Integer subscribeEnum = jsonData.getInteger("subscribeEnum");

		if (null != memberId && subscribeEnum != null) {
			log.info("预告参数 forecastId={}，memberId={}，memberCode={},productCode={},productName={}", forecastId, memberId,
					memberCode, productCode, productName);
			SubscribeReq arg0 = new SubscribeReq();
			arg0.setForecastId(forecastId);
			arg0.setProductName(productName);
			arg0.setMemberId(memberId);
			arg0.setProductCode(productCode);

			arg0.setMemberCode(memberCode);

			if (SubscribeEnum.SUB.getCode() == subscribeEnum) {
				arg0.setSub(SubscribeEnum.SUB);
				SubscribeResp resp = forcastService.subscribe(arg0);
				log.info("预告提醒返回结果 state= {}", resp.getState().getName());
				if (resp.getState().equals(ResultState.SUCCESS)) {

					return JsonApiResult.ofSuccessResult("开售提醒开启成功！");
				} else {
					return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), "添加预告提醒失败！");
				}

			} else {
				arg0.setSub(SubscribeEnum.UNSUB);
				SubscribeResp resp = forcastService.subscribe(arg0);
				log.info("取消预告提醒返回结果 state= {}", resp.getState().getName());
				if (resp.getState().equals(ResultState.SUCCESS)) {
					return JsonApiResult.ofSuccessResult("开售提醒关闭成功！");
				} else {
					return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), "取消预告提醒失败！");
				}
			}

		} else {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

	}

	private SkuItemDetailVO setItemVO(PsProductVO psProductVO, PsSkuVO psSkuVO, String code) {

		SkuItemDetailVO vo = new SkuItemDetailVO();

		vo.setPicThumb(imageUrl(psProductVO.getPicThumb()));

		if (psProductVO.getCrossBorderFlag() != null && psProductVO.getCrossBorderFlag() == 1) {
			// 海淘产品
			vo.setCrossBorderFlag(1);
		} else {
			vo.setCrossBorderFlag(0);
		}
		vo.setExpressType(psProductVO.getExpressType());

		if (psSkuVO == null) {

			vo.setCode(psProductVO.getCode());
			vo.setId(Long.valueOf(psProductVO.getId()));
			vo.setName(psProductVO.getNameCn());
		} else {

			vo.setCode(psSkuVO.getSkuCode());
			vo.setId(psSkuVO.getSkuId());
			vo.setName(psSkuVO.getSkuNameCN());
			vo.setPrice(BigDecimal.valueOf(psSkuVO.getSalesPrice()));
			vo.setDiscountPrice(psSkuVO.getDiscountPrice());
			vo.setDeliveryPeriod(psSkuVO.getDeliveryPeriod());
			vo.setIsJit(psSkuVO.getIsJit());
			vo.setRemarkEnable(psSkuVO.getCanRemark());
		}

		return vo;
	}

	public String imageUrl(String imageUrl) {
		String url = imageUrl;
		if (!StringUtils.isBlank(imageUrl)) {

			if (imageUrl.indexOf("http://") >= 0) {
				url = imageUrl;
			} else {
				url = "http://img.thebeastshop.com/" + imageUrl;
			}

		}

		return url;
	}

	private final static Comparator<PsDynmContentVO> comparator = new Comparator<PsDynmContentVO>() {

		@Override
		public int compare(PsDynmContentVO o1, PsDynmContentVO o2) {
			int rlt = 0;
			if (o1.getSort().equals(o2.getSort())) {

				return rlt;

			}

			rlt = o1.getSort() < o2.getSort() ? -1 : 1;
			return rlt;
		}

	};

	/**
	 * 查询是否有预告商品
	 * 
	 * @param productItemVOList
	 */
	public void setNewAttribute(List<ProductItemVO> productItemVOList, Integer memberLevel, List<String> prodList) {

		if (CollectionUtils.isNotEmpty(productItemVOList)) {
			Map<String, List<ForcastVO>> prodForcastMap = forecastAdapter.getPrevueProductList(prodList);
			for (ProductItemVO vo : productItemVOList) {
				List<ForcastVO> forcastVOs = prodForcastMap.get(vo.getCode());
				if (CollectionUtils.isNotEmpty(forcastVOs)) {
					for (ForcastVO forcastVO : forcastVOs) {

						Date endtime = forcastVO.getEndTime();
						if (forcastVO.isLevel()) {

							Date endtime00 = forcastVO.getEndTime();
							Date endtime0 = forcastVO.getEndTime();
							Date endtime1 = forcastVO.getEndTime();
							Date endtime2 = forcastVO.getEndTime();
							Date endtime3 = forcastVO.getEndTime();
							List<LevelInfo> levels = forcastVO.getLevels();
							if (CollectionUtils.isNotEmpty(levels)) {
								for (LevelInfo level : levels) {
									switch (level.getMemberLevel()) {

									case -1:
										endtime00 = level.getEndTime();
										break;
									case 0:
										endtime0 = level.getEndTime();
										break;
									case 1:
										endtime1 = level.getEndTime();
										break;
									case 2:
										endtime2 = level.getEndTime();
										break;
									case 3:
										endtime3 = level.getEndTime();
										break;
									default:
										break;
									}
								}

							}
							switch (memberLevel) {
							case -1:
								endtime = endtime00;
								break;
							case 0:
								endtime = endtime0;
								break;
							case 1:
								endtime = endtime1;
								break;
							case 2:
								endtime = endtime2;
								break;
							case 3:
								endtime = endtime3;
								break;
							default:
								break;
							}
						}

						if (null != forcastVO && endtime.after(new Date())) {
							vo.setForetell(true);
							if (vo.getQuantity() <= 0) {
								vo.setQuantity(1000);
							}
						}
					}
				}
				// 库存预警
				vo.setStockWarn(stockAdapter.stockWarn(vo.getQuantity()));
			}

		}
	}

	/**
	 * 价格计算会员对象转换 包括设置新用户标签
	 * 
	 * @param source
	 * @return
	 */
	private PrsMemberVO convert4MemberVO(MemberVO source, Boolean isNewMember) {
		if (null == source)
			return null;

		PrsMemberVO target = new PrsMemberVO();
		target.setBirthday(source.getBirthday());
		target.setCode(source.getCode());
		target.setId(source.getId());
		target.setMemberLevel(source.getMemberLevel());
		target.setNickName(source.getNickName());
		target.setFishMan(isNewMember);
		return target;

	}

	/**
	 * 获取新客标识 默认会员：则表示未登录，按照新客处理 非默认会员：通过会员服务查是否新客
	 * 
	 * @param memberId
	 * @return
	 */
	protected Boolean getNewcomerFlag(Long memberId) {
		if (MemberConstant.DEFAULT_MEMBER_ID.equals(memberId)) {
			return true;
		}
		return memberQueryService.isNewMember(memberId);
	}

	private List<ProductItemVO> setProductPrice(List<PsProductVO> productList, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay) {
		List<ProductItemVO> productItemVOList = new ArrayList<ProductItemVO>();
		List<PrsProductVO> prsProductVOList = new ArrayList<>();

		Map<String, List<PsSkuVO>> mapProductId = itemAdpter.GetSkusByProducts(productList);
		for (PsProductVO bean : productList) {
			PrsProductVO product = itemAdpter.assembleProduct(bean, mapProductId.get(bean.getId()), member);
			prsProductVOList.add(product);
		}

		PrsCalcProductDTO arg0 = new PrsCalcProductDTO();
		PrsMemberVO arg1 = convert4MemberVO(member, getNewcomerFlag(member.getId()));
		arg0.setAccessWay(AccessWayEnum.getEnumByCode(accessWay.getCode()));
		arg0.setChannelCode(opChannel.getCode());
		arg0.setMemberVO(arg1);
		arg0.setProductVOList(prsProductVOList);
		arg0.setCampaignLimitList(itemAdpter.getPrsCampLimit4ProdsList(productList));
		Map<Long, PrsProductPriceResultVO> priceVos = prsPriceService.calculatePrs4ProductList(arg0);

		List<String> codes = new ArrayList<>();

		Map<String, SSkuStockVO> stockMap = new HashMap<>();
		Map<String, SPresaleSaleInvVO> spresaleMap = new HashMap<>();
		List<String> skuCodes = new ArrayList<>();
		for (PsProductVO pp : productList) {
			codes.add(pp.getCode());
			for (PsSpvVO psSpv : pp.getSpvList()) {
				if (psSpv.getCombined()) {
					for (PsSkuCombinationVO sc : psSpv.getSkuCombinationList()) {
						skuCodes.add(sc.getSubSkuCode());
					}
				} else {
					skuCodes.add(psSpv.getSkuCode());
				}
			}
		}

		stockMap.putAll(sStockService.getSkuStocks(skuCodes, opChannel.getWarehouseForSales()));
		
		
		spresaleMap.putAll(sPresaleService.findCanUseQttBySkuCodes(skuCodes, SPresaleChannelTypeEnum.CHANNEL_TYPE_BEAST.getCode()));
		
		// 取得商品的活动配置描述
		Map<String, ProductCopywriterVO> activiyDescMap = new HashMap<>();
		Map<String, ProductCopywriterVO> map = mcPcsCopywriterService.selectProductCopywriterByProdCodes(codes);
		if (map != null && map.size() > 0) {
			activiyDescMap.putAll(map);
		}

		ProductItemVO pi = null;
		ProductCampaignVO pc = null;

		for (PsProductVO pp : productList) {
			pi = new ProductItemVO();
			if (CollectionUtils.isNotEmpty(pp.getBrands())) {
				pi.setBrandId(pp.getBrands().get(0).getBrandId());
				pi.setBrandName(pp.getBrands().get(0).getBrandName());
			} else {
				pi.setBrandName("");
			}

			PrsProductPriceResultVO priceVo = priceVos.get(Long.parseLong(pp.getId()));

			pi.setId(pp.getId());
			pi.setListIcon(pp.getLargeIconList());
			pi.setNameZh(pp.getNameCn());
			if (pp.getCombined()) {
				pi.setPrice(pp.getOriginalPrice());
			} else {
				pi.setPrice(pp.getListPrice());
			}

//			if (pp.getDiscountPrice() != null) {
//				pi.setDiscountPrice(pp.getDiscountPrice());
//			} else {
				pi.setDiscountPrice(pi.getPrice());
//			}

			if (StringUtils.isBlank(pp.getPicList())) {
				pi.setSmallImgUrl("http://img.thebeastshop.com/js/grey.gif" + pp.getPicList());
			} else {
				pi.setSmallImgUrl("http://img.thebeastshop.com/" + pp.getPicList());
			}

			List<ProductCampaignVO> pcs = new ArrayList<>();

			if (CollectionUtils.isNotEmpty(pp.getStocks())) {
				for (PsChnStockVO psChnStockVO : pp.getStocks()) {
					if ("CHN2018".equals(psChnStockVO.getChnCode())) {
						pi.setQuantity(psChnStockVO.getStock());
						// 无库存
						/*
						 * if (psChnStockVO.getSoldOut() == 1) {
						 * pi.setQuantity(0); } else { // 有库存 pi.setQuantity(1);
						 * }
						 */
						break;
					}

				}
			}
			if (CollectionUtils.isNotEmpty(pp.getSpvList())) {
				for (PsSpvVO psSpv : pp.getSpvList()) {

					// if(psSpv.getSkuVO()!=null){
					boolean discountPriceBool = true;

					Map<Long, BigDecimal> mapSpv = itemAdpter.combineSpvPrice(priceVo);
					BigDecimal spvDiscountPrice = mapSpv.get(psSpv.getSpvId());

					if (spvDiscountPrice == null) {
						spvDiscountPrice = psSpv.getDiscountPrice();
						log.error("商品价格有误sprId={}", psSpv.getSpvId());

					} else {

						if (psSpv.getCombined()) {
							for (PsSkuCombinationVO sc : psSpv.getSkuCombinationList()) {
								SSkuStockVO sSkuStockVO = stockMap.get(sc.getSubSkuCode());

								if (sSkuStockVO.getCanUseQuantity() <= 0) {
									discountPriceBool = false;
									break;

								}

							}

						} else {
							SSkuStockVO sSkuStockVO = stockMap.get(psSpv.getSkuCode());
							if (sSkuStockVO.getCanUseQuantity() <= 0) {
								discountPriceBool = false;
								if(spresaleMap.get(psSpv.getSkuCode()) != null && spresaleMap.get(psSpv.getSkuCode()).getCanUseInv()>0){
									discountPriceBool = true;
								}
								

							}

							// if(psSpv !=null && psSpv.getCanUseQuantity()!=
							// null && psSpv.getCanUseQuantity() <= 0){
							// discountPriceBool = false;
							// }

						}

					}

					if (discountPriceBool) {
						if (pi.getDiscountPrice().doubleValue() > spvDiscountPrice.doubleValue()) {
							pi.setDiscountPrice(spvDiscountPrice);
						}
					}

					// }

					if (!CollectionUtils.isEmpty(psSpv.getCampaignList())) {
						for (PsCampaignVO bean : psSpv.getCampaignList()) {
							if (DiscountType.PANIC_BUY.id.equals(bean.getDiscountTypeId())) {
								pi.setIsPanicBuy(1);
								pc = new ProductCampaignVO();
								pc.setCreateTime(bean.getCreateTime());
								pc.setCumulative(bean.getCumulative());
								pc.setDiscountTypeId(bean.getDiscountTypeId());

								pc.setDiscountTypeName(bean.getDiscountTypeName());
								pc.setExpireTime(bean.getExpireTime());
								pc.setId(bean.getId());
								pc.setName(bean.getName());
								pc.setProductScopeId(bean.getProductScopeId());
								pc.setSkuCode(pp.getCode());
								pc.setStartTime(bean.getStartTime());
								pc.setTitle(bean.getTitle());

								String activityDesc = bean.getTitle();
								List<PsCampaignSectionVO> sectionList = bean.getCampaignSectionList();

								if (null != sectionList && CollectionUtils.isNotEmpty(sectionList)
										&& sectionList.size() == 1) {
									PsCampaignSectionVO section = sectionList.get(0);
									if (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_AMOUNT.getId())
											|| section.getFactorType().equals(FactorTypeEnum.FIXED_AMOUNT.getId())) {
										activityDesc = activityDesc + " ￥" + section.getFactor();
									} else if (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_DISCOUNT.getId())
											|| section.getFactorType().equals(FactorTypeEnum.FIXED_DISCOUNT.getId())) {
										activityDesc = activityDesc + " " + section.getFactor() + "折";
									}
								}
								pi.setActivityDesc(activityDesc);

								pcs.add(pc);

								if (pi.getQuantity() <= 0) {

									SPreparedStockQueryDTO dto = new SPreparedStockQueryDTO();
									dto.setSkuCode(psSpv.getSkuCode());
									dto.setBusinessCode(bean.getCode());
									dto.setWarehouseCode(opChannel.getWarehouseForSales());
									dto.setOccupyType(SStockOccupyTypeEnum.CAMPAIGN_OUT);
									// 这里暂时不支付抢购
									SPreparedStockVO sPreparedStockVO = sStockService.getPreparedQuantity(dto);

									if (sPreparedStockVO != null && sPreparedStockVO.getPreparedQuantity() != null) {
										pi.setQuantity(sPreparedStockVO.getPreparedQuantity());
									}

								}

								break;
							}
						}
					}

					// 添加活动
					pi.setProductCampaignVOs(pcs);

				}
			}

			// activityDesc 文案顺序:抢购-》预告-》后台配置
			ProductCopywriterVO productCopywriterVO = activiyDescMap.get(pp.getCode());

			if (productCopywriterVO != null) {
				// 设置活动预告
				pi.setActivityDesc(productCopywriterVO.getContent());
			}

			// 处理预告活动
			if (pp.getPsAdvanceCampaignVO() != null) {
				PsCampaignVO pcVO = pp.getPsAdvanceCampaignVO().getAdvanceCampaignList().get(0);
				AdvanceVO advanceVO = new AdvanceVO();
				advanceVO.setAdvanceEndTime(pcVO.getExpireTime());
				advanceVO.setAdvanceName(pcVO.getAdvanceName());
				advanceVO.setMaxPrice(pp.getPsAdvanceCampaignVO().getMaxPrice());
				advanceVO.setMinPrice(pp.getPsAdvanceCampaignVO().getMinPrice());
				advanceVO.setAdvancePriceTitle(pcVO.getAdvancePriceTitle());
				advanceVO.setAdvanceStartTime(pcVO.getStartTime());
				advanceVO.setApprovalState(pcVO.getApprovalState());
				advanceVO.setIsAdvance(pcVO.getAdvance());

				String activityDesc = pcVO.getAdvancePriceTitle();
				List<PsCampaignSectionVO> sectionList = pcVO.getCampaignSectionList();
				if (null != sectionList && CollectionUtils.isNotEmpty(sectionList) && sectionList.size() == 1) {
					PsCampaignSectionVO section = sectionList.get(0);
					if (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_AMOUNT.getId())
							|| section.getFactorType().equals(FactorTypeEnum.FIXED_AMOUNT.getId())) {
						activityDesc = activityDesc + " ￥" + section.getFactor();
					} else if (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_DISCOUNT.getId())
							|| section.getFactorType().equals(FactorTypeEnum.FIXED_DISCOUNT.getId())) {
						activityDesc = activityDesc + " " + section.getFactor() + "折";
					}
				}

				pi.setActivityDesc(activityDesc);
				pi.setAdvanceVO(advanceVO);
			}

			// 是否上架
			if (pp.getOnShelfChnCodes().contains(opChannel.getCode())) {
				pi.setIsShelf(1);
			}
			// 是否可售
			if (pp.getChnSaleChnCodes().contains(opChannel.getCode())) {
				pi.setIsSale(1);
			}

			pi.setShortDescription(pp.getDescription());
			pi.setCode(pp.getCode());
			// 是否支持VIP折扣，1是0否
			pi.setAllowVipDiscount(pp.getAllowVipDiscount());

			// if(CollectionUtils.isNotEmpty(pp.getChnCanSeeSKu())){S
			productItemVOList.add(pi);
			// }

			/** 描述 */
			List<PsDynmContentVO> psDynmContentVOsDetail = new ArrayList<>();
			if (CollectionUtils.isNotEmpty(pp.getDynmContents())) {
				for (PsDynmContentVO psDynmContentVO : pp.getDynmContents()) {
					if (null != psDynmContentVO && "DETAILS".equalsIgnoreCase(psDynmContentVO.getTitleEn())) {
						psDynmContentVOsDetail.add(psDynmContentVO);
						break;
					}
				}
			}
			pi.setItemDescs(psDynmContentVOsDetail);
		}

		return productItemVOList;
	}

}
