package com.thebeastshop.pegasus.channelservice.controller.ipos;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.commdata.service.CommAddressService;
import com.thebeastshop.commdata.vo.CommDistrictVO;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.utils.BeanUtil;
import com.thebeastshop.common.utils.ValidationUtil;
import com.thebeastshop.member.dto.LoginDTO;
import com.thebeastshop.member.dto.MemberLoginQueryCondDTO;
import com.thebeastshop.member.dto.RegisterDTO;
import com.thebeastshop.member.enums.GenderEnum;
import com.thebeastshop.member.enums.LoginTypeEnum;
import com.thebeastshop.member.enums.RegisterSourceEnum;
import com.thebeastshop.member.enums.TitleEnum;
import com.thebeastshop.member.service.MemberIposService;
import com.thebeastshop.member.service.MemberLoginQueryService;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.service.MemberService;
import com.thebeastshop.member.service.point.MemberPointService;
import com.thebeastshop.member.vo.MemberIposVO;
import com.thebeastshop.member.vo.MemberLoginVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.member.vo.point.MemberPointVO;
import com.thebeastshop.message.enums.MsgTypeEnum;
import com.thebeastshop.message.enums.PublishTypeEnum;
import com.thebeastshop.message.service.MsgSendService;
import com.thebeastshop.message.vo.SingleSmsTemplateVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.ipos.MemberAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.vo.ipos.UserCreateVO;
import com.thebeastshop.pegasus.channelservice.vo.website.user.UserQueryVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpMemberVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesVO;
import com.thebeastshop.wms.constant.PegasusConstants;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.math.BigDecimal;
import java.util.*;


@Controller("iposUserController")
@RequestMapping("/api/ipos/user")
public class UserController {

	private PegasusChannelServiceFacade pcInstance=PegasusChannelServiceFacade.getInstance();
	
	@Autowired
	private  MemberAdapter memberAdapter;
	
	@Autowired
	private MemberService memberService;
	
	@Autowired
    private MemberPointService memberPointService;
	
	@Autowired
	private MemberIposService memberIposService;
	
	@Autowired
	private MemberQueryService memberQueryService;
	
	@Autowired
	private MemberLoginQueryService memberLoginQueryService;

	@Autowired
	private MsgSendService msgSendService;

	@Autowired
	private CommAddressService commAddressService;
	
	private Integer getTitle(Integer sex){
		if(GenderEnum.MALE.getCode().equals(sex)){
			return TitleEnum.MR.getCode();
		}else if(GenderEnum.FEMALE.getCode().equals(sex)){
			return TitleEnum.MISS.getCode();
		}
		return TitleEnum.UNKNOWN.getCode();
	}
	
	private OpMemberVO toMemberVO(MemberVO member, Integer loginType){
		MemberPointVO memberPointVO = memberPointService.getMemberPointVO(member.getId(), member.getCode());
		OpMemberVO memberVO = BeanUtil.buildFrom(member, OpMemberVO.class);
		memberVO.setPoint(memberPointVO.getCommonMemberPointValid().doubleValue());
		memberVO.setHistoryPoint(memberPointVO.getExpirelevelMemberPoint().doubleValue());
		memberVO.setMemberType(loginType);
		BigDecimal expenseValid = memberPointService.findAvailablePointByCode(member.getId(), member.getCode());
		if(expenseValid!=null){
			memberVO.setExpenseValid(expenseValid);
		}else{
			memberVO.setExpenseValid(BigDecimal.ZERO);
		}
		if(member.getDistrictId()!=null&&member.getDistrictId()>0){
			CommDistrictVO commonDistrict=commAddressService.findDistrictById(member.getDistrictId().intValue());
			if(commonDistrict!=null){
				//FULL_NAME 全名，国家-省-市-区
			  String fullName=	commonDistrict.getFullName();
			  if(StringUtils.isNotBlank(fullName)){
				String []names=  fullName.split("-");
				if(names!=null&&names.length==4){
					memberVO.setProvince(names[1]);
					memberVO.setCity(names[2]);
					memberVO.setDistrict(names[3]);
				}
			  }
			}
		}
		return memberVO;
	}
	
	/***
	 * 根据手机号或者邮箱。查询用户
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value="/search")
	@ResponseBody
	public JsonApiResult search(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		JSONObject json= JSONObject.parseObject(data);
		String loginId=json.getString("username");
	
		if(StringUtils.isBlank(loginId)){
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
         if(getMemberType(loginId)==-1){
        	 return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
         }
         OpMemberVO opMemberVO = null;
         MemberLoginQueryCondDTO dto = new MemberLoginQueryCondDTO();
         dto.setLoginId(loginId);
         dto.setLoginType(getMemberType(loginId));
         List<MemberLoginVO> list = memberLoginQueryService.getByCond(dto);
         if(CollectionUtils.isNotEmpty(list)){
        	 MemberLoginVO memberLogin=list.get(0);
        	 opMemberVO = toMemberVO(memberQueryService.getById(memberLogin.getMemberId()), memberLogin.getLoginType());
         }
		 if(null==opMemberVO){
			 return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_NOT_EXIST.getCode(), ErrorCode.USER_LOGIN_NOT_EXIST.getMesage());
		 }
		 return JsonApiResult.ofSuccessResult(opMemberVO);
	}
	
	/***
	 * 根据手机号或者邮箱。查询用户(最多凡返回三个)
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value="/searchList")
	@ResponseBody
	public JsonApiResult searchList(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		JSONObject json = JSONObject.parseObject(data);
		String loginId = json.getString("username");

		if (StringUtils.isBlank(loginId)) {
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(),
					ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
		MemberLoginQueryCondDTO cond = new MemberLoginQueryCondDTO();
		cond.setLoginId(loginId);
		cond.setCompleteMatching(false);
		cond.setLoginTypes(Lists.newArrayList(LoginTypeEnum.EMAIL.getCode(),LoginTypeEnum.MOBILE.getCode()));
		List<MemberLoginVO> list = memberLoginQueryService.getByCond(cond);
		if (CollectionUtils.isEmpty(list)) {
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_NOT_EXIST.getCode(), ErrorCode.USER_LOGIN_NOT_EXIST.getMesage());
		}
		List<OpMemberVO> opMemberVOs = Lists.newArrayListWithExpectedSize(list.size());
		for (MemberLoginVO login : list) {
			MemberVO memberVO = memberQueryService.getById(login.getMemberId());
			opMemberVOs.add(toMemberVO(memberVO, login.getLoginType()));
		}
		return JsonApiResult.ofSuccessResult(opMemberVOs);
	}
	
	
	/***
	 * 手机用户注册
	 * @param code
	 * @param data
	 * @return
	 * 对应 /beast_site/user/mobile/reg
	 */
	@ApiAuth
	@RequestMapping(value="/mobile/register")
	@ResponseBody
	public JsonApiResult mobileRegister(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		UserCreateVO userCreateVO=JSONObject.parseObject(data,UserCreateVO.class);
		RegisterDTO memberRegisterVO = new RegisterDTO();
		memberRegisterVO.setGender(userCreateVO.getSex());
		memberRegisterVO.setMobile(userCreateVO.getMobile());
		memberRegisterVO.setLoginType(LoginTypeEnum.MOBILE.getCode());
		memberRegisterVO.setNickName(userCreateVO.getName());
		memberRegisterVO.setPassword(userCreateVO.getPassword());
		memberRegisterVO.setRegisterSource(RegisterSourceEnum.SHOP.getCode());
		memberRegisterVO.setTitle(getTitle(userCreateVO.getSex()));
		memberRegisterVO.setLoginId(userCreateVO.getMobile());
		memberRegisterVO.setBirthday(userCreateVO.getBirthday());
		memberRegisterVO.setChannelCode(code);
		memberRegisterVO.setPassword(getRandomPassword());//随机密码
		ServiceResp<MemberVO> resp = memberService.register(memberRegisterVO);
		if (resp != null) {
			if (resp.isSuccess()) {
				MemberVO result = resp.getBean();
				MemberIposVO  record = new MemberIposVO();
				record.setAgeGroup(userCreateVO.getAgeGroup());
				record.setChannelCode(code);
				record.setCityId(userCreateVO.getCityId());
				record.setCreateTime(new Date());
				record.setMemberid(result.getId());
				record.setStatus(0);
				record.setUpdateTime(new Date());
				memberIposService.create(record);
				
				// 注册成功发送短信通知
				SingleSmsTemplateVO smsTemplateVO  = new SingleSmsTemplateVO();
				smsTemplateVO.setMsgTo(userCreateVO.getMobile());
		        Map<String, Object> params = new HashMap<String, Object>();
		        params.put("passwd", memberRegisterVO.getPassword());
				smsTemplateVO.setTemplateName("REGISTER_SUCCESS_BS");
				smsTemplateVO.setParams(params);
				smsTemplateVO.setMsgType(MsgTypeEnum.SmsMsg);
				smsTemplateVO.setPublishType(PublishTypeEnum.IDENTIFYING_CODE);
				msgSendService.sendInterfaceVOTemplate(Arrays.asList(smsTemplateVO));

				UserQueryVO userVO=memberAdapter.common2ipos(result, memberRegisterVO.getLoginType());
				return JsonApiResult.ofSuccessResult(userVO);
			} else {
				return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), resp.getRespMsg());
			}
		}
		return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
	}
	
	
	/***
	 * 根据用户登陆名称，返回用户类型,只有手机用户和邮箱用户，可以根据旧密码，修改新密码
	 * @param loginId
	 * @return
	 */
	private Integer getMemberType(String loginId){
		if(ValidationUtil.isEmail(loginId)){
			return LoginTypeEnum.EMAIL.getCode();
		}
		if(ValidationUtil.isMobile(loginId)){
			return LoginTypeEnum.MOBILE.getCode();
		}
		return -1;
	}
	
	/***
	 * 获取ipos注册用户的随机生成密码 2-9之间6位
	 * @return
	 */
	private String getRandomPassword(){
		String IntString="23456789";//随机密码范围
		StringBuilder sb=new StringBuilder();
		int length=6;//随机密码位数
		Random random=new Random();
		for(int i=0;i<length;i++){
			sb.append(IntString.charAt(random.nextInt(IntString.length())));
		}
		return sb.toString();
	}
	
	/***
	 * 实体店店员登陆
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value="/shop/login")
	@ResponseBody
	public JsonApiResult shopUserLogin(@RequestParam("CODE") String code,@RequestParam("DATA") String data){
		JSONObject jsonData=JSONObject.parseObject(data);
		String loginName=jsonData.getString("loginName");
		String loginPwd=jsonData.getString("loginPwd");
		if(StringUtils.isBlank(loginPwd)||StringUtils.isBlank(loginName)){
			return JsonApiResult.ofErrorResult(ErrorCode.AUTHFAILED_MISS_PARAMS.getCode(), ErrorCode.AUTHFAILED_MISS_PARAMS.getMesage());
		}
		OpSalesVO opSalesVO=pcInstance.salesLogin(loginName, loginPwd);
		if(opSalesVO!=null){
			if(opSalesVO.getSalesStatus()== PegasusConstants.STATUS_UNAVAILABLE){
				return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(),ErrorCode.USER_LOGIN_FAILED.getMesage());//TODO 增加用户不可用状态
			}else{
				return JsonApiResult.ofSuccessResult(opSalesVO);
			}
		}
		return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(),ErrorCode.USER_LOGIN_FAILED.getMesage());
	}
	
	
	/***
	 * 实体店店员登陆
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value="/shop/findSaleById")
	@ResponseBody
	public JsonApiResult findSaleById(@RequestParam("CODE") String code,@RequestParam("DATA") String data){
		JSONObject jsonData=JSONObject.parseObject(data);
		Long saleId=jsonData.getLong("saleId");

		
		OpSalesVO opSalesVO=pcInstance.findSaleById(saleId);
		if(opSalesVO!=null){
			if(opSalesVO.getSalesStatus()==PegasusConstants.STATUS_UNAVAILABLE){
				return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(),ErrorCode.USER_LOGIN_FAILED.getMesage());//TODO 增加用户不可用状态
			}else{
				return JsonApiResult.ofSuccessResult(opSalesVO);
			}
		}
		return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(),ErrorCode.USER_LOGIN_FAILED.getMesage());
	}
	
	/***
	 * 根据oldcode查询用户信息
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value="/searchByOldCode")
	@ResponseBody
	public JsonApiResult searchByOldCode(@RequestParam("CODE") String code,@RequestParam("DATA") String data){
		JSONObject jsonData=JSONObject.parseObject(data);
		String oldCode=jsonData.getString("oldCode");
		if(StringUtils.isBlank(oldCode)){
			return JsonApiResult.ofErrorResult(ErrorCode.AUTHFAILED_MISS_PARAMS.getCode(), ErrorCode.AUTHFAILED_MISS_PARAMS.getMesage());
		}
		MemberVO member =memberQueryService.getByCode(oldCode);
		if(member!=null){
				return JsonApiResult.ofSuccessResult(member);
		}
		return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(),ErrorCode.USER_LOGIN_FAILED.getMesage());
	}
	
	
	
	/***
	 * 用户登录接口
	 * @param code
	 * @param data
	 * @return
	 * 对应 /beast_site/user/login
	 */
	@ApiAuth
	@RequestMapping(value="/passwordLogin")
	@ResponseBody
	public JsonApiResult login(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		JSONObject json= JSONObject.parseObject(data);
		String memberId=json.getString("memberId");
		String password=json.getString("password");
		if(StringUtils.isBlank(memberId)||StringUtils.isBlank(password)){
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
		
		
		List<MemberLoginVO>  members = memberLoginQueryService.getByMemberId(Long.valueOf(memberId));
		
		if(CollectionUtils.isEmpty(members)){
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_NOT_EXIST.getCode(), ErrorCode.USER_LOGIN_NOT_EXIST.getMesage());
		}
		
		
//		Integer loginType = getMemberType(userName);
//		if(loginType<0){
//			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_NOT_EXIST.getCode(), ErrorCode.USER_LOGIN_NOT_EXIST.getMesage());
//		}
		
		for(MemberLoginVO vo:members){
			 LoginDTO loginVO=new LoginDTO();
			 loginVO.setLoginId(vo.getLoginId());
			 loginVO.setPasswd(password);
			 if(vo.getLoginType()==null || (vo.getLoginType()!=1 && vo.getLoginType()!=2) ){
				 continue;
			 }
			 loginVO.setLoginType(vo.getLoginType());
			 loginVO.setChannelCode(code);
			 loginVO.setAccessWay(AccessWayEnum.PC.getCode());
			 ServiceResp<MemberVO> resp = memberService.login(loginVO);
			 if(resp.isSuccess() && resp.getBean()!=null){
				 OpMemberVO opMemberVO = new OpMemberVO();
				 opMemberVO.setCode( resp.getBean().getCode());
				 opMemberVO.setId( resp.getBean().getId());
				 opMemberVO.setNickName( resp.getBean().getNickName());

				 return JsonApiResult.ofSuccessResult(opMemberVO);
			 }
			 
			
		}
		
		return JsonApiResult.ofErrorResult(ErrorCode.USER_PASSWORD_FAILED.getCode(), ErrorCode.USER_PASSWORD_FAILED.getMesage());
		 
	}
	
	
}
