package com.thebeastshop.pegasus.channelservice.controller.ipos;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.common.utils.BCrypt;
import com.thebeastshop.wms.constant.PegasusConstants;
import com.thebeastshop.wms.vo.WhInvQttVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.ipos.OrderAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.pegasus.channelservice.vo.ipos.OrderCreateVO;
import com.thebeastshop.pegasus.channelservice.vo.ipos.OrderDetailVO;
import com.thebeastshop.pegasus.channelservice.vo.ipos.PresaleSaleVO;
import com.thebeastshop.pegasus.channelservice.vo.website.order.SyncOrderPayStatusVO;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderResponseVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.vo.OpPresaleVO;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.stock.vo.SPresaleVO;
import com.thebeastshop.stock.vo.SSkuStockVO;
import com.thebeastshop.support.vo.payment.OrderPayVO;

@Controller("iposOrderController")
@RequestMapping("/api/ipos/order")
public class OrderController {
	private Logger logger = LoggerFactory.getLogger(OrderController.class);

	private PegasusChannelServiceFacade pcInstance=PegasusChannelServiceFacade.getInstance();
	//private PegasusOperationServiceFacade poInstance = PegasusOperationServiceFacade.getInstance();
	//private PegasusWarehouseServiceFacade pwInstance = PegasusWarehouseServiceFacade.getInstance();
	@Autowired
	OrderAdapter orderAdapter;
	@Autowired
	private McOpChannelService mcOpChannelService;
	@Autowired
	private MemberQueryService memberQueryService;
	

	@Autowired
	private SPresaleService sPresaleService;
	
	@Autowired
    private SStockService sStockService;
//	@ApiAuth
//	@RequestMapping(value="/create2")
//	@ResponseBody
//	public JsonApiResult create(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
//		try{
//			
//		OrderCreateVO orderCreateVO = JSONObject.parseObject(data,OrderCreateVO.class);
//		orderCreateVO.setChannelCode(code);
//		OpSalesOrderVO opSalesOrderVO = orderAdapter.ipos2Common(orderCreateVO);
//		OpSalesOrderResponseVO orderResp = pcInstance.orderAdd(opSalesOrderVO);
//		if (orderResp!=null) {
//			return JsonApiResult.ofSuccessResult(orderResp);
//		}else{
//			return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(),ErrorCode.DEFAULT_EXCEPTION.getMesage());
//		}
//		}catch(ChannelException e){
//			logger.error("订单错误 : e={}",e);
//			return JsonApiResult.ofErrorResult(e.getErrorCode(),e.getMessage());
//		}catch (Exception e) {
//			logger.error("订单错误 : e={}",e);
//			return JsonApiResult.ofErrorResult(-40,e.getMessage());
//		}
//		
//	}
	


	@ApiAuth
	@RequestMapping(value="/iposOrdercreate")
	@ResponseBody
	public JsonApiResult iposOrdercreate(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		try{
			
		OrderCreateVO orderCreateVO = JSONObject.parseObject(data,OrderCreateVO.class);
		orderCreateVO.setChannelCode(code);
		OpSalesOrderVO opSalesOrderVO = orderAdapter.iposOrder2Common(orderCreateVO);
		OpSalesOrderResponseVO orderResp = pcInstance.iposOrderCreate(opSalesOrderVO);
		if (orderResp!=null) {
			return JsonApiResult.ofSuccessResult(orderResp);
		}else{
			return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(),ErrorCode.DEFAULT_EXCEPTION.getMesage());
		}
		}catch(ChannelException e){
			logger.error("订单错误 : e={}",e);
			return JsonApiResult.ofErrorResult(e.getErrorCode(),e.getMessage());
		}catch (Exception e) {
			logger.error("订单错误 : e={}",e);
			return JsonApiResult.ofErrorResult(-40,e.getMessage());
		}
		
	}
	
	/***
	 * 根据订单号，更新支付状态为已支付
	 * 
	 * @param code
	 * @param data
	 * @return 对应原 /beast_site/order/pay
	 * @throws Exception 
	 */
	@ApiAuth
	@RequestMapping("/pay")
	@ResponseBody
	public JsonApiResult pay(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) throws Exception {
		SyncOrderPayStatusVO vo = JSONObject.parseObject(data,
				SyncOrderPayStatusVO.class);

		// 取得会员IdSyncOrderPayStatusVO
		// String orderNo = jsonData.getString("orderNo");

		// Integer paymentType = jsonData.getInteger("paymentType");

		// BigDecimal totalAmount = jsonData.getBigDecimal("totalAmount");

		if (vo == null) {
			return JsonApiResult.ofErrorResult(
					ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		// 判断订单编号，支付方式，总金额
		if (StringUtils.isBlank(vo.getOrder_no())
				|| StringUtils.isBlank(vo.getPay_method())
				|| vo.getTotal() == null) {
			return JsonApiResult.ofErrorResult(
					ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		
		Integer paymentType = getPaymentType(vo.getPay_method());
		
		boolean result = pcInstance.orderPay(
				vo.getOrder_no(), paymentType,
				new BigDecimal(String.valueOf(vo.getTotal())),vo.getPay_account());

		if (result) {
			return JsonApiResult.ofSuccessResult(result);
		}
		return JsonApiResult.ofErrorResult(
				ErrorCode.DEFAULT_EXCEPTION.getCode(),
				ErrorCode.DEFAULT_EXCEPTION.getMesage());
	}
	
	
	/***
	 * 根据订单号，更新支付状态为已支付
	 * 
	 * @param code
	 * @param data
	 * @return 对应原 /beast_site/order/pay
	 * @throws Exception 
	 */
	@ApiAuth
	@RequestMapping("/payAccount")
	@ResponseBody
	public JsonApiResult payAccount(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) throws Exception {
		SyncOrderPayStatusVO vo = JSONObject.parseObject(data,
				SyncOrderPayStatusVO.class);
		OrderPayVO orderPayVO = new OrderPayVO();
		// 取得会员IdSyncOrderPayStatusVO


		if (vo == null) {

			orderPayVO.setCode(ErrorCode.PARAMS_ILLEGAL.getCode());
			orderPayVO.setMessage(ErrorCode.PARAMS_ILLEGAL.getMesage());
			return JsonApiResult.ofSuccessResult(orderPayVO);
		}
		// 判断订单编号，支付方式，总金额
		if (StringUtils.isBlank(vo.getOrder_no())
				|| StringUtils.isBlank(vo.getPay_method())||StringUtils.isBlank(vo.getMemberId())
				|| vo.getTotal() == null) {
			orderPayVO.setCode(ErrorCode.PARAMS_ILLEGAL.getCode());
			orderPayVO.setMessage(ErrorCode.PARAMS_ILLEGAL.getMesage());
			return JsonApiResult.ofSuccessResult(orderPayVO);
		}

		
		Integer paymentType = getPaymentType(vo.getPay_method());
		
		MemberVO opMember = memberQueryService.getById(Long.valueOf(vo.getMemberId()));
				
		// 判断支付密码是否正确
		if(StringUtils.isBlank(opMember.getPayPasswd()) || !BCrypt.checkpw(vo.getPaypwd(), opMember.getPayPasswd())){
						
			orderPayVO.setCode(ErrorCode.USER_PAYPWD_ERR.getCode());
			orderPayVO.setMessage(ErrorCode.USER_PAYPWD_ERR.getMesage());
			return JsonApiResult.ofSuccessResult(orderPayVO);
		}

		// 判断存款是否足够
		BigDecimal accountBalace = pcInstance.getMemberAccountByMemberId(opMember.getId(),code);
		if(accountBalace==null){
			
			orderPayVO.setCode(ErrorCode.NSUFFICIENT_FUND.getCode());
			orderPayVO.setMessage(ErrorCode.NSUFFICIENT_FUND.getMesage());
			return JsonApiResult.ofSuccessResult(orderPayVO);
		}else{
			
			if(accountBalace.compareTo(new BigDecimal(vo.getTotal()))<0){
				orderPayVO.setAccountFee(accountBalace);
				return JsonApiResult.ofSuccessResult(orderPayVO);
			}
			
		}
		
		boolean result = pcInstance.orderAccountPay(
				vo.getOrder_no(), paymentType,
				new BigDecimal(String.valueOf(vo.getTotal())),vo.getPay_account(),null,vo.getOperatorId(),vo.getOperatorName());

		if (result) {
			orderPayVO.setPayStatus("1");
			return JsonApiResult.ofSuccessResult(orderPayVO);
		}
		
		orderPayVO.setCode(ErrorCode.DEFAULT_EXCEPTION.getCode());
		orderPayVO.setMessage(ErrorCode.DEFAULT_EXCEPTION.getMesage());
		return JsonApiResult.ofSuccessResult(orderPayVO);
	}
	
	private Integer getPaymentType(String payMethod){
		Integer paymentType = null;
		if("CASH".equals(payMethod)){
			paymentType = PegasusConstants.Payment.TYPE_CASH;
		}else if("BANK".equals(payMethod)){
			paymentType = PegasusConstants.Payment.TYPE_DEBIT_CARD;
		}else if("CRDT".equals(payMethod)){
			paymentType = PegasusConstants.Payment.TYPE_CREDIT_CARD;
		}else if("WXSQ".equals(payMethod)){
			paymentType = PegasusConstants.Payment.TYPE_WEIXIN;
		}else if("ZFBA".equals(payMethod)){
			paymentType = PegasusConstants.Payment.TYPE_ALIPAY;
		}else if("CMB".equals(payMethod)){
			paymentType = PegasusConstants.Payment.TYPE_CMB;
		}else if("TRANSFER".equals(payMethod)){
            paymentType = PegasusConstants.Payment.TYPE_TRANSFER;
        }else if("YCK".equals(payMethod)){
        	paymentType = PegasusConstants.Payment.PRE_DEPOSIT;
        }else if("YEZHU".equals(payMethod)){
        	paymentType = PegasusConstants.Payment.TYPE_PROPRIETOR;
        }
		
		return paymentType;
		
	}
	
	//@ApiAuth
	@RequestMapping(value="/iposPrintTasks")
	@ResponseBody
	public JsonApiResult iposPrintTasks(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		try{
			final JSONObject jsonData = JSON.parseObject(data);
		
		// 取得订单号
		final String status = jsonData.getString("status");

		List<OrderDetailVO> orderDetailVOs = orderAdapter.setIposPrintTasks(status,code);


		return JsonApiResult.ofSuccessResult(orderDetailVOs);


		}catch(ChannelException e){
			logger.error("订单错误 : e={}",e);
			return JsonApiResult.ofErrorResult(e.getErrorCode(),e.getMessage());
		}catch (Exception e) {
			logger.error("订单错误 : e={}",e);
			return JsonApiResult.ofErrorResult(-40,e.getMessage());
		}

	}

	/**
	 * 根据sku 取得实际和预存数量
	 *
	 * @param code
	 * @param data
	 * @return JsonApiResult
	 */
	@ApiAuth
	@RequestMapping(value = "/checkQuantity")
	@ResponseBody
	public JsonApiResult checkQuantity(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {

		List<String> skus = JSONObject.parseArray(data, String.class);

		if (CollectionUtils.isEmpty(skus)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), "数据请求错误");
		}
		Map<String, PresaleSaleVO> map = new HashMap<String, PresaleSaleVO>();

		PresaleSaleVO vo = null;
		// 取得所有sku预算
		Map<String, SPresaleSaleInvVO> mapOp = sPresaleService.findCanUseQttBySkuCodes(skus,OpPresaleVO.CHANNEL_TYPE_OFFLINE);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		Map<String, SSkuStockVO> mapPw = sStockService.getSkuStocks(skus,
				opChannel.getWarehouseForSales());

		Map<String, SPresaleVO> opvMap = sPresaleService.findAvaliableBySkuCodes(skus,true);

		SSkuStockVO pw = null;
		SPresaleSaleInvVO op = null;
		SPresaleVO opv = null;
		for (int i = 0; i < skus.size(); i++) {

			vo = new PresaleSaleVO();
			vo.setSkuCode(skus.get(i));

			if (mapOp != null) {
				op = mapOp.get(skus.get(i));
				if (op != null) {
					// 预售库存
					vo.setPresellQuantity(op.getCanUseInv());
				} else {
					vo.setPresellQuantity(0);
				}

			}
			// 预计发货日期
			if (mapPw != null) {
				opv = opvMap.get(skus.get(i));
				if (opv != null) {
					vo.setPresellDate(opv.getPlanedDeliveryDateStr());
				}

			}

			if (mapPw != null) {
				pw = mapPw.get(skus.get(i));
				if (pw != null) {
					// 实际库存
					vo.setQuantity(pw.getCanUseQuantity());
				} else {
					// 实际库存
					vo.setQuantity(0);
				}
			}

			map.put(skus.get(i), vo);
		}

		return JsonApiResult.ofSuccessResult(map);
	}


	/**
	 * 根据sku 取得实际和预存数量
	 *
	 * @param code
	 * @param data
	 * @return JsonApiResult
	 */
	@ApiAuth
	@RequestMapping(value = "/searchPresaleSkuQty")
	@ResponseBody
	public JsonApiResult searchPresaleSkuQty(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		String skuCode = jsonData.getString("skuCode");

		WhInvQttVO whInvQttVO = new WhInvQttVO();
		// 取得所有sku预算
		SPresaleSaleInvVO opPresaleSaleInvVO = sPresaleService.findCanUseQttBySkuCode(skuCode, OpPresaleVO.CHANNEL_TYPE_OFFLINE);
		
		whInvQttVO.setQuantity(opPresaleSaleInvVO.getCanUseInv());
		whInvQttVO.setSkuCode(skuCode);

		return JsonApiResult.ofSuccessResult(whInvQttVO);
	}


	//@ApiAuth
		@RequestMapping(value="/updateIposPrintStatus")
		@ResponseBody
		public JsonApiResult updateIposPrintStatus(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
			try{
				final JSONObject jsonData = JSON.parseObject(data);

			// 取得订单号
			final Long id = jsonData.getLong("id");

			// 取得订单号
			final Integer status = jsonData.getInteger("status");
			int count = orderAdapter.updateIposPrintStatus(id,status);

			return JsonApiResult.ofSuccessResult(count);


			}catch(ChannelException e){
				logger.error("订单错误 : e={}",e);
				return JsonApiResult.ofErrorResult(e.getErrorCode(),e.getMessage());
			}catch (Exception e) {
				logger.error("订单错误 : e={}",e);
				return JsonApiResult.ofErrorResult(-40,e.getMessage());
			}

		}
		
		
		/***
		 * 根据订单号，验证支付状态
		 * 
		 * @param code
		 * @param data
		 * @return 对应原 /beast_site/order/pay
		 * @throws Exception 
		 */
		@ApiAuth
		@RequestMapping("/checkPayStatus")
		@ResponseBody
		public JsonApiResult checkPayStatus(@RequestParam("CODE") String code,
				@RequestParam("DATA") String data) throws Exception {
			SyncOrderPayStatusVO vo = JSONObject.parseObject(data,
					SyncOrderPayStatusVO.class);

			// 取得会员IdSyncOrderPayStatusVO
			// String orderNo = jsonData.getString("orderNo");

			// Integer paymentType = jsonData.getInteger("paymentType");

			// BigDecimal totalAmount = jsonData.getBigDecimal("totalAmount");
			
			

			if (vo == null) {
				return JsonApiResult.ofErrorResult(
						ErrorCode.PARAMS_ILLEGAL.getCode(),
						ErrorCode.PARAMS_ILLEGAL.getMesage());
			}
			// 判断订单编号，支付方式，总金额
			if (StringUtils.isBlank(vo.getOrder_no())) {
				return JsonApiResult.ofErrorResult(
						ErrorCode.PARAMS_ILLEGAL.getCode(),
						ErrorCode.PARAMS_ILLEGAL.getMesage());
			}


			try{
				
				boolean result = pcInstance.checkPayStatus(vo.getOrder_no());


				return JsonApiResult.ofSuccessResult(result);
			}catch(Exception e){
				return JsonApiResult.ofErrorResult(
						ErrorCode.DEFAULT_EXCEPTION.getCode(),
						e.getMessage());
			}

			
			
			
		}
}
