package com.thebeastshop.pegasus.channelservice.controller.ipos;


import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.vo.ConponParamVO;
import com.thebeastshop.pegasus.channelservice.vo.ConponVO;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.exception.OperationException;
import com.thebeastshop.pegasus.service.operation.vo.CouponPromRtnVO;
import com.thebeastshop.pegasus.service.operation.vo.CouponPromSkuVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
@Controller("iposCouponController")
@RequestMapping("/api/ipos/coupon")
public class CouponController {

	@Autowired
	private McPsSkuService mcPsSkuService;

	private PegasusOperationServiceFacade poInstance=PegasusOperationServiceFacade.getInstance();

	/**
	 * 
	 * @param code 渠道编码
	 * @param data 业务参数
	 * @return
	 * 对应原：/beast_site/coupon/check 检查coupon
	 */
	@ApiAuth
	@RequestMapping(value="/check")
	@ResponseBody
	public JsonApiResult couponCheck(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		JSONObject jsonData=JSONObject.parseObject(data);
		Long memberId=jsonData.getLong("userId");//用户ID
		Double total=jsonData.getDouble("totalAmount");//金额
		String couponCode=jsonData.getString("couponCode");
		ConponVO coupon=new ConponVO();
		if(total==null|| StringUtils.isBlank(couponCode)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		try{
			BigDecimal discount=poInstance.validByCouponCode(BigDecimal.valueOf(total), couponCode,memberId);
			coupon.setDiscount(discount.doubleValue());
			coupon.setValid(true);
		}catch(OperationException e){
			coupon.setDiscount(0d);
			coupon.setValid(false);
			coupon.setMessage(e.getMessage());
		}
		return JsonApiResult.ofSuccessResult(coupon);
	}
	
	/**
	 * 
	 * @param code 渠道编码
	 * @param data 业务参数
	 * @return
	 * 对应原：/beast_site/coupon/check 检查coupon
	 */
	@ApiAuth
	@RequestMapping(value="/checkBySku")
	@ResponseBody
	public JsonApiResult couponCheckBySku(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		ConponParamVO cpVO = JSONObject.parseObject(data,ConponParamVO.class);

		List<CouponPromSkuVO> promSkuVOs =cpVO.getPromSkus();
		
		ConponVO coupon=new ConponVO();
		if(promSkuVOs==null||StringUtils.isBlank(cpVO.getCouponCode())){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		try{

			List<String> skuCodes=new ArrayList<>();
			for(CouponPromSkuVO bean: promSkuVOs){
				skuCodes.add(bean.getSkuCode());
			}
			
			List<PsSkuVO> ps = mcPsSkuService.findBySkuCodes(skuCodes);
			if(!CollectionUtils.isEmpty(ps)){
				for(PsSkuVO po: ps){
				  for(CouponPromSkuVO bean: promSkuVOs){
					  if(po.getSkuCode().equals(bean.getSkuCode())){
						  bean.setBrandId(po.getBrandId());
						  bean.setCategroyId(po.getCategoryId());
						  break;
					  }
					 
				  }
					
					
				}

			}
			
			CouponPromRtnVO couponVo=poInstance.validByCouponCodeAndSkus(promSkuVOs, cpVO.getCouponCode(), cpVO.getMemberId());

			if(couponVo!=null){
				coupon.setDiscount(couponVo.getPromSum().doubleValue());
				coupon.setValid(true);
			}else{
				coupon.setDiscount(0d);
				coupon.setValid(false);
			}
			
		}catch(OperationException e){
			coupon.setDiscount(0d);
			coupon.setValid(false);
			coupon.setMessage(e.getMessage());
		}
		return JsonApiResult.ofSuccessResult(coupon);
	}
}
