package com.thebeastshop.pegasus.channelservice.controller.ipos;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.exception.OperationException;
import com.thebeastshop.pegasus.service.operation.model.OpSales;

/**
 * 渠道（店铺）
 * @author Paul-xiong
 *
 */
@Controller("iposChannelController")
@RequestMapping("/api/ipos/channel")
public class ChannelController {

	private PegasusChannelServiceFacade pcsInstance = PegasusChannelServiceFacade.getInstance();
	/**
	 * 
	 * @param code 渠道编码
	 * @param data 业务参数
	 * @return
	 * 对应原：/beast_site/api/ipos/channel/findChannelSeller 查询店铺销售员
	 */
	@ApiAuth
	@RequestMapping(value="/findChannelSeller")
	@ResponseBody
	public JsonApiResult findChannelSeller(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		JSONObject jsonData=JSONObject.parseObject(data);
		String channelCode = jsonData.getString("channelCode");//渠道code
		if(StringUtils.isBlank(channelCode)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		List<OpSales> list = null;
		try{
			list = pcsInstance.findSalesByChannelCode(channelCode);
		}catch(OperationException e){
			return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
		}
		return JsonApiResult.ofSuccessResult(list);
	}
}
