package com.thebeastshop.pegasus.channelservice.controller.ipos;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.vo.ipos.CategorySkuVO;
import com.thebeastshop.pegasus.channelservice.vo.ipos.CategoryVO;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuCategoryService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.vo.OpPresaleVO;
import com.thebeastshop.pegasus.channelservice.util.PriceUtil;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.stock.vo.SSkuStockVO;

/***
 * ipos分类
 * 
 * @author fs
 *
 */
@Controller
@RequestMapping("/api/ipos/category")
public class CategoryController {

	@Autowired
	private McPcsSkuCategoryService mcPcsSkuCategoryService;
	@Autowired
	private McPsProductService mcPsProductService;
	@Autowired
	private McPsSkuService mcPsSkuService;
	@Autowired
	private McOpChannelService mcOpChannelService;
	@Autowired
	private McPsSpvService mcPsSpvService;

	@Autowired
	private SPresaleService sPresaleService;

	@Autowired
	private SStockService sStockService;

	// private PegasusOperationServiceFacade
	// poInstance=PegasusOperationServiceFacade.getInstance();
	// private PegasusWarehouseServiceFacade
	// pwInstance=PegasusWarehouseServiceFacade.getInstance();
	@RequestMapping("/all")
	@ApiAuth
	@ResponseBody
	public JsonApiResult getAllCategories(@RequestParam("CODE") String code) {
		List<PcsSkuCategoryVO> categoryList = mcPcsSkuCategoryService.findSkuCategoryByParentIdIsNull();
		if (CollectionUtils.isEmpty(categoryList)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		List<CategoryVO> categoriesVOs = new ArrayList<CategoryVO>();
		for (PcsSkuCategoryVO category : categoryList) {
			CategoryVO categoryVO = new CategoryVO();
			categoryVO.setCode(category.getCode());
			categoryVO.setCategoryName(category.getFullName());
			categoriesVOs.add(categoryVO);
		}
		return JsonApiResult.ofSuccessResult(categoriesVOs);
	}

	@RequestMapping("/products2")
	@ApiAuth
	@ResponseBody
	public JsonApiResult getProdcutsByCateId(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		String cateCode = jsonData.getString("code");

		List<CategorySkuVO> cateSkus = new ArrayList<CategorySkuVO>();
		List<PsProductVO> productList = mcPsProductService.findByChnCodeCateCode(code, cateCode);
		if (CollectionUtils.isEmpty(productList)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}

		List<String> skus = new ArrayList<String>();
		for (PsProductVO product : productList) {
			List<String> skuCodeList = product.getCanSaleSku(code);
			List<PsSkuVO> skuList = mcPsSkuService.findBySkuCodes(skuCodeList);
			for (PsSkuVO pcsSku : skuList) {
				CategorySkuVO skuVO = new CategorySkuVO();

				skuVO.setProductNameEn(product.getName());
				skuVO.setProductNameZn(product.getNameCn());

				skuVO.setSku(pcsSku.getSkuCode());

				if (pcsSku.getIsJit() == 0) {
					skus.add(pcsSku.getSkuCode());
				}

				skuVO.setIsJit(pcsSku.getIsJit());
				skuVO.setName(pcsSku.getSkuNameCN());
				skuVO.setEnName(pcsSku.getSkuName());
				skuVO.setPrice(pcsSku.getSalesPrice());
				skuVO.setBrandId(pcsSku.getBrandId());
				skuVO.setCategoryId(pcsSku.getCategoryId());
				if (1 == product.getAllowVipDiscount()) {
					skuVO.setVipEnable(product.getAllowVipDiscount());
					skuVO.setVipPrice(PriceUtil.getVipPrice(pcsSku.getSalesPrice()));
					skuVO.setVvipPrice(PriceUtil.getVvipPrice(pcsSku.getSalesPrice()));
				} else {
					skuVO.setVipPrice(pcsSku.getSalesPrice());
					skuVO.setVvipPrice(pcsSku.getSalesPrice());
				}
				String picThumb = product.getPicThumb();
				if (StringUtils.isNotEmpty(picThumb)) {
					if (picThumb.indexOf("http://") < 0) {
						// picThumb="http://oss.thebeastshop.com/"+picThumb;
						picThumb = "http://img.thebeastshop.com/" + picThumb;
					}
				}
				skuVO.setImage(picThumb);
				cateSkus.add(skuVO);
			}
		}

		if (CollectionUtils.isEmpty(cateSkus)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}

		// 取得所有sku预算
		Map<String, SPresaleSaleInvVO> mapOp = sPresaleService.findCanUseQttBySkuCodes(skus,
				OpPresaleVO.CHANNEL_TYPE_OFFLINE);

		OpChannelVO opChannel = mcOpChannelService.findByCode(code);

		Map<String, SSkuStockVO> mapPw = sStockService.getSkuStocks(skus, opChannel.getWarehouseForSales());

		SSkuStockVO pw = null;
		SPresaleSaleInvVO op = null;
		for (int i = 0; i < cateSkus.size(); i++) {

			if (cateSkus.get(i).getIsJit() == 0) {
				op = mapOp.get(cateSkus.get(i).getSku());
				if (op != null) {
					// 预售库存
					cateSkus.get(i).setPresellQuantity(op.getCanUseInv());
				} else {
					cateSkus.get(i).setPresellQuantity(0);
				}

				pw = mapPw.get(cateSkus.get(i).getSku());
				if (pw != null) {
					// 实际库存
					cateSkus.get(i).setQuantity(pw.getCanUseQuantity());
				} else {
					// 实际库存
					cateSkus.get(i).setQuantity(0);
				}

			} else {
				cateSkus.get(i).setQuantity(0);
				cateSkus.get(i).setPresellQuantity(0);
			}

		}

		return JsonApiResult.ofSuccessResult(cateSkus);
	}

	@RequestMapping("/searchProdcutsByCateId")
	@ApiAuth
	@ResponseBody
	public JsonApiResult searchProdcutsByCateId(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		String cateCode = jsonData.getString("code");
		Integer memberLevel = jsonData.getInteger("memberLevel");// 会员等级
		Integer away = jsonData.getInteger("away");// 登陆方式
		List<CategorySkuVO> cateSkus = new ArrayList<CategorySkuVO>();
		List<PsProductVO> productList = mcPsProductService.findByChnCodeCateCode(code, cateCode);
		if (CollectionUtils.isEmpty(productList)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}

		List<String> skus = new ArrayList<String>();
		for (PsProductVO product : productList) {
			List<String> skuCodeList = product.getCanSaleSku(code);
			List<PsSkuVO> skuList = mcPsSkuService.findBySkuCodes(skuCodeList);
			for (PsSkuVO pcsSku : skuList) {
				CategorySkuVO skuVO = new CategorySkuVO();

				skuVO.setProductNameEn(product.getName());
				skuVO.setProductNameZn(product.getNameCn());

				skuVO.setSku(pcsSku.getSkuCode());

				if (pcsSku.getIsJit() == 0) {
					skus.add(pcsSku.getSkuCode());
				}

				skuVO.setIsJit(pcsSku.getIsJit());
				skuVO.setName(pcsSku.getSkuNameCN());
				skuVO.setEnName(pcsSku.getSkuName());
				skuVO.setPrice(pcsSku.getSalesPrice());
				skuVO.setBrandId(pcsSku.getBrandId());
				skuVO.setCategoryId(pcsSku.getCategoryId());
				if (1 == product.getAllowVipDiscount()) {
					skuVO.setVipEnable(product.getAllowVipDiscount());
					skuVO.setVipPrice(PriceUtil.getVipPrice(pcsSku.getSalesPrice()));
					skuVO.setVvipPrice(PriceUtil.getVvipPrice(pcsSku.getSalesPrice()));
				} else {
					skuVO.setVipPrice(pcsSku.getSalesPrice());
					skuVO.setVvipPrice(pcsSku.getSalesPrice());
				}
				String picThumb = product.getPicThumb();
				if (StringUtils.isNotEmpty(picThumb)) {
					if (picThumb.indexOf("http://") < 0) {
						// picThumb="http://oss.thebeastshop.com/"+picThumb;
						picThumb = "http://img.thebeastshop.com/" + picThumb;
					}
				}
				skuVO.setImage(picThumb);

				// 设置折扣价格
				PsMatchCampaignCond cond = new PsMatchCampaignCond();
				cond.setMatchCampaign(true);
				cond.setChannelCode(code);

				cond.setMemberLevel(memberLevel);
				cond.setAccessWay(away);
				cond.setDiscount(MemberLevelEnum.getEnumByCode(memberLevel).getLevelAmountCondition());
				pcsSku = mcPsProductService.calculateDiscountPrice(product, pcsSku, cond);
				if (pcsSku.getDiscountPrice() != null && pcsSku.getDiscountPrice().doubleValue() > 0) {
					skuVO.setDiscountPrice(pcsSku.getDiscountPrice());

				} else {
					skuVO.setDiscountPrice(BigDecimal.valueOf(pcsSku.getSalesPrice()));

				}
				// 判断是否低利率商品
				if (pcsSku.getCostPrice().doubleValue() - pcsSku.getSalesPrice() * 0.7 > 0) {
					skuVO.setIsLowPrice(1);
				} else {
					skuVO.setIsLowPrice(0);
				}
				List<PsCampaignVO> pcList = pcsSku.getCampaignList();
				if (pcList != null) {
					for (PsCampaignVO bean : pcList) {
						if (DiscountType.OFF.id.equals(bean.getDiscountTypeId())) {
							skuVO.setDiscountFlg(1);
							break;
						}

					}
				}

				cateSkus.add(skuVO);
			}
		}

		if (CollectionUtils.isEmpty(cateSkus)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}

		// 取得所有sku预算
		Map<String, SPresaleSaleInvVO> mapOp = sPresaleService.findCanUseQttBySkuCodes(skus,
				OpPresaleVO.CHANNEL_TYPE_OFFLINE);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		Map<String, SSkuStockVO> mapPw = sStockService.getSkuStocks(skus, opChannel.getWarehouseForSales());

		SSkuStockVO pw = null;
		SPresaleSaleInvVO op = null;
		for (int i = 0; i < cateSkus.size(); i++) {

			if (cateSkus.get(i).getIsJit() == 0) {
				op = mapOp.get(cateSkus.get(i).getSku());
				if (op != null) {
					// 预售库存
					cateSkus.get(i).setPresellQuantity(op.getCanUseInv());
				} else {
					cateSkus.get(i).setPresellQuantity(0);
				}

				pw = mapPw.get(cateSkus.get(i).getSku());
				if (pw != null) {
					// 实际库存
					cateSkus.get(i).setQuantity(pw.getCanUseQuantity());
				} else {
					// 实际库存
					cateSkus.get(i).setQuantity(0);
				}

			} else {
				cateSkus.get(i).setQuantity(0);
				cateSkus.get(i).setPresellQuantity(0);
			}

		}

		return JsonApiResult.ofSuccessResult(cateSkus);
	}

	@RequestMapping("/allProduct")
	@ApiAuth
	@ResponseBody
	public JsonApiResult allProduct(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {

		List<PcsSkuCategoryVO> categoryList = mcPcsSkuCategoryService.findSkuCategoryByParentIdIsNull();
		if (CollectionUtils.isEmpty(categoryList)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		List<CategorySkuVO> cateSkus = new ArrayList<CategorySkuVO>();
		for (PcsSkuCategoryVO category : categoryList) {

			List<PsProductVO> productList = mcPsProductService.findByChnCodeCateCode(code, category.getCode());
			if (CollectionUtils.isEmpty(productList)) {
				continue;
			}
			for (PsProductVO product : productList) {
				List<String> skuCodeList = product.getCanSaleSku(code);
				List<PsSkuVO> skuList = mcPsSkuService.findBySkuCodes(skuCodeList);
				for (PsSkuVO pcsSku : skuList) {
					CategorySkuVO skuVO = new CategorySkuVO();
					skuVO.setSku(pcsSku.getSkuCode());
					skuVO.setName(pcsSku.getSkuNameCN());
					skuVO.setEnName(pcsSku.getSkuName());
					skuVO.setPrice(pcsSku.getSalesPrice());
					skuVO.setIsJit(pcsSku.getIsJit());
					skuVO.setBrandId(pcsSku.getBrandId());
					skuVO.setCategoryId(pcsSku.getCategoryId());
					if (1 == product.getAllowVipDiscount()) {
						skuVO.setVipEnable(product.getAllowVipDiscount());
						skuVO.setVipPrice(PriceUtil.getVipPrice(pcsSku.getSalesPrice()));
						skuVO.setVvipPrice(PriceUtil.getVvipPrice(pcsSku.getSalesPrice()));
					} else {
						skuVO.setVipPrice(pcsSku.getSalesPrice());
						skuVO.setVvipPrice(pcsSku.getSalesPrice());
					}
					String picThumb = product.getPicThumb();
					if (StringUtils.isNotEmpty(picThumb)) {
						if (picThumb.indexOf("http://") < 0) {
							// picThumb="http://oss.thebeastshop.com/"+picThumb;
							picThumb = "http://img.thebeastshop.com/" + picThumb;
						}
					}
					skuVO.setImage(picThumb);
					cateSkus.add(skuVO);
				}
			}

		}

		if (CollectionUtils.isEmpty(cateSkus)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}

		return JsonApiResult.ofSuccessResult(cateSkus);

	}

	// /***
	// * ipos搜索 搜索包含skuname和productname的sku
	// * @param code
	// * @param data
	// * @return
	// */
	// @RequestMapping("/search")
	//// @ApiAuth
	// @ResponseBody
	// public JsonApiResult searchProduct(@RequestParam("CODE") String
	// code,@RequestParam("DATA") String data){
	// JSONObject jsonData=JSONObject.parseObject(data);
	// String keyWords=jsonData.getString("keywords");
	// List<PsSkuVO> pcsSkuList=mcPsSkuService.findByCodeName(keyWords);
	// List<PsSkuVO> prodSkuLis=findSkuByProductName(code, keyWords);
	// //for ipos search fs
	// if(CollectionUtils.isEmpty(pcsSkuList)&&CollectionUtils.isNotEmpty(prodSkuLis)){
	// pcsSkuList=prodSkuLis;
	// }else
	// if(CollectionUtils.isNotEmpty(pcsSkuList)&&CollectionUtils.isNotEmpty(prodSkuLis)){
	// List<PsSkuVO> repeatSku=new ArrayList<PsSkuVO>();
	// for(PsSkuVO psSku:pcsSkuList){
	// for(PsSkuVO pdSku:prodSkuLis){
	// if(psSku.getSkuCode().equals(pdSku.getSkuCode())){
	// repeatSku.add(pdSku);
	// }
	// }
	// }
	// prodSkuLis.removeAll(repeatSku);
	// pcsSkuList.addAll(prodSkuLis);
	// }
	// //for ipos search fs end
	// if(CollectionUtils.isEmpty(pcsSkuList)){
	// return
	// JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),ErrorCode.DATA_NOT_FOUND.getMesage());
	// }
	// List<CategorySkuVO> cateSkus=new ArrayList<CategorySkuVO>();
	// if (!CollectionUtils.isEmpty(pcsSkuList)) {
	// for (PsSkuVO pcsSku : pcsSkuList) {
	// PsProductVO product =
	// mcPsProductService.findProdBySkuCode(pcsSku.getSkuCode());
	// if (product != null) {// 渠道可售商品，包含了此商品
	// CategorySkuVO skuVO = new CategorySkuVO();
	// skuVO.setSku(pcsSku.getSkuCode());
	// skuVO.setName(pcsSku.getSkuNameCN());
	// skuVO.setEnName(pcsSku.getSkuName());
	// skuVO.setPrice(pcsSku.getSalesPrice());
	// skuVO.setBrandId(pcsSku.getBrandId());
	// skuVO.setCategoryId(pcsSku.getCategoryId());
	// skuVO.setIsJit(pcsSku.getIsJit());
	// skuVO.setProductNameEn(product.getName());
	// skuVO.setProductNameZn(product.getNameCn());
	// if (1 == product.getAllowVipDiscount()) {
	// skuVO.setVipEnable(product.getAllowVipDiscount());
	// skuVO.setVipPrice(PriceUtil.getVipPrice(pcsSku.getSalesPrice()));
	// skuVO.setVvipPrice(PriceUtil.getVvipPrice(pcsSku.getSalesPrice()));
	// } else {
	// skuVO.setVipPrice(pcsSku.getSalesPrice());
	// skuVO.setVvipPrice(pcsSku.getSalesPrice());
	// }
	// String picThumb = product.getPicThumb();
	// if (StringUtils.isNotEmpty(picThumb)) {
	// if (picThumb.indexOf("http://") < 0) {
	// // picThumb = "http://oss.thebeastshop.com/"+ picThumb;
	// picThumb="http://img.thebeastshop.com/"+picThumb;
	// }
	// }
	// skuVO.setImage(picThumb);
	//
	// if(pcsSku.getIsJit()==0){
	// // 取得所有sku预算
	// OpPresaleSaleInvVO op = poInstance.findCanUseQttBySkuCode(skuVO.getSku(),
	// null);
	// OpChannelVO opChannel = mcOpChannelService.findByCode(code);
	// WhInvVO pw =
	// pwInstance.findCanUseQttBySkuCodeAndWarehouseCode(skuVO.getSku(),opChannel.getWarehouseForSales());
	//
	// if (op != null) {
	// // 预售库存
	// skuVO.setPresellQuantity(op.getCanUseInv());
	// } else {
	// skuVO.setPresellQuantity(0);
	// }
	//
	// if (pw != null) {
	// // 实际库存
	// skuVO.setQuantity(pw.getCanUseInv());
	// } else {
	// // 实际库存
	// skuVO.setQuantity(0);
	// }
	// }else{
	// skuVO.setPresellQuantity(0);
	// skuVO.setQuantity(0);
	// }
	//
	//
	// cateSkus.add(skuVO);
	// }
	//
	// }
	// }
	//
	// if(CollectionUtils.isEmpty(cateSkus)){
	// return
	// JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),ErrorCode.DATA_NOT_FOUND.getMesage());
	// }
	// return JsonApiResult.ofSuccessResult(cateSkus);
	// }

	/***
	 * ipos搜索 搜索包含skuname和productname的sku 设置折扣字段
	 * 
	 * @auhtro lijing
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping("disSearch")
	@ApiAuth
	@ResponseBody
	public JsonApiResult searchProductDis(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		String keyWords = jsonData.getString("keywords");
		Integer memberLevel = jsonData.getInteger("memberLevel");// 会员等级
		Integer away = jsonData.getInteger("away");// 登陆方式
		List<PsSkuVO> pcsSkuList = new ArrayList<>();

		int pagenum = 40;

		// 根据输入内空去查询sku
		PsSkuVO psSkuVO = mcPsSkuService.findBySkuCode(keyWords);
		// 设置折扣价格
		PsMatchCampaignCond cond = new PsMatchCampaignCond();
		cond.setMatchCampaign(true);

		cond.setChannelCode(code);
		cond.setMemberLevel(memberLevel);
		cond.setAccessWay(away);
		cond.setDiscount(MemberLevelEnum.getEnumByCode(memberLevel).getLevelAmountCondition());
		if (psSkuVO != null) {
			PsProductVO psProduct = mcPsProductService.findProdBySkuCode(psSkuVO.getSkuCode());
			// 未创建Product
			if (psProduct == null) {
				return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), "该SKU未创建Product");
			}
			// 销售时间结束不展示
			// if(psSkuVO.getSaleEndDate()!=null &&
			// psSkuVO.getSaleEndDate().getTime()<new Date().getTime()){
			// return
			// JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),"该SKU已经超出销售结束时间。");
			// }
			// // SKU状态不是可用时，不展示
			// if(psSkuVO.getSkuStatus()==null || psSkuVO.getSkuStatus()!=9){
			// return
			// JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),"暂时无法销售");
			// }

			pcsSkuList.add(psSkuVO);

		} else {

			// pcsSkuList=mcPsSkuService.findBySkuName(keyWords,1,30, cond);

			pcsSkuList = mcPsSkuService.findSkuByCodeName(keyWords, 0, pagenum);

			Map<String, PsSkuVO> prodSkuMap = findSkuByProduct(code, keyWords);
			// for ipos search fs
			if (CollectionUtils.isEmpty(pcsSkuList) && prodSkuMap.size() > 0) {
				pcsSkuList = new ArrayList<PsSkuVO>(prodSkuMap.values());
			} else if (CollectionUtils.isNotEmpty(pcsSkuList) && prodSkuMap.size() > 0) {
				// List<PsSkuVO> repeatSku=new ArrayList<PsSkuVO>();

				for (PsSkuVO psSku : pcsSkuList) {
					PsSkuVO sku = prodSkuMap.get(psSku.getSkuCode());
					if (sku != null) {
						// repeatSku.add(psSku);
						prodSkuMap.remove(sku.getSkuCode());
					}

				}
				// prodSkuLis.removeAll(repeatSku);
				List<PsSkuVO> list = new ArrayList<PsSkuVO>(prodSkuMap.values());
				pcsSkuList.addAll(list);
			}
			// for ipos search fs end
			if (CollectionUtils.isEmpty(pcsSkuList)) {
				return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
						ErrorCode.DATA_NOT_FOUND.getMesage());
			}
		}

		// List<PsSkuVO> prodSkuLis=findSkuByProductName(code, keyWords);
		// //for ipos search fs
		// if(CollectionUtils.isEmpty(pcsSkuList)&&CollectionUtils.isNotEmpty(prodSkuLis)){
		// pcsSkuList=prodSkuLis;
		// }else
		// if(CollectionUtils.isNotEmpty(pcsSkuList)&&CollectionUtils.isNotEmpty(prodSkuLis)){
		// List<PsSkuVO> repeatSku=new ArrayList<PsSkuVO>();
		// for(PsSkuVO psSku:pcsSkuList){
		// for(PsSkuVO pdSku:prodSkuLis){
		// if(psSku.getSkuCode().equals(pdSku.getSkuCode())){
		// repeatSku.add(pdSku);
		// }
		// }
		// }
		// prodSkuLis.removeAll(repeatSku);
		// pcsSkuList.addAll(prodSkuLis);
		// }

		List<CategorySkuVO> cateSkus = new ArrayList<CategorySkuVO>();
		if (!CollectionUtils.isEmpty(pcsSkuList)) {

			List<String> skuCodes = Lists.newArrayList();
			for (PsSkuVO pcsSku : pcsSkuList) {
				skuCodes.add(pcsSku.getSkuCode());
			}

			// cond.setPagenum(pagenum);
			List<PsProductVO> products = mcPsProductService.findProdBySkuCodes(skuCodes, cond);
			Map<String, PsProductVO> prodMap = new HashMap<>();
			if (products != null) {

				for (PsProductVO prod : products) {

					if (CollectionUtils.isNotEmpty(prod.getSkuCodes())) {
						for (String skuCode : prod.getSkuCodes()) {
							prodMap.put(skuCode, prod);
						}
					}

				}

			} else {
				return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
						ErrorCode.DATA_NOT_FOUND.getMesage());
			}

			OpChannelVO opChannel = mcOpChannelService.findByCode(code);

			// 取得所有sku预算
			Map<String, SPresaleSaleInvVO> psMap = sPresaleService.findCanUseQttBySkuCodes(skuCodes,
					OpPresaleVO.CHANNEL_TYPE_OFFLINE);

			Map<String, SSkuStockVO> stockMap = sStockService.getSkuStocks(skuCodes, opChannel.getWarehouseForSales());

			for (PsSkuVO pcsSku : pcsSkuList) {

				PsProductVO product = prodMap.get(pcsSku.getSkuCode());
				if (product != null) {// 渠道可售商品，包含了此商品
					if (pcsSku.getIsMonthSend() != null && pcsSku.getIsMonthSend() == 1) {
						continue;
					}

					// 销售时间结束不展示
					// if(pcsSku.getSaleEndDate()!=null &&
					// pcsSku.getSaleEndDate().getTime()<new Date().getTime()){
					// continue;
					// }
					// // SKU状态不是可用时，不展示
					// if(pcsSku.getSkuStatus()==null ||
					// pcsSku.getSkuStatus()!=9){
					// continue;
					// }

					CategorySkuVO skuVO = new CategorySkuVO();
					skuVO.setSku(pcsSku.getSkuCode());
					skuVO.setName(pcsSku.getSkuNameCN());
					skuVO.setEnName(pcsSku.getSkuName());
					skuVO.setPrice(
							BigDecimal.valueOf(pcsSku.getSalesPrice()).setScale(2, RoundingMode.HALF_UP).doubleValue());
					skuVO.setBrandId(pcsSku.getBrandId());
					skuVO.setCategoryId(pcsSku.getCategoryId());
					skuVO.setIsJit(pcsSku.getIsJit());
					skuVO.setProductNameEn(product.getName());
					skuVO.setProductNameZn(product.getNameCn());
					skuVO.setIsDiscount(product.getIsDiscount());
					if (1 == product.getAllowVipDiscount()) {
						skuVO.setVipEnable(product.getAllowVipDiscount());
						// skuVO.setVipPrice(PriceUtil.getVipPrice(pcsSku.getSalesPrice()));
						// skuVO.setVvipPrice(PriceUtil.getVvipPrice(pcsSku.getSalesPrice()));
					}
					// else {
					// skuVO.setVipPrice(pcsSku.getSalesPrice());
					// skuVO.setVvipPrice(pcsSku.getSalesPrice());
					// }
					String picThumb = product.getPicThumb();
					if (StringUtils.isNotEmpty(picThumb)) {
						if (picThumb.indexOf("http://") < 0) {
							// picThumb = "http://oss.thebeastshop.com/"+
							// picThumb;
							picThumb = "http://img.thebeastshop.com/" + picThumb;
						}
					}
					skuVO.setImage(picThumb);

					if (pcsSku.getIsJit() == 0) {
						// 取得所有sku预算
						SPresaleSaleInvVO op = psMap.get(pcsSku.getSkuCode());

						SSkuStockVO pw = stockMap.get(skuVO.getSku());

						if (op != null) {
							// 预售库存
							skuVO.setPresellQuantity(op.getCanUseInv());
						} else {
							skuVO.setPresellQuantity(0);
						}

						if (pw != null) {
							// 实际库存
							skuVO.setQuantity(pw.getCanUseQuantity());
						} else {
							// 实际库存
							skuVO.setQuantity(0);
						}

						// 商品实示加预售数量
						skuVO.setTotalQuantity(skuVO.getQuantity() + skuVO.getPresellQuantity());
						if (skuVO.getTotalQuantity() == null) {
							skuVO.setTotalQuantity(0);
						}
					} else {
						skuVO.setPresellQuantity(0);
						skuVO.setQuantity(0);
						// jit 商品排到最前面
						skuVO.setTotalQuantity(10000);
					}

					pcsSku = mcPsProductService.calculateDiscountPrice(pcsSku, cond);
					if (pcsSku.getDiscountPrice() != null && pcsSku.getDiscountPrice().doubleValue() > 0) {
						// if (pcsSku.getSalesPrice() !=
						// pcsSku.getDiscountPrice().doubleValue()) {
						skuVO.setDiscountPrice(pcsSku.getDiscountPrice().setScale(2, RoundingMode.HALF_UP));
						// }
					} else {
						skuVO.setDiscountPrice(
								BigDecimal.valueOf(pcsSku.getSalesPrice()).setScale(2, RoundingMode.HALF_UP));

					}
					// 判断是否低利率商品
					if (pcsSku.getCostPrice().doubleValue() - pcsSku.getSalesPrice() * 0.7 > 0) {
						skuVO.setIsLowPrice(1);
					} else {
						skuVO.setIsLowPrice(0);
					}

					List<PsCampaignVO> pcList = pcsSku.getCampaignList();
					if (pcList != null) {
						for (PsCampaignVO bean : pcList) {
							if (DiscountType.OFF.id.equals(bean.getDiscountTypeId())) {
								skuVO.setDiscountFlg(1);
								break;
							}

						}
					}

					if (pcsSku.getCanCustomizeSalesPrice() != null) {
						skuVO.setCanCustomizeSalesPrice(pcsSku.getCanCustomizeSalesPrice());
					}

					// 取得spvId
					if (product != null) {
						PsSpvVO psSpvVO = mcPsSpvService.findSpvBySkuCode(product.getCode(), skuVO.getSku());
						if (psSpvVO != null) {
							skuVO.setSpvId(psSpvVO.getSpvId());
						}
					}

					// 设置海淘属性
					if (pcsSku.getCrossBorderFlag() != null) {
						skuVO.setCrossBorderFlag(pcsSku.getCrossBorderFlag());
					}

					cateSkus.add(skuVO);
				}

			}
		}

		// 按数量倒序排序
		Collections.sort(cateSkus, comparator);

		if (CollectionUtils.isEmpty(cateSkus)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		return JsonApiResult.ofSuccessResult(cateSkus);
	}

	private final static Comparator<CategorySkuVO> comparator = new Comparator<CategorySkuVO>() {
		@Override
		public int compare(CategorySkuVO o1, CategorySkuVO o2) {
			int rlt = 0;
			if (o1.getTotalQuantity().equals(o2.getTotalQuantity()))

				return rlt;
			rlt = o1.getTotalQuantity() < o2.getTotalQuantity() ? 1 : -1;
			return rlt;
		}
	};

	/***
	 * ipos搜索 搜索包含skuname和productname的sku 设置折扣字段
	 * 
	 * @auhtro lijing
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping("searchSkuCodes")
	@ApiAuth
	@ResponseBody
	public JsonApiResult searchSkuCodes(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);

		List<String> skuCodes = JSON.parseArray(jsonData.getString("skuCodes"), String.class);

		if (CollectionUtils.isEmpty(skuCodes)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		List<PsSkuVO> pcsSkuList = mcPsSkuService.findBySkuCodes(skuCodes);

		Integer memberLevel = jsonData.getInteger("memberLevel");// 会员等级
		Integer away = jsonData.getInteger("away");// 登陆方式
		String vipFlg = jsonData.getString("vipFlg");// 会员等级

		// for ipos search fs end
		if (CollectionUtils.isEmpty(pcsSkuList)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		List<CategorySkuVO> cateSkus = new ArrayList<CategorySkuVO>();
		if (!CollectionUtils.isEmpty(pcsSkuList)) {

			// 设置折扣价格
			PsMatchCampaignCond cond = new PsMatchCampaignCond();
			cond.setMatchCampaign(true);

			cond.setChannelCode(code);
			cond.setMemberLevel(memberLevel);
			cond.setAccessWay(away);

			if ("0".equals(vipFlg)) {
				cond.setDiscount(new BigDecimal(1));
			} else {
				cond.setDiscount(MemberLevelEnum.getEnumByCode(memberLevel).getLevelAmountCondition());
			}

			for (PsSkuVO pcsSku : pcsSkuList) {
				PsProductVO product = mcPsProductService.findProdBySkuCode(pcsSku.getSkuCode(), cond);
				if (product != null) {// 渠道可售商品，包含了此商品
					CategorySkuVO skuVO = new CategorySkuVO();
					skuVO.setSku(pcsSku.getSkuCode());
					skuVO.setName(pcsSku.getSkuNameCN());
					skuVO.setEnName(pcsSku.getSkuName());
					skuVO.setPrice(pcsSku.getSalesPrice());
					skuVO.setBrandId(pcsSku.getBrandId());
					skuVO.setCategoryId(pcsSku.getCategoryId());
					skuVO.setIsJit(pcsSku.getIsJit());
					skuVO.setProductNameEn(product.getName());
					skuVO.setProductNameZn(product.getNameCn());

					String picThumb = product.getPicThumb();
					if (StringUtils.isNotEmpty(picThumb)) {
						if (picThumb.indexOf("http://") < 0) {
							// picThumb = "http://oss.thebeastshop.com/"+
							// picThumb;
							picThumb = "http://img.thebeastshop.com/" + picThumb;
						}
					}
					skuVO.setImage(picThumb);

					// pcsSku =
					// mcPsProductService.calculateDiscountPrice(product,
					// pcsSku, cond);
					pcsSku = mcPsProductService.calculateDiscountPrice(pcsSku, cond);
					if (pcsSku.getDiscountPrice() != null && pcsSku.getDiscountPrice().doubleValue() > 0) {
						// if (pcsSku.getSalesPrice() !=
						// pcsSku.getDiscountPrice().doubleValue()) {
						skuVO.setDiscountPrice(pcsSku.getDiscountPrice().setScale(2, RoundingMode.HALF_UP));
						// }
					} else {
						skuVO.setDiscountPrice(
								BigDecimal.valueOf(pcsSku.getSalesPrice()).setScale(2, RoundingMode.HALF_UP));
					}

					skuVO.setPrice(
							BigDecimal.valueOf(pcsSku.getSalesPrice()).setScale(2, RoundingMode.HALF_UP).doubleValue());
					cateSkus.add(skuVO);
				}

			}
		}

		if (CollectionUtils.isEmpty(cateSkus)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		return JsonApiResult.ofSuccessResult(cateSkus);
	}

	/***
	 * ipos搜索 搜索包含skuname和productname的sku 设置折扣字段
	 * 
	 * @auhtro lijing
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping("searchSkuCodeList")
	@ApiAuth
	@ResponseBody
	public JsonApiResult searchSkuCodeList(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);

		List<String> skuCodes = JSON.parseArray(jsonData.getString("skuCodes"), String.class);

		if (CollectionUtils.isEmpty(skuCodes)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		Integer memberLevel = jsonData.getInteger("memberLevel");// 会员等级
		Integer away = jsonData.getInteger("away");// 登陆方式
		String vipFlg = jsonData.getString("vipFlg");// 会员等级

		List<CategorySkuVO> cateSkus = new ArrayList<CategorySkuVO>();

		// 设置折扣价格
		PsMatchCampaignCond cond = new PsMatchCampaignCond();
		cond.setMatchCampaign(true);

		cond.setChannelCode(code);
		cond.setMemberLevel(memberLevel);
		cond.setAccessWay(away);

		if ("0".equals(vipFlg)) {
			cond.setDiscount(new BigDecimal(1));
		} else {
			cond.setDiscount(MemberLevelEnum.getEnumByCode(memberLevel).getLevelAmountCondition());
		}

		for (String skuCode : skuCodes) {

			PsSkuVO pcsSku = mcPsSkuService.findBySkuCode(skuCode);

			if (pcsSku == null) {
				continue;
			}
			PsProductVO product = mcPsProductService.findProdBySkuCode(pcsSku.getSkuCode(), cond);
			if (product != null) {// 渠道可售商品，包含了此商品
				CategorySkuVO skuVO = new CategorySkuVO();
				skuVO.setSku(pcsSku.getSkuCode());
				skuVO.setName(pcsSku.getSkuNameCN());
				skuVO.setEnName(pcsSku.getSkuName());
				skuVO.setPrice(pcsSku.getSalesPrice());
				skuVO.setBrandId(pcsSku.getBrandId());
				skuVO.setCategoryId(pcsSku.getCategoryId());
				skuVO.setIsJit(pcsSku.getIsJit());
				skuVO.setProductNameEn(product.getName());
				skuVO.setProductNameZn(product.getNameCn());

				String picThumb = product.getPicThumb();
				if (StringUtils.isNotEmpty(picThumb)) {
					if (picThumb.indexOf("http://") < 0) {
						// picThumb = "http://oss.thebeastshop.com/"+ picThumb;
						picThumb = "http://img.thebeastshop.com/" + picThumb;
					}
				}
				skuVO.setImage(picThumb);

				// pcsSku = mcPsProductService.calculateDiscountPrice(product,
				// pcsSku, cond);
				pcsSku = mcPsProductService.calculateDiscountPrice(pcsSku, cond);
				if (pcsSku.getDiscountPrice() != null && pcsSku.getDiscountPrice().doubleValue() > 0) {
					// if (pcsSku.getSalesPrice() !=
					// pcsSku.getDiscountPrice().doubleValue()) {
					skuVO.setDiscountPrice(pcsSku.getDiscountPrice().setScale(2, RoundingMode.HALF_UP));
					// }
				} else {
					skuVO.setDiscountPrice(
							BigDecimal.valueOf(pcsSku.getSalesPrice()).setScale(2, RoundingMode.HALF_UP));
				}

				skuVO.setPrice(
						BigDecimal.valueOf(pcsSku.getSalesPrice()).setScale(2, RoundingMode.HALF_UP).doubleValue());

				if (pcsSku.getIsJit() == 0) {
					// 取得所有sku预算
					SPresaleSaleInvVO op = sPresaleService.findCanUseQttBySkuCode(skuVO.getSku(),
							OpPresaleVO.CHANNEL_TYPE_OFFLINE);

					OpChannelVO opChannel = mcOpChannelService.findByCode(code);
					// WhInvVO pw =
					// pwInstance.findCanUseQttBySkuCodeAndWarehouseCode(skuVO.getSku(),opChannel.getWarehouseForSales());

					SSkuStockVO pw = sStockService.getSkuStock(skuVO.getSku(), opChannel.getWarehouseForSales());
					if (op != null) {
						// 预售库存
						skuVO.setPresellQuantity(op.getCanUseInv());
					} else {
						skuVO.setPresellQuantity(0);
					}

					if (pw != null) {
						// 实际库存
						skuVO.setQuantity(pw.getCanUseQuantity());
					} else {
						// 实际库存
						skuVO.setQuantity(0);
					}

					// 商品实示加预售数量
					skuVO.setTotalQuantity(skuVO.getQuantity() + skuVO.getPresellQuantity());
					if (skuVO.getTotalQuantity() == null) {
						skuVO.setTotalQuantity(0);
					}
				} else {
					skuVO.setPresellQuantity(0);
					skuVO.setQuantity(0);
					// jit 商品排到最前面
					skuVO.setTotalQuantity(10000);
				}

				cateSkus.add(skuVO);
			}

		}

		if (CollectionUtils.isEmpty(cateSkus)) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		return JsonApiResult.ofSuccessResult(cateSkus);
	}

	/***
	 * 根据productname 查询包含搜索的sku
	 * 
	 * @param channelCode
	 * @param keyWords
	 * @return
	 */
	private List<PsSkuVO> findSkuByProductName(String channelCode, String keyWords) {
		List<PsSkuVO> skuVOList = new ArrayList<PsSkuVO>();
		final Map<String, Object> params = new HashMap<>();
		params.put("name", keyWords);
		params.put("nameCn", keyWords);
		params.put("pagenum", 30);
		List<PsProductVO> prodList = mcPsProductService.findByNameOrNameCN(params);
		if (CollectionUtils.isNotEmpty(prodList)) {
			for (PsProductVO prodVo : prodList) {
				List<String> skuList = prodVo.getCanSaleSku(channelCode);
				for (String skuCode : skuList) {
					PsSkuVO skuVO = mcPsSkuService.findBySkuCode(skuCode);
					if (null != skuVO) {
						skuVOList.add(skuVO);
					}
				}
			}
		}
		return skuVOList;
	}

	/***
	 * 根据productname 查询包含搜索的sku
	 * 
	 * @param channelCode
	 * @param keyWords
	 * @return
	 */
	private Map<String, PsSkuVO> findSkuByProduct(String channelCode, String keyWords) {
		Map<String, PsSkuVO> skuVOList = new HashMap<>();
		final Map<String, Object> params = new HashMap<>();
		params.put("name", keyWords);
		params.put("nameCn", keyWords);
		params.put("pagenum", 30);
		List<PsProductVO> prodList = mcPsProductService.findByNameOrNameCN(params);
		if (CollectionUtils.isNotEmpty(prodList)) {
			for (PsProductVO prodVo : prodList) {
				List<String> skuList = prodVo.getCanSaleSku(channelCode);
				for (String skuCode : skuList) {
					PsSkuVO skuVO = mcPsSkuService.findBySkuCode(skuCode);
					if (null != skuVO) {
						skuVOList.put(skuVO.getSkuCode(), skuVO);
					}
				}
			}
		}
		return skuVOList;
	}

}
