package com.thebeastshop.pegasus.channelservice.controller.ipos;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.thebeastshop.wms.constant.PegasusConstants;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.payment.alipay.PaymentConfig;
import com.thebeastshop.pegasus.channelservice.payment.alipay.PaymentUtil;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.model.OpSalesOrder;
import com.thebeastshop.common.utils.DateUtil;


/***
 * 
 * @author fs ipos支付宝支付
 */
@RequestMapping("/api/ipos/alipay")
@Controller("IposAlipayController")
public class AlipayController {
	private static final Logger logger = LoggerFactory.getLogger(AlipayController.class);
	private PegasusChannelServiceFacade pcInstance=PegasusChannelServiceFacade.getInstance();
	/***
	 * ipos 根据订单号，返回支付链接
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping("/payurl")
	@ApiAuth
	@ResponseBody
	public JsonApiResult paymentUrl(@RequestParam("CODE") String code,@RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		String orderCode = jsonData.getString("orderNo");
		
		OpSalesOrder opSalesOrder = pcInstance.getOrderByCode(orderCode, code);
		
		Date gmtCreate=opSalesOrder.getCreateTime();
		Date validTime=DateUtil.addMin(gmtCreate,PaymentConfig.ORDER_TIMEOUT );
		Date now = new Date();
		if(now.after(validTime)){
			return JsonApiResult.ofErrorResult(ErrorCode.ORDER_TIMEOUT.getCode(), ErrorCode.ORDER_TIMEOUT.getMesage());
		}
		Map<String, String> params= buildRequestParamMap(orderCode,opSalesOrder.getNeedToPayAmount().doubleValue());//TODO
		params.put("form_action", PaymentConfig.ALI_GATEWAY);//保存支付提交form的action
		return JsonApiResult.ofSuccessResult(params);
	}

	/***
	 * 封装支付参数
	 * @param orderCode
	 * @param totalAmount
	 * @return
	 */
	private Map<String, String> buildRequestParamMap(String orderCode,Double totalAmount) {

		Map<String, String> params = null;
		// 必填订单交易号
		String out_trade_no =orderCode;// request.getParameter("out_trade_no");
		// 支付方式 默认是支付宝支付
		String paymethod = "directPay";// request.getParameter("paymethod");

		logger.warn(String.format("request parameter is: out_trade_no=%s ,total_fee=%s",out_trade_no, totalAmount));

			// 请求参数封装到map 参数描述见PaymentRequest
			params = new HashMap<String, String>();
			params.put("service", PaymentConfig.SERVICE);
			params.put("partner", PaymentConfig.PARTNER);
			params.put("seller_email", PaymentConfig.SELLER_EMAIL);
			params.put("_input_charset", PaymentConfig.INPUT_CAHRTSET);
			// params.put("return_url", PaymentConfig.RETURN_URL);
			params.put("notify_url", PaymentConfig.NOTIFY_URL);
			params.put("out_trade_no", out_trade_no);
			params.put("subject", out_trade_no);
			params.put("payment_type", PaymentConfig.PAYMENT_TYPE);
			params.put("total_fee",String.valueOf(totalAmount));//TODO
			params.put("paymethod", paymethod);
			// params.put("show_url", PaymentConfig.SHOW_URL);
//			params.put("defaultbank", defaultbank);
			params.put("it_b_pay", PaymentConfig.IT_B_PAY);
			params.put("body", out_trade_no);
			params.put("qr_pay_mode", PaymentConfig.QR_PAY_MODE);
			params = PaymentUtil.paraFilter(params);// 过滤掉map中value为null和不需要签名的参数
			params.put("sign", getSign(params));
			params.put("sign_type", PaymentConfig.SIGN_TYPE);

			return params;
	}

	/***
	 * 根据订单号查询订单支付状态
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping("/payStatus")
	@ApiAuth
	@ResponseBody
	public JsonApiResult status(@RequestParam("CODE") String code,@RequestParam("DATA") String data){
		JSONObject jsonData=JSONObject.parseObject(data);
		String orderNo=jsonData.getString("orderNo");
		
		OpSalesOrder salesOrder=pcInstance.getOrderByCode(orderNo, null);
		
		if(salesOrder!=null){
			// 订单类型，1渠道销售单  订单状态，0取消1未付款2挂起5换货待收货完成10待审单11已审单12已完成
			if(salesOrder.getSalesOrderType()==1 && (salesOrder.getSalesOrderStatus()==10 ||salesOrder.getSalesOrderStatus()==11 ||salesOrder.getSalesOrderStatus()==12 )){
				return JsonApiResult.ofSuccessResult(true);
			}else{
				return JsonApiResult.ofSuccessResult(false);
			}
		}else{
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		
		//return JsonApiResult.ofErrorResult(ErrorCode.ORDER_TIMEOUT.getCode(), ErrorCode.ORDER_TIMEOUT.getMesage());
		
	}
	
	@RequestMapping(value="/notify",method = RequestMethod.POST)
	public ModelAndView notify(HttpServletRequest request) throws Exception{
		// 获取支付宝的通知返回参数
		// 商户订单号
		String out_trade_no = request.getParameter("out_trade_no");
		// 支付宝交易号
		String trade_no = request.getParameter("trade_no");
		// 交易状态
		String trade_status = request.getParameter("trade_status");
		//金额
		String total_fee=request.getParameter("total_fee");
		//卖家支付宝账号
		String buyer_email=request.getParameter("buyer_email");
		OpSalesOrder salesOrder=pcInstance.getOrderByCode(out_trade_no, null);
		String payResult = "failed";
		ModelAndView mav = new ModelAndView();
		if(salesOrder!=null){
			if(OpSalesOrder.ORDER_STATUS_NONPAYMENT==salesOrder.getSalesOrderStatus()&&"TRADE_SUCCESS".equals(trade_status)){
				if(pcInstance.orderPay(out_trade_no, PegasusConstants.Payment.TYPE_ALIPAY, new BigDecimal(total_fee),buyer_email)){
					payResult="success";
				}
				
			}else if(salesOrder.getSalesOrderStatus()==OpSalesOrder.ORDER_STATUS_WAITING_REVIEW){
				payResult="success";
			}else if("TRADE_FINISHED".equals(trade_status)){
				payResult="success";
			}
			
		}
		mav.addObject("result", payResult);
		mav.setViewName("payment/alipay/notify");
		return mav;
	}
	
	@RequestMapping(value="/testnotify")
	public ModelAndView testnotify(HttpServletRequest request){
		// 获取支付宝的通知返回参数
		// 商户订单号
		String out_trade_no = request.getParameter("out_trade_no");
		String payResult = "failed";
		ModelAndView mav = new ModelAndView();
		mav.addObject("result", payResult);
		mav.setViewName("payment/alipay/notify");
		return mav;
	}
	
	/***
	 * 根据拼接参数，生成摘要
	 * 
	 * @param sortedParmas
	 * @return
	 */
	private String getSign(Map<String, String> sortedParmas) {
		String sign = "";
		String plainText = PaymentUtil.createLinkString(sortedParmas);// 获取拼接的未加密文本
		sign = PaymentUtil.sign(plainText, PaymentConfig.KEY,
				PaymentConfig.INPUT_CAHRTSET);

		return sign;
	}
	
	/***
	 * 获取支付宝POST过来反馈信息
	 * 
	 * @param request
	 * @return
	 * @throws
	 */
	private Map<String, String> buildResponseParamMap(HttpServletRequest request) {
		Map<String, String> params = new HashMap<String, String>();

		Map requestParams = request.getParameterMap();
		for (Iterator<String> iter = requestParams.keySet().iterator(); iter
				.hasNext();) {
			String name = (String) iter.next();
			String[] values = (String[]) requestParams.get(name);
			String valueStr = "";
			for (int i = 0; i < values.length; i++) {
				valueStr = (i == values.length - 1) ? valueStr + values[i]
						: valueStr + values[i] + ",";
			}
			// 乱码解决，这段代码在出现乱码时使用。如果mysign和sign不相等也可以使用这段代码转化
			// valueStr = new String(valueStr.getBytes("ISO-8859-1"), "gbk");
			params.put(name, valueStr);
		}
		logger.warn(String.format("response parameters from alipay is :",
				params.toString()));
		return params;
	}

	/***
	 * 对支付宝的请求参数进行验证 1.验证notify_id是否有效 2.验证签名是否正确
	 * 
	 * @param params
	 * @return
	 */
	private boolean verifyResult(Map<String, String> params) {
		boolean verifyNotify = false;
		boolean verifySign = false;
		String notify_id = params.get("notify_id");

		if (StringUtils.isNotBlank(notify_id)) {
			verifyNotify = verifyNotifyID(notify_id);
			// verifyNotify=true;
			logger.warn(String.format("notify_id is:%s , verifyNotify is:%s",
					notify_id, verifyNotify));
		}
		String sign = params.get("sign");
		if (StringUtils.isNotBlank(sign)) {
			verifySign = verifySign(params, sign);
			logger.warn(String.format("sign is:%s , verifySign is:%s", sign,
					verifySign));
		}
		return verifyNotify && verifySign;

	}

	/***
	 * 校验支付宝返回的签名sign
	 * 
	 * @param params
	 * @param sign
	 * @return
	 */
	private boolean verifySign(Map<String, String> params, String sign) {
		// 过滤掉加密不需要的参数
		Map<String, String> sortedParams = PaymentUtil.paraFilter(params);
		// 根据首字母拼接待加密字符串
		String plaintext = PaymentUtil.createLinkString(sortedParams);
		return PaymentUtil.verify(plaintext, sign, PaymentConfig.KEY,
				PaymentConfig.INPUT_CAHRTSET);
	}

	/***
	 * 根据支付宝请求中的notify_id 去支付宝服务器验证，是否是有效请求 正确情况下 接口返回true的字符串
	 * 
	 * @param notify_id
	 * @return
	 */
	private boolean verifyNotifyID(String notify_id) {
		String urlStr = PaymentConfig.VERIFY_URL + "partner="
				+ PaymentConfig.PARTNER + "&notify_id=" + notify_id;
		String inputLine = "";

		try {
			URL url = new URL(urlStr);
			HttpURLConnection urlConnection = (HttpURLConnection) url
					.openConnection();
			BufferedReader in = new BufferedReader(new InputStreamReader(
					urlConnection.getInputStream()));
			inputLine = in.readLine().toString();
		} catch (Exception e) {
			logger.error("verify notify_id failed notify_id:" + notify_id + " "
					+ e.getMessage());
			inputLine = "";
		}

		return "true".equals(inputLine);
	}
}
