package com.thebeastshop.pegasus.channelservice.controller.interest;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.interest.InterestAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartInterestAdapter;
import com.thebeastshop.scm.vo.interest.InterestGoodsGetVO;
import com.thebeastshop.support.util.EnumUtil;
import com.thebeastshop.support.vo.product.ProductVariantVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

/**
 * 权益controller
 * Created by feilong.gao on 2017/1/16.
 */
@Controller("InterestController")
@RequestMapping("/api/interest")
@ResponseBody
public class InterestController {

    @Autowired
    private InterestAdapter interestAdapter;
    @Autowired
    private CartInterestAdapter cartInterestAdapter;

    /**
     * 领取权益
     *
     * @param code
     * @param data
     * @return
     */
    @ApiAuth
    @RequestMapping(value = "/receive")
    public JsonApiResult receiveInterest(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
        JSONObject json = JSONObject.parseObject(data);
        Long memberId = json.getLong("memberId");
        String interestId = json.getString("interestId");
        // 1.领取权益
        InterestGoodsGetVO interestGoodsGetVO = interestAdapter.receiveInterest(memberId, interestId);
        // 2. 发放权益
        Boolean flag = cartInterestAdapter.saveInterest2Cart(memberId,interestGoodsGetVO);
        return JsonApiResult.ofSuccessResult(flag);
    }


    /**
     * 权益规格
     *
     * @param code
     * @param data
     * @return
     */
    @ApiAuth
    @RequestMapping(path = "/getProductVariant", method = RequestMethod.GET)
    @ResponseStatus(HttpStatus.OK)
    public JsonApiResult interestSpecification(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
        JSONObject json = JSONObject.parseObject(data);
        String interestId = json.getString("interestId");
        AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(json.getInteger("accessWay"));
        ProductVariantVO productVariantVO = interestAdapter.getInterestVariant(code,interestId,accessWay);
        return JsonApiResult.ofSuccessResult(productVariantVO);
    }

}
