package com.thebeastshop.pegasus.channelservice.controller.index;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.thebeastshop.member.constant.MemberConstant;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.message.MessageAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ShopOperationConstant;
import com.thebeastshop.pegasus.channelservice.controller.order.app.OrderController;
import com.thebeastshop.pegasus.component.index.domain.IndexVo;
import com.thebeastshop.pegasus.component.index.service.IndexEntryService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.component.support.service.RedisService;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.support.enums.MessageType;
import com.thebeastshop.support.vo.Module;
import com.thebeastshop.support.vo.message.Message;

import net.sf.json.JSONArray;

@Controller
@RequestMapping(value = "/api/index")
public class IndexController {

	private IndexEntryService service = ComponentServiceLoader.getBean(IndexEntryService.class);

	@Autowired
	private MemberQueryService memberQueryService;

	private PegasusOperationServiceFacade poInstance = PegasusOperationServiceFacade.getInstance();

	private RedisService redisService = ComponentServiceLoader.getBean(RedisService.class);

	@Autowired
	private MessageAdapter msgAdapter;

	private final Logger logger = LoggerFactory.getLogger(OrderController.class);

	private String indexKey = "app-index";

	/**
	 * 获取首页
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/getIndexList", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getIndexList(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		IndexVo cond = new IndexVo();
		// cond.setId(indexId);
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		MemberVO member = memberQueryService.getById(memberId);

		cond.setState(ShopOperationConstant.type.PUBLISH);

		IndexVo index = new IndexVo();
		List<String> outputNewMoudules = new ArrayList();
		List<String> outputOldMoudules = new ArrayList();
		IndexVo output = new IndexVo();

		// 获取首页消息
		Module msgModule = null;
		if (memberId != MemberConstant.DEFAULT_MEMBER_ID) {
			Message message = msgAdapter.indexMessage(MessageType.ALL.getType(), member);
			if (null != message) {
				msgModule = new Module();
				msgModule.setType("message");
				msgModule.setData(message);
			}
		}

		index = redisService.get(indexKey, IndexVo.class);
		if (null == index) {
			logger.info("获取首页内容未从redis中取到");
			List<IndexVo> indexs = service.findIndexListByCond(cond);
			index = indexs.get(0);
			redisService.set(indexKey, index, 300);
		}
		if (null != index) {
			output.setId(index.getId());
			output.setState(index.getState());
			List<String> modules = JSONObject.parseArray(index.getModules(), String.class);
			for (String module : modules) {
				JSONObject moduleJson = JSONObject.parseObject(module);
				String moduleData = moduleJson.getString("data");
				JSONObject dataJson = JSONObject.parseObject(moduleData);
				String customer = dataJson.getString("customer");
				if (null != customer) {
					switch (customer) {
					case "OLD":
						outputOldMoudules.add(module);
						break;
					case "NEW":
						outputNewMoudules.add(module);
						break;
					default:
						outputOldMoudules.add(module);
						outputNewMoudules.add(module);
						break;
					}
				} else {
					outputOldMoudules.add(module);
					outputNewMoudules.add(module);
				}
			}
		}

		boolean state = poInstance.ifPaidOrder("CHN2049", member.getCode());
		// 新老客户判断
		if (member != null && member.getId() != null && !member.getId().equals(MemberConstant.DEFAULT_MEMBER_ID)
				&& state) {
			if (null != msgModule) {
				outputOldMoudules.add(JSON.toJSONString(msgModule, SerializerFeature.WriteNullStringAsEmpty));
			}
			output.setModules(JSONArray.fromObject(outputOldMoudules).toString());
			logger.info("老用户内容：outputOldMoudules={}", outputOldMoudules);
		} else {
			if (null != msgModule) {
				outputNewMoudules.add(JSON.toJSONString(msgModule, SerializerFeature.WriteNullStringAsEmpty));
			}
			output.setModules(JSONArray.fromObject(outputNewMoudules).toString());
			logger.info("新用户内容：outputOldMoudules={}", outputNewMoudules);
		}

		return JsonApiResult.ofSuccessResult(output);
	}

	public IndexEntryService getService() {
		return service;
	}

	public void setService(IndexEntryService service) {
		this.service = service;
	}

	// public static void main(String[] args) {
	// Module module = new Module();
	// Message message = new Message();
	// message.setMessage(null);
	// message.setNumber(0);
	// module.setData(message);
	// System.out.println(JSON.toJSONString());
	//
	// }

}
