package com.thebeastshop.pegasus.channelservice.controller.growth;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

import com.thebeastshop.support.vo.product.ShareData;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.configuration.enums.ShareTypeEnum;
import com.thebeastshop.configuration.enums.ShowTypeEnum;
import com.thebeastshop.configuration.service.FissionRedEnvelopeService;
import com.thebeastshop.configuration.service.PurchasePostService;
import com.thebeastshop.configuration.service.ShareImageService;
import com.thebeastshop.configuration.vo.FissionRedEnvelopVO;
import com.thebeastshop.configuration.vo.PurchasePostOrderInfoVO;
import com.thebeastshop.configuration.vo.PurchasePostVO;
import com.thebeastshop.configuration.vo.ShareImageVO;
import com.thebeastshop.configuration.vo.ShareVO;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.redenvelope.RedEnvelopeAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.enums.OrderFlowState;
import com.thebeastshop.pegasus.channelservice.vo.Bear;
import com.thebeastshop.pegasus.channelservice.vo.Customize;
import com.thebeastshop.pegasus.component.customize.domain.SkuCustomize;
import com.thebeastshop.pegasus.component.customize.service.SkuCustomizeService;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelope;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuCategoryService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageSkuVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageVO;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.support.encode.Base64Util;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.vo.order.OrderActionVO;
import com.thebeastshop.support.vo.product.GrowthVO;
import com.thebeastshop.support.vo.product.GrowthVO.EmphasizeVO;
import com.thebeastshop.support.vo.product.ProductLotteryShareVO;

import com.thebeastshop.support.vo.product.ProductShareVO;

/**
 * 
 * 
 * @author Paul-xiong
 *
 */
@Controller("growthController")
@RequestMapping("/api/growth")
@ResponseBody
public class GrowthController {
	private final Logger logger = LoggerFactory.getLogger(GrowthController.class);

	@Autowired
	private RedEnvelopeAdapter redEnvelopeAdapter;

	private SkuCustomizeService skuCustomizeService = ComponentServiceLoader.getBean(SkuCustomizeService.class);

	@Autowired
	private McPsProductService mcPsProductService;

	@Autowired
	private McPcsSkuCategoryService mcPcsSkuCategoryService;

	@Autowired
	private FissionRedEnvelopeService fissionRedEnvelopeService;

	@Autowired
	private MemberQueryService memberQueryService;
	@Autowired
	private PurchasePostService purchasePostService;

	@Autowired
	private ShareImageService shareImageService;

	private PegasusChannelServiceFacade instance = PegasusChannelServiceFacade.getInstance();
	String RedEnvelopeLink = "http://www.thebeastshop.com/wx/re.htm?id=";

	private static final String imageAPI = "https://api.thebeastshop.com/img/generateMomentImage";

	// ================private================
	private String getOrderRedEnvelopeTitle() {
		String title = "";

		String property = PropConstants.getProperties("orderRedEnvelope.title");
		if (StringUtils.isNotBlank(property)) {
			logger.info("orderRedEnvelope.title:{}", property);
			title = property;
		}

		return title;
	}

	private String getOrderRedEnvelopeContent() {
		String content = "";

		String property = PropConstants.getProperties("orderRedEnvelope.content");
		if (StringUtils.isNotBlank(property)) {
			logger.info("orderRedEnvelope.content:{}", property);
			content = property;

		}
		return content;
	}

	private String getOrderRedEnvelopeLink() {
		String link = "";

		String startTime = "2016-12-26 00:00:00";
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date date = new Date();
		try {
			date = dateFormat.parse(startTime);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		String property = PropConstants.getProperties("orderRedEnvelope.link");
		if (date.compareTo(Calendar.getInstance().getTime()) < 0) {

			property = PropConstants.getProperties("orderRedEnvelope_Christmas.link");
		}
		if (StringUtils.isNotBlank(property)) {
			logger.info("orderRedEnvelope.link:{}", property);
			link = property;
		}

		return link;
	}

	private String getOrderRedEnvelopeImage() {
		String image = "";

		String property = PropConstants.getProperties("orderRedEnvelope.image",
				"http://img.thebeastshop.com/apppictures/2016-09-18/897b8e02d034c30216bb35b2507fa509.png");
		if (StringUtils.isNotBlank(property)) {
			logger.info("orderRedEnvelope.image:{}", property);
			image = property;
		}

		return image;
	}

	// =======================================
	/**
	 * 获取订单分享信息
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/orderRedEnvelope")
	public JsonApiResult getOrderRedEnvelope(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		String orderCode = jsonData.getString("orderCode");
		logger.info("参数: memberId:{} orderCode{}", memberId, orderCode);

		String title = getOrderRedEnvelopeTitle();
		String content = getOrderRedEnvelopeContent();
		String link = getOrderRedEnvelopeLink();
		String img = getOrderRedEnvelopeImage();

		FissionRedEnvelopVO fissionRedEnvelopVO = new FissionRedEnvelopVO();
		ServiceResp<FissionRedEnvelopVO> RedEnvelopServiceResp = fissionRedEnvelopeService.getCanUseFissionById(null);
		if (RedEnvelopServiceResp.isSuccess()) {
			fissionRedEnvelopVO = RedEnvelopServiceResp.getBean();
			ShareVO shareVO = fissionRedEnvelopVO.getShare();
			title = shareVO.getTitle();
			content = shareVO.getContent();
			img = shareVO.getImage();
			link = shareVO.getLink();
		}
		if (memberId == null || StringUtils.isBlank(orderCode)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		MemberVO member = memberQueryService.getById(memberId);
		// =========校验订单信息=========
		OpSalesOrderVO order = instance.orderDetail(member.getCode(), orderCode);
		if (order == null) {
			throw new WrongArgException("订单不存在", "orderCode", orderCode);
		}

		// ===========================

		ProductShareVO productShareVO = null;
		Date linkStartDate = new Date();
		String linkStartTime = "2016-12-26 00:00:00";
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		try {
			linkStartDate = dateFormat.parse(linkStartTime);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (OrderFlowState.isPaid(order.getSalesOrderStatus())) {
			productShareVO = new ProductShareVO();
			productShareVO.setTitle(title);
			productShareVO.setContent(content);
			productShareVO.setLink(link);
			productShareVO.setImage(img);

			if (linkStartDate.compareTo(Calendar.getInstance().getTime()) < 0) {
				// 1月5日10点以后，根据订单号生成一个裂变红包并返回分享地址
				RedEnvelope redEnvelope = redEnvelopeAdapter.createRedEnvenlope(orderCode, member.getCode(), memberId);
				if (redEnvelope == null) {
					logger.error("redEnvelope == null");
					logger.error("参数: memberId:{} orderCode{} memberCode:{} orderType:{}", memberId, orderCode,
							member.getCode(), order.getOrderTypeEnum().getCode());
					return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), "生成红包地址有误！");
				} else {
					if (!NumberUtil.isNullOrZero(redEnvelope.getId())) {
						String shareCode = redEnvelope.getId().toString();
						productShareVO.setLink(link + "&id=" + shareCode + "&templateId=1");
						if (!link.contains("configId") && link.endsWith(".htm")) {
							productShareVO.setLink(link + "?id=" + shareCode + "&templateId=1");
						}
					}
				}
			}
		}
		return JsonApiResult.ofSuccessResult(productShareVO);
	}

	/**
	 * 获取订单分享信息（1.2版本及以上）
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/orderRedEnvelope1.2.0")
	public JsonApiResult getOrderRedEnvelope1_2_0(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		String orderCode = jsonData.getString("orderCode");
		logger.info("参数: memberId:{} orderCode{}", memberId, orderCode);

		if (memberId == null || StringUtils.isBlank(orderCode)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		MemberVO member = memberQueryService.getById(memberId);
		// =========校验订单信息=========
		OpSalesOrderVO order = instance.orderDetail(member.getCode(), orderCode);
		if (order == null) {
			throw new WrongArgException("订单不存在", "orderCode", orderCode);
		}
		GrowthVO growthVO = null;
		if (OrderFlowState.isPaid(order.getSalesOrderStatus())) {
			growthVO = new GrowthVO();
			ProductShareVO productShareVO = new ProductShareVO();
			productShareVO.setTitle(getOrderRedEnvelopeTitle());
			productShareVO.setContent(getOrderRedEnvelopeContent());
			productShareVO.setLink(getOrderRedEnvelopeLink());
			productShareVO.setImage(getOrderRedEnvelopeImage());
			EmphasizeVO emphasize = new EmphasizeVO();
			emphasize.setImg("");
			growthVO.setEmphasize(emphasize);
			growthVO.setShare(productShareVO);
		}
		// ===========================

		return JsonApiResult.ofSuccessResult(growthVO);
	}

	/**
	 * 获取订单支付成功的后续操作信息
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/orderAction")
	public JsonApiResult getOrderAction(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		String orderCode = jsonData.getString("orderCode");
		logger.info("参数: memberId:{} orderCode{}", memberId, orderCode);

		String website = "beastapp://entry?name=order-action&orderId=";

		if (memberId == null || StringUtils.isBlank(orderCode)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		MemberVO member = memberQueryService.getById(memberId);
		// =========校验订单信息=========
		OpSalesOrderVO order = instance.orderDetail(member.getCode(), orderCode);

		if (order == null) {
			throw new WrongArgException("订单不存在", "orderCode", orderCode);
		}
		OrderActionVO orderAction = null;
		if (OrderFlowState.isPaid(order.getSalesOrderStatus())) {
			orderAction = new OrderActionVO();

			List<OpSoPackageVO> packs = order.getOpSoPackageVOs();
			boolean bear = false;
			Long customizeId = Long.valueOf(0L);
			String productCode = "";
			Long spvId = Long.valueOf(0L);
			for (OpSoPackageVO pack : packs) {
				List<OpSoPackageSkuVO> skus = pack.getOpSoPackageSkuVOs();
				for (OpSoPackageSkuVO sku : skus) {
					if (sku.getSpvId() != null) {
						PsProductVO prod = mcPsProductService.findProdBySpvId(sku.getSpvId());
						String bearProductCode = "PROD001018193";

						// String bearProd =
						// configurer.getProperty("bear.productId");
						// if (StringUtils.isNotBlank(bearProd)) {
						// logger.info("定制小熊商品code", bearProd);
						// bearProductCode = bearProd;
						// }

						if (prod.getCode().equals(bearProductCode)) {
							bear = true;
							customizeId = pack.getId();
							productCode = prod.getCode();
							spvId = sku.getSpvId();
							break;
						}
					}
				}
				if (bear) {
					break;
				}
			}
			if (bear) {
				logger.info("定制商品分享链接spvid:" + spvId + "productId:" + productCode);
				Bear bearCustomizeVO = new Bear();
				if (customizeId.longValue() != 0L) {
					String userName = member.getNickName();
					List<SkuCustomize> customizes = this.skuCustomizeService.selectByPackId(customizeId);
					logger.info("定制信息：customizes：" + customizes + "customizeId" + customizeId);
					bearCustomizeVO.setProductId(productCode);
					bearCustomizeVO.setUserName(userName);
					bearCustomizeVO.setSpvId(spvId.toString());
					List<Customize> items = new ArrayList();
					if (null != customizes) {
						for (SkuCustomize customize : customizes) {
							Customize item = new Customize();
							item.setDimension(customize.getCustomDimensionId());
							item.setName(customize.getCustomDimensionName());
							item.setValue(customize.getCustomDimensionValue());
							items.add(item);
						}
					}
					bearCustomizeVO.setCustomizes(items);
				}
				String bearData;
				bearData = Base64Util.encode(JSON.toJSONString(bearCustomizeVO).getBytes());
				bearData = bearData.replaceAll("\\+", "__j__").replaceAll("/", "__x__").replaceAll("=", "__d__");
				orderAction.setWebview(website + orderCode + "&action=customization&product=bear&bearData=" + bearData);
				ProductLotteryShareVO productShareVO = new ProductLotteryShareVO();
				ShareData ShareData = new ShareData();
				ShareData.setTitle("我在野兽派定制了丝绒大熊，快来看我的好品味！");
				ShareData.setContent("我在野兽派定制独一无二的丝绒大熊，你也来玩玩吧！");
				ShareData.setLink("www.thebeastshop.com/app/weixin/customizationShare.htm?bearData=" + bearData);
				orderAction.setShare(productShareVO);
				orderAction.setWvVisible(true);
			} else {
				Long create1 = System.currentTimeMillis();
				PurchasePostOrderInfoVO purchasePostOrderInfoVO = createPurchasePostOrderInfoVO(order, code,
						member.getCode());
				Long create2 = System.currentTimeMillis();
				logger.info(
						"构造查询条件createPurchasePostOrderInfoVO用时{}ms: productCode={} category={} amount={} destination={} firstPurchase={}",
						create2 - create1, purchasePostOrderInfoVO.getProductCodes(),
						purchasePostOrderInfoVO.getCategory(), purchasePostOrderInfoVO.getAmount(),
						purchasePostOrderInfoVO.getDestination(), purchasePostOrderInfoVO.getFirstPurchase());
				Long point1 = System.currentTimeMillis();
				PurchasePostVO purchasePostVO = purchasePostService
						.findCurrentLastOnlineByOrderInfo(purchasePostOrderInfoVO);
				if (purchasePostVO != null) {
					logger.info("购买成功配置不为空");
					RedEnvelope red = redEnvelopeAdapter.createRedEnvenlope(orderCode, member.getCode(), memberId);
					if(red != null && red.getId() != null){
						String shareCode = red.getId().toString();
						orderAction.setShare(createProductShareVO(purchasePostVO, shareCode));
						orderAction.setWvVisible(false);
						orderAction.setWebview(website + orderCode);
						if (purchasePostVO.getShowType().equals(ShowTypeEnum.SCRATCH)) {
							logger.info("website={},orderCode={},LotteryActivityId={} ,id={}", website, orderCode,
									purchasePostVO.getLotteryActivityId(), purchasePostVO.getId());

							website = "beastapp://entry?name=order-action&orderId=";
							orderAction.setWvVisible(true);
							orderAction.setWebview(website + orderCode + "&action=lottery&lotteryId="
									+ purchasePostVO.getLotteryActivityId());
						}
					}
					
					

				}
			}
		}
		return JsonApiResult.ofSuccessResult(orderAction);
	}

	private String convertToShareImageURL(String dataPack, String fissionRedEnvelopLink, String redEnvelopeId) {
		logger.info("分享图片组装 dataPack={}，fissionRedEnvelopLink={}，redEnvelopeId={}", dataPack, fissionRedEnvelopLink,
				redEnvelopeId);
		JSONArray dataPackArray = JSONArray.parseArray(dataPack);
		JSONObject dataPackObject = dataPackArray.getJSONObject(new Random().nextInt(dataPackArray.size()));
		JSONObject imageObject = dataPackObject.getJSONObject("image");
		StringBuilder builder = new StringBuilder(256);
		builder.append(imageAPI).append("?");
		builder.append("im=").append(Base64Util.encode(imageObject.getString("src").getBytes())).append("&");
		builder.append("url=")
				.append(Base64Util.encode(fissionRedEnvelopLink.concat("&id=").concat(redEnvelopeId).getBytes()))
				.append("&");
		builder.append("w=").append(imageObject.getString("width")).append("&");
		builder.append("h=").append(imageObject.getString("height")).append("&");
		builder.append("qx=").append(dataPackObject.getString("qrcodePX")).append("&");
		builder.append("qy=").append(dataPackObject.getString("qrcodePY")).append("&");
		builder.append("qw=").append(dataPackObject.getString("qrcodeWidth")).append("&");
		builder.append("qh=").append(dataPackObject.getString("qrcodeWidth")).append("&");
		builder.append("qh=").append(dataPackObject.getString("qrcodeWidth"));
		logger.info("组装结束 build={}", builder.toString());
		return builder.toString();
	}

	private ProductLotteryShareVO createProductShareVO(PurchasePostVO purchasePostVO, String shareCode) {
		logger.info("返回share组装，dataPack内容 = {}", purchasePostVO.getDataPack());
		ProductLotteryShareVO productShareVO = new ProductLotteryShareVO();
		ShareData shareData = new ShareData();
		productShareVO.setShowType(purchasePostVO.getShowType().getName());
		if (null != purchasePostVO.getDataPack()) {
			logger.info("datapack编码 encode= {}", Base64Util.encode(purchasePostVO.getDataPack().getBytes()));
			productShareVO.setDataPack(Base64Util.encode(purchasePostVO.getDataPack().getBytes()));
		}

		shareData.setType(purchasePostVO.getShareType().getName());

		if (purchasePostVO.getShareType().equals(ShareTypeEnum.WORD_LINK)) {
			shareData.setType("LINK");
		}

		String title = getOrderRedEnvelopeTitle();
		String content = getOrderRedEnvelopeContent();
		String link = getOrderRedEnvelopeLink();
		String img = getOrderRedEnvelopeImage();

		logger.info("fissionId={}", purchasePostVO.getFissionId());
		FissionRedEnvelopVO fissionRedEnvelop = new FissionRedEnvelopVO();
		if (null != purchasePostVO.getShareType() && purchasePostVO.getShareType().equals(ShareTypeEnum.IMAGE)) {

			logger.info("shareImageId={}", purchasePostVO.getShareImageId());
			ShareImageVO shareImageVO = shareImageService.getShareImageById(purchasePostVO.getShareImageId());
			if (shareImageVO != null) {
				fissionRedEnvelop = fissionRedEnvelopeService.getFissionRedEnvelopById(shareImageVO.getFissionId());
				logger.info("分享图片组装 dataPack={}，fissionRedEnvelopLink={}，redEnvelopeId={}", shareImageVO.getDataPack(),
						fissionRedEnvelop.getTargetUrl(), shareCode);
				String image = convertToShareImageURL(shareImageVO.getDataPack(), fissionRedEnvelop.getTargetUrl(),
						shareCode);
				link = fissionRedEnvelop.getShare().getLink() + "&id=" + shareCode;
				shareData.setImage(image);
				shareData.setLink(link);
			} else {
				logger.info("图片实体内容为空");
			}
		} else if(!NumberUtil.isNullOrZero(purchasePostVO.getFissionId()) && purchasePostVO.getFissionId()>0) {
			fissionRedEnvelop = fissionRedEnvelopeService.getFissionRedEnvelopById(purchasePostVO.getFissionId());

			ShareVO shareVO = fissionRedEnvelop.getShare();
			title = shareVO.getTitle();
			content = shareVO.getContent();
			img = shareVO.getImage();
			link = shareVO.getLink() + "&id=" + shareCode;
			shareData.setContent(content);
			shareData.setImageLink(img);
			shareData.setLink(link);
			shareData.setTitle(title);

		}

		productShareVO.setShareData(shareData);
		return productShareVO;
	}

	private PurchasePostOrderInfoVO createPurchasePostOrderInfoVO(OpSalesOrderVO order, String channelCode,
			String memberCode) {
		Set<String> productCodeList = new HashSet<>();
		Set<String> categoryList = new HashSet<>();
		String destination = null;
		if (CollectionUtils.isNotEmpty(order.getOpSoPackageVOs())) {
			for (OpSoPackageVO opSoPackageVO : order.getOpSoPackageVOs()) {
				if (CollectionUtils.isNotEmpty(opSoPackageVO.getOpSoPackageSkuVOs())) {
					for (OpSoPackageSkuVO opSoPackageSkuVO : opSoPackageVO.getOpSoPackageSkuVOs()) {
						PsProductVO productVO;
						if (opSoPackageSkuVO.getProductId() != null && opSoPackageSkuVO.getProductId() > 0) {
							productVO = mcPsProductService.findByProdId(opSoPackageSkuVO.getProductId());
						} else {
							productVO = mcPsProductService.findProdBySkuCode(opSoPackageSkuVO.getSkuCode());
						}
						if (productVO != null) {
							productCodeList.add(productVO.getCode());
						}
						List<PcsSkuCategoryVO> pcsSkuCategoryVOList = mcPcsSkuCategoryService
								.findFrontCategoriesBySkuCode(opSoPackageSkuVO.getSkuCode());
						if (CollectionUtils.isNotEmpty(pcsSkuCategoryVOList)) {
							categoryList.addAll(
									Lists.transform(pcsSkuCategoryVOList, new Function<PcsSkuCategoryVO, String>() {
										@Override
										public String apply(PcsSkuCategoryVO item) {
											return item.getId().toString();
										}
									}));
						}
					}
				}
			}

			if (CollectionUtils.isNotEmpty(order.getOpSoPackageVOs())
					&& order.getOpSoPackageVOs().get(0).getOpSoPackageDeliveryInfoVO() != null) {
				if ("上海市".equals(order.getOpSoPackageVOs().get(0).getOpSoPackageDeliveryInfoVO().getCity())) {
					destination = "shanghai";
				} else if ("北京市".equals(order.getOpSoPackageVOs().get(0).getOpSoPackageDeliveryInfoVO().getCity())) {
					destination = "beijing";
				}
			}

		}

		PurchasePostOrderInfoVO purchasePostOrderInfoVO = new PurchasePostOrderInfoVO();
		purchasePostOrderInfoVO.setProductCodes(StringUtils.join(productCodeList, ","));
		purchasePostOrderInfoVO.setCategory(StringUtils.join(categoryList, ","));
		purchasePostOrderInfoVO.setAmount(order.getNeedToPayAmount());
		purchasePostOrderInfoVO.setDestination(destination);
		purchasePostOrderInfoVO
				.setFirstPurchase(PegasusOperationServiceFacade.getInstance().ifFirtOrder(channelCode, memberCode));
		return purchasePostOrderInfoVO;
	}
}
