package com.thebeastshop.pegasus.channelservice.controller.groupon;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.thebeastshop.support.file.FileConstant;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.campaign.enums.DiscountTypeEnum;
import com.thebeastshop.campaign.service.CampaignLimitService;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.member.constant.MemberConstant;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.order.OrderGrouponAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.price.PriceAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.ProductAdapter;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McOpProdDynmcontDetailsService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.price.service.PrsPriceService;
import com.thebeastshop.price.vo.PrsCalcProductDTO;
import com.thebeastshop.price.vo.PrsProductPriceResultVO;
import com.thebeastshop.price.vo.PrsSpvPriceResultVO;
import com.thebeastshop.stock.dto.SGroupbuyCheckDTO;
import com.thebeastshop.stock.service.SGroupbuyStockService;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.vo.SGroupbuyCheckResultVO;
import com.thebeastshop.stock.vo.SGroupbuyInfoVO;
import com.thebeastshop.stock.vo.SGroupbuyLimitInfoVO;
import com.thebeastshop.stock.vo.SGroupbuyStockVO;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.vo.order.OrderConfirmVO;
import com.thebeastshop.support.vo.order.OrderPreviewDTO;
import com.thebeastshop.support.vo.product.Groupon;
import com.thebeastshop.support.vo.product.GrouponInfo;
import com.thebeastshop.support.vo.product.ProductVO;
import com.thebeastshop.support.vo.product.Share;
import com.thebeastshop.support.vo.product.SpvVO;

@Controller("grouponController")
@RequestMapping("/api/groupon")
public class GrouponController {
	private Logger logger = LoggerFactory.getLogger(GrouponController.class);

	@Autowired
	private SPresaleService sPresaleService;

	@Autowired
	private CampaignLimitService campaignLimitService;

	@Autowired
	private SGroupbuyStockService sGroupbuyStockService;

	@Autowired
	private OrderGrouponAdapter orderGrouponAdapter;

	@Autowired
	private PrsPriceService prsPriceService;

	@Autowired
	private PriceAdapter priceAdapter;

	@Autowired
	private MemberQueryService memberQueryService;

	@Autowired
	private McPsSkuService mcPsSkuService;

	@Autowired
	private ProductAdapter adapter;

	@Autowired
	private McPsProductService mcPsProductService;

	@Autowired
	private McOpProdDynmcontDetailsService mcOpProdDynmcontDetailsService;

	@Autowired
	private CartProductPackAdapter cartProductPackAdapter;

	@Autowired
	private McOpChannelService mcOpChannelService;

	/**
	 * 获取一个商品
	 *
	 * @param
	 */
	@RequestMapping(path = "/getInfo", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getProduct(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {

		JSONObject jsonData = JSONObject.parseObject(data);
		String productCode = jsonData.getString("productCode");// product code
		Long memberId = jsonData.getLong("memberId");
		Boolean isOpen = jsonData.getBoolean("isOpen");

		
		if (StringUtils.isEmpty(productCode)) {
			logger.info("参数有误码，商品productCode不存在，"+productCode);
			return null;
		}
		
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		MemberVO member = memberQueryService.getById(memberId);
		MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());

		PsMatchCampaignCond cond = new PsMatchCampaignCond();
		cond.setMatchCampaign(true);
		cond.setChannelCode(code);
		cond.setAccessWay(accessWay.getCode());
		cond.setMemberLevel(memberLevel.getCode());
		cond.setDiscount(memberLevel.getLevelAmountCondition());
		cond.setBdDiscount(member.getBdayDiscountRatio());
		PsProductVO product = mcPsProductService.getProductDetailByCode(code, productCode, cond);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		GrouponInfo grouponInfo = new GrouponInfo();
		ProductVO productVO = adapter.getProduct(product, member, opChannel, accessWay);
		if (productVO != null) {
			// label排序
			if (productVO != null && CollectionUtils.isNotEmpty(productVO.getLabels())) {
				List<Label> labels = productVO.getLabels();
				int[][] typed = new int[labels.size()][2];
				for (int i = 0; i < labels.size(); i++) {
					typed[i][0] = trans(labels.get(i).getType().toString());
					typed[i][1] = i;
				}
				for (int j = 0; j < typed.length; j++) {
					for (int i = 0; i < typed.length - 1; i++) {
						int[] ss;
						if (typed[i][0] > typed[i + 1][0]) {
							ss = typed[i];
							typed[i] = typed[i + 1];
							typed[i + 1] = ss;
						}
					}
				}
				List<Label> typed_lables = new ArrayList<Label>();
				for (int i = 0; i < typed.length; i++) {
					typed_lables.add(i, labels.get(typed[i][1]));
				}
				productVO.setLabels(typed_lables);
			}

		} else {
			productVO = new ProductVO();
			productVO.setInvisible(true);
		}

		if (productCode.equals("PROD001018058") || productCode.equals("PROD001018048")
				|| productCode.equals("PROD001018049")) {
			if (productVO.getInvisible() || productVO.getOffShelf() || productVO.getSoldOut()) {
				productVO.setOffShelf(false);
				productVO.setSoldOut(false);
				productVO.setBuyable(false);
			}
		}
		// 是否编辑过
		productVO.setLegacyDetails(!mcOpProdDynmcontDetailsService.IsEditByProdCode(productCode));

		grouponInfo.setProduct(productVO);

		// 去sku详情
		List<String> codes = product.getSkuCodes();
		List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(codes);

		PrsCalcProductDTO arg0 = priceAdapter.assemblePriceProduct(product, skus, member, opChannel, accessWay);

		if (null == arg0) {
			logger.info("商品组装出现问题：取不到该商品完整信息，productcode=" + product.getCode());
			return null;
		}
		logger.info("获取商品规格价格计算");

		PrsProductPriceResultVO priceVo = prsPriceService.calculatePrs4GroupBuyProductDetail(arg0);

		// 团购内容拼接
		Groupon groupon = assembleGroupon(product.getSpvList().get(0).getCampaignList(), member.getCode(), product,
				priceVo, isOpen);
		grouponInfo.setGroupon(groupon);

		return JsonApiResult.ofSuccessResult(grouponInfo);
	}

	int trans(String type) {
		int transed = 0;
		switch (type) {
		case "预售":
			transed = 0;
			return transed;
		case "海淘":
			transed = 1;
			return transed;
		case "定制":
			transed = 2;
			return transed;
		case "满减":
			transed = 3;
			return transed;
		case "满赠":
			transed = 4;
			return transed;
		case "换购":
			transed = 5;
			return transed;
		case "其他活动系统里的优惠":
			transed = 6;
			return transed;
		default:
			transed = 7;
		}
		return transed;
	}

	/**
	 * 团购预览订单
	 */

	@ApiAuth
	@RequestMapping(value = "/preview", method = RequestMethod.POST)
	@ResponseBody
	public JsonApiResult preview(@RequestParam("CODE") final String code, @RequestBody final String data) {
		logger.info("团购订单预览");
		OrderConfirmVO orderConfirm = new OrderConfirmVO();
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		Long spvId = jsonData.getLong("spvId");
		logger.info("memberId={},spvId={}", memberId, spvId);
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		MemberVO member = memberQueryService.getById(memberId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		// 订单预览
		OrderPreviewDTO orderPreview = JSON.parseObject(jsonData.getString("orderPreview"), OrderPreviewDTO.class);

		List<CartProductPack> packs = cartProductPackAdapter.setProdAndSpv2CartProductPack(orderPreview.getPacks(),
				accessWay, member, opChannel.getCode());

		cartProductPackAdapter.syncPrice2ProductPack(packs);
		logger.info("来自购物车的商品包处理   packs ：{}", packs);
		orderConfirm = orderGrouponAdapter.getOrderPreview(orderPreview, packs, member, opChannel, accessWay);

		orderConfirm.setOrderType(OrderBusinessType.GROUPON);

		logger.info("execute  preview end");
		return JsonApiResult.ofSuccessResult(orderConfirm);

	}

	// =============================================私有方法=============================================
	private Groupon assembleGroupon(List<PsCampaignVO> campaignList, String memberCode, PsProductVO product,
			PrsProductPriceResultVO priceVo, Boolean isOpen) {
		Groupon groupon = null;
		for (PsCampaignVO camp : campaignList) {
			if (camp.getDiscountTypeId().equals(DiscountTypeEnum.GROUP_BUY.getId())) {
				groupon = new Groupon();
				String groupId = camp.getId().toString();
				List<PsCampaignSectionVO> sectionList = camp.getCampaignSectionList();

				// 排序 团购价
				Collections.sort(sectionList, new Comparator<PsCampaignSectionVO>() {
					@Override
					public int compare(PsCampaignSectionVO o1, PsCampaignSectionVO o2) {
						BigDecimal a = o1.getFactor();
						BigDecimal b = o2.getFactor();
						return (a.compareTo(b));
					}
				});

				List<BigDecimal> range = new ArrayList<BigDecimal>();

				List<PrsSpvPriceResultVO> resultVOs = priceVo.getSpvPriceResultVOs();
				BigDecimal price0 = resultVOs.get(0).getDiscountPrice();
				BigDecimal price1 = resultVOs.get(0).getDiscountPrice();
				for (PrsSpvPriceResultVO resultVO : resultVOs) {
					if (resultVO.getDiscountPrice().compareTo(price0) < 0) {
						price0 = resultVO.getDiscountPrice();
					}
					if (resultVO.getDiscountPrice().compareTo(price1) > 0) {
						price1 = resultVO.getDiscountPrice();
					}
				}
				range.add(price0);
				range.add(price1);
				groupon.setPrice(range);

				if (!StringUtils.isEmpty(camp.getImageUrl())) {
					groupon.setDetailImage(FileConstant.BASE_URL + camp.getImageUrl());
				}
				groupon.setGroupCode(camp.getCode());
				groupon.setGroupDesc(camp.getTitle());
				groupon.setGroupTitle(camp.getName());

				groupon.setLeft(0);
				// 开团库存查询

				ServiceResp<Map<String, Integer>> liResp = campaignLimitService.getGroupBuySkuLeftLimit(camp.getCode(),
						product.getSkuCodes());

				SGroupbuyCheckDTO arg0 = new SGroupbuyCheckDTO();
				SGroupbuyInfoVO sGroupbuyInfoVO = new SGroupbuyInfoVO();

				List<SGroupbuyLimitInfoVO> sGroupbuyLimitInfoVOs = new ArrayList<SGroupbuyLimitInfoVO>();
				if (liResp.isSuccess()) {
					// 问架构能否开团
					Map<String, Integer> limitMap = liResp.getBean();

					// 开团库存查询
					for (Entry<String, Integer> entry : limitMap.entrySet()) {
						SGroupbuyLimitInfoVO sGroupbuyLimitInfoVO = new SGroupbuyLimitInfoVO(entry.getKey(),
								entry.getValue());
						sGroupbuyLimitInfoVOs.add(sGroupbuyLimitInfoVO);
					}
				} else {
					logger.info("调用小飞限量查询结果报错");
					return null;
				}

				sGroupbuyInfoVO.setGroupNumber(camp.getGroupNumber());
				sGroupbuyInfoVO.setMinUnit(camp.getMinUnit());
				arg0.setGroupbuyInfo(sGroupbuyInfoVO);
				arg0.setGroupbuyLimitInfoList(sGroupbuyLimitInfoVOs);
				arg0.setSkuCodeList(product.getSkuCodes());

				SGroupbuyCheckResultVO result = sGroupbuyStockService.checkCanStartGroupbuy(arg0);

				if (result.isCheckResult()) {

					// 校验预售库存
					Map<String, SPresaleSaleInvVO> presales = sPresaleService
							.findCanUseQttBySkuCodes(product.getSkuCodes(), null);

					List<SGroupbuyStockVO> stocks = result.getGroupbuyStockList();
					if (!CollectionUtils.isEmpty(stocks)) {
						int left = 0;
						for (SGroupbuyStockVO stock : stocks) {
							if (presales.containsKey(stock.getSkuCode())) {
								SPresaleSaleInvVO presale = presales.get(stock.getSkuCode());
								if (presale != null) {
									Date now = new Date();
									Calendar cal = Calendar.getInstance();
									cal.setTime(now);
									cal.add(Calendar.HOUR_OF_DAY, 4);
									cal.add(Calendar.MINUTE, 30);
									if (cal.getTime().after(presale.getCloseTime())) {
										continue;
									}
								}
							}
							left = left + stock.getCanSalesQuantity();
						}
						groupon.setLeft(left);
					}
				} else {
					if (!isOpen) {
						groupon.setLeft(camp.getMinUnit());
					}
				}

				groupon.setRemainSpellNum(null);
				if (camp.getLimitAmount() != -1 && memberCode != MemberConstant.DEFAULT_MEMBER_CODE) {
					ServiceResp<Integer> limitResp = campaignLimitService.getOpenGroupLeftNumber(groupon.getGroupCode(),
							memberCode);
					if (limitResp.isSuccess()) {
						groupon.setRemainSpellNum(limitResp.getBean());
					}
				}
				Share share = new Share();
				// 新增分享信息

				String detail = camp.getMerchDetailShareTitle();
				String state = camp.getStatusShareTitle();
				logger.info("新增团购分享信息，detail={},state,camp.getShareImageUrl()={}", detail, state,
						camp.getShareImageUrl());

				share.setDetail(detail);
				share.setState(state);
				if (!StringUtils.isEmpty(camp.getShareImageUrl())) {
					share.setImage(FileConstant.BASE_URL + camp.getShareImageUrl());
				}
				if (!StringUtils.isEmpty(camp.getFriendShareImageUrl())) {
					share.setSpecialImage(FileConstant.BASE_URL + camp.getFriendShareImageUrl());
				}
				groupon.setShare(share);
				groupon.setNumber(camp.getGroupNumber());
				groupon.setType("ALL");
				if (camp.getObject().equals("firstBuy")) {
					groupon.setType("GROWTH");
				}
				groupon.setIsStart(false);
				if (camp.getStartTime().before(new Date())) {
					groupon.setIsStart(true);
				}
				groupon.setIsEnd(false);
				if (camp.getExpireTime().before(new Date())) {
					groupon.setIsStart(true);
				}
			}
		}
		return groupon;

	}

}
