/*
package com.thebeastshop.pegasus.channelservice.controller.flowermonth;

import java.math.BigDecimal;
import java.util.List;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.coupon.service.CpCouponService;
import com.thebeastshop.member.constant.MemberConstant;
import com.thebeastshop.member.service.MemberAddressService;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberAddressVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.apiaddressfilter.AppEmojiFilter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.flowermonth.FlowerMonthOrderAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.flowermonth.FlowerMonthTiedAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.logistics.LogisticsAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.model.CalculateProductPackDTO;
import com.thebeastshop.pegasus.channelservice.model.OrderFeeVO;
import com.thebeastshop.pegasus.channelservice.model.PriceResult;
import com.thebeastshop.pegasus.channelservice.model.ServiceFeeStep;
import com.thebeastshop.pegasus.channelservice.service.PostageService;
import com.thebeastshop.pegasus.channelservice.service.PriceService;
import com.thebeastshop.pegasus.channelservice.vo.order.FlowerMonthOrderVO;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderGiftCardVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderResponseVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.enums.ChannelCodeEnum;
import com.thebeastshop.pegasus.service.operation.exception.ChannelException;
import com.thebeastshop.pegasus.service.operation.exception.ChannelExceptionErrorCode;
import com.thebeastshop.pegasus.service.operation.exception.OperationException;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.support.YesOrNo;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.enums.PaymentType;
import com.thebeastshop.support.enums.PriceType;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.PriceUtil;
import com.thebeastshop.support.vo.logistics.DeliverableVO;
import com.thebeastshop.support.vo.logistics.PostageVO;
import com.thebeastshop.support.vo.order.OrderCard;
import com.thebeastshop.support.vo.order.OrderConfirmDTO;
import com.thebeastshop.support.vo.order.OrderConfirmVO;
import com.thebeastshop.support.vo.order.OrderPreviewDTO;

*
 * Created by feilong.gao on 2017/2/20.


@Controller("flowerMonthOrderController")
@RequestMapping("/api/app/order/flowerMonth")
@ResponseBody
public class FlowerMonthOrderController {

	private Logger logger = LoggerFactory.getLogger(FlowerMonthOrderController.class);

	@Autowired
	private MemberQueryService memberQueryService;

	private final PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();

	@Autowired
	private MemberAddressService memberAddressService;

	@Autowired
	private PostageService postageService;

	@Autowired
	private PriceService priceService;

	@Autowired
	private LogisticsAdapter logisticsAdapter;

	@Autowired
	private CpCouponService cpCouponService;

	@Autowired
	private McOpChannelService mcOpChannelService;

	@Autowired
	private CartProductPackAdapter cartProductPackAdapter;

	@Autowired
	private FlowerMonthTiedAdapter flowerMonthTiedAdapter;

	@Autowired
	private FlowerMonthOrderAdapter flowerMonthOrderAdapter;

**
	 * 鲜花订单预览。
	 *
	 * @param code
	 * @param data
	 * @return 对应原


	@ApiAuth
	@RequestMapping(value = "/preview", method = RequestMethod.POST)
	public JsonApiResult preview(@RequestParam("CODE") final String code, @RequestBody final String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		if (memberId == null) {
			memberId = MemberConstant.DEFAULT_MEMBER_ID;
		}
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		MemberVO member = memberQueryService.getById(memberId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		OrderPreviewDTO orderPreview = JSON.parseObject(jsonData.getString("orderPreview"), OrderPreviewDTO.class);

		List<CartProductPack> packs = Lists.newArrayList();
		if (null == orderPreview || null == orderPreview.getPacks()) {
			return JsonApiResult.ofSuccessResult(new OrderConfirmVO());
		} else {
			packs = cartProductPackAdapter.setProdAndSpv2CartProductPack(orderPreview.getPacks(), AccessWayEnum.APP,
					member, ChannelCodeEnum.CHN2049.getChannelCode());
			cartProductPackAdapter.syncPrice2ProductPack(packs);
			checkFlowerMonthParams(packs);
		}

		OrderConfirmVO orderConfirm = flowerMonthOrderAdapter.getFlowerMonthConfirm(orderPreview, packs, member,
				opChannel, accessWay);
		// 设置订单业务类型为鲜花月送
		orderConfirm.setOrderType(OrderBusinessType.MONTHLY_FLOWER);
		return JsonApiResult.ofSuccessResult(orderConfirm);
	}

**
	 * 订单创建接口
	 *
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原/beast_site/order/confirm
	 * @throws Exception
	 *
	 *             !!只针对月送鲜花，没有海淘邮费，没有定制费


	@ApiAuth
	@RequestMapping(value = "/create", method = RequestMethod.POST)
	public JsonApiResult create(@RequestParam("CODE") final String code, @RequestBody final String data)
			throws Exception {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		if (memberId == null) {
			memberId = MemberConstant.DEFAULT_MEMBER_ID;
		}
		MemberVO member = memberQueryService.getById(memberId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		String deviceId = jsonData.getString("deviceId");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		OrderConfirmDTO orderConfirmDTO = JSON.parseObject(jsonData.getString("orderConfirm"), OrderConfirmDTO.class);
		orderConfirmDTO.setPrice(orderConfirmDTO.getPrice());
		FlowerMonthOrderVO orderCreateVO = new FlowerMonthOrderVO();
		String orderCode = "";
		boolean hasOverSea = false;
		List<CartProductPack> packs = Lists.newArrayList();
		if (orderConfirmDTO == null || CollectionUtils.isEmpty(orderConfirmDTO.getPacks())) {
			logger.error("订单请求对象为空 ！");
			throw new WrongArgException("请求对象不能为空");
		} else {
			packs = cartProductPackAdapter.setProdAndSpv2CartProductPack(orderConfirmDTO.getPacks(), AccessWayEnum.APP,
					member, ChannelCodeEnum.CHN2049.getChannelCode());
			cartProductPackAdapter.syncPrice2ProductPack(packs);
			// 入参校验
			checkFlowerMonthParams(packs);
			CartProductPack rewPack = null;
			for (CartProductPack pack : packs) {
				if (CartPackSourceEnum.RAW.equals(pack.getSource())) {
					rewPack = pack;
					break;
				}
			}
			MemberAddressVO address = memberAddressService.getById(orderConfirmDTO.getAddressId());
			if (!flowerMonthOrderAdapter.canDistFlowerAddress(address, rewPack)) {
				throw new WrongArgException("地址不可用，不在配送区域！");
			}
			Integer deliveryTimes = 1;
			if (null != rewPack.getSpv().getSkuVO()) {
				PsSkuVO sku = rewPack.getSpv().getSkuVO();
				deliveryTimes = sku.getDeliveryTimes();
			}
			// 优惠券校验
			CalculateProductPackDTO calPriceDTO = new CalculateProductPackDTO();
			Long couponId = orderConfirmDTO.getCouponId();
			if (!NumberUtil.isNullOrZero(couponId)) {
				orderCreateVO.setCouponCode(orderConfirmDTO.getCouponId().toString());
				calPriceDTO.setCouponId(couponId);
			}

			// 价格计算
			calPriceDTO.setAccessWay(accessWay);
			calPriceDTO.setOpChannel(opChannel);
			calPriceDTO.setMember(member);
			calPriceDTO.setPacks(packs);
			calPriceDTO.setBirthday(false); // 不参与生日折扣

			PriceResult priceResult = priceService.calculateProductPackPrice(calPriceDTO);
			DeliverableVO deliverableTime = logisticsAdapter.getDeliverableNew(packs, address, member, accessWay,
					opChannel, orderConfirmDTO.getPostage(), hasOverSea, priceResult);
			PostageVO postageVO = new PostageVO();
			if (deliverableTime != null) {
				postageVO = deliverableTime.getPostage();
			}

			logger.info("价格计算入口参数  时段={}，商品包={} , ", orderConfirmDTO.getDeliveryTimeSlot(), packs);
			OrderFeeVO orderFeeVO = postageService.calculateServiceFee(BigDecimal.ZERO,
					orderConfirmDTO.getDeliveryTimeSlot(), postageVO, packs,
					(priceResult.getTotalPrice().subtract(priceResult.getSavedPrice())), BigDecimal.ZERO, member,
					AccessWayEnum.APP);
			// 运费乘以配送次数
			if (CollectionUtils.isNotEmpty(orderFeeVO.getPostageSteps()) && deliveryTimes > 1) {
				for (ServiceFeeStep serviceFeeStep : orderFeeVO.getPostageSteps()) {
					serviceFeeStep.setPrice(serviceFeeStep.getPrice().multiply(new BigDecimal(deliveryTimes)));
				}
			}
			// 礼品卡
			if (CollectionUtils.isNotEmpty(orderConfirmDTO.getGiftCards())) {
				// 折扣后价格
				BigDecimal orderPrice = priceResult.getTotalPrice().subtract(priceResult.getSavedPrice());
				for (ServiceFeeStep setp : orderFeeVO.getServiceStep()) {
					orderPrice = orderPrice.add(setp.getPrice());
				}
				List<OpSalesOrderGiftCardVO> opSalesOrderGiftCardVOs = priceService
						.calculateGiftPrice(orderConfirmDTO.getGiftCards(), orderPrice);
				BigDecimal giftPrice = BigDecimal.ZERO;
				for (OpSalesOrderGiftCardVO vo : opSalesOrderGiftCardVOs) {
					giftPrice = giftPrice.add(vo.getGiftCardValue());
				}
				orderCreateVO.setOpSalesOrderGiftCardVOs(opSalesOrderGiftCardVOs);
				orderFeeVO.setGiftCardSteps(Lists.newArrayList(
						new ServiceFeeStep("礼品卡", BigDecimal.ZERO.subtract(giftPrice), PriceType.GIFTCARD)));

			}
			orderCreateVO.setPriceResult(priceResult);
			orderCreateVO.setServiceStep(orderFeeVO.getServiceStepContainGift());
			// =============支付金额校验=============
			BigDecimal payment = postageService.calculatePayment(priceResult, orderFeeVO.getServiceStepContainGift());
			if (payment.compareTo(orderConfirmDTO.getPrice()) != 0) {
				throw new ChannelException(ChannelExceptionErrorCode.ORDER_AMOUNT_ZERO_CODE, "商品支付价格有误," + payment);
			}
			orderCreateVO.setBirthdayDiscountUse("0");
			orderCreateVO.setActualPayFee(orderConfirmDTO.getPrice());
			orderCreateVO.setAddressId(orderConfirmDTO.getAddressId());
			orderCreateVO.setMemberId(memberId);
			orderCreateVO.setPacks(packs);
			orderCreateVO.setIsAnonymous(orderConfirmDTO.isAnonymous() ? 1 : 0);
			orderCreateVO.setChannelCode(code);
			orderCreateVO.setNote(orderConfirmDTO.getRemark());
			orderCreateVO.setDeliveryTimeSlot(orderConfirmDTO.getDeliveryTimeSlot());
			OrderCard card = orderConfirmDTO.getNewCard();
			orderCreateVO.setNoteCard(card.getType().getCode());
			orderCreateVO.setNoteCardMessage(AppEmojiFilter.filterEmoji(card.getContent()));
			orderCreateVO.setNoteCardTo(card.getTo());
			orderCreateVO.setNoteCardFrom(card.getFrom());
			orderCreateVO.setUtmSource(orderConfirmDTO.getUtmSource());

			orderCreateVO.setDownloadSource(orderConfirmDTO.getDownloadSource());
			// ----------spv map-----------
			final OpSalesOrderVO opSalesOrderVO = flowerMonthAdapter.orderWebsite2CommonFlower(orderCreateVO, accessWay,
					opChannel, packs);
			logger.info("返回的 订单vo 信息 opSalesOrderVO={}", opSalesOrderVO);
			opSalesOrderVO.setDeviceId(deviceId);
			final OpSalesOrderResponseVO orderResp = pcInstance.editOrder(opSalesOrderVO, accessWay);

			if (orderResp != null && StringUtils.isNotBlank(orderResp.getOrderCode())) {
				orderCode = orderResp.getOrderCode();
				if (orderResp.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
					// TODO:如果支付价格为零元则订单设为已支付,默认支付方式为支付宝
					_callOldOrderPay(orderCode, PaymentType.ALIPAY.getId(), orderResp.getAmount(), "");
				}
				if (orderCreateVO.getCouponCode() != null && StringUtils.isNotBlank(orderCode)) {
					// TODO：如果创建订单成功,则优惠券要改为已使用（注：这个应该是在下订单流程中处理的，以后要改）
					ServiceResp<Boolean> resp = cpCouponService.use(Long.valueOf(orderCreateVO.getCouponCode()));
					if (resp.isFailure()) {
						throw new OperationException("优惠券使用失败");
					}
				}

*
				 * 
				 * 订单快照不可用
				 * 
				 * 上线前重新修改
				 * 


				if (StringUtils.isNotBlank(orderCode)) {
					// orderSnapshotService.saveOrderSnapshot(orderResp.getId(),
					// orderFeeVO, priceResult,
					// orderConfirmDTO.getGiftCards(),
					// orderConfirmDTO.getAddressId());

				}
			} else {
				logger.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" + ErrorCode.DEFAULT_EXCEPTION.getMesage());
				return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(),
						ErrorCode.DEFAULT_EXCEPTION.getMesage());
			}
		}
		return JsonApiResult.ofSuccessResult(orderCode);
	}

	private Boolean _callOldOrderPay(String orderCode, Integer paymentType, BigDecimal totalAmount, String tradeNo) {
		try {
			// XXX:是否有必要给支付价格呢
			// 支付账号
			String _payAccount = "";
			return pcInstance.orderPay(orderCode, paymentType, totalAmount, _payAccount, tradeNo);
		} catch (Exception e) {
			logger.error("订单支付异常! e={}", e);
		}
		return false;
	}

*
	 * 周送鲜花入参校验
	 *
	 * @param packs


	private void checkFlowerMonthParams(List<CartProductPack> packs) {
		// 月送鲜花商品校验 1、主品校验 2、赠品 3、换购（暂不实现）
		List<Long> giftSpvIds = Lists.newArrayList();
		for (CartProductPack pack : packs) {
			if (CartPackSourceEnum.RAW.equals(pack.getSource())) {
				if (YesOrNo.NO.getId().equals(pack.getProduct().getIsMonthSend())) {
					throw new WrongArgException("周送鲜花不能和普通商品一起下单");
				}
			}
			if (CartPackSourceEnum.GIFT.equals(pack.getSource())) {
				giftSpvIds.add(pack.getSpvId());
			}
			if (CartPackSourceEnum.ADDIBLE.equals(pack.getSource())) {
				throw new WrongArgException("周送鲜花不支持换购");
			}

		}
		if (CollectionUtils.isNotEmpty(giftSpvIds)) {
			if (!flowerMonthTiedAdapter.checkFlowerFirstGift(giftSpvIds)) {
				throw new WrongArgException("周送鲜花不支持该赠品");
			}
		}
	}

}
*/
