package com.thebeastshop.pegasus.channelservice.controller.flowermonth;

import com.google.common.collect.Lists;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.member.constant.MemberConstant;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.flowermonth.FlowerMonthShowAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.flowermonth.FlowerMonthStockAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.flowermonth.FlowerMonthTiedAdapter;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;

import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.stock.dto.SFlowerMonthlyCityDTO;
import com.thebeastshop.stock.enums.SFlowerProductionTypeEnum;
import com.thebeastshop.support.YesOrNo;
import com.thebeastshop.support.enums.flowerMonth.FlowerMonthDistType;
import com.thebeastshop.support.util.EnumUtil;
import com.thebeastshop.support.vo.flowerMonth.*;
import com.thebeastshop.support.vo.product.ProductVariantVO;
import com.thebeastshop.support.vo.stock.StoreStockVO;

import org.apache.commons.collections.CollectionUtils;
import org.forest.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;

import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;

import java.util.List;

@Controller("flowerMonthController")
@RequestMapping("/api/app/flowerMonth")
public class FlowerMonthController {
    private Logger logger = LoggerFactory.getLogger(FlowerMonthController.class);

    @Autowired
    private FlowerMonthShowAdapter flowerMonthShowAdapter;

    @Autowired
    private FlowerMonthTiedAdapter flowerMonthTiedAdapter;
    
    @Autowired
    private FlowerMonthStockAdapter flowerMonthStockAdapter;

	@Autowired
	private McOpChannelService mcOpChannelService;

    @Autowired
    private McPsProductService mcPsProductService;

    @Autowired
    private MemberQueryService memberQueryService;
//
//	/**
//     * 获取周送鲜花配送日期
//     *
//     * @param code
//     * @param data
//     * @return
//     */
//    @ApiAuth
//    @RequestMapping(path = "/deliveryDate")
//    @ResponseBody
//    public JsonApiResult getFlowerDeliveryDate(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
//        JSONObject jsonData = JSONObject.parseObject(data);
//        Long spvId = jsonData.getLong("spvId");
//        String areaCode = jsonData.getString("areaCode");
//        String distType = jsonData.getString("distType");
//
//        OpChannelVO opChannel = mcOpChannelService.findByCode(code);
//		FlowerMonthDeliveryDateVO result = flowerMonthAdapter.getFlowerDeliveryDate(spvId,opChannel);
//        return JsonApiResult.ofSuccessResult(result);
//    }
//
//    /**
//     * 获取身份验证结果
//     *
//     * @param code
//     * @param data
//     * @return
//     */
//    @ApiAuth
//    @RequestMapping(path = "/monthFlowerVerify")
//    @ResponseBody
//    public JsonApiResult monthFlowerVerify(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
//
//        JSONObject jsonData = JSONObject.parseObject(data);
//        Integer accessWay=jsonData.getInteger("accessWay");
//        Long memberId = jsonData.getLong("memberId");
//        String productCode = jsonData.getString("productCode");
//        OpChannelVO opChannel = mcOpChannelService.findByCode(code);
//        logger.info("==查询用户是否有权限memberId={}",memberId);
//
//        FlowerMonthVerifyVO vo= flowerMonthAdapter.monthFlowerVerify(memberId, opChannel,productCode,accessWay);
//        return JsonApiResult.ofSuccessResult(vo);
//    }


    /**
     * 月送鲜花规格
     *
     * @param code
     * @param data
     * @return
     */
    @ApiAuth
    @RequestMapping(path = "/variant")
    @ResponseBody
    public JsonApiResult monthFlowerVariant(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {

        FlowerMonthVariantVO result = new FlowerMonthVariantVO();
        JSONObject jsonData = JSONObject.parseObject(data);
        AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));

        String productCode = jsonData.getString("productCode");
        String areaCode = jsonData.getString("areaCode");
        Long memberId = jsonData.getLong("memberId");

        MemberVO member = memberQueryService.getById(memberId);
        OpChannelVO opChannel = mcOpChannelService.findByCode(code);

        MemberLevelEnum memberLevel = MemberLevelEnum.NORMAL;
        PsMatchCampaignCond cond = new PsMatchCampaignCond();
        cond.setMatchCampaign(true);
        cond.setAccessWay(accessWay.getCode());
        cond.setMemberLevel(memberLevel.getCode());
        cond.setDiscount(memberLevel.getLevelAmountCondition());
        cond.setBdDiscount(member.getBdayDiscountRatio());

        PsProductVO product = mcPsProductService.getProductDetailByCode(code, productCode, cond);
        SFlowerProductionTypeEnum type = SFlowerProductionTypeEnum.WAREHOUSE;
        if (null != product && YesOrNo.YES.getId().equals(product.getIsMonthSend())){
            // 设置店送区域
            if(SFlowerProductionTypeEnum.STORE.getValue().equals(product.getFlowerMonProductionType().byteValue())){
                type = SFlowerProductionTypeEnum.STORE;
                List<FlowerMonthDistAreaVO> distAreas = flowerMonthShowAdapter.getDistArea(productCode);
                result.setDistAreas(distAreas);
                if(StringUtils.isEmpty(areaCode)){
                    areaCode = distAreas.get(0).getCode();
                }
            }
            // 设置规格信息
            ProductVariantVO variant= flowerMonthShowAdapter.getFlowerMonthVariant(product, member,opChannel,areaCode,type);
            result.setVariant(variant);

            // 添加捆绑元素
            List<TiedDimensionVO> tiedDimension = flowerMonthTiedAdapter.getTiedDimension(product,member,accessWay,opChannel);
            result.setDimensions(tiedDimension);
        }
        return JsonApiResult.ofSuccessResult(result);
    }


    /**
     * 月送鲜花配送区域
     *
     * @param code
     * @param data
     * @return
     */
    @ApiAuth
    @RequestMapping(path = "/shopDistArea")
    @ResponseBody
    public JsonApiResult shopDistArea(@RequestParam("CODE") String code, @RequestParam("DATA") String data){

        List<FlowerMonthDistAreaVO> result = Lists.newArrayList();
        JSONObject jsonData = JSONObject.parseObject(data);
        AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
        String productCode = jsonData.getString("productCode");
        Long memberId = jsonData.getLong("memberId");
        if(memberId == null || NumberUtil.isNullOrZero(memberId)){
            memberId =MemberConstant.DEFAULT_MEMBER_ID;
        }
        MemberVO member = memberQueryService.getById(memberId);
        MemberLevelEnum memberLevel = MemberLevelEnum.NORMAL;
        PsMatchCampaignCond cond = new PsMatchCampaignCond();
        cond.setMatchCampaign(true);
        cond.setAccessWay(accessWay.getCode());
        cond.setMemberLevel(memberLevel.getCode());
        cond.setDiscount(memberLevel.getLevelAmountCondition());
        cond.setBdDiscount(member.getBdayDiscountRatio());

        PsProductVO product = mcPsProductService.getProductDetailByCode(code, productCode, cond);

        // 月送且是店送查询配送区域列表
        if (null != product && YesOrNo.YES.getId().equals(product.getIsMonthSend())
                && SFlowerProductionTypeEnum.STORE.getValue().equals(product.getFlowerMonProductionType().byteValue())){
            result = flowerMonthShowAdapter.getDistArea(productCode);
        }
        return JsonApiResult.ofSuccessResult(result);

    }
    
    /**
	 * 根据spv 取得实际和预存数量
	 * 
	 * @param code
	 * @param data
	 * @return JsonApiResult
	 */
	@ApiAuth
	@RequestMapping(value = "/searchSpvQty")
	@ResponseBody
	public JsonApiResult searchSpvQty(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long spvId = Long.valueOf(jsonData.getString("spvId"));
		List<StoreStockVO> list = flowerMonthStockAdapter.canSaleQuantity(spvId, code);
		return JsonApiResult.ofSuccessResult(list);
	}


}
