package com.thebeastshop.pegasus.channelservice.controller.favorite;

import java.util.List;

import com.thebeastshop.cart.enums.FavoriteExtTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.cart.req.FavoriteCondition;
import com.thebeastshop.cart.service.FavoriteService;
import com.thebeastshop.cart.vo.Favorite;
import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.configuration.service.ArticleService;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.favorite.FavoriteAdapter;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.support.enums.FavoriteExtType;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.page.Page;
import com.thebeastshop.support.page.Pagination;
import com.thebeastshop.support.vo.favorite.CreateFavoriteDTO;
import com.thebeastshop.support.vo.favorite.FavoriteVO;

/**
 * 收藏服务接口
 * 
 * @author Paul-xiong
 *
 */
@Controller
@RequestMapping(value = "/api/favorite")
public class FavoriteControllor {

	@Autowired
	private FavoriteService favoriteService;

	@Autowired
	private McPsProductService mcPsProductService;

	@Autowired
	private ArticleService articleService;

	@Autowired
	private MemberQueryService memberQueryService;
	@Autowired
	private McOpChannelService mcOpChannelService;

	@Autowired
	private FavoriteAdapter favoriteAdapter;

	/**
	 * 创建收藏
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/create", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult create(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		CreateFavoriteDTO dto = jsonData.getObject("dto", CreateFavoriteDTO.class);

		List<Long> itemIds = dto.getItemIds();
		if (CollectionUtils.isNotEmpty(itemIds)) {
			FavoriteExtTypeEnum type = FavoriteExtTypeEnum.getEnumByCode(dto.getType().getId());
			List<Favorite> toCreate = Lists.newArrayList();
			for (Long itemId : itemIds) {
				// =========校验关联者是否存在==========
				switch (type) {
				case ARTICLE:
					if (articleService.getArticleById(itemId).getBean() == null) {
						throw new NoSuchResourceException("文章", itemId);
					}
					break;
				case PRODUCT:
					if (mcPsProductService.findByProdId(itemId) == null) {
						throw new NoSuchResourceException("商品", itemId);
					}
					break;
				default:
					break;

				}
				// ================================
				Favorite favorite = new Favorite();
				favorite.setExtType(type);
				favorite.setExtId(itemId);
				favorite.setOwnerId(memberId);
				toCreate.add(favorite);
			}

			favoriteService.create(toCreate);
		}
		return JsonApiResult.ofSuccessResult(true);
	}

	@RequestMapping(path = "/delete", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult delete(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		// Long memberId = jsonData.getLong("memberId");
		FavoriteExtTypeEnum type = jsonData.getObject("type", FavoriteExtTypeEnum.class);
		List<Long> itemIds = JSON.parseArray(jsonData.getString("itemIds"), Long.class);
		Long memberId = jsonData.getLong("memberId");//会员id
		if (CollectionUtils.isNotEmpty(itemIds)) {

			favoriteService.batchDelete(itemIds,type,memberId);
			//优化
			/*for (Long itemId : itemIds) {
				FavoriteCondition condition = new FavoriteCondition();
				condition.setExtId(itemId);
				condition.setExtType(type);
				List<Favorite> list = favoriteService.getByCondition(condition);
				if (CollectionUtils.isNotEmpty(list)) {
					favoriteService.delete(list.get(0).getId());
				}
			}*/
		}
		return JsonApiResult.ofSuccessResult(true);
	}

	/**
	 * 获取收藏列表
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/list", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult list(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		final Long memberId = jsonData.getLong("memberId");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		final MemberVO member = memberQueryService.getById(memberId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		final Integer offset = jsonData.getInteger("offset");
		final Integer limit = jsonData.getInteger("limit");
		FavoriteExtTypeEnum type = jsonData.getObject("type", FavoriteExtTypeEnum.class);

		FavoriteCondition condition = new FavoriteCondition();
		condition.setOwnerId(memberId);
		condition.setExtType(type);
		PageQueryResp<Favorite> page = favoriteService.find(condition, offset, limit);

		Page<FavoriteVO> resultPage = new Page<FavoriteVO>(new Pagination(offset, limit));
		resultPage.setTotal(page.getTotalCnt());
//		resultPage.setItems(favoriteAdapter.getFavorite(page.getBeanList(), member, opChannel, accessWay,code));
		resultPage.setItems(favoriteAdapter.getFavorite(FavoriteExtType.valueOf(type.name()),page.getBeanList(), member, opChannel, accessWay));
		return JsonApiResult.ofSuccessResult(resultPage);
	}

	@RequestMapping(path = "/ifFavorIted", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult ifFavorIted(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		final Long memberId = jsonData.getLong("memberId");
		//final Channel channel = channelService.getByCode(code);
		FavoriteExtTypeEnum type = jsonData.getObject("type", FavoriteExtTypeEnum.class);
		Long id = jsonData.getLong("id");
		Favorite favorite = new Favorite();
		favorite.setExtId(id);
		favorite.setExtType(type);
		favorite.setOwnerId(memberId);
		Boolean res = favoriteService.checkIsExist(favorite);
		return JsonApiResult.ofSuccessResult(res);
	}
}
