//package com.thebeastshop.pegasus.channelservice.controller.deposit;
//
//import java.math.BigDecimal;
//import java.util.ArrayList;
//import java.util.Arrays;
//import java.util.Calendar;
//import java.util.Date;
//import java.util.HashMap;
//import java.util.List;
//import java.util.Map;
//
//import org.apache.commons.collections.CollectionUtils;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Controller;
//import org.springframework.web.bind.annotation.RequestBody;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RequestMethod;
//import org.springframework.web.bind.annotation.RequestParam;
//import org.springframework.web.bind.annotation.ResponseBody;
//
//import com.alibaba.fastjson.JSON;
//import com.alibaba.fastjson.JSONObject;
//import com.google.common.collect.Lists;
//import com.thebeastshop.cart.resp.CartProductPack;
//import com.thebeastshop.common.ServiceResp;
//import com.thebeastshop.common.enums.AccessWayEnum;
//import com.thebeastshop.common.enums.MemberLevelEnum;
//import com.thebeastshop.common.utils.DateUtil;
//import com.thebeastshop.cooperation.enums.DepositStatus;
//import com.thebeastshop.cooperation.enums.DepositType;
//import com.thebeastshop.cooperation.service.deposit.DepositService;
//import com.thebeastshop.cooperation.vo.deposit.DepositInfoVO;
//import com.thebeastshop.cooperation.vo.deposit.DepositOrderVO;
//import com.thebeastshop.member.service.MemberQueryService;
//import com.thebeastshop.member.vo.MemberVO;
//import com.thebeastshop.pegasus.channelservice.ApiAuth;
//import com.thebeastshop.pegasus.channelservice.JsonApiResult;
//import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
//import com.thebeastshop.pegasus.channelservice.adapter.order.OrderCommonAdapter;
//import com.thebeastshop.pegasus.channelservice.adapter.price.PriceAdapter;
//import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
//import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
//import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
//import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
//import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
//import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
//import com.thebeastshop.pegasus.merchandise.vo.PsAttributeValuePairVO;
//import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
//import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
//import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
//import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
//import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderResponseVO;
//import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
//import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageDeliveryInfoVO;
//import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageSkuVO;
//import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageVO;
//import com.thebeastshop.pegasus.service.operation.channelvo.OrderTypeEnum;
//import com.thebeastshop.pegasus.service.operation.exception.ChannelException;
//import com.thebeastshop.pegasus.service.operation.model.OpProduct;
//import com.thebeastshop.pegasus.service.operation.model.OpSalesOrder;
//import com.thebeastshop.pegasus.service.operation.model.OpSoPackageSku;
//import com.thebeastshop.pegasus.util.PegasusConstants;
//import com.thebeastshop.price.vo.PrsCartSettleLabelVO;
//import com.thebeastshop.price.vo.PrsSpvPriceStepVO;
//import com.thebeastshop.scm.po.InterestGoods;
//import com.thebeastshop.support.Label;
//import com.thebeastshop.support.enums.OrderBusinessType;
//import com.thebeastshop.support.exception.WrongArgException;
//import com.thebeastshop.support.exception.WrongEntityException;
//import com.thebeastshop.support.vo.cart.CartProductPackVO;
//import com.thebeastshop.support.vo.order.OrderConfirmDTO;
//import com.thebeastshop.support.vo.order.OrderConfirmVO;
//import com.thebeastshop.support.vo.order.OrderDetailVO.PriceStepVO;
//import com.thebeastshop.support.vo.order.OrderPreviewDTO;
//
//@Controller("depositController")
//@RequestMapping("/api/deposit")
//public class DepositController {
//	private Logger logger = LoggerFactory.getLogger(DepositController.class);
//
//	private final PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();
//
//	@Autowired
//	private McPsSkuService mcPsSkuService;
//
//	@Autowired
//	private McPsSpvService mcPsSpvService;
//
//	@Autowired
//	private McPsProductService mcPsProductService;
//	@Autowired
//	private DepositService depositService;
//	@Autowired
//	private PriceAdapter priceAdapter;
//	@Autowired
//	private OrderCommonAdapter orderCommonAdapter;
//
//	@Autowired
//	private MemberQueryService memberQueryService;
//
//	@Autowired
//	private CartProductPackAdapter cartProductPackAdapter;
//
//	@Autowired
//	private McOpChannelService mcOpChannelService;
//
//	/**
//	 * 定金订单预览订单
//	 */
//
//	@ApiAuth
//	@RequestMapping(value = "/preview", method = RequestMethod.POST)
//	@ResponseBody
//	public JsonApiResult preview(@RequestParam("CODE") final String code, @RequestBody final String data) {
//		logger.info("定金订单预览");
//		OrderConfirmVO orderConfirm = new OrderConfirmVO();
//		JSONObject jsonData = JSONObject.parseObject(data);
//		Long memberId = jsonData.getLong("memberId");
//		Long spvId = jsonData.getLong("spvId");
//		logger.info("memberId={},spvId={}", memberId, spvId);
//		Integer accessWayId = jsonData.getInteger("accessWay");
//		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
//		MemberVO member = memberQueryService.getById(memberId);
//		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
//		// 订单预览
//		OrderPreviewDTO orderPreview = JSON.parseObject(jsonData.getString("orderPreview"), OrderPreviewDTO.class);
//
//		List<CartProductPack> packs = cartProductPackAdapter.setProdAndSpv2CartProductPack(orderPreview.getPacks(),
//				accessWay, member, opChannel.getCode());
//
//		cartProductPackAdapter.syncPrice2ProductPack(packs);
//		logger.info("来自购物车的商品包处理   packs ：{}", packs);
//		orderConfirm = getOrderPreview(orderPreview, packs, member, opChannel, accessWay, code);
//
//		orderConfirm.setOrderType(OrderBusinessType.DEPOSIT);
//
//		logger.info("execute  preview end");
//		return JsonApiResult.ofSuccessResult(orderConfirm);
//
//	}
//
//	/**
//	 * 定金订单确认页，没有优惠券生日折扣等
//	 * 
//	 * @param paramPacks
//	 * @param member
//	 * @param opChannel
//	 * @param accessWay
//	 * @return
//	 */
//	public OrderConfirmVO getOrderPreview(OrderPreviewDTO orderPreview, List<CartProductPack> paramPacks,
//			MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay, String code) {
//
//		if (CollectionUtils.isEmpty(paramPacks)) {
//			throw new WrongArgException("商品包不能为空");
//		}
//
//		BigDecimal totalPrice = paramPacks.get(0).getSpv().getSalesPrice()
//				.multiply(new BigDecimal(paramPacks.get(0).getCount()));
//
//		OrderConfirmVO rt = new OrderConfirmVO();
//		boolean hasOverSea = false;// 判断是否有海外购商品
//		PsProductVO vp = new PsProductVO();
//		MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
//		PsProductVO product = new PsProductVO();
//		List<PriceStepVO> priceSteps = new ArrayList<PriceStepVO>();
//
//		String sku = "";
//		ServiceResp<DepositInfoVO> info = depositService.getByVirtualSku(paramPacks.get(0).getSpv().getSkuCode());
//
//		if (info.isSuccess()) {
//
//			sku = info.getBean().getSkuCode();
//			vp = mcPsProductService.findProdBySkuCode(sku);
//			PsMatchCampaignCond cond = new PsMatchCampaignCond();
//			cond.setMatchCampaign(true);
//			cond.setChannelCode(code);
//			cond.setAccessWay(accessWay.getCode());
//			cond.setMemberLevel(memberLevel.getCode());
//			cond.setDiscount(memberLevel.getLevelAmountCondition());
//			cond.setBdDiscount(member.getBdayDiscountRatio());
//			product = mcPsProductService.getProductDetailByCode(code, vp.getCode(), cond);
//
//			priceSteps.add(new PriceStepVO("商品定金", totalPrice));
//
//			List<CartProductPackVO> packVOs = Lists.newArrayListWithExpectedSize(paramPacks.size());
//
//			Map<String, Date> spvPresaleDateMap = new HashMap<String, Date>();
//			Map<PsSpvVO, List<Label>> spvLabelMap = new HashMap<PsSpvVO, List<Label>>();
//			for (CartProductPack pack : paramPacks) {
//
//				pack.getSpv().setDiscountPrice(pack.getSpv().getSalesPrice());
//				packVOs.addAll(priceAdapter.getCartProductPackList(Arrays.asList(pack), member, opChannel, true, false,
//						true, accessWay, false, spvPresaleDateMap, new HashMap<Long, InterestGoods>(),
//						new HashMap<Long, List<CartProductPackVO>>(), new HashMap<Long, List<PrsCartSettleLabelVO>>(),
//						true, spvLabelMap));
//
//				for (PsSpvVO spv : product.getSpvList()) {
//					if (spv.getSkuCode().equals(sku)) {
//						StringBuilder sb = new StringBuilder();
//						List<PsAttributeValuePairVO> attrList = spv.getAttributeValuePairList();
//						if (CollectionUtils.isNotEmpty(attrList)) {
//							for (PsAttributeValuePairVO attr : attrList) {
//								if (attr != null && org.apache.commons.lang.StringUtils.isNotBlank(attr.getAttrName())
//										&& org.apache.commons.lang.StringUtils.isNotBlank(attr.getValue()))
//									sb.append(attr.getAttrName()).append(" : ").append(attr.getValue()).append(" ");
//							}
//						}
//						packVOs.get(0).getSpv().setSpvDesc(sb.toString());
//					}
//				}
//
//			}
//			// =========是否包含海外购商品===========
//			rt.setHasOverseaProducts(hasOverSea);
//			// =========可用的支付方式===========
//			rt.setPayMethods(orderCommonAdapter.getPayMethods(rt.isHasOverseaProducts()));
//			// ==============商品包================
//			rt.setPacks(packVOs);
//			rt.setLabels(new ArrayList<Label>());
//			// =============价格步骤===============
//			rt.setPrice(totalPrice);
//
//			rt.setPriceSteps(priceSteps);
//
//			// ===============定制信息===============
//			rt.setCustomizable(Boolean.FALSE);
//
//			// ===============配送信息（是否使用语音卡）===============
//			rt.setVoiceCard(false);
//			rt.setAddress(null);
//
//			// ===========没有生日折扣============
//			rt.setBday(null);
//
//			// ===========不可写注释============
//			rt.setCanRemark(false);
//		}
//		return rt;
//
//	}
//
//	/***
//	 * 定金订单
//	 */
//	@ApiAuth
//	@RequestMapping(value = "/confirm", method = RequestMethod.POST)
//	@ResponseBody
//	public JsonApiResult confirm(@RequestParam("CODE") String code, @RequestBody final String data) {
//		logger.info("execute  deposit confirm");
//		JSONObject jsonData = JSONObject.parseObject(data);
//		Long memberId = jsonData.getLong("memberId");
//		String deviceId = jsonData.getString("deviceId");
//		MemberVO member = memberQueryService.getById(memberId);
//
//		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
//		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
//		OrderConfirmDTO orderConfirmDTO = JSON.parseObject(jsonData.getString("orderConfirm"), OrderConfirmDTO.class);
//
//		logger.info("确认订单：memberId：{}，packs：{}", memberId, orderConfirmDTO.getPacks());
//		// 目前先调用老的创建订单
//		String orderCode = "";
//		// Long orderId = 0L;
//		if (null != orderConfirmDTO.getPacks().get(0).getSpvId()) {
//			Long spvId = orderConfirmDTO.getPacks().get(0).getSpvId();
//
//			PsProductVO productVO = mcPsProductService.findProdBySpvId(spvId);
//			PsSpvVO spv = mcPsSpvService.findBySpvId(spvId);
//			PsSkuVO sku = mcPsSkuService.findBySkuCode(spv.getSkuCode());
//
//			OpSalesOrderVO opSalesOrderVO = orderCreate(orderConfirmDTO, member, opChannel, deviceId, productVO, spv,
//					sku);
//			try {
//				OpSalesOrderResponseVO orderResp = pcInstance.iposOrderCreate(opSalesOrderVO);
//				orderCode = orderResp.getOrderCode();
//
//				DepositOrderVO arg0 = new DepositOrderVO();
//				arg0.setCount(orderConfirmDTO.getPacks().get(0).getCount());
//				arg0.setMemberId(member.getId());
//				arg0.setOrderCode(orderCode);
//				arg0.setSkuCode(sku.getSkuCode());
//				arg0.setState(DepositStatus.DEFAULT);
//				arg0.setType(DepositType.DEPOSIT);
//				ServiceResp<Boolean> state = depositService.save(arg0);
//				logger.info("保存定金订单信息结果 state=" + state.getBean());
//			} catch (Exception e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//				throw new WrongEntityException(e.getMessage());
//
//			}
//
//		}
//		logger.info("confirm orderCode=" + orderCode);
//		JsonApiResult jsonResult = JsonApiResult.ofSuccessResult(orderCode);
//		logger.info("confirm result,code=[" + jsonResult.getCode() + "],msg=[" + jsonResult.getMessage() + "]");
//
//		return jsonResult;
//	}
//
//	/**
//	 * 新创建订单方法
//	 * 
//	 * @param orderConfirmDTO
//	 */
//
//	public OpSalesOrderVO orderCreate(OrderConfirmDTO orderComfirmDTO, MemberVO member, OpChannelVO channel,
//			String deviceId, PsProductVO productVO, PsSpvVO spv, PsSkuVO sku) {
//
//		// 订单VO
//		OpSalesOrderVO opSalesOrderVO = new OpSalesOrderVO();
//		opSalesOrderVO.setDeviceId(deviceId);
//		// 定金兑换订单类型
//		opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_11);
//		// 定金无运费
//		opSalesOrderVO.setCarriage(BigDecimal.ZERO);
//		// 精确配送订单
//		opSalesOrderVO.setLimitFee(BigDecimal.ZERO);
//		// 包裹VO
//		List<OpSoPackageVO> opSoPackageVOs = new ArrayList<OpSoPackageVO>();
//		// 官网默认是一个包裹
//		OpSoPackageVO opSoPackage = new OpSoPackageVO();
//		// 包裹地址信息
//		OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO = new OpSoPackageDeliveryInfoVO();
//		// 包裹sku信息
//		List<OpSoPackageSkuVO> opSoPackageSkuVOs = new ArrayList<OpSoPackageSkuVO>();
//
//		// 配送仓
//		OpChannelVO opChannel = mcOpChannelService.findByCode(channel.getCode());
//		if (opChannel != null) {
//			opSoPackage.setDispatchWarehouseCode(opChannel.getWarehouseForSales());
//		}
//
//		// 订单来源渠道编码
//		opSalesOrderVO.setChannelCode(channel.getCode());
//		opSoPackage.setCardType(0);
//		// 配送方式，0非快递1快递
//		opSoPackage.setDeliveryType(0);
//
//		// 4点后第二天发货
//		opSoPackage.setPlanedDeliveryDate(new Date());
//		Calendar c = Calendar.getInstance();
//		int hour = c.get(Calendar.HOUR_OF_DAY);
//		int minute = c.get(Calendar.MINUTE);
//		if (hour > 16 || (hour == 16 && minute > 0)) {
//			opSoPackage.setPlanedDeliveryDate(DateUtil.addDay(new Date(), 1));
//		}
//
//		opSoPackageDeliveryInfoVO.setAddress(null);// 详细地址
//		opSoPackageDeliveryInfoVO.setCircuitDesc(null);// 环线
//		opSoPackageDeliveryInfoVO.setCompanyName(null);// 公司名称
//		opSoPackageDeliveryInfoVO.setDistrictId(null);// 收货的区县ID
//		opSoPackageDeliveryInfoVO.setReceiver(null);// 收件人
//		opSoPackageDeliveryInfoVO.setZipCode(null);// 邮编
//		opSoPackageDeliveryInfoVO.setTitle(null);// 称谓
//		opSoPackageDeliveryInfoVO.setReceiverPhone(null); // 收件人电话
//		opSoPackageDeliveryInfoVO.setExpressType(null);
//
//		// opSoPackageDeliveryInfoVO.setOpenId(address.get);不造是个嘛，先不传，有问题再改
//		// 配送方式，判断是否需要强制审单
//		Map<String, Boolean> deliveryTypes = new HashMap<String, Boolean>();
//		OpSoPackageSkuVO packageSku = new OpSoPackageSkuVO();
//		packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);// 默认会员添加
//		packageSku.setSkuCode(spv.getSkuCode());
//		packageSku.setSpvId(spv.getSpvId());
//		// coupon使用
//		packageSku.setBrandId(productVO.getBrands().get(0).getBrandId());
//		packageSku.setCategroyId(productVO.getCategoryId());
//
//		packageSku.setIsJit(sku.getIsJit());// 是否来单制作
//		packageSku.setQuantity(orderComfirmDTO.getPacks().get(0).getCount());// 数量
//		packageSku.setUnitPoint(BigDecimal.ZERO);// 单品积分
//		// 判断是否包含两种以上配送方式，如果是，则需要强制审单
//		if (OpProduct.EP_TYPE_SELF == productVO.getExpressType()) {
//			deliveryTypes.put("SELF", true);
//		} else if (OpProduct.EP_TYPE_FED == productVO.getExpressType()) {
//			deliveryTypes.put("FEDX24", true);
//		} else if (OpProduct.EP_TYPE_Sf_AIR == productVO.getExpressType()) {
//			deliveryTypes.put("SF_AIR", true);
//		} else if (OpProduct.EP_TYPE_Sf_LAND == productVO.getExpressType()) {
//			deliveryTypes.put("SF_LAND", true);
//		} else if (OpProduct.EP_TYPE_YTO == productVO.getExpressType()) {// 圆通
//			deliveryTypes.put("YTO", true);
//		} else if (OpProduct.EP_TYPE_DEPPON == productVO.getExpressType()) {
//			deliveryTypes.put("DEPPON", true);
//		}
//
//		packageSku.setExpressType(productVO.getExpressType());
//		packageSku.setUnitDiscount(BigDecimal.ZERO);
//		PsSkuVO pssSkuVO = mcPsSkuService.findBySkuCode(spv.getSkuCode());
//
//		if (pssSkuVO == null) {
//			throw new ChannelException("商品已下架 " + spv.getSkuCode());
//		}
//		BigDecimal totalPrice = spv.getSalesPrice()
//				.multiply(new BigDecimal(orderComfirmDTO.getPacks().get(0).getCount()));
//
//		packageSku.setUnitDiscount(BigDecimal.ZERO);
//		// 折扣后金额
//		packageSku.setUnitAmountAfterDiscount(spv.getSalesPrice());
//		// 特价
//		packageSku.setDiscountPrice(spv.getSalesPrice());
//		packageSku.setUnitPointDeduction(BigDecimal.ZERO);
//		packageSku.setUnitPrice(spv.getSalesPrice());
//
//		packageSku.setIsGift(0);
//
//		// 商品分类
//		packageSku.setCategoryId(pssSkuVO.getCategoryId());
//		opSoPackageSkuVOs.add(packageSku);
//
//		opSalesOrderVO.setIsForceAudit(PegasusConstants.NO);
//		// 设置包裹配送信息
//		opSoPackage.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
//		opSoPackage.setOpSoPackageSkuVOs(opSoPackageSkuVOs);
//		opSoPackageVOs.add(opSoPackage);
//		// 设置订单关联包裹
//		opSalesOrderVO.setOpSoPackageVOs(opSoPackageVOs);
//
//		if (member != null) {
//			// 会员code
//			opSalesOrderVO.setMemberCode(member.getCode());
//			opSalesOrderVO.setMemberId(member.getId());
//		}
//
//		// 用户备注
//		opSalesOrderVO.setRemark(orderComfirmDTO.getRemark());
//		// 订单类型，1渠道销售单2渠道退货单3渠道换货单4集团订单11礼品订单12样品订单
//		opSalesOrderVO.setSalesOrderType(OrderTypeEnum.ORDERTYPE_11.getCode());
//
//		// 服务费
//		opSalesOrderVO.setServiceFeeAmount(BigDecimal.ZERO);
//		opSalesOrderVO.setIsAnonymous(orderComfirmDTO.isAnonymous() ? 1 : 0);
//		return opSalesOrderVO;
//	}
//}
