package com.thebeastshop.pegasus.channelservice.controller.cps;

import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.service.OpCpsOrderService;
import com.thebeastshop.pegasus.service.operation.util.cps.CpsOrderUtil;
import com.thebeastshop.pegasus.service.operation.util.cps.YiQiFaOrderUtil;
import com.thebeastshop.pegasus.service.operation.vo.cps.CpsOrderSkuVO;
import com.thebeastshop.pegasus.service.operation.vo.cps.CpsOrderVO;
import com.thebeastshop.support.encode.Base64Util;
import com.thebeastshop.support.enums.CpsChannelType;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Controller
@RequestMapping(value = "/api/cps")
public class CpsOrderControllor {

	private OpCpsOrderService opCpsOrderService = PegasusOperationServiceFacade.getInstance().getOpCpsOrderService();

	@RequestMapping(path = "/yiqifa/search/orderTime", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult yiqifaSearchByOrderTime(@RequestParam("cid") String cid, @RequestParam("startTime") long startTime, @RequestParam("endTime") long endTime) {
		List<CpsOrderVO> result = null;
		try {
			result = opCpsOrderService.selectOrderByChannel(CpsChannelType.YIQIFA.getName(), new Date(startTime), new Date(endTime), cid);
			return JsonApiResult.ofSuccessResult(Base64Util.encode(YiQiFaOrderUtil.createJSONFromList(result).getBytes()));
		} catch (Exception e) {
			e.printStackTrace();
			return JsonApiResult.ofErrorResult(0, e.getMessage());
		}
	}

	@RequestMapping(path = "/linktech/search/orderTime", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult linkTechSearchByOrderTime(@RequestParam("orderTime") String orderTime) {
		try {
			List<CpsOrderVO> cpsOrderVOList;
			Date orderDate = new SimpleDateFormat("yyyyMMdd").parse(orderTime);
			cpsOrderVOList = opCpsOrderService.selectOrderByChannel(CpsChannelType.LINKTECH.getName(), DateUtil.dayStart(orderDate), DateUtil.dayEnd(orderDate), null);
			char tab = '\t';
			char newline = '\n';
			StringBuilder builder = new StringBuilder();
			SimpleDateFormat timeFormat = new SimpleDateFormat("HHmmss");
			for (CpsOrderVO cpsOrderVO : cpsOrderVOList){
				for (CpsOrderSkuVO cpsOrderSkuVO : cpsOrderVO.getCpsOrderSkuVOList()){
					builder.append(2).append(tab)
							.append(timeFormat.format(cpsOrderVO.getOrder_time())).append(tab)
							.append(cpsOrderVO.getCpsData()).append(tab)
							.append(cpsOrderVO.getOrder_sn()).append(tab)
							.append(cpsOrderSkuVO.getGoods_id()).append(tab)
							.append(cpsOrderVO.getMemberCode()).append(tab)
							.append(cpsOrderSkuVO.getGoods_ta()).append(tab)
							.append(cpsOrderSkuVO.getActualUnitPrice()).append(tab)
							.append(CpsOrderUtil.linkTechConvertToCpsCategoryType(cpsOrderSkuVO.getActualUnitPrice(), cpsOrderSkuVO.getGoods_cate())).append(tab)
							.append(cpsOrderSkuVO.isReturned()?300:(cpsOrderVO.getPaymentStatus()==1?200:100)).append(newline);
				}
			}
			return JsonApiResult.ofSuccessResult(builder.toString());
		} catch (Exception e) {
			e.printStackTrace();
			return JsonApiResult.ofErrorResult(0, e.getMessage());
		}
	}
}