package com.thebeastshop.pegasus.channelservice.controller.coupon.app;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.thebeastshop.coupon.enums.CouponCodeTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.coupon.dto.CpCouponSampleProductCondDto;
import com.thebeastshop.coupon.service.CpCouponCodeExchangeService;
import com.thebeastshop.coupon.service.CpCouponService;
import com.thebeastshop.coupon.vo.CouponResponse;
import com.thebeastshop.coupon.vo.CpCouponCodeExchangeVO;
import com.thebeastshop.coupon.vo.CpCouponVO;
import com.thebeastshop.coupon.vo.ResponseCode;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.card.CardAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.coupon.CouponAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.coupon.OfflineCouponAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.exception.OperationException;
import com.thebeastshop.pegasus.service.operation.vo.CardVO;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.coupon.CouponCountVO;
import com.thebeastshop.support.vo.coupon.CouponVO;

/**
 * TODO：优惠券接口（目前针对app端）
 * 
 * @author Paul-xiong
 *
 */
@Controller("AppCouponController")
@RequestMapping("/api/app/coupon")
public class CouponController {
	private final Logger logger = LoggerFactory.getLogger(CouponController.class);



	private PegasusOperationServiceFacade instance = PegasusOperationServiceFacade.getInstance();


	@Autowired
	private CpCouponService cpCouponService;

	@Autowired
	private CpCouponCodeExchangeService cpCouponCodeExchangeService;

	@Autowired
	private CouponAdapter couponAdapter;

	@Autowired
	public CardAdapter cardAdapter;

	@Autowired
	private OfflineCouponAdapter offlineCouponAdapter;

	@Autowired
	private MemberQueryService memberQueryService;

	@Autowired
	private McOpChannelService mcOpChannelService;
	/**
	 * 取得某人的优惠券数量
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 */
	@ApiAuth
	@RequestMapping(value = "/size")
	@ResponseBody
	public JsonApiResult getCouponsCount(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("app execute getCouponsCount data={}","");
		CouponCountVO result = new CouponCountVO();
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");// 用户ID
		Integer accessWay = jsonData.getInteger("accessWay");
		logger.info("accessWay={}",accessWay);
		if (memberId == null || memberId == 0) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		MemberVO member = memberQueryService.getById(memberId);


        Integer notExpiredCount = cpCouponService.getNotExpiredCouponsCount(memberId);
        Integer expiredCount = cpCouponService.getExpiredCouponsCount(memberId);
        Integer usedCount = cpCouponService.getUsedCouponsCount(memberId);

        // 卡券
        CardVO card = instance.ifMemberOwnFreePostage(member.getCode());
        if (card != null && card.getCardType() != null && card.getCardType().getEndAt() != null && card.getCardType().getEndAt().after(new Date())) {
            notExpiredCount += 1;
        }
        if (card != null && card.getCardType() != null && card.getCardType().getEndAt() != null &&  card.getCardType().getEndAt().before(new Date())) {
            expiredCount += 1;
        }


		// PC渠道不查询数量
		if (!AccessWayEnum.PC.getCode().equals(accessWay)) {
			// 线下券数量 (1:未使用;2:已使用;3:已过期)
			notExpiredCount += offlineCouponAdapter.getOfflineCouponSize(memberId, 1L);
			usedCount += offlineCouponAdapter.getOfflineCouponSize(memberId, 2L);
			expiredCount += offlineCouponAdapter.getOfflineCouponSize(memberId, 3L);
		}
		result.setExpiredCount(expiredCount);
		result.setUsableCount(notExpiredCount);
		result.setUsedCount(usedCount);

		return JsonApiResult.ofSuccessResult(result);
	}

	/**
	 * 取得可用优惠卷
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 */
	@ApiAuth
	@RequestMapping(value = "/getUsableCoupons")
	@ResponseBody
	public JsonApiResult getUsableCoupons(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("app execute getUsableCoupons data={}",data);
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");// 用户ID

		if (memberId == null || memberId == 0) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		MemberVO member = memberQueryService.getById(memberId);
		logger.info("accessWay={}",jsonData.getInteger("accessWay"));
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));// 平台来源
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);

		List<RequestPack> sourcePackVOs = JSON.parseArray(jsonData.getString("packs"), RequestPack.class);
		List<CouponVO> usableCoupons = new ArrayList<CouponVO>();

		try {
			if (CollectionUtils.isNotEmpty(sourcePackVOs)) {

				List<CouponVO> couponVOs = couponAdapter.getUsableCoupons(sourcePackVOs, member, accessWay,
						opChannel);
				usableCoupons.addAll(couponVOs);

			} else {
				List<CpCouponVO> couponVOs = cpCouponService.getNotExpiredCoupons(memberId);
				usableCoupons = couponAdapter.getCouponList(couponVOs);
				CardVO card = instance.ifMemberOwnFreePostage(member.getCode());
				if (card != null &&  card.getCardType() != null && card.getCardType().getEndAt() !=  null && card.getCardType().getEndAt().after(new Date())) {
					usableCoupons.add(cardAdapter.getCard(card));
				}
				usableCoupons.addAll(offlineCouponAdapter.getOfflineCoupon(memberId, 1L));
			}
			// 设置状态
			this.setCouponStatus(usableCoupons, 1L);
		} catch (OperationException e) {
			logger.error("获取可用优惠券异常：e{}", e);
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		return JsonApiResult.ofSuccessResult(usableCoupons);
	}

	/**
	 * 取得已用优惠卷
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 */
	@ApiAuth
	@RequestMapping(value = "/getUsedCoupons")
	@ResponseBody
	public JsonApiResult getUsedCoupons(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("app execute getUsedCoupons data={}","");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");// 用户ID
		List<CouponVO> usedCoupons = new ArrayList<CouponVO>();

		if (memberId == null || memberId == 0) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		List<CpCouponVO> couponVOs = cpCouponService.getUsedCoupons(memberId);
		usedCoupons = couponAdapter.getCouponList(couponVOs);
		//获取已用线下优惠券
		usedCoupons.addAll(offlineCouponAdapter.getOfflineCoupon(memberId,2L));

		// 设置状态
		this.setCouponStatus(usedCoupons, 2L);
		return JsonApiResult.ofSuccessResult(usedCoupons);
	}

	/**
	 * 取得过期优惠卷
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 */
	@ApiAuth
	@RequestMapping(value = "/getExpiredCoupons")
	@ResponseBody
	public JsonApiResult getExpiredCoupons(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("app execute getExpiredCoupons data={}","");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");// 用户ID
		List<CouponVO> usedCoupons = new ArrayList<CouponVO>();

		if (memberId == null || memberId == 0) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		MemberVO member = memberQueryService.getById(memberId);
		List<CpCouponVO> couponVOs = cpCouponService.getExpiredCoupons(memberId);
		usedCoupons = couponAdapter.getCouponList(couponVOs);

		CardVO card = instance.ifMemberOwnFreePostage(member.getCode());
		if (card != null && card.getCardType().getEndAt().before(new Date())) {
			usedCoupons.add(cardAdapter.getCard(card));
		}
		// 获取过期线下劵
		usedCoupons.addAll(offlineCouponAdapter.getOfflineCoupon(memberId, 3L));
		// 设置状态
		this.setCouponStatus(usedCoupons, 3L);
		return JsonApiResult.ofSuccessResult(usedCoupons);
	}

	/**
	 * 检查优惠券是否可用
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/coupon/getList 获取coupon列表
	 */
//	@ApiAuth
//	@RequestMapping(value = "/checkCoupon")
//	@ResponseBody
//	public JsonApiResult checkCoupon(@RequestParam("CODE") String code, @RequestParam("DATA") String data)
//			throws Exception {
//		logger.info("app execute checkCoupon data={}","");
//		JSONObject jsonData = JSONObject.parseObject(data);
//		Long memberId = jsonData.getLong("memberId");// 用户ID
//		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));// 平台来源
//		logger.info("accessWay={}",jsonData.getInteger("accessWay"));
//
//		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
//		List<RequestPack> sourcePackVOs = JSON.parseArray(jsonData.getString("packs"), RequestPack.class);
//		Long couponId = jsonData.getLong("couponId");// 优惠券ID
//
//		if (memberId == null || memberId == 0 || couponId == null || couponId == 0
//				|| CollectionUtils.isEmpty(sourcePackVOs)) {
//			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
//					ErrorCode.PARAMS_ILLEGAL.getMesage());
//		}
//
//		if (CollectionUtils.isNotEmpty(sourcePackVOs)) {
//			MemberVO member = memberQueryService.getById(memberId);
//			boolean rt = couponAdapter.checkUseCouponForProducts(sourcePackVOs, member, couponId, accessWay,
//					opChannel);
//			return JsonApiResult.ofSuccessResult(rt);
//		}
//		return JsonApiResult.ofSuccessResult(false);
//	}
	
	@ApiAuth
	@RequestMapping("/type")
	@ResponseBody
	public JsonApiResult couponType(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		String couponCode = jsonData.getString("couponCode");
		Long memberId = jsonData.getLong("memberId");
		CpCouponSampleProductCondDto couponDto = new CpCouponSampleProductCondDto();
		couponDto.setCouponCode(couponCode);
		couponDto.setMemberId(memberId);
		CouponResponse response = cpCouponService.checkCouponInfo(couponDto);
		// 优惠券 返回coupon对象
		if (ResponseCode.SUCCESS.equals(response.getResponseCode()) && response.getCouponCodeType().equals(CouponCodeTypeEnum.CODE.type)) {
			CpCouponVO cpCouponVO = (CpCouponVO)response.getObj();
			response.setObj(couponAdapter.getCoupon(cpCouponVO));
		}
		return JsonApiResult.ofSuccessResult(response);
	}
	
//	@ApiAuth
//	@RequestMapping("/iposCheckCoupon")
//	@ResponseBody
//	public JsonApiResult iposCheckCoupon(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
//		JSONObject jsonData = JSONObject.parseObject(data);
//		Long couponId = jsonData.getLong("couponCode");
//		Long memberId = jsonData.getLong("memberId");
//		Integer accessWayCode = jsonData.getInteger("accessWay");
//		String packs = jsonData.getString("packs");
//		if (couponId == null || StringUtils.isBlank(packs) || memberId == null || accessWayCode == null) {
//			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
//		}
//		List<RequestPack> packList = JSON.parseArray(packs, RequestPack.class);
//		OpChannelVO channel = mcOpChannelService.findByCode(code);
//		MemberVO member = memberQueryService.getById(memberId);
//		if (member == null || channel == null) {
//			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
//		}
//		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayCode);
//		CouponResponse resp = couponAdapter.iposCheckUseCouponForProducts(packList, member, couponId, accessWay, channel);
//		return JsonApiResult.ofSuccessResult(resp);
//	
//	}

	/**
	 * 优惠码兑换优惠券
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/coupon/getList 获取coupon列表
	 */
	@ApiAuth
	@RequestMapping(value = "/codeExchange")
	@ResponseBody
	public JsonApiResult exchange(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("app execute exchange data={}","");
		JSONObject jsonData = JSONObject.parseObject(data);
		CouponVO rt = null;
		try {
			Long memberId = jsonData.getLong("memberId");// 用户ID
			String couponCode = jsonData.getString("couponCode");// 用户ID

			if (memberId == null || memberId == 0) {
				return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
						ErrorCode.PARAMS_ILLEGAL.getMesage());
			}

			if (StringUtils.isBlank(couponCode)) {
				return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
						ErrorCode.PARAMS_ILLEGAL.getMesage());
			}

			CpCouponCodeExchangeVO couponCodeExchange = new CpCouponCodeExchangeVO();
			couponCodeExchange.setCode(couponCode);
			couponCodeExchange.setOwnerId(memberId);

			ServiceResp<CpCouponCodeExchangeVO> resp = cpCouponCodeExchangeService.exchangeCouponCode(couponCodeExchange);
			if (resp.isFailure() ||  resp.getBean() == null) {
				logger.info("优惠卷兑换失败原因："+resp.getRespMsg());
				return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), "兑换失败,"+resp.getRespMsg());
			}
			CpCouponVO cpCouponVoO = cpCouponService.getCouponWithAllById(resp.getBean().getCouponId());
		    rt = couponAdapter.getCoupon(cpCouponVoO);
		    
		} catch (Exception e) {
			logger.error("exchange error {}",e);
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), e.getMessage());
		}
		return JsonApiResult.ofSuccessResult(rt);
	}
	
	/**
	 * 优惠券设置使用状态和过期状态对象
	 * 
	 * @param couponVOs
	 * @param status
	 *            (1:未使用;2:已使用;3:已过期)
	 * @return
	 */

	private void setCouponStatus(List<CouponVO> couponVOs, Long status) {
		if (CollectionUtils.isNotEmpty(couponVOs)) {
			for (CouponVO couponVO : couponVOs) {
				if (status.equals(1L)) {
					couponVO.setUsed(false);
					couponVO.setUsable(true);
					couponVO.setExpired(false);
				}
				if (status.equals(2L)) {
					couponVO.setUsed(true);
					couponVO.setUsable(false);
					couponVO.setExpired(false);
				}
				if (status.equals(3L)) {
					couponVO.setUsed(false);
					couponVO.setUsable(false);
					couponVO.setExpired(true);
				}
			}
		}
	}

}
