package com.thebeastshop.pegasus.channelservice.controller.coupon;


import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import com.thebeastshop.message.vo.MsgSingleVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.coupon.enums.CpCouponTypeEnum;
import com.thebeastshop.coupon.exception.CouponExceptionCode;
import com.thebeastshop.coupon.service.CpCouponCodeExchangeService;
import com.thebeastshop.coupon.service.CpCouponSampleService;
import com.thebeastshop.coupon.service.CpCouponService;
import com.thebeastshop.coupon.vo.CpCouponCodeExchangeVO;
import com.thebeastshop.coupon.vo.CpCouponSampleVO;
import com.thebeastshop.coupon.vo.CpCouponVO;
import com.thebeastshop.coupon.vo.CpFixedPriceVO;
import com.thebeastshop.coupon.vo.CpFullCutPriceVO;
import com.thebeastshop.coupon.vo.CpFullDiscountVO;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.message.enums.MsgTypeEnum;
import com.thebeastshop.message.enums.PublishTypeEnum;
import com.thebeastshop.message.service.MsgSendService;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.coupon.CouponAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.vo.ConponDetailVO;
import com.thebeastshop.pegasus.channelservice.vo.ConponParamVO;
import com.thebeastshop.pegasus.channelservice.vo.ConponVO;
import com.thebeastshop.pegasus.channelservice.vo.coupon.PsCouponContentVO;
import com.thebeastshop.pegasus.channelservice.vo.coupon.PsCouponVO;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.exception.OperationException;
import com.thebeastshop.pegasus.service.operation.vo.CouponPromRtnVO;
import com.thebeastshop.pegasus.service.operation.vo.CouponPromSkuVO;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.exception.WrongStateException;
import com.thebeastshop.support.vo.cart.RequestPack;




@Controller("CommonCouponController")
@RequestMapping("/api/coupon")
public class CouponController {
	private static final Logger logger = LoggerFactory.getLogger(CouponController.class);
	private PegasusOperationServiceFacade instance = PegasusOperationServiceFacade.getInstance();



	@Autowired
	private McOpChannelService mcOpChannelService;
	@Autowired
    private CpCouponService cpCouponService;

	@Autowired
	private CpCouponSampleService cpCouponSampleService;

	@Autowired
	private MemberQueryService memberQueryService;
	@Autowired
	private McPsSkuService mcPsSkuService;

	@Autowired
	private CpCouponCodeExchangeService cpCouponCodeExchangeService;


	@Autowired
	private CouponAdapter couponAdapter;


	@Autowired
	private MsgSendService msgSendService;






	/**
	 * 通过卡券id 查询 coupon信息
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(value = "/findCouponById")
	@ResponseBody
	public JsonApiResult findCouponById(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.error("===查询卡券 参数DATA={}", data);
		try {
			JSONObject jsonData = JSONObject.parseObject(data);
			Long couponId = jsonData.getLong("couponId");// 优惠券模版id
			PsCouponVO  psCouponVO = null;
			try {
				CpCouponVO cpCouponVO = cpCouponService.getCouponWithAllById(couponId);
				psCouponVO = getPsCouponVO(cpCouponVO,null);

			} catch (Exception ex) {
				logger.error("优惠券查询错误 [id=" + couponId + "]: " + ex);
				throw new RuntimeException("优惠券查询错误 [id=" + couponId + "]");
			}
			return JsonApiResult.ofSuccessResult(psCouponVO);
		} catch (Exception e) {
			logger.error("===通过id  查询卡券vo异常e={}", e);
			return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
		}
	}

	/**
	 * 发送优惠券
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	// @ApiAuth
	@RequestMapping(value = "/send")
	@ResponseBody
	public JsonApiResult send(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("发送优惠券到用户  信息中 data={},code ={}", data, code);
		Integer sendType = 1; // 那个类型 1 是 注册 2是订单
		Long sendUserId = 0L;
		Long sendCoupon = 0L;
		try {
			JSONObject jsonData = JSONObject.parseObject(data);
			Long couponSampleId = jsonData.getLong("couponSampleId");// 优惠券模版id
			Long userId = jsonData.getLong("userId");// 用户id
			Integer type = jsonData.getInteger("type");
			sendType = type;
			sendUserId = userId;
			sendCoupon = couponSampleId;

			ServiceResp<CpCouponVO> resp = cpCouponService.send(couponSampleId, userId);
			if (resp.isFailure()) {
				//发送短信提醒
				sendDuanxin(sendType, sendUserId, sendCoupon);//发送短信提示
				Integer errorCode = ErrorCode.DEFAULT_EXCEPTION.getCode();
				if (CouponExceptionCode.DATA_NOT_FOUND.getErrorCode().equals(resp.getRespCode())) {
					errorCode = ErrorCode.DATA_NOT_FOUND.getCode();
				 }
			}
			return JsonApiResult.ofSuccessResult(null);
		} catch (Exception e) {
			logger.error("发送断行 系统异常 e={}", e);
			sendDuanxin(sendType, sendUserId, sendCoupon);// 发送短信提示
			return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
		}
	}

	/**
	 * 发送短信
	 * 
	 * @Author lijing
	 * @param type
	 *            1代表注册 2 代表订单
	 * @param userID
	 *            用户id
	 * @param couponId
	 *            卡券模版id
	 */
	public void sendDuanxin(Integer type, Long userID, Long couponId) {
		String content = "";
		if (type != null) {
			switch (type.intValue()) {
			case 1:
				content = "注册送优惠券失败   用户id:" + userID + "，卡券模版id为:" + couponId + "!请处理，野兽派";
				break;
			case 2:
				content = "订单送优惠券失败   用户id:" + userID + "，卡券模版id为:" + couponId + "!请处理，野兽派";
				break;
			}
		}

		List<MsgSingleVo> msgSingleVoList = new ArrayList<MsgSingleVo>();
		MsgSingleVo msgSingleVo  = new MsgSingleVo();
		msgSingleVo.setMsgTo("15312153102");//李靖开发
		msgSingleVo.setContent(content);
		msgSingleVo.setMsgType(MsgTypeEnum.SmsMsg);
		msgSingleVo.setPublishType(PublishTypeEnum.IDENTIFYING_CODE);
		msgSingleVoList.add(msgSingleVo);
		msgSingleVo  = new MsgSingleVo();
		msgSingleVo.setMsgTo("15221198655");//天琪开发
		msgSingleVo.setContent(content);
		msgSingleVo.setMsgType(MsgTypeEnum.SmsMsg);
		msgSingleVo.setPublishType(PublishTypeEnum.IDENTIFYING_CODE);
		msgSingleVoList.add(msgSingleVo);
		msgSendService.sendInterfaceVO(msgSingleVoList);

		logger.info("====发送失败短信成功");
	}

	/**
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/coupon/check 检查coupon
	 */
	@ApiAuth
	@RequestMapping(value = "/check")
	@ResponseBody
	public JsonApiResult couponCheck(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute couponCheck data={}","");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");// 用户ID
		Double total = jsonData.getDouble("totalAmount");// 金额
		String couponCode = jsonData.getString("couponCode");
		if (total == null || StringUtils.isBlank(couponCode)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		ConponVO coupon = new ConponVO();
		try {
			BigDecimal discount = instance.validByCouponCode(BigDecimal.valueOf(total), couponCode, memberId);
			coupon.setDiscount(discount.doubleValue());
			coupon.setValid(true);
		} catch (OperationException e) {
			logger.error("OperationException error {}",e);
			coupon.setDiscount(0d);
			coupon.setValid(false);
			coupon.setMessage(e.getMessage());
		}
		return JsonApiResult.ofSuccessResult(coupon);
	}

	/**
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/coupon/check 检查coupon
	 */
	@ApiAuth
	@RequestMapping(value = "/checkBySku")
	@ResponseBody
	public JsonApiResult couponCheckBySku(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute couponCheckBySku");
		ConponParamVO cpVO = JSONObject.parseObject(data, ConponParamVO.class);
		List<CouponPromSkuVO> promSkuVOs = cpVO.getPromSkus();

		ConponVO coupon = new ConponVO();
		if (promSkuVOs == null || StringUtils.isBlank(cpVO.getCouponCode())) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		try {
			List<String> skuCodes = new ArrayList<>();
			for (CouponPromSkuVO bean : promSkuVOs) {
				skuCodes.add(bean.getSkuCode());
			}

			List<PsSkuVO> ps = mcPsSkuService.findBySkuCodes(skuCodes);
			if (!CollectionUtils.isEmpty(ps)) {
				for (PsSkuVO po : ps) {
					for (CouponPromSkuVO bean : promSkuVOs) {
						if (po.getSkuCode().equals(bean.getSkuCode())) {
							bean.setBrandId(po.getBrandId());
							bean.setCategroyId(po.getCategoryId());
							break;
						}
					}
				}
			}

			CouponPromRtnVO couponVo = instance.validByCouponCodeAndSkus(promSkuVOs, cpVO.getCouponCode(), cpVO.getMemberId());
			if (couponVo != null) {
				coupon.setDiscount(couponVo.getPromSum().doubleValue());
				coupon.setValid(true);
			} else {
				coupon.setDiscount(0d);
				coupon.setValid(false);
			}

		} catch (OperationException e) {
			logger.error("OperationException error {}",e);
			coupon.setDiscount(0d);
			coupon.setValid(false);
			coupon.setMessage(e.getMessage());
		}
		return JsonApiResult.ofSuccessResult(coupon);
	}

	/**
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/coupon/getList 获取coupon列表
	 */
	@ApiAuth
	@RequestMapping(value = "/getList")
	@ResponseBody
	public JsonApiResult couponGetList(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute couponGetList data={}","");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");// 用户ID

		if (memberId == null || memberId == 0) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		List<ConponDetailVO> couponList = new ArrayList<ConponDetailVO>();
		try {
			// TODO:模拟数据
			for (int i = 1; i <= 10; i++) {
				ConponDetailVO cdv = new ConponDetailVO();
				cdv.setId((long) i);
				cdv.setCouponRuleId((long) i);
				cdv.setCode("12345" + i);
				cdv.setValid(true);
				couponList.add(cdv);
			}

		} catch (OperationException e) {
			logger.error("OperationException error {}",e);
		}
		return JsonApiResult.ofSuccessResult(couponList);
	}

	/**
	 * 取得可用优惠卷
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/coupon/getList 获取coupon列表
	 */
	@ApiAuth
	@RequestMapping(value = "/getUsableCoupons")
	@ResponseBody
	public JsonApiResult getUsableCoupons(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute getUsableCoupons data={}","");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");// 用户ID
		AccessWayEnum accessWay = AccessWayEnum.PC;// 平台来源
		Integer accessWayId = jsonData.getInteger("accessWay");
		if (accessWayId != null) {
			accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		}
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		List<RequestPack> sourcePackVOs = JSON.parseArray(jsonData.getString("cartProductPacks"), RequestPack.class);
		Long couponId = jsonData.getLong("couponId");// 用户ID

		logger.info("accessWayId={},couponId={}",accessWayId,couponId);
		List<PsCouponVO> usableCoupons = new ArrayList<PsCouponVO>();

		if (memberId == null || memberId == 0) {
			logger.warn("memberId is null");
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		MemberVO member = memberQueryService.getById(memberId);
		try {
			if (CollectionUtils.isEmpty(sourcePackVOs)) {
				logger.warn("sourcePackVOs is null");
				return JsonApiResult.ofSuccessResult(usableCoupons);
			}

			List<com.thebeastshop.support.vo.coupon.CouponVO> couponVOs = couponAdapter.getUsableCoupons(sourcePackVOs, member, accessWay, opChannel);
			if (CollectionUtils.isEmpty(couponVOs)) {
				return JsonApiResult.ofSuccessResult(usableCoupons);
			}

			for (com.thebeastshop.support.vo.coupon.CouponVO couponVO : couponVOs) {
				PsCouponVO dcs = convertPsCouponVO4support(couponVO);
				if (couponId != null && couponId.equals(dcs.getId())) {
					dcs.setDefaultSelect(true);
					logger.info("dcs.setDefaultSelect(true)={}",couponId);
				}
				usableCoupons.add(dcs);
			}

		} catch (OperationException e) {
			logger.error("OperationException error {}",e);
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		if (usableCoupons != null){
			logger.info("couponVOs B count=" + usableCoupons.size());
		}
		return JsonApiResult.ofSuccessResult(usableCoupons);
	}

	private PsCouponVO convertPsCouponVO4support(com.thebeastshop.support.vo.coupon.CouponVO source) {
		PsCouponVO target = new PsCouponVO();
		target.setTitle(source.getTitle());
		target.setExpireTime(source.getExpireTime());
		target.setStartTime(source.getStartTime());
		target.setDescription(source.getDescription());


		PsCouponContentVO psCouponContentVO = new PsCouponContentVO();
		psCouponContentVO.setDescription(source.getThresholdDesc());
		psCouponContentVO.setFullPrice(source.getThreshold());
		psCouponContentVO.setCutPrice(source.getDiscount());
		target.setPsCouponContentVO(psCouponContentVO);
		target.setCouponContent(JSON.toJSONString(psCouponContentVO));

		// 给web用站点用
		PsCouponContentVO couponContentVO = new PsCouponContentVO();
		couponContentVO.setDescription(source.getThresholdDesc());
		couponContentVO.setFullPrice(source.getThreshold());
		couponContentVO.setCutPrice(source.getDiscount());
		target.setCouponContentVO(couponContentVO);


		target.setCouponId(source.getId());
		target.setId(source.getId());
		target.setCouponPrice(source.getDiscount());
		return target;

	}

	/**
	 * 兑换优惠卷
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/coupon/getList 获取coupon列表
	 */


//	@ApiAuth
//	@RequestMapping(value = "/checkCoupon")
//	@ResponseBody
//	public JsonApiResult checkCoupon(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
//		logger.info("execute checkCoupon data={}","");
//		JSONObject jsonData = JSONObject.parseObject(data);
//		Long memberId = jsonData.getLong("memberId");// 用户ID
//		AccessWayEnum accessWay = AccessWayEnum.PC;// 平台来源
//		Integer accessWayId = jsonData.getInteger("accessWay");
//		logger.info("accessWayId={}",accessWayId);
//		if (accessWayId != null) {
//			accessWay = AccessWayEnum.getEnumByCode(accessWayId);
//		}
//		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
//		List<RequestPack> sourcePackVOs = JSON.parseArray(jsonData.getString("cartProductPacks"), RequestPack.class);
//		Long couponId = jsonData.getLong("couponId");// 用户ID
//
//		if (memberId == null || memberId == 0) {
//			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
//					ErrorCode.PARAMS_ILLEGAL.getMesage());
//		}
//		MemberVO member = memberQueryService.getById(memberId);
//		if (couponId == null || couponId == 0) {
//			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
//					ErrorCode.PARAMS_ILLEGAL.getMesage());
//		}
//
//		if(CollectionUtils.isEmpty(sourcePackVOs)){
//			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
//		}
//		couponAdapter.checkUseCouponForProducts(sourcePackVOs, member, couponId, accessWay,opChannel);
//		return JsonApiResult.ofSuccessResult(true);
//	}


	/**
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/coupon/getList 获取coupon列表
	 */
	@ApiAuth
	@RequestMapping(value = "/getCouponVO")
	@ResponseBody
	public JsonApiResult getCouponVO(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute getCouponVO data={}","");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");// 用户ID
		AccessWayEnum accessWay = AccessWayEnum.PC;// 平台来源
		Integer accessWayId = jsonData.getInteger("accessWay");
		logger.info("accessWayId={}",accessWayId);
		if (accessWayId != null) {
			accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		}
		List<RequestPack> sourcePackVOs = JSON.parseArray(jsonData.getString("cartProductPacks"), RequestPack.class);
		Long couponId = jsonData.getLong("couponId");// 用户ID

		if (memberId == null || memberId == 0) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		if (couponId == null || couponId == 0) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		PsCouponVO dcs = null;
		MemberVO member = memberQueryService.getById(memberId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);

		try {
			if(CollectionUtils.isEmpty(sourcePackVOs)){
				logger.error("sourcePackVOs is null");
				return null;
			}
			List<com.thebeastshop.support.vo.coupon.CouponVO> couponVOs = couponAdapter.getUsableCoupons(sourcePackVOs, member, accessWay, opChannel);
			if (CollectionUtils.isEmpty(couponVOs)) {
				return JsonApiResult.ofSuccessResult(dcs);
			}
			for (com.thebeastshop.support.vo.coupon.CouponVO couponVO : couponVOs) {
				dcs = convertPsCouponVO4support(couponVO);
				if (couponId != null && couponId.equals(dcs.getId())) {
					dcs.setDefaultSelect(true);
				}
			}
		} catch (OperationException e) {
			logger.error("getCouponVO error {}",e);
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		return JsonApiResult.ofSuccessResult(dcs);
	}



	/**
	 * 使用优惠卷
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/coupon/getList 获取coupon列表
	 */
	@ApiAuth
	@RequestMapping(value = "/useCoupon")
	@ResponseBody
	public JsonApiResult useCoupon(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute useCoupon data={}","");
		JSONObject jsonData = JSONObject.parseObject(data);

		Long couponId = jsonData.getLong("couponId");// 用户ID
		if (couponId == null || couponId == 0) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		try{
			if (couponId == null || couponId == 0) {
				return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
						ErrorCode.PARAMS_ILLEGAL.getMesage());
			}
			ServiceResp<Boolean> resp = cpCouponService.use(couponId);
			if (resp.isFailure()) {
				return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), resp.getRespMsg());
			}
		}catch(Exception e){
			logger.error("useCoupon error {}",e);
			return JsonApiResult.ofSuccessResult(false);
		}
		return JsonApiResult.ofSuccessResult(true);

	}



	/**
	 * 根据Id取得优惠卷信息
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/coupon/getList 获取coupon列表
	 */
	@ApiAuth
	@RequestMapping(value = "/getCouponById")
	@ResponseBody
	public JsonApiResult getCouponById(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute getCouponById data={}","");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long couponId = jsonData.getLong("couponId");// 用户ID

		if (couponId == null || couponId == 0) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		try{
			CpCouponVO coupon = cpCouponService.getCouponWithAllById(couponId);
			PsCouponVO  dcs = getPsCouponVO(coupon,couponId);
			return JsonApiResult.ofSuccessResult(dcs);
		}catch(Exception e){
			return JsonApiResult.ofSuccessResult(false);
		}
	}


	/**
	 * 根据Id取得优惠卷信息
	 * @param code 渠道编码
	 * @param data 业务参数
	 * @return
	 * 对应原：/beast_site/coupon/getList 获取coupon列表
	 */
	@ApiAuth
	@RequestMapping(value = "/couponExchange")
	@ResponseBody
	public JsonApiResult couponExchange(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute couponExchange data={}","");
		JSONObject jsonData = JSONObject.parseObject(data);

		try{
			Long memberId = jsonData.getLong("memberId");// 用户ID
			String couponCode = jsonData.getString("couponCode");// 用户ID

			if (memberId == null || memberId == 0) {
				return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
						ErrorCode.PARAMS_ILLEGAL.getMesage());
			}

			if (StringUtils.isBlank(couponCode)) {
				return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
						ErrorCode.PARAMS_ILLEGAL.getMesage());
			}

			CpCouponCodeExchangeVO couponCodeExchange = new CpCouponCodeExchangeVO();
			couponCodeExchange.setCode(couponCode);
			couponCodeExchange.setOwnerId(memberId);

			ServiceResp<CpCouponCodeExchangeVO> resp = cpCouponCodeExchangeService.exchangeCouponCode(couponCodeExchange);

			if(resp == null || resp.isFailure()){
				return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), "兑换失败！");
			}
		} catch (Exception e) {
			logger.error("couponExchange error {}",e);
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), e.getMessage());
		}

		return JsonApiResult.ofSuccessResult(true);



	}


	/**
	 * 根据Id取得优惠卷信息
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/coupon/getList 获取coupon列表
	 */
	@ApiAuth
	@RequestMapping(value = "/couponExchangeReturn")
	@ResponseBody
	public JsonApiResult couponExchangeReturn(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute couponExchangeReturn data={}","");
		JSONObject jsonData = JSONObject.parseObject(data);

		try{
			Long memberId = jsonData.getLong("memberId");// 用户ID
			String couponCode = jsonData.getString("couponCode");// 用户ID

			if (memberId == null || memberId == 0) {
				return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
						ErrorCode.PARAMS_ILLEGAL.getMesage());
			}

			if (StringUtils.isBlank(couponCode)) {
				return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
						ErrorCode.PARAMS_ILLEGAL.getMesage());
			}

			CpCouponCodeExchangeVO couponCodeExchangeVO = new CpCouponCodeExchangeVO();
			couponCodeExchangeVO.setCode(couponCode);
			couponCodeExchangeVO.setOwnerId(memberId);

			ServiceResp<CpCouponCodeExchangeVO> resp = cpCouponCodeExchangeService.exchangeCouponCode(couponCodeExchangeVO);
			if (resp == null) {
				return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),"兑换失败！");
			}

			if (resp.isFailure()) {
				return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),"兑换失败！" + resp.getRespMsg());
			}

			CpCouponCodeExchangeVO cce = resp.getBean();

			PsCouponVO dcs = new PsCouponVO();

			CpCouponVO couponVO = null;
			try {
				couponVO = cpCouponService.getCouponWithAllById(cce.getCouponId());
			} catch (Exception ex) {
				logger.error("" + ex);
			}

			if (couponVO == null) {
				logger.error("couponVO is null");
				return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),"系统错误！");
			}

			CpCouponSampleVO cs = couponVO.getCouponSample();
			if (cs == null) {
				logger.error("cs is null");
				return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),"系统错误！");
			}
			dcs.setTitle(cs.getTitle());
			dcs.setExpireTime(couponVO.getExpireTime());
			dcs.setStartTime(couponVO.getStartTime());
			dcs.setDescription(cs.getDescription());
			dcs.setCouponId(couponVO.getId());
			dcs.setId(couponVO.getId());

			if (cs.getCouponTypeId().equals(CpCouponTypeEnum.CHEAPEN_LINE.getId())) {
				CpFullCutPriceVO fullCutPriceVO = (CpFullCutPriceVO) cs.getCouponContent();
				dcs.setCouponPrice(fullCutPriceVO.getCutPrice());
			}else if (cs.getCouponTypeId() == CpCouponTypeEnum.DISCOUNT_LINE.getId()) {
				CpFullDiscountVO fullCutCoupon = (CpFullDiscountVO) cs.getCouponContent();
				dcs.setCouponPrice(fullCutCoupon.getDiscount());
			}else if (cs.getCouponTypeId() == CpCouponTypeEnum.FIXEDPRICE_LINE.getId()) {
				CpFixedPriceVO fullCutCoupon = (CpFixedPriceVO)cs.getCouponContent();
				dcs.setCouponPrice(fullCutCoupon.getFixedPrice());
			}

			return JsonApiResult.ofSuccessResult(dcs);
		}catch(WrongArgException w){
			return JsonApiResult.ofErrorResult(-1,w.getMessage() );
		}catch(WrongStateException e){
			return JsonApiResult.ofErrorResult(-1,e.getMessage());
		} catch (Exception e) {
			logger.error("couponExchangeReturn error {}",e);
			return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(),ErrorCode.DEFAULT_EXCEPTION.getMesage() );
		}


	}





//	/**
//	 * 兑换优惠卷
//	 * 
//	 * @param code
//	 *            渠道编码
//	 * @param data
//	 *            业务参数
//	 * @return 对应原：/beast_site/coupon/getList 获取coupon列表
//	 */
//	@ApiAuth
//	@RequestMapping(value = "/checkCouponExchange")
//	@ResponseBody
//	public JsonApiResult checkCouponExchange(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
//		logger.info("checkCouponExchange 兑换优惠卷 data={}","");
//		JSONObject jsonData = JSONObject.parseObject(data);
//		Long memberId = jsonData.getLong("memberId");// 用户ID
//		AccessWayEnum accessWay = AccessWayEnum.PC;// 平台来源
//		Integer accessWayId = jsonData.getInteger("accessWay");
//		logger.info("accessWayId={}",accessWayId);
//		if (accessWayId != null) {
//			accessWay = AccessWayEnum.getEnumByCode(accessWayId);
//		}
//		List<RequestPack> sourcePackVOs = JSON.parseArray(jsonData.getString("cartProductPacks"), RequestPack.class);
//		String couponCode = jsonData.getString("couponCode");// 用户ID
//
//		if (memberId == null || memberId == 0) {
//			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
//					ErrorCode.PARAMS_ILLEGAL.getMesage());
//		}
//
//		if (StringUtils.isEmpty(couponCode)) {
//			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
//					ErrorCode.PARAMS_ILLEGAL.getMesage());
//		}
//
//		if(CollectionUtils.isEmpty(sourcePackVOs)){
//			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
//		}
//
//
//		CpCouponCodeExchangeVO couponCodeExchangeVO = new CpCouponCodeExchangeVO();
//		couponCodeExchangeVO.setCode(couponCode);
//		couponCodeExchangeVO.setOwnerId(memberId);
//
//
//		ServiceResp<CpCouponCodeExchangeVO> resp = null;
//		try {
//			resp = cpCouponCodeExchangeService.exchangeCouponCode(couponCodeExchangeVO);
//		} catch (Exception ex) {
//			logger.error("" + ex);
//		}
//		if (resp == null) {
//			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),"兑换失败！");
//		}
//		if (resp.isFailure()) {
//			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),"兑换失败！" + resp.getRespMsg());
//		}
//
//		CpCouponCodeExchangeVO cce = resp.getBean();
//
//
//		MemberVO member = memberQueryService.getById(memberId);
//		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
//		CpCouponVO couponVO = cpCouponService.getCouponById(cce.getCouponId());
//		PsCouponVO dcs = new PsCouponVO();
//		dcs.setId(couponVO.getId());
//		boolean rlt = false;
//		try {
//
//			rlt = couponAdapter.checkUseCouponForProducts(sourcePackVOs, member, cce.getCouponId(), accessWay, opChannel);
//		}
//		catch(Exception e){
//           logger.error("优惠劵checkCouponExchange 异常:",e);
//		}
//		dcs.setDefaultSelect(rlt);
//		logger.info("checkCouponExchange 兑换优惠卷 end");
//		return JsonApiResult.ofSuccessResult(dcs);
//	}




	public PsCouponVO getPsCouponVO(CpCouponVO couponVO,Long couponId) {
		logger.info("execute getPsCouponVO xxx");
		if (couponVO == null){
			logger.error("couponVO is null");
			return null;
		}
		CpCouponSampleVO cs = couponVO.getCouponSample();
		if (cs == null){
			cs = cpCouponSampleService.getCouponSampleById(couponVO.getCouponSampleId());
		}
		if (cs == null){
			logger.error("cs2 is null");
		}

		PsCouponVO dcs = new PsCouponVO();
		dcs.setTitle(cs.getTitle());
		dcs.setExpireTime(couponVO.getExpireTime());
		dcs.setStartTime(couponVO.getStartTime());
		dcs.setDescription(cs.getDescription());
		dcs.setCouponContent(JSON.toJSONString(cs.getCouponContentMap()));
		PsCouponContentVO psCouponContentVO = new PsCouponContentVO(cs.getCouponContent());
		dcs.setPsCouponContentVO(psCouponContentVO);
		dcs.setId(couponVO.getId());
		dcs.setCouponId(couponVO.getId());

		if(couponId != null && couponId.equals(couponVO.getId())){
			dcs.setDefaultSelect(true);
		}

		if (cs.getCouponTypeId().equals(CpCouponTypeEnum.CHEAPEN_LINE.getId())) {
			dcs.setCouponPrice(psCouponContentVO.getCutPrice());
		}

		return dcs;
	}
}
