package com.thebeastshop.pegasus.channelservice.controller.category;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.vo.ipos.CategorySkuVO;
import com.thebeastshop.pegasus.channelservice.vo.ipos.CategoryVO;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuCategoryService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.channelservice.util.PriceUtil;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.stock.vo.SSkuStockVO;

/***
 * 分类
 * @author fs
 *
 */
@Controller("CommonCategoryController")
@RequestMapping("/api/category")
public class CategoryController {

	@Autowired
	private McPcsSkuCategoryService mcPcsSkuCategoryService;
	@Autowired
	private McPsProductService mcPsProductService;
	@Autowired
	private McPsSkuService mcPsSkuService;
	@Autowired
	private McOpChannelService mcOpChannelService;

	 //private PegasusPurchaseServiceFacade  ppInstance=PegasusPurchaseServiceFacade.getInstance();
	 //private PegasusOperationServiceFacade poInstance=PegasusOperationServiceFacade.getInstance();
	// private PegasusWarehouseServiceFacade pwInstance=PegasusWarehouseServiceFacade.getInstance();
	 
	@Autowired
	private SPresaleService sPresaleService;
	
	@Autowired
	private SStockService sStockService;
	
	@RequestMapping("/sync")
	@ApiAuth
	@ResponseBody
	public JsonApiResult syncCategory(@RequestParam("CODE") String code){
		List<PcsSkuCategoryVO> categoryList=mcPcsSkuCategoryService.findAll();
		if(CollectionUtils.isEmpty(categoryList)){
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		List<CategoryVO> categoriesVOs=new ArrayList<CategoryVO>();
		for(PcsSkuCategoryVO category:categoryList){
			CategoryVO categoryVO=new CategoryVO();
			categoryVO.setId(category.getId());
			categoryVO.setFullName(category.getFullName());
			categoryVO.setCode(category.getCode());
			categoryVO.setCategoryName(category.getName());
			categoryVO.setAttr(category.getAttr());
			categoryVO.setInUse(category.getInUse());
			categoryVO.setIsLeaf(category.getIsLeaf());
			if(category.getParentId()==null){
				categoryVO.setParentId(0L);
			}else{
				categoryVO.setParentId(category.getParentId());
			}
			
			categoriesVOs.add(categoryVO);
		}
		return JsonApiResult.ofSuccessResult(categoriesVOs);
	}
	
	/***
	 * ipos搜索  搜索包含skuname和productname的sku
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping("/ipossarch")
//	@ApiAuth
	@ResponseBody
	public JsonApiResult searchProduct(@RequestParam("CODE") String code,@RequestParam("DATA") String data){
		JSONObject jsonData=JSONObject.parseObject(data);
		String keyWords=jsonData.getString("keywords");
		List<PsSkuVO> pcsSkuList=mcPsSkuService.findByCodeName(keyWords);
		List<PsSkuVO> prodSkuLis=findSkuByProductName(code, keyWords);
		//for ipos search fs 
		if(CollectionUtils.isEmpty(pcsSkuList)&&CollectionUtils.isNotEmpty(prodSkuLis)){
			pcsSkuList=prodSkuLis;
		}else if(CollectionUtils.isNotEmpty(pcsSkuList)&&CollectionUtils.isNotEmpty(prodSkuLis)){
			List<PsSkuVO> repeatSku=new ArrayList<PsSkuVO>(); 
			for(PsSkuVO psSku:pcsSkuList){
				for(PsSkuVO pdSku:prodSkuLis){
					if(psSku.getSkuCode().equals(pdSku.getSkuCode())){
						repeatSku.add(pdSku);
					}
				}
			}
			prodSkuLis.removeAll(repeatSku);
			pcsSkuList.addAll(prodSkuLis);
		}
		//for ipos search fs  end
		if(CollectionUtils.isEmpty(pcsSkuList)){
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		List<CategorySkuVO> cateSkus=new ArrayList<CategorySkuVO>();

		if (!CollectionUtils.isEmpty(pcsSkuList)) {
			for (PsSkuVO pcsSku : pcsSkuList) {
				
				if(pcsSku.getCrossBorderFlag()!=null && pcsSku.getCrossBorderFlag()==1){
					continue;
				}
				
				PsProductVO product = mcPsProductService.findProdBySkuCode(pcsSku.getSkuCode());
				if (product != null) {// 渠道可售商品，包含了此商品
					CategorySkuVO skuVO = new CategorySkuVO();
					skuVO.setSku(pcsSku.getSkuCode());
					skuVO.setName(pcsSku.getSkuNameCN());
					skuVO.setEnName(pcsSku.getSkuName());
					skuVO.setPrice(pcsSku.getSalesPrice());
					skuVO.setBrandId(pcsSku.getBrandId());
					skuVO.setCategoryId(pcsSku.getCategoryId());
					skuVO.setIsJit(pcsSku.getIsJit());
					skuVO.setProductNameEn(product.getName());
					skuVO.setProductNameZn(product.getNameCn());
					if (product.getAllowVipDiscount()!=null && 1 == product.getAllowVipDiscount()) {
						skuVO.setVipEnable(product.getAllowVipDiscount());
						skuVO.setVipPrice(PriceUtil.getVipPrice(pcsSku.getSalesPrice()));
						skuVO.setVvipPrice(PriceUtil.getVvipPrice(pcsSku.getSalesPrice()));
					} else {
						skuVO.setVipPrice(pcsSku.getSalesPrice());
						skuVO.setVvipPrice(pcsSku.getSalesPrice());
					}
					String picThumb = product.getPicThumb();
					if (StringUtils.isNotEmpty(picThumb)) {
						if (picThumb.indexOf("http://") < 0) {
							//picThumb = "http://oss.thebeastshop.com/"+ picThumb;
							picThumb="http://img.thebeastshop.com/"+picThumb;
						}
					}
					skuVO.setImage(picThumb);

					if(pcsSku.getIsJit()==0){
						// 取得所有sku预算
						final SPresaleSaleInvVO preSaleInvVO = sPresaleService.findCanUseQttBySkuCode(skuVO.getSku(), null);
						OpChannelVO opChannel = mcOpChannelService.findByCode(code);
						SSkuStockVO pw = sStockService.getSkuStock(skuVO.getSku(),opChannel.getWarehouseForSales());
						
	

						if (preSaleInvVO != null) {
							// 预售库存
							skuVO.setPresellQuantity(preSaleInvVO.getCanUseInv());
						} else {
							skuVO.setPresellQuantity(0);
						}

						if (pw != null) {
							// 实际库存
							skuVO.setQuantity(pw.getCanUseQuantity());
						} else {
							// 实际库存
							skuVO.setQuantity(0);
						}
						
						// 商品实示加预售数量
						skuVO.setTotalQuantity(skuVO.getQuantity()+skuVO.getPresellQuantity());
						if(skuVO.getTotalQuantity()==null){
							skuVO.setTotalQuantity(0);
						}
						
					}else{
						skuVO.setPresellQuantity(0);
						skuVO.setQuantity(0);
						// jit 商品排到最前面
						skuVO.setTotalQuantity(10000);
					}
					
					cateSkus.add(skuVO);
				}

			}
		}

		// 按数量倒序排序
		Collections.sort(cateSkus,comparator);
		//Collections.reverse(cateSkus);

		if(CollectionUtils.isEmpty(cateSkus)){
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		return JsonApiResult.ofSuccessResult(cateSkus);
	}
	
	 private  final static Comparator<CategorySkuVO> comparator = new Comparator<CategorySkuVO>(){
	        @Override  
	        public int compare(CategorySkuVO o1, CategorySkuVO o2) { 
			int rlt = 0;
			if (o1.getTotalQuantity().equals(o2.getTotalQuantity()))

				return rlt;
			rlt = o1.getTotalQuantity() < o2.getTotalQuantity() ? 1 : -1;
			return rlt;
	        }
	 };
	
	
	/***
	 * 根据productname 查询包含搜索的sku
	 * @param channelCode
	 * @param keyWords
	 * @return
	 */
	private List<PsSkuVO> findSkuByProductName(String channelCode,String keyWords){
		List<PsSkuVO> skuVOList=new ArrayList<PsSkuVO>();
		final Map<String, Object> params = new HashMap<>();
		params.put("name", keyWords);
		params.put("nameCn", keyWords);
		params.put("pagenum", 30);
		List<PsProductVO> prodList=  mcPsProductService.findByNameOrNameCN(params);
		if(CollectionUtils.isNotEmpty(prodList)){
	    	for(PsProductVO prodVo:prodList){
	    	      List<String>  skuList= prodVo.getSkuCodes();
	    	      for(String skuCode:skuList){
	    	      	PsSkuVO skuVO=mcPsSkuService.findBySkuCode(skuCode);
	    	      	if(null!=skuVO){
		    	      	skuVOList.add(skuVO);
	    	      	}
	    	      }
	    	   	}
		}
		return skuVOList;
	}
}
