package com.thebeastshop.pegasus.channelservice.controller.cart;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.cart.TempCart;
import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.req.TempCartPackCondition;
import com.thebeastshop.cart.resp.CartCustomization;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.resp.TempCartProductPack;
import com.thebeastshop.cart.service.CartService;
import com.thebeastshop.cart.service.TempCartService;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.member.constant.MemberConstant;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartPriceAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.MiniCartAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.TempCartAdapter;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.cart.CartVO;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.customize.UserSingleCustomization;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.List;

/**
 * 临时购物车 create by com.thebeastshop.pegasus.channelservice.controller.cart trunk
 * :author lijing User:lijing DATE : 2016/7/21 TIME : 22:43 trunk.
 */
@Controller("TempCartController")
@RequestMapping("/api/tempcart")
@ResponseBody
public class TempCartController {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private MemberQueryService memberQueryService;

	@Autowired
	private TempCartService tempCartService;

	@Autowired
	private CartPriceAdapter cartPriceAdapter;

	@Autowired
	private CartService cartService;

	@Autowired
	private McPsSpvService mcPsSpvService;

	@Autowired
	private TempCartAdapter tempCartAdaptor;

	@Autowired
	private MiniCartAdapter miniCartAdaptor;

	@Autowired
	private CartProductPackAdapter cartProductPackAdapter;
	@Autowired
	private McOpChannelService mcOpChannelService;

	// ============private================
	private TempCartProductPack getTempCartProudct(List<TempCartProductPack> packs, Long packId) {
		for (TempCartProductPack pack : packs) {
			if (pack.getId().equals(packId)) {
				return pack;
			}
		}
		return null;
	}

	// ============华丽丽的分割线================

	/**
	 * 获取购物车
	 *
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "")
	public JsonApiResult getCart(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute getCart");
		JSONObject jsonData = JSONObject.parseObject(data);
		String binding = jsonData.getString("building");
		String tbsId = jsonData.getString("tbsId");
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		TempCart cart = tempCartService.getByBinding(binding, tbsId, accessWay, code);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);

		CartVO cartVO = new CartVO();
		//
		// String ISNEWPRODUCTPRICE =
		// PropConstants.getProperties("ISNEWPRODUCTPRICE");//
		//
		// if (ISNEWPRODUCTPRICE.equals("true")) {
		// 给一个默认会员
		MemberVO member = memberQueryService.getById(MemberConstant.DEFAULT_MEMBER_ID);
		cartVO = cartPriceAdapter.getTempCart(cart, member, opChannel, accessWay);
		// } else {
		// cartVO = cartNewAdapter.getTempCartVO(cart, binding, opChannel,
		// accessWay);
		// }

		return JsonApiResult.ofSuccessResult(cartVO);
	}

	/**
	 * 获取临时购物车
	 *
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/getMiniCart")
	public JsonApiResult getMiniCart(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute getMiniCart");
		JSONObject jsonData = JSONObject.parseObject(data);
		String binding = jsonData.getString("building");
		String tbsId = jsonData.getString("tbsId");
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		final TempCart cart = tempCartService.getByBinding(binding, tbsId, accessWay, code);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		CartVO cartVO = new CartVO();
		// String ISNEWPRODUCTPRICE =
		// PropConstants.getProperties("ISNEWPRODUCTPRICE");//
		//
		// if (ISNEWPRODUCTPRICE.equals("true")) {

		if (accessWay.getCode().equals(AccessWayEnum.PC.getCode())) {
			cartVO = miniCartAdaptor.getTempCart(cart, binding, opChannel, accessWay);
		} else {
			// 给一个默认会员
			MemberVO member = memberQueryService.getById(MemberConstant.DEFAULT_MEMBER_ID);
			cartVO = cartPriceAdapter.getTempCart(cart, member, opChannel, accessWay);
		}

		// } else {
		// cartVO = miniCartAdaptor.getTempCart(cart, binding, opChannel,
		// accessWay);
		//
		// }

		return JsonApiResult.ofSuccessResult(cartVO);
	}

	/**
	 * 加入购物车
	 *
	 * @param code
	 * @param data
	 */
	@ApiAuth
	@RequestMapping(value = "/addPacks")
	public JsonApiResult addPack(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute addPacks");
		JSONObject jsonData = JSONObject.parseObject(data);
		String building = jsonData.getString("building");
		String tbsId = jsonData.getString("tbsId");
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		List<RequestPack> addPacks = JSON.parseArray(jsonData.getString("tempPacks"), RequestPack.class);
		List<TempCartProductPack> packs = Lists.newArrayList();
		for (RequestPack packVo : addPacks) {
			if (packVo != null && packVo.getSpvId() != null) {
				PsSpvVO spv = mcPsSpvService.findBySpvId(packVo.getSpvId());
				TempCartProductPack pack = new TempCartProductPack();
				pack.setCount(packVo.getCount());
				pack.setSource(CartPackSourceEnum.getEnumByCode(packVo.getSource().getId()));
				pack.setProductId(spv.getProductId());
				pack.setSpvId(spv.getSpvId());
				if (CollectionUtils.isNotEmpty(packVo.getCustomizes())) {
					pack.setCustomize(Boolean.TRUE);
					List<CartCustomization> cartCustomizes = Lists.newArrayList();
					for (UserSingleCustomization userCustomize : packVo.getCustomizes()) {
						CartCustomization cartCustom = new CartCustomization();
						cartCustom.setCustomDimensionId(userCustomize.getCode());
						cartCustom.setCustomDimensionName(userCustomize.getName());
						cartCustom.setCustomDimensionValue(userCustomize.getValue());
						cartCustomizes.add(cartCustom);
					}
					pack.setCustomizeList(cartCustomizes);
				}
				packs.add(pack);
			}
		}
		List<TempCartProductPack> rtPacks = tempCartService.addPacks(building, tbsId, packs, accessWay, code);
		logger.info("加入购物车成功 ：building:{},tbsId:{},packs:{}", building, tbsId, packs);
		List<Long> packIds = Lists.newArrayList();
		if(CollectionUtils.isNotEmpty(rtPacks)){
			for (TempCartProductPack rtPack : rtPacks) {
				packIds.add(rtPack.getId());
			}
		}
		return JsonApiResult.ofSuccessResult(packIds);
	}

	/**
	 * 编辑购物车商品
	 *
	 * @param code
	 * @param data
	 */
	@ApiAuth
	@RequestMapping(value = "/editPacks")
	public JsonApiResult modifyPack(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute editPacks");
		// ==============解析数据=============
		JSONObject jsonData = JSONObject.parseObject(data);
		String building = jsonData.getString("building");
		String tbsId = jsonData.getString("tbsId");
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		List<RequestPack> editPacks = JSON.parseArray(jsonData.getString("tempPacks"), RequestPack.class);
		// =============业务逻辑=============
		List<CartProductPackVO> packsAll = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(editPacks)) {
			List<Long> needToEditIds = Lists.newArrayListWithExpectedSize(editPacks.size());
			for (RequestPack editPackVO : editPacks) {
				needToEditIds.add(editPackVO.getId());
			}
			List<TempCartProductPack> needToEdit = tempCartService.getPacksByIds(building, tbsId, needToEditIds,
					accessWay, code);
			for (RequestPack editPackVO : editPacks) {
				TempCartProductPack edit = getTempCartProudct(needToEdit, editPackVO.getId());
				if (edit != null) {
					if (editPackVO.getCount() > 0) {
						edit.setCount(editPackVO.getCount());
					}
					if (editPackVO.getSpvId() != null) {
						edit.setSpvId(editPackVO.getSpvId());
					}
				}
			}
			List<TempCartProductPack> tempCartProductPacks = tempCartService.modifyPack(building, tbsId, needToEdit,
					accessWay, code);

			if (CollectionUtils.isNotEmpty(tempCartProductPacks)) {

				// String ISNEWPRODUCTPRICE =
				// PropConstants.getProperties("ISNEWPRODUCTPRICE");//
				//
				// if (ISNEWPRODUCTPRICE.equals("true")) {

				packsAll.addAll(cartPriceAdapter.getTempModityPacks(tempCartProductPacks, opChannel, accessWay));

				// } else {
				// packsAll.addAll(
				// tempCartAdaptor.getModityPacks(tempCartProductPacks,
				// building, opChannel, accessWay));
				// }

			}
		}
		return JsonApiResult.ofSuccessResult(packsAll);
	}

	/**
	 * 删除商品包
	 *
	 * @param code
	 * @param data
	 */
	@ApiAuth
	@RequestMapping(value = "/deletePacks")
	public JsonApiResult delPacks(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute deletePacks");
		JSONObject jsonData = JSONObject.parseObject(data);
		String building = jsonData.getString("building");
		String tbsId = jsonData.getString("tbsId");
		List<Long> packIds = JSON.parseArray(jsonData.getString("packIds"), Long.class);
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		if (CollectionUtils.isNotEmpty(packIds)) {
			TempCart cart = tempCartService.getByBinding(building, tbsId, accessWay, code);
			packIds = tempCartAdaptor.getDelPackIds(cart, packIds);
			tempCartService.removePacksById(building, tbsId, packIds);
		}
		return JsonApiResult.ofSuccessResult(true);
	}

	/**
	 * 清空失效商品
	 *
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/clearInvalidPacks")
	public JsonApiResult clearInvalid(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute clearInvalidPacks");
		JSONObject jsonData = JSONObject.parseObject(data);
		String building = jsonData.getString("building");
		String tbsId = jsonData.getString("tbsId");
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		TempCart cart = tempCartService.getByBinding(building, tbsId, accessWay, code);
		List<TempCartProductPack> invalidPacks = tempCartAdaptor.getInvalidPack(cart, building, opChannel, accessWay);
		tempCartService.removePacks(building, tbsId, invalidPacks);
		return JsonApiResult.ofSuccessResult(true);
	}

	@ApiAuth
	@RequestMapping(value = "/count")
	public JsonApiResult count(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute count");
		int res = 0;
		JSONObject jsonData = JSONObject.parseObject(data);
		String building = jsonData.getString("building");
		String tbsId = jsonData.getString("tbsId");
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		TempCart cart = tempCartService.getByBinding(building, tbsId, accessWay, opChannel.getCode());
		List<TempCartProductPack> validPacks = tempCartAdaptor.getValidPack(cart, building, opChannel, accessWay);
		res = validPacks.size();
		return JsonApiResult.ofSuccessResult(res);
	}

	/**
	 * 预览订单。 在购物车里勾选
	 *
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/preview")
	public JsonApiResult preview(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute preview");
		JSONObject jsonData = JSONObject.parseObject(data);
		final String building = jsonData.getString("building");
		String tbsId = jsonData.getString("tbsId");
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		List<RequestPack> requestPacks = JSON.parseArray(jsonData.getString("packs"), RequestPack.class);
		MemberVO member = memberQueryService.getById(MemberConstant.DEFAULT_MEMBER_ID);
		CartVO cartVo = null;
		if (CollectionUtils.isNotEmpty(requestPacks)) {

			List<Long> packIds = Lists.newArrayList();
			List<RequestPack> noIdPacks = Lists.newArrayList();
			for (RequestPack requestPack : requestPacks) {

				if (NumberUtil.isNullOrZero(requestPack.getId())) {
					noIdPacks.add(requestPack);
				} else {
					packIds.add(requestPack.getId());
				}
			}

			List<TempCartProductPack> packsToUse = Lists.newArrayList();
			if (CollectionUtils.isNotEmpty(packIds)) {
				packsToUse = tempCartService.getPacksByIds(building, tbsId, packIds, accessWay, code);
				TempCartPackCondition condition = new TempCartPackCondition();
				condition.setSource(CartPackSourceEnum.ADDIBLE);
				List<TempCartProductPack> cheapenOtherPacks = new ArrayList<>();
				if (StringUtil.isNotBlank(tbsId)) {
					condition.setTbsId(tbsId);
					cheapenOtherPacks = tempCartService.findByCondition(condition, accessWay, opChannel.getCode());
				} else if (CollectionUtils.isEmpty(cheapenOtherPacks) && StringUtil.isNotBlank(building)) {
					condition.setBinding(building);
					cheapenOtherPacks = tempCartService.findByCondition(condition, accessWay, opChannel.getCode());
				}
				if (CollectionUtils.isNotEmpty(cheapenOtherPacks)) {
					packsToUse.addAll(cheapenOtherPacks);
				}
			}
			if (CollectionUtils.isNotEmpty(noIdPacks)) {
				List<TempCartProductPack> prodPacks = cartProductPackAdapter
						.setProdAndSpv2TempCartProductPack(noIdPacks, accessWay, code);
				packsToUse.addAll(prodPacks);
			}
			cartProductPackAdapter.syncPrice2ProductPack(packsToUse);
			// cartVo = tempCartAdaptor.preview(packsToUse, building, opChannel,
			// accessWay);

			// String ISNEWPRODUCTPRICE =
			// PropConstants.getProperties("ISNEWPRODUCTPRICE");//
			//
			// if (ISNEWPRODUCTPRICE.equals("true")) {
			cartVo = cartPriceAdapter.previewCartPrice(packsToUse, member, opChannel, accessWay);

			// } else {
			// cartVo = cartPreviewAdapter.previewCart(packsToUse, member,
			// opChannel, accessWay);
			// }

		}
		return JsonApiResult.ofSuccessResult(cartVo);
	}

	/**
	 * 合并购物车
	 *
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/mergercart")
	public JsonApiResult mergerCart(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute mergercart");
		JSONObject jsonData = JSONObject.parseObject(data);
		final String building = jsonData.getString("building");
		String tbsId = jsonData.getString("tbsId");
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		Long memberId = jsonData.getLong("memberId");

		TempCart tempCart = tempCartService.getByBinding(building, tbsId, accessWay, code);

		if ((StringUtils.isNotBlank(building) || StringUtils.isNotBlank(tbsId)) && null != memberId) {
			// 得到prodcut
			List<TempCartProductPack> packs = tempCart.getProductPacks();
			// 会员
			MemberVO member = memberQueryService.getById(memberId);
			// 转换
			List<CartProductPack> cartProductPacks = getCartsByTempCart(packs);

			// 调用 添加购物车信息
			cartService.addPacks(member, cartProductPacks, accessWay, code);
			// 清楚购物车
			if (StringUtils.isNotBlank(tbsId)) {
				tempCartService.removeByTbsId(tbsId);
			}
			if (StringUtils.isNotBlank(building)) {
				tempCartService.removeByBinding(building);
			}
		}
		return JsonApiResult.ofSuccessResult(true);
	}

	/**
	 * 通过临时的购物车商品 转为 会员的购物车商品
	 *
	 * @return
	 */
	private List<CartProductPack> getCartsByTempCart(List<TempCartProductPack> tempCartProductPacks) {
		List<CartProductPack> cartProductPacks = new ArrayList<>();
		for (TempCartProductPack tempCartProductPack : tempCartProductPacks) {
			CartProductPack cartProductPack = new CartProductPack();
			cartProductPack.setCount(tempCartProductPack.getCount());
			cartProductPack.setSource(tempCartProductPack.getSource());
			cartProductPack.setProductId(tempCartProductPack.getProductId());
			cartProductPack.setSpvId(tempCartProductPack.getSpvId());
			cartProductPack.setValid(tempCartProductPack.isValid());
			cartProductPack.setCustomize(tempCartProductPack.isCustomize());
			cartProductPack.setCustomizeList(tempCartProductPack.getCustomizeList());
			cartProductPack.setCreateTime(tempCartProductPack.getCreateTime());
			cartProductPacks.add(cartProductPack);
		}
		return cartProductPacks;
	}
}
