package com.thebeastshop.pegasus.channelservice.controller.cart;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.cart.Cart;
import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.req.CartPackCondition;
import com.thebeastshop.cart.resp.CartCustomization;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.service.CartService;
import com.thebeastshop.cart.vo.CartPacksTransferDTO;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartPriceAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.IposPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.interest.InterestAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.ipos.IposAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.price.IposPriceAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.IposSpvAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.cart.CartVO;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.customize.UserSingleCustomization;
import com.thebeastshop.support.vo.stock.SpvStockVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 *
 * @author Paul-xiong
 *
 */
@Controller("CartController")
@RequestMapping("/api/cart")
@ResponseBody
public class CartController {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private MemberQueryService memberQueryService;

	@Autowired
	private CartService cartService;

	@Autowired
	private McPsSpvService mcPsSpvService;

	@Autowired
	private CartAdapter cartAdaptor;

	@Autowired
	private CartPriceAdapter cartPriceAdapter;

	@Autowired
	private InterestAdapter interestAdapter;

	@Autowired
	private CartProductPackAdapter cartProductPackAdapter;
	@Autowired
	private McOpChannelService mcOpChannelService;
	
	@Autowired
	private IposPackAdapter iposPackAdapter;
	
	@Autowired
	private IposAdapter iposAdapter;
	
	@Autowired
	private IposSpvAdapter iposSpvAdapter;
	
	
	@Autowired
	private IposPriceAdapter iposPriceAdapter;
	
	// ============private================
	private CartProductPack getCartProudct(List<CartProductPack> packs, Long packId) {
		for (CartProductPack pack : packs) {
			if (pack.getId().equals(packId)) {
				return pack;
			}
		}
		return null;
	}

	// ============华丽丽的分割线================

	/**
	 * 移到(收藏夹)
	 *
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/transfer")
	public JsonApiResult transfer(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute transfer");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		CartPacksTransferDTO transfer = jsonData.getObject("transfer", CartPacksTransferDTO.class);
		transfer.setOwnerId(memberId);
		ServiceResp resp = cartService.transfer(transfer);
		if (resp.isSuccess()) {
			return JsonApiResult.ofSuccessResult(true);
		} else {
			return JsonApiResult.ofErrorResult(400, resp.getRespMsg());
		}
	}

	/**
	 * 获取购物车
	 *
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "")
	public JsonApiResult getCart(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute getCart");
		Date start = new Date();
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		MemberVO member = memberQueryService.getById(memberId);
		CartVO cartGroupsVO = new CartVO();
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);

		final Cart cart = cartService.getByOwner(member, accessWay, code);
//		String ISNEWPRODUCTPRICE = PropConstants.getProperties("ISNEWPRODUCTPRICE");//
//
//		if (ISNEWPRODUCTPRICE.equals("true")) {
			cartGroupsVO = cartPriceAdapter.getCart(cart, member, opChannel, accessWay);

		// } else {
		// cartGroupsVO = cartNewAdapter.getCartVO(cart, member, opChannel,
		// accessWay);
		// }

		Date end = new Date();
		logger.info("方法getCart花费时间：{}毫秒", end.getTime() - start.getTime());
		return JsonApiResult.ofSuccessResult(cartGroupsVO);
	}

	/**
	 * 获取正式迷你购物车
	 *
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/getMiniCart")
	public JsonApiResult getMiniCart(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute getMiniCart");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		MemberVO member = memberQueryService.getById(memberId);
		final Cart cart = cartService.getByOwner(member, accessWay, code);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		CartVO cartVo = new CartVO();

//		String ISNEWPRODUCTPRICE = PropConstants.getProperties("ISNEWPRODUCTPRICE");//
//
//		if (ISNEWPRODUCTPRICE.equals("true")) {
			cartVo = cartPriceAdapter.getMiniCart(cart, member, opChannel, accessWay);
		// } else {
		// cartVo = miniCartAdaptor.getCart(cart, member, opChannel, accessWay);
		// }
		return JsonApiResult.ofSuccessResult(cartVo);
	}

	/**
	 * 加入购物车
	 *
	 * @param code
	 * @param data
	 */
	@ApiAuth
	@RequestMapping(value = "/addPacks")
	public JsonApiResult addPack(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute addPacks");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		MemberVO member = memberQueryService.getById(memberId);
		List<RequestPack> addPacks = JSON.parseArray(jsonData.getString("packs"), RequestPack.class);
		List<CartProductPack> packs = Lists.newArrayList();
		for (RequestPack packVo : addPacks) {
			if (packVo != null && packVo.getSpvId() != null) {
				PsSpvVO spv = mcPsSpvService.findBySpvId(packVo.getSpvId());

				if (spv == null) {
					logger.info("spv 为Null,spvId:" + packVo.getSpvId());
				}

				CartProductPack pack = new CartProductPack();
				pack.setCount(packVo.getCount() == 0 ? 1 : packVo.getCount());
				pack.setSource(CartPackSourceEnum.getEnumByCode(packVo.getSource().getId()));
				pack.setProductId(spv.getProductId());
				pack.setSpvId(spv.getSpvId());
				pack.setCreateTime(new Date());
				if (CollectionUtils.isNotEmpty(packVo.getCustomizes())) {
					pack.setCustomize(Boolean.TRUE);
					List<CartCustomization> cartCustomizes = Lists.newArrayList();
					for (UserSingleCustomization userCustomize : packVo.getCustomizes()) {
						CartCustomization cartCustom = new CartCustomization();
						cartCustom.setCustomDimensionId(userCustomize.getCode());
						cartCustom.setCustomDimensionName(userCustomize.getName());
						cartCustom.setCustomDimensionValue(userCustomize.getValue());
						cartCustomizes.add(cartCustom);
					}
					pack.setCustomizeList(cartCustomizes);
				}
				packs.add(pack);
			}
		}
		List<CartProductPack> rtPacks = cartService.addPacks(member, packs, accessWay, code);
		List<Long> packIds = Lists.newArrayList();
		if(CollectionUtils.isNotEmpty(rtPacks)){
			for (CartProductPack rtPack : rtPacks) {
				packIds.add(rtPack.getId());
			}
		}
		return JsonApiResult.ofSuccessResult(packIds);
	}

	/**
	 * 编辑购物车商品
	 *
	 * @param code
	 * @param data
	 */
	@ApiAuth
	@RequestMapping(value = "/editPacks")
	public JsonApiResult modifyPack(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute editPacks");
		Date start = new Date();
		// ==============解析数据=============
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		MemberVO member = memberQueryService.getById(memberId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		List<RequestPack> editPacks = JSON.parseArray(jsonData.getString("packs"), RequestPack.class);
		// =============业务逻辑=============
		List<CartProductPackVO> packsAll = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(editPacks)) {
			List<Long> needToEditIds = Lists.newArrayListWithExpectedSize(editPacks.size());
			for (RequestPack editPackVO : editPacks) {
				needToEditIds.add(editPackVO.getId());
			}
			List<CartProductPack> needToEdit = cartService.getPacksByIds(member, needToEditIds, accessWay, code);
			for (RequestPack editPackVO : editPacks) {
				CartProductPack edit = getCartProudct(needToEdit, editPackVO.getId());
				if (edit != null) {
					// 修改权益商品规格
					if (CartPackSourceEnum.BENEFIT.equals(edit.getSource())) {
						interestAdapter.updInterestSku(memberId, edit.getSourceBindVal(), edit.getSpvId(),
								editPackVO.getSpvId());
					}
					if (editPackVO.getCount() > 0) {
						edit.setCount(editPackVO.getCount());
					}
					if (editPackVO.getSpvId() != null) {
						edit.setSpvId(editPackVO.getSpvId());
					}
				}
			}
			List<CartProductPack> cartProductPacks = cartService.modifyPack(needToEdit, member, accessWay, code);
			if (CollectionUtils.isNotEmpty(cartProductPacks)) {
//
//				String ISNEWPRODUCTPRICE = PropConstants.getProperties("ISNEWPRODUCTPRICE");//
//
//				if (ISNEWPRODUCTPRICE.equals("true")) {
					packsAll.addAll(cartPriceAdapter.getModityPacks(cartProductPacks, member, opChannel, accessWay));

				// } else {
				// packsAll.addAll(cartAdaptor.getModityPacks(cartProductPacks,
				// member, opChannel, accessWay));
				// }

			}
		}
		Date end = new Date();
		logger.info("方法editPacks花费时间：{}毫秒", end.getTime() - start.getTime());
		return JsonApiResult.ofSuccessResult(packsAll);
	}

	/**
	 * 删除商品包
	 *
	 * @param code
	 * @param data
	 */
	@ApiAuth
	@RequestMapping(value = "/deletePacks")
	public JsonApiResult delPacks(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute deletePacks");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		MemberVO member = memberQueryService.getById(memberId);
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		List<Long> packIds = JSON.parseArray(jsonData.getString("packIds"), Long.class);
		if (CollectionUtils.isNotEmpty(packIds)) {
			Cart cart = cartService.getByOwner(member, accessWay, code);
			packIds = cartAdaptor.getDelPackIds(cart, packIds);
			cartService.removePacksById(member, packIds);
		}
		return JsonApiResult.ofSuccessResult(true);
	}

	/**
	 * 清空失效商品
	 *
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/clearInvalidPacks")
	public JsonApiResult clearInvalid(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute clearInvalidPacks");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		MemberVO member = memberQueryService.getById(memberId);
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		final Cart cart = cartService.getByOwner(member, accessWay, code);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		List<CartProductPack> invalidPacks = cartAdaptor.getInvalidPack(cart, member, opChannel, accessWay);
		cartService.removePacks(member, invalidPacks);
		return JsonApiResult.ofSuccessResult(true);
	}

	@ApiAuth
	@RequestMapping(value = "/count")
	public JsonApiResult count(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute count");
		int res = 0;
		JSONObject jsonData = JSONObject.parseObject(data);
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		Long memberId = jsonData.getLong("memberId");
		MemberVO member = null;
		if (memberId != null) {
			member = memberQueryService.getById(memberId);
		}
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		Cart cart = cartService.getByOwner(member, accessWay, code);
		List<CartProductPack> validPacks = cartAdaptor.getValidPack(cart, member, opChannel, accessWay);
		res = validPacks.size();
		return JsonApiResult.ofSuccessResult(res);
	}

	/**
	 * 预览订单。 在购物车里勾选
	 *
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/preview")
	public JsonApiResult preview(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("execute preview");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		MemberVO member = memberQueryService.getById(memberId);
		// 使用礼品卡则不能进行会员打折,则把当前会员等级暂时变成普通会员
		if (jsonData.getBoolean("useGiftCard") != null && jsonData.getBoolean("useGiftCard")) {
			member.setMemberLevel(MemberLevelEnum.NORMAL.getCode());
		}
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		List<RequestPack> requestPacks = JSON.parseArray(jsonData.getString("packs"), RequestPack.class);
		CartVO cartVo = null;
		if (CollectionUtils.isNotEmpty(requestPacks)) {
			List<Long> packIds = Lists.newArrayList();
			List<RequestPack> noIdPacks = Lists.newArrayList();
			for (RequestPack requestPack : requestPacks) {
				if (NumberUtil.isNullOrZero(requestPack.getId())) {
					noIdPacks.add(requestPack);
				} else {
					packIds.add(requestPack.getId());
				}
			}
			List<CartProductPack> packsToUse = Lists.newArrayList();
			if (CollectionUtils.isNotEmpty(packIds)) {
				packsToUse = cartService.getPacksByIds(member, packIds, accessWay, code);
			}
			if (CollectionUtils.isNotEmpty(noIdPacks)) {
				List<CartProductPack> prodPacks = cartProductPackAdapter.setProdAndSpv2CartProductPack(noIdPacks,
						accessWay, member, code);
				packsToUse.addAll(prodPacks);
			}
			cartProductPackAdapter.syncPrice2ProductPack(packsToUse);
			if (CollectionUtils.isNotEmpty(packIds)) {
				CartPackCondition condition = new CartPackCondition();
				condition.setOwnerId(memberId);
				condition.setSource(CartPackSourceEnum.ADDIBLE);
				List<CartProductPack> cheapenOtherPacks = cartService.findByCondition(condition, accessWay, member,
						code); // 加价购商品包
				if (CollectionUtils.isNotEmpty(cheapenOtherPacks)) {
					packsToUse.addAll(cheapenOtherPacks);
				}
			}
			cartVo = cartPriceAdapter.previewCartPrice(packsToUse, member, opChannel, accessWay);
		}
		return JsonApiResult.ofSuccessResult(cartVo);
	}
	
	/**
	 * IPOS 购物车预览
	 * @Methods Name iposPreview
	 * @Create In 2018-12-26 By Xiang.Gao
	 * @return JsonApiResult
	 */
	@ApiAuth
	@RequestMapping(value = "/iposPreview", method = RequestMethod.POST)
	@ResponseBody
	public JsonApiResult iposPreview(@RequestParam("CODE") final String code, @RequestBody final String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		List<RequestPack> packs = JSON.parseArray(jsonData.getString("packs"), RequestPack.class);
		if (CollectionUtils.isEmpty(packs)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), "请选择商品");
		}
		
		Long memberId = jsonData.getLong("memberId");
		memberId = memberId == null ? 1L : memberId;
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		MemberVO member = memberQueryService.getById(memberId);
		
		List<CartProductPack> packsToUse = iposPackAdapter.setProdAndSpvCartPack(packs, accessWay, member, opChannel.getCode());
		CartVO cart = iposAdapter.cartPreview(packsToUse, member, opChannel, accessWay);
		return JsonApiResult.ofSuccessResult(cart);
	}
	
	/**
	 * 购物车查询 spv库存
	 * @Methods Name getSpvStock
	 * @Create In 2019-1-2 By Xiang.Gao
	 * @return JsonApiResult
	 */
	@RequestMapping("/spvStock")
	@ResponseBody
	public JsonApiResult getSpvStock(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long spvId = jsonData.getLong("spvId");
		
		SpvStockVO spvStock = new SpvStockVO();
		spvStock.setSpvId(spvId);
		List<PsSpvVO> list = mcPsSpvService.findBySpvIdsWithStock(Lists.newArrayList(spvId), code);
		if (CollectionUtils.isEmpty(list)) {
			return JsonApiResult.ofSuccessResult(spvStock);
		}
		PsSpvVO psSpvVO = list.get(0);
		if (psSpvVO.isJit()) {
			spvStock.setStoreCount(Integer.MAX_VALUE);
			spvStock.setWarehouseCount(Integer.MAX_VALUE);
			return JsonApiResult.ofSuccessResult(spvStock);
		} 
		
		int storeCount = 0;
		if (psSpvVO.getPsStockVO() != null && psSpvVO.getPsStockVO().getCanUseQuantity() != null) {
			storeCount = psSpvVO.getPsStockVO().getCanUseQuantity();
		}
		int warehouseCount = 0;
		if (psSpvVO.getPsFurnitureStockVO() != null) {
			warehouseCount += psSpvVO.getPsFurnitureStockVO().getCanUseQuantity();
		}
		if (psSpvVO.getPsPresaleSaleStockVO() != null) {
			warehouseCount += psSpvVO.getPsPresaleSaleStockVO().getAvailQuantity();
		}
		// 抢购库存
		PsCampaignVO rushCamp = iposSpvAdapter.getRushCamp(psSpvVO);
		// 价格折扣限量
		PsCampaignVO limitCamp = iposSpvAdapter.getPriceLimitCamp(psSpvVO);
		if (rushCamp != null) {
			Integer rushStock = iposPriceAdapter.getPanicLeftAmount(rushCamp.getCode(), "", psSpvVO);
			if(rushStock <= warehouseCount){
        		warehouseCount = rushStock;
			}
			if(rushStock <= storeCount){
				storeCount = rushStock;
			}
		} else if (limitCamp != null) {
			Integer limitStock = iposPriceAdapter.getPriceLeftAmount(limitCamp.getCode(), psSpvVO);
			if(limitStock <= warehouseCount){
        		warehouseCount = limitStock;
			}
			if(limitStock <= storeCount){
				storeCount = limitStock;
			}
		}
		
		spvStock.setStoreCount(storeCount);
		spvStock.setWarehouseCount(warehouseCount);
		logger.info("spv:{} stock:{}", spvId, spvStock.toString());
		return JsonApiResult.ofSuccessResult(spvStock);
	}

}
