package com.thebeastshop.pegasus.channelservice.controller.card;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.vo.CardVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 卡的控制
 * create by com.thebeastshop.pegasus.channelservice.controller.card trunk :author lijing
 * User:lijing
 * DATE : 2016/11/22
 * TIME : 15:08
 * trunk.
 */
@Controller
@RequestMapping(value = "/api/card")
@ResponseBody
public class CardController {
    private static Logger logger = LoggerFactory.getLogger(CardController.class);

    private PegasusOperationServiceFacade pcInstance=PegasusOperationServiceFacade.getInstance();

    /**
     * 判断此会员是否有免邮卡
     * @param code
     * @param data
     * @return
     */
    @ApiAuth
    @RequestMapping(value = "/ifMemberValidFreePostageCard")
    @ResponseBody
    public JsonApiResult ifMemberValidFreePostageCard(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
        logger.info("判断用户有没有免邮卡 参数  code={},data={}",code,data);
        try {
            JSONObject jsonData = JSONObject.parseObject(data);
            String memberCode = jsonData.getString("memberCode");
            if(StringUtils.isBlank(memberCode)){
                return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),ErrorCode.PARAMS_ILLEGAL.getMesage());
            }
            CardVO cardVO = pcInstance.ifMemberOwnFreePostage(memberCode);
            if(null != cardVO && cardVO.getCardId() != null){
                return JsonApiResult.ofSuccessResult(cardVO);
            }else{
                return JsonApiResult.ofErrorResult(1001, "此人没有预售卡!");
            }
        }catch (Exception e){
            logger.error("系统错误    e={}", e);
            return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(),ErrorCode.DEFAULT_EXCEPTION.getMesage());
        }
    }
}
