package com.thebeastshop.pegasus.channelservice.controller.brand;

import java.util.List;

import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.component.brand.domain.BrandCond;
import com.thebeastshop.pegasus.component.brand.service.BrandService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.support.vo.brand.BrandVo;

@Controller
@RequestMapping(value = "/api/brand")
public class BrandControllor {

	protected BrandService service = ComponentServiceLoader.getBean(BrandService.class);

	/**
	 * 获取品牌页
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/getBrandById", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getBrand(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Integer brandId = jsonData.getInteger("brandId");
		BrandCond cond = new BrandCond();
		cond.setBrandId(brandId);
		List<BrandCond> brands = service.findBrandListByCond(cond);

		BrandVo brandVo = new BrandVo();
		if (null != brands && brands.size() > 0) {
			BrandCond brand = brands.get(0);
			brandVo = convertBrandDetails(brand);
		}
		return JsonApiResult.ofSuccessResult(brandVo);
	}

	/**
	 * 转换vo对象
	 * 
	 * @return
	 */
	public BrandVo convertBrandDetails(BrandCond cond) {
		BrandVo brandVO = new BrandVo();
		if (null != cond) {
			brandVO.setId(cond.getBrandId());
			brandVO.setModules(cond.getModules());
			brandVO.setName(cond.getNameCN()); // 用品牌中文名
		}
		return brandVO;
	}

}
