package com.thebeastshop.pegasus.channelservice.controller.benefit;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.service.Benefit.BenefitQueryService;
import com.thebeastshop.pegasus.channelservice.service.Benefit.BenefitRedeemService;
import com.thebeastshop.support.page.Page;
import com.thebeastshop.support.vo.benefit.BenefitVO;
import com.thebeastshop.support.vo.benefit.MyBenefitVO;
import com.thebeastshop.support.vo.benefit.RedeemDetailVO;
import com.thebeastshop.support.vo.benefit.ReminderVO;
import com.thebeastshop.support.vo.benefit.VipBenefitVO;

@Controller
@RequestMapping("/api/app/benefit")
public class BenefitController {
    private Logger logger = LoggerFactory.getLogger(BenefitController.class);


    @Autowired
    private MemberQueryService memberQueryService;
    @Autowired
    private BenefitQueryService benefitQueryService;
    @Autowired
    private BenefitRedeemService benefitRedeemService;


    /**
     * 获取我的特权提示信息
     *
     * @param code
     * @param data
     * @return
     */
    @ApiAuth
    @RequestMapping(path = "/getMyBenefit")
    @ResponseBody
    public JsonApiResult getMyBenefit(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
        JSONObject jsonData = JSONObject.parseObject(data);
        Integer accessWay = jsonData.getInteger("accessWay");
        Long memberId = jsonData.getLong("memberId");
        MemberVO member = memberQueryService.getById(memberId);
        MyBenefitVO result = new MyBenefitVO();
        //1、查询会员当前等级的等级特权
        List<BenefitVO> vipBenefits = benefitQueryService.getVIPPrivilegeByLevel(member.getMemberLevel());
        result.setVipBenefits(vipBenefits);
        //2、获取会员的提示特权
        List<ReminderVO> reminders = benefitQueryService.getBenefitReminders(member);
        result.setReminders(reminders);
        //3、获取会员的福利信息 默认第一页 6条 方便前端判断是否跳转福列表页
        Page<BenefitVO> page = benefitQueryService.queryRecordList(member, 0, 6);
        result.setBenefits(Lists.newArrayList(page.getItems()));
        return JsonApiResult.ofSuccessResult(result);
    }

    /**
     * 获取特权详情
     *
     * @param code
     * @param data
     * @return
     */
    @ApiAuth
    @RequestMapping(path = "/getBenefitDetail")
    @ResponseBody
    public JsonApiResult getBenefitDetail(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
        JSONObject jsonData = JSONObject.parseObject(data);
        Long memberId = jsonData.getLong("memberId");
        Integer benefitId = jsonData.getInteger("benefitId");
        MemberVO member = memberQueryService.getById(memberId);
        BenefitVO benefitVO = benefitQueryService.getBenefitDetails(member, benefitId);
        return JsonApiResult.ofSuccessResult(benefitVO);
    }

    /**
     * 获取所有VIP特权
     *
     * @param code
     * @param data
     * @return
     */
    @RequestMapping(path = "/getAllVipBenefit")
    @ResponseBody
    public JsonApiResult getAllVipBenefit(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
        List<VipBenefitVO> list = benefitQueryService.getAllVIPPrivilege();
        return JsonApiResult.ofSuccessResult(list);
    }

    /**
     * 领取特权
     *
     * @param code
     * @param data
     * @return
     */
    @ApiAuth
    @RequestMapping(path = "/redeemBenefit")
    @ResponseBody
    public JsonApiResult redeemBenefit(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
        JSONObject jsonData = JSONObject.parseObject(data);
        Long memberId = jsonData.getLong("memberId");
        Integer benefitId = jsonData.getInteger("benefitId");
        MemberVO member = memberQueryService.getById(memberId);
        RedeemDetailVO redeemDetailVO = benefitRedeemService.redeemPrivilegeById(member, benefitId);
        return JsonApiResult.ofSuccessResult(redeemDetailVO);
    }

    /**
     * 查询特权记录列表
     *
     * @param code
     * @param data
     * @return
     */
    @ApiAuth
    @RequestMapping(path = "/queryRecordList")
    @ResponseBody
    public JsonApiResult queryRecordList(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
        JSONObject jsonData = JSONObject.parseObject(data);
        Integer accessWay = jsonData.getInteger("accessWay");
        Long memberId = jsonData.getLong("memberId");
        Integer offset = jsonData.getInteger("offset");
        Integer limit = jsonData.getInteger("limit");
        MemberVO member = memberQueryService.getById(memberId);
        Page<BenefitVO> page = benefitQueryService.queryRecordList(member, offset, limit);
        return JsonApiResult.ofSuccessResult(page);
    }
}
