package com.thebeastshop.pegasus.channelservice.controller.beastLesson;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.support.vo.exchange.ExchangeGroupVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by GFL on 2019/3/7.
 */
@RestController
@RequestMapping("api/lesson")
public class LessonController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 线下收银购物车预览，目前只有source.RAW商品
     *
     * @param code
     * @param data
     * @return
     */
    @ApiAuth
    @RequestMapping(value = "/course/detail")
    public JsonApiResult getCourseDetail(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {

        logger.info("getGoodsList 入参：code={} data={}");
        ExchangeGroupVO result = new ExchangeGroupVO();
        JSONObject jsonData = JSONObject.parseObject(data);
        Integer accessWayId = jsonData.getInteger("accessWay");
        String status = jsonData.getString("status");
        return JsonApiResult.ofSuccessResult(null);
    }

}
