package com.thebeastshop.pegasus.channelservice.controller.article;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.campaign.service.CampaignQueryService;
import com.thebeastshop.campaign.vo.CampaignVO;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.product.ProductAdapter;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.support.enums.CampaignState;
import com.thebeastshop.support.vo.article.SimpleCampagin;
import com.thebeastshop.support.vo.product.SimpleProductVO;

@Controller
@RequestMapping(value = "/api/campaign")
@ResponseBody
public class CampaignController {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ProductAdapter productAdapter;

	@Autowired
	private MemberQueryService memberQueryService;

	@Autowired
	private McOpChannelService mcOpChannelService;

	@Autowired
	private CampaignQueryService campaignQueryService;

	@Autowired
	private McPsProductService mcPsProductService;

	/**
	 * 获取商品的简要信息
	 *
	 * @param
	 * @param
	 * @param
	 * @return
	 */

	@RequestMapping(path = "/listCampaignProducts")
	@ResponseStatus(HttpStatus.OK)

	@ResponseBody
	public JsonApiResult listSimpleProducts(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		List<String> codes = JSON.parseArray(jsonData.getString("codes"), String.class);
		Long memberId = jsonData.getLong("memberId");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));

		List<SimpleCampagin> simpleCampagins = new ArrayList<SimpleCampagin>();
		List<SimpleCampagin> result = new ArrayList<SimpleCampagin>();

		MemberVO member = memberQueryService.getById(memberId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);

		MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
		PsMatchCampaignCond cond = new PsMatchCampaignCond();
		cond.setChannelCode(code);
		cond.setMatchCampaign(true);
		cond.setAccessWay(accessWay.getCode());
		cond.setMemberLevel(memberLevel.getCode());
		cond.setDiscount(memberLevel.getLevelAmountCondition());
		cond.setBdDiscount(member.getBdayDiscountRatio());

		List<CampaignVO> camps = campaignQueryService.checkoutPanicBuyCampaigns(codes);
		if (CollectionUtils.isNotEmpty(camps)) {
			logger.info("从李蒙处取库存个数为 size={}", camps);
			List<String> skuCodes = new ArrayList<String>();
			List<String> prodCodes = new ArrayList<String>();
			for (CampaignVO camp : camps) {
				if (CollectionUtils.isNotEmpty(camp.getSkuCodes())) {

					skuCodes.addAll(camp.getSkuCodes());
				}
			}
			if (CollectionUtils.isNotEmpty(skuCodes)) {

				Map<String, PsProductVO> mapProduct = mcPsProductService.mapProductBySkuCodes(skuCodes);

				if (!mapProduct.isEmpty()) {
					Map<String, String> mapCodes = new HashMap<String, String>();

					for (Map.Entry<String, PsProductVO> entry : mapProduct.entrySet()) {
						prodCodes.add(entry.getValue().getCode());
						mapCodes.put(entry.getKey(), entry.getValue().getCode());
					}
					// 所有商品
					List<PsProductVO> products = mcPsProductService.findTopicByCodes(code, prodCodes, cond, 1,
							prodCodes.size());
					List<SimpleProductVO> simpleProducts = new ArrayList<SimpleProductVO>();
					if (CollectionUtils.isNotEmpty(products)) {
						simpleProducts = productAdapter.getSimpleProducts(products, member, opChannel, accessWay);
					}
					if (CollectionUtils.isNotEmpty(simpleProducts)) {
						for (CampaignVO camp : camps) {
							SimpleCampagin simpleCampagin = new SimpleCampagin();
							simpleCampagin.setCode(camp.getCode());
							simpleCampagin.setName(camp.getName());
							// 时间显示
							Date startTime = camp.getStartTime();

							simpleCampagin.setStart(startTime);

							Calendar cal = Calendar.getInstance();
							cal.setTime(startTime);
							cal.get(Calendar.MONTH); // 注意月份是从0开始的,比如当前7月，获得的month为6

							Date now = new Date();
							String time = "";
							Calendar calendar1 = Calendar.getInstance();
							calendar1.setTime(new Date());
							calendar1.set(Calendar.HOUR_OF_DAY, 0);
							calendar1.set(Calendar.MINUTE, 0);
							calendar1.set(Calendar.SECOND, 0);
							Date today = calendar1.getTime();// 今天0点
							Calendar calendar2 = Calendar.getInstance();
							calendar2.setTime(new Date());
							calendar2.add(Calendar.DATE, 1);
							calendar2.set(Calendar.HOUR_OF_DAY, 0);
							calendar2.set(Calendar.MINUTE, 0);
							calendar2.set(Calendar.SECOND, 0);
							Date tomorrow = calendar2.getTime();// 明天0点
							Calendar calendar3 = Calendar.getInstance();
							calendar3.setTime(new Date());
							calendar3.add(Calendar.DATE, 2);
							calendar3.set(Calendar.HOUR_OF_DAY, 0);
							calendar3.set(Calendar.MINUTE, 0);
							calendar3.set(Calendar.SECOND, 0);
							Date thedayaftertomorrow = calendar3.getTime();// 后天0点
							Calendar calendar4 = Calendar.getInstance();
							calendar4.setTime(new Date());
							calendar4.add(Calendar.DATE, 1);
							calendar4.set(Calendar.HOUR_OF_DAY, 23);
							calendar4.set(Calendar.MINUTE, 59);
							calendar4.set(Calendar.SECOND, 59);
							Date tomorrowend = calendar4.getTime();// 明天23点59分59秒
							Calendar calendar5 = Calendar.getInstance();
							calendar5.setTime(new Date());
							calendar5.set(Calendar.HOUR_OF_DAY, 23);
							calendar5.set(Calendar.MINUTE, 59);
							calendar5.set(Calendar.SECOND, 59);
							Date todayend = calendar5.getTime();// 今天23点59分59秒
							if (startTime.before(today) || startTime.after(tomorrowend)) {
								time = time + cal.get(Calendar.DAY_OF_MONTH) + "日";
							} else if (startTime.after(todayend) && startTime.before(thedayaftertomorrow)) {
								time = time + "明日";
							}

							time = time + "" + cal.get(Calendar.HOUR_OF_DAY);
							String min = cal.get(Calendar.MINUTE) + "";
							if (min.length() > 1) {
								time = time + ":" + min;
							} else {
								time = time + ":0" + min;
							}

							simpleCampagin.setStartTime(time);

							simpleCampagin.setState(CampaignState.ING);
							if (startTime.after(now)) {
								simpleCampagin.setState(CampaignState.SOON);
							} else if (camp.getExpireTime().before(now)) {
								simpleCampagin.setState(CampaignState.DONE);
							}

							if (CollectionUtils.isNotEmpty(camp.getSkuCodes())) {
								List<SimpleProductVO> simples = new ArrayList<SimpleProductVO>();
								List<String> skus = camp.getSkuCodes();
								Map<String, String> prodMap = new HashMap<String, String>();
								for (String sku : skus) {
									for (SimpleProductVO simpleProduct : simpleProducts) {
										if (simpleProduct.getId().equals(mapCodes.get(sku))) {
											if (prodMap.containsKey(simpleProduct.getId())) {
												break;
											} else {

												String image = simpleProduct.getFeatureImage();
												if (!image.contains("@")) {
													simpleProduct
															.setFeatureImage(image + "@4e_0o_0l_345h_330w_90q.jpg");
												}
												simples.add(simpleProduct);
												prodMap.put(simpleProduct.getId(), sku);
												break;
											}
										}
									}
								}

								// 下架删除
								if (CollectionUtils.isNotEmpty(simples)) {
									Iterator<SimpleProductVO> iterator = simples.iterator();
									while (iterator.hasNext()) {
										SimpleProductVO vo = iterator.next();
										if (vo.getOffShelf()) {
											iterator.remove();
										}
									}

								}

								// 售罄沉底
								Collections.sort(simples, new Comparator<SimpleProductVO>() {
									@Override
									public int compare(SimpleProductVO o1, SimpleProductVO o2) {
										int a = o1.getSoldOut() ? 1 : 0;
										int b = o2.getSoldOut() ? 1 : 0;
										return (a - b);
									}
								});
								simpleCampagin.setProducts(simples);
							}
							simpleCampagins.add(simpleCampagin);

						}

						// 没有商品的模块 删除

						if (CollectionUtils.isNotEmpty(simpleCampagins)) {
							Iterator<SimpleCampagin> iterator = simpleCampagins.iterator();
							while (iterator.hasNext()) {
								SimpleCampagin vo = iterator.next();
								if (null == vo.getProducts() || CollectionUtils.isEmpty(vo.getProducts())) {
									iterator.remove();
								}
							}

						}
						// 排序
						Collections.sort(simpleCampagins, new Comparator<SimpleCampagin>() {
							@Override
							public int compare(SimpleCampagin o1, SimpleCampagin o2) {
								return (o1.getStart().compareTo(o2.getStart()));
							}
						});
						// 区分现在和已开始状态
						for (int i = 0; i < simpleCampagins.size(); i++) {

							SimpleCampagin re = simpleCampagins.get(i);
							if (i < simpleCampagins.size() - 1) {
								SimpleCampagin next = simpleCampagins.get(i + 1);
								if (re.getState().equals(CampaignState.ING)
										&& next.getState().equals(CampaignState.SOON)) {
									re.setState(CampaignState.NOW);
								}

							}
							result.add(re);
						}

					}

				}
			}

		}

		return JsonApiResult.ofSuccessResult(result);
	}
}
