package com.thebeastshop.pegasus.channelservice.controller.article;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.thebeastshop.pegasus.component.article.domain.Article;
import com.thebeastshop.pegasus.component.article.domain.ArticleCond;
import com.thebeastshop.support.vo.article.ArticleDetailsVO;
import com.thebeastshop.support.vo.article.ArticleVO;
import com.thebeastshop.support.vo.article.SimpleArticle;

import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ShopOperationConstant;
import com.thebeastshop.pegasus.component.article.service.ArticleService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;

/**
 * 已经不再使用了
 */
@Controller
@RequestMapping(value = "/api/article")
@Deprecated
public class ArticleControllor {

	protected ArticleService service = ComponentServiceLoader.getBean(ArticleService.class);

	/**
	 * 获取 article
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/getArticleById", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getProduct(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long articleId = jsonData.getLong("articleId");
		ArticleCond cond = new ArticleCond();
		cond.setArticleId(articleId.intValue());
		cond.setState(ShopOperationConstant.type.PUBLISH);
		List<ArticleCond> articles = service.findArticleListByCond(cond);
		ArticleCond article = new ArticleCond();

		ArticleDetailsVO articleVO = new ArticleDetailsVO();
		if (null != articles && articles.size() > 0) {
			article = articles.get(0);
			articleVO = convertArticleDetails(article);
		}
		return JsonApiResult.ofSuccessResult(articleVO);
	}

	/**
	 * 转换vo对象
	 * 
	 * @return
	 */
	public ArticleVO convertArticleVOByArticle(Article article) {
		ArticleVO articleVO = new ArticleVO();
		if (null != article) {
			ArticleVO.Share share = new ArticleVO.Share();
			share.setTitle(article.getShareTitle());
			share.setContent(article.getShareContent());
			share.setImage(article.getShareImage());
			share.setLink(article.getShareLink());
			articleVO.setTitle(article.getTitle());
			articleVO.setId(article.getId());
			articleVO.setModulesTemp(article.getModules());
			articleVO.setShare(share);
			articleVO.setFeatureImage(StringUtils.isNotBlank(article.getFeatureImage()) ? article.getFeatureImage() : "");
		}
		return articleVO;
	}

	/**
	 * 转换vo对象
	 * 
	 * @return
	 */
	public ArticleDetailsVO convertArticleDetails(ArticleCond article) {
		ArticleDetailsVO articleVO = new ArticleDetailsVO();
		if (null != article) {
			ArticleDetailsVO.Share share = new ArticleDetailsVO.Share();
			share.setTitle(article.getShareTitle());
			share.setContent(article.getShareContent());
			share.setImage(article.getShareImage());
			share.setLink(article.getShareLink());
			articleVO.setTitle(article.getTitle());
			articleVO.setId(article.getId());
			articleVO.setModulesTemp(article.getModules());
			articleVO.setShare(share);
			articleVO.setFeatureImage(StringUtils.isNotBlank(article.getFeatureImage()) ? article.getFeatureImage() : "");
			articleVO.setArticleId(article.getArticleId());
			articleVO.setBrief(article.getBrief());
			String typ = "NORMAL";
			if (null != article.getType() && article.getType() == 1) {
				typ = "LESSON";
			}
			articleVO.setType(typ);
			articleVO.setShopId(article.getShopId());
			articleVO.setShopIcon(article.getShopIcon());
			articleVO.setVolume(article.getVolume());
		}
		return articleVO;
	}

	/**
	 * 获取 article列表
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/getArticleList", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getArticleList(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);

		String type = jsonData.getString("type");
		String shopId = jsonData.getString("shopId");
		String sortField = jsonData.getString("sortField");
		String sortOrder = jsonData.getString("sortOrder");
		ArticleCond cond = new ArticleCond();
		if (null != shopId && !"".equals(shopId)) {
			cond.setShopId(Integer.parseInt(shopId));
		}
		int tp = 0;
		if (type != null && "LESSON".equals(type)) {
			tp = 1;
		}
		cond.setType(tp);

		if (null != sortField && !"".equals(sortField)) {
			if ("VOLUME".endsWith(sortField)) {
				cond.setOrder(1);
			}
			if ("LESSON".endsWith(sortField)) {
				cond.setOrder(2);
			}
			if ("CREATE_TIME".endsWith(sortField)) {
				cond.setOrder(3);
			}
		}
		if (null != sortOrder && !"".equals(sortOrder)) {
			if ("DESC".endsWith(sortField)) {
				cond.setOrder(1);
			}
			if ("ASC".endsWith(sortField)) {
				cond.setOrder(2);
			}
		}
		cond.setState(ShopOperationConstant.type.PUBLISH);
		List<ArticleCond> articles = service.findArticleListByCond(cond);
		List<SimpleArticle> articleVOs = new ArrayList<SimpleArticle>();
		if (null != articles && articles.size() > 0) {
			articleVOs = convertArticleList(articles);
		} else {
			articleVOs.add(new SimpleArticle());
		}
		return JsonApiResult.ofSuccessResult(articleVOs);
	}

	/**
	 * 转换list对象
	 * 
	 * @return
	 */
	public List<SimpleArticle> convertArticleList(List<ArticleCond> articles) {
		List<SimpleArticle> articleList = new ArrayList<SimpleArticle>();
		if (null != articles) {
			for (ArticleCond article : articles) {
				SimpleArticle spA = new SimpleArticle();
				spA.setBrief(article.getBrief());
				spA.setFeatureImage(StringUtils.isNotBlank(article.getFeatureImage()) ? article.getFeatureImage() : "");
				spA.setId(article.getArticleId().longValue());
				spA.setShopIcon(article.getShopIcon());
				spA.setTitle(article.getTitle());
				if (null != article.getShopId() && article.getShopId() > 0) {
					spA.setShopId(article.getShopId());
				}
				String tp = "NORMAL ";
				if (article.getType() != null && article.getType() == 1) {
					tp = "LESSON";
				}
				spA.setType(tp);
				if (null != article.getVolume() && article.getVolume() > 0) {
					spA.setVolume(article.getVolume());
				}
				articleList.add(spA);
			}

		}
		return articleList;
	}

	public ArticleService getService() {
		return service;
	}

	public void setService(ArticleService service) {
		this.service = service;
	}

	/**
	 * 根据id获取文章列表
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/getArticleListByIds", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getArticleListByIds(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);

		List<String> ids = JSON.parseArray(jsonData.getString("ids"), String.class);
		List<Integer> articleIds = Lists.newArrayList();
		List<SimpleArticle> articleVOs = new ArrayList<SimpleArticle>();
		if (null != ids && !ids.equals("")) {
			for (String id : ids) {
				Integer articleId = Integer.parseInt(id);
				if (Collections.frequency(articleIds, articleId) < 1)
					articleIds.add(articleId);
			}
			if (null != articleIds && articleIds.size() > 0) {
				List<ArticleCond> articles = service.findArticleListByids(articleIds);
				if (null != articles && articles.size() > 0) {
					articleVOs = convertArticleList(articles);
				} else {
					articleVOs.add(null);
				}
			} else {
				articleVOs.add(null);
			}
		} else {
			articleVOs.add(null);
		}
		return JsonApiResult.ofSuccessResult(articleVOs);
	}

}
