package com.thebeastshop.pegasus.channelservice.controller.area;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.commdata.service.CommAddressService;
import com.thebeastshop.commdata.vo.CommCityVO;
import com.thebeastshop.commdata.vo.CommDistrictVO;
import com.thebeastshop.commdata.vo.CommProvinceVO;
import com.thebeastshop.common.utils.BeanUtil;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.wms.sservice.SWhInfoService;
import com.thebeastshop.wms.vo.WhPhysicalWarehouseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@RequestMapping("/api/area")
@Controller("areaController")
public class AreaController {

	@Autowired
	private SWhInfoService sWhInfoService;

	@Autowired
	private CommAddressService commAddressService;

	/**
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 取得所有省份
	 */
	@ApiAuth
	@RequestMapping(value = "/provinceByCountryId")
	@ResponseBody
	public JsonApiResult provinceByCountryId(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		// 取得会员Id
		Long countryId = jsonData.getLong("countryId");
		
		List<CommProvinceVO> list = commAddressService.findProvinceByCountryId(countryId.intValue(),false);
		
		if (list!=null) {
			return JsonApiResult.ofSuccessResult(list);
		}
		return JsonApiResult.ofErrorResult(
				ErrorCode.DATA_NOT_FOUND.getCode(), ErrorCode.DATA_NOT_FOUND.getMesage());

	}
	
	/**
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 取得所有省份
	 */
	@ApiAuth
	@RequestMapping(value = "/cityByProvinceId")
	@ResponseBody
	public JsonApiResult cityByProvinceId(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		// 取得会员Id
		Long provinceId = jsonData.getLong("provinceId");
		
		List<CommCityVO> list = commAddressService.findCityByProvinceId(provinceId.intValue(),false);
		
		if (list!=null) {
			return JsonApiResult.ofSuccessResult(list);
		}
		return JsonApiResult.ofErrorResult(
				ErrorCode.DATA_NOT_FOUND.getCode(), ErrorCode.DATA_NOT_FOUND.getMesage());

	}
	
	/**
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 取得所有省份
	 */
	@ApiAuth
	@RequestMapping(value = "/districtByCityId")
	@ResponseBody
	public JsonApiResult districtByCityId(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		// 取得会员Id
		Long cityId = jsonData.getLong("cityId");
		
		List<CommDistrictVO> list = commAddressService.findDistrictByCityId(cityId.intValue());
		
		if (list!=null) {
			return JsonApiResult.ofSuccessResult(list);
		}
		return JsonApiResult.ofErrorResult(
				ErrorCode.DATA_NOT_FOUND.getCode(), ErrorCode.DATA_NOT_FOUND.getMesage());

	}
	
	/**
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 取得所有省份
	 */
	@ApiAuth
	@RequestMapping(value = "/citysByCityIds")
	@ResponseBody
	public JsonApiResult citysByCityIds(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		// 取得会员Id
		String cityIds = jsonData.getString("cityIds");
		
		
		List<Integer> ids = Lists.newArrayList();
		String array[] = cityIds.split(";");
		for(String id : array){
			ids.add(Integer.valueOf(id));
		}
		
		
		List<CommCityVO> list = commAddressService.findCityByIds(ids, false);
		
		if (list!=null) {
			return JsonApiResult.ofSuccessResult(list);
		}
		return JsonApiResult.ofErrorResult(
				ErrorCode.DATA_NOT_FOUND.getCode(), ErrorCode.DATA_NOT_FOUND.getMesage());

	}
	
	@ApiAuth
	@RequestMapping("/storeCity")
	@ResponseBody
	public JsonApiResult storeCitys(@RequestParam("CODE") String code) {
		List<CommCityVO> cityList = Lists.newArrayList();
		
		WhPhysicalWarehouseVO warehouseVO = new WhPhysicalWarehouseVO();
		warehouseVO.setWarehouseType(2);
		warehouseVO.setWarehouseStatus(1);
		List<WhPhysicalWarehouseVO> whList = sWhInfoService.findPhysicalWarehouseByCond(BeanUtil.buildFrom(warehouseVO, WhPhysicalWarehouseVO.class));
		if (CollectionUtils.isEmpty(whList)) {
			return JsonApiResult.ofSuccessResult(cityList);
		}
		List<Integer> discritIdList = Lists.newArrayList();
		for (WhPhysicalWarehouseVO warehouse : whList) {
			if (!discritIdList.contains(warehouse.getCityId())) {
				discritIdList.add(warehouse.getCityId().intValue());
			}
		}
		List<CommDistrictVO> districtList = commAddressService.findDistrictByIds(discritIdList);
		List<Integer> cityIdList = Lists.newArrayList();
		for (CommDistrictVO district : districtList) {
			if (!cityIdList.contains(district.getCityId())){
				cityIdList.add(district.getCityId());
			}
		}
		cityList = commAddressService.findCityByIds(cityIdList, false);
		return JsonApiResult.ofSuccessResult(cityList);
	}
	
}
