package com.thebeastshop.pegasus.channelservice.controller.address;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.member.service.MemberAddressService;
import com.thebeastshop.member.vo.MemberAddressVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.AddressAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.vo.address.AddressVO;

@Controller("CommonAddressController")
@RequestMapping("/api/address")
public class AddressController {

	@Autowired
	private AddressAdapter addressAdapter;

	@Autowired
	private MemberAddressService memberAddressService;

	/**
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：beast_site/delivery/list 查询所有收货地址
	 */
	@ApiAuth
	@RequestMapping(value = "/list")
	@ResponseBody
	public JsonApiResult list(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) {

		JSONObject jsonData = JSONObject.parseObject(data);
		// 取得会员Id
		Long memberId = jsonData.getLong("memberId");
		
		if (memberId == null) {
			return JsonApiResult.ofErrorResult(
					ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		
		// 取得会员所有收货地址
		List<MemberAddressVO> voList = memberAddressService.list(memberId);
		List<AddressVO> list = new ArrayList<AddressVO>();
		//
		if (voList != null && voList.size() > 0) {
			AddressVO vo = null;
			for (MemberAddressVO opMemberAddressVO : voList) {
				vo = addressAdapter.common2website(opMemberAddressVO);
				list.add(vo);
			}
		}
		return JsonApiResult.ofSuccessResult(list);
	}

	/**
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/delivery/add 新增收货地址接口
	 */
	@ApiAuth
	@RequestMapping(value = "/add")
	@ResponseBody
	public JsonApiResult add(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) {
		AddressVO addressVO = JSONObject.parseObject(data, AddressVO.class);
		MemberAddressVO opMemberAddressVO = addressAdapter
				.website2Common(addressVO);
		MemberAddressVO result = memberAddressService.create(opMemberAddressVO);
		if (result!=null) {
			return JsonApiResult.ofSuccessResult(result.getId());
		}
		return JsonApiResult.ofErrorResult(
				ErrorCode.DEFAULT_EXCEPTION.getCode(), "新增地址失败!");

	}

	/**
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/delivery/update 新增收货地址接口
	 */
	@ApiAuth
	@RequestMapping(value = "/edit")
	@ResponseBody
	public JsonApiResult edit(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) {

		AddressVO addressVO = JSONObject.parseObject(data, AddressVO.class);
		MemberAddressVO opMemberAddressVO = addressAdapter.website2Common(addressVO);
		Boolean result = memberAddressService.update(opMemberAddressVO);
		if (result) {
			return JsonApiResult.ofSuccessResult(true);
		}
		return JsonApiResult.ofErrorResult(
				ErrorCode.DEFAULT_EXCEPTION.getCode(), "更新地址失败!");
	}

	/**
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/delivery/remove 新增收货地址接口
	 */
	@ApiAuth
	@RequestMapping(value = "/delete")
	@ResponseBody
	public JsonApiResult delete(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) {

		JSONObject jsonData = JSONObject.parseObject(data);
		// 取得会员Id
		Long id = jsonData.getLong("add_id");

		if (id == null) {
			return JsonApiResult.ofErrorResult(
					ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		
		Boolean result = memberAddressService.delete(id);
		if (result) {
			return JsonApiResult.ofSuccessResult(true);
		}
		return JsonApiResult.ofErrorResult(
				ErrorCode.DEFAULT_EXCEPTION.getCode(), "删除失败!");

	}

	/**
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/delivery/address/info 新增收货地址接口
	 */
	@ApiAuth
	@RequestMapping(value = "/info")
	@ResponseBody
	public JsonApiResult info(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) {

		JSONObject jsonData = JSONObject.parseObject(data);
		// 取得Id
		Long id = jsonData.getLong("addressId");

		if (id == null) {
			return JsonApiResult.ofErrorResult(
					ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		
		MemberAddressVO opMemberAddressVO = memberAddressService.getById(id);

		AddressVO vo = addressAdapter.common2website(opMemberAddressVO);

		
		if (vo!=null) {
			return JsonApiResult.ofSuccessResult(vo);
		}
		return JsonApiResult.ofErrorResult(
				ErrorCode.DEFAULT_EXCEPTION.getCode(), "查询失败!");

	}

	/**
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/delivery/address/sync 同步标准的省市区数据
	 */
	@ApiAuth
	@RequestMapping(value = "/sync")
	@ResponseBody
	public JsonApiResult sync(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) {

		// Result<Long> result = addressService.loadAddressPcsesFromOe(id);
		Map<String, String> t = new HashMap<String, String>();
		t.put("timestamp", String.valueOf(System.currentTimeMillis()));
		t.put("sign", "test 12345");
		return JsonApiResult.ofSuccessResult(t);
	}
	
}
