package com.thebeastshop.pegasus.channelservice.controller.activity;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartInterestAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.interest.InterestAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.member.MemberAdapter;
import com.thebeastshop.pegasus.channelservice.util.MobileUtil;
import com.thebeastshop.scm.vo.interest.InterestGoodsGetVO;

/**
 * app 发送权益controller
 * Created by feilong.gao on 2017/1/18.
 */
@Controller("appSendInterestController")
@RequestMapping("/app/activity/interest")
@ResponseBody
public class AppSendInterestController {

    private static final Logger logger = LoggerFactory.getLogger(AppSendInterestController.class);
    @Autowired
    private InterestAdapter interestAdapter;
    @Autowired
    private MemberAdapter memberAdapter;
    @Autowired
    private CartInterestAdapter cartInterestAdapter;

    /**
     * 发送商品权益
     * 1.如果有手机没有注册成我们的会员  则我们自动帮其注册用户账号       注册的密码是随机密码   然后以短信发送给用户
     * 2.发送某个指定的商品权益
     *
     * @param code
     * @param data
     * @return
     */
    @RequestMapping(value = "/receive", method = RequestMethod.GET)
    @ResponseBody
    public JsonApiResult receiveInterest(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
        logger.info("发送商品权益调用参数 code={},data={}", code, data);
        JSONObject jsonData = JSONObject.parseObject(data);
        String mobile = jsonData.getString("mobile");
        String interestId = jsonData.getString("interestId");
        if (StringUtils.isBlank(mobile) || StringUtils.isBlank(interestId)) {
            return JsonApiResult.ofErrorResult(-10, "参数错误");
        }
        if (!MobileUtil.isValidPhoneNumber(mobile)) {
            return JsonApiResult.ofErrorResult(-10, "手机号码格式错误");
        }
        MemberVO member = memberAdapter.getOrCreateMemberByMobile(mobile, code);
        InterestGoodsGetVO interestGoodsGetVO = interestAdapter.receiveInterest(member.getId(), interestId);
        boolean flag = cartInterestAdapter.saveInterest2Cart(member.getId(),interestGoodsGetVO);
        if(flag){
            return JsonApiResult.ofSuccessResult(flag);
        }else{
            return JsonApiResult.ofErrorResult(400, "添加购物车失败！");
        }
    }


}
