package com.thebeastshop.pegasus.channelservice.controller.activity;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.kit.kafka.producer.KafkaProducerClient;
import com.thebeastshop.member.dto.MemberQueryCondDTO;
import com.thebeastshop.member.dto.RegisterDTO;
import com.thebeastshop.member.enums.GenderEnum;
import com.thebeastshop.member.enums.LoginTypeEnum;
import com.thebeastshop.member.enums.RegisterSourceEnum;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.service.MemberService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.message.enums.MsgTypeEnum;
import com.thebeastshop.message.enums.PublishTypeEnum;
import com.thebeastshop.message.service.MsgSendService;
import com.thebeastshop.message.vo.SingleSmsTemplateVO;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.param.SendCouponGroupParam;
import com.thebeastshop.pegasus.channelservice.param.SendCouponParam;
import com.thebeastshop.pegasus.channelservice.param.SendRabbitCouponParam;
import com.thebeastshop.pegasus.channelservice.service.SendCouponService;

import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * app 发券代码 copy ActivityController create by
 * com.thebeastshop.pegasus.channelservice.controller.activity trunk :author
 * lijing User:lijing DATE : 2016/9/19 TIME : 14:04 trunk.
 */
@Controller("appSendCouponController")
@RequestMapping("/app/activity/coupon")
public class AppSendCouponController {
	/** logger */
	private final static Logger logger = LoggerFactory.getLogger(AppSendCouponController.class);

	@Autowired
	private MemberService memberService;

	@Autowired
	private MemberQueryService memberQueryService;

	private PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();

	@Autowired
	private SendCouponService sendCouponService;

	// @Autowired
	// private KafkaProducerClient kafkaProducerClient;

	@Autowired
	private MsgSendService msgSendService;

	// /**
	// * 使用mq 发送一步 发送卡券信息 ， 这里只是发送消息 并不处理消息 对于处理消息 在于 mq 的消费端
	// * @param code
	// * @param data
	// * @return
	// */
	// @RequestMapping(value = "/rabbitreceive", method = RequestMethod.GET)
	// @ResponseBody
	// public JsonApiResult rabbitReceiveCoupon(@RequestParam("CODE") String
	// code, @RequestParam("DATA") String data) {
	// logger.info("发送优惠券调用参数 code={},data={}",code,data);
	// try {
	// JSONObject jsonData = JSONObject.parseObject(data);
	// String mobile = jsonData.getString("mobile");
	// Integer channel = jsonData.getInteger("channel");
	// Integer type = jsonData.getInteger("type");
	// Long couponSampleId = jsonData.getLong("couponSampleId");
	// if (StringUtils.isBlank(mobile) || channel == null || type == null ||
	// couponSampleId == null) {
	// return JsonApiResult.ofErrorResult(-10, "参数错误");
	// }
	// /* if (!isValidPhoneNumber(mobile)) {
	// return JsonApiResult.ofErrorResult(-10, "手机号码格式错误");
	// }*/
	//
	// SendRabbitCouponParam sendRabbitCouponParam =
	// covertSendRabbitCouponParam(mobile,couponSampleId,type,channel);
	//
	// //发送kafka 信息
	// kafkaProducerClient.send("coupon_send",sendRabbitCouponParam);
	//
	// return JsonApiResult.ofSuccessResult(true);
	// }catch (Exception e) {
	// logger.info("发券系统错误 e={}",e);
	// return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
	// ErrorCode.PARAMS_ILLEGAL.getMesage());
	// }
	// }

	// /**
	// * 补发券
	// * @param code
	// * @param data
	// * @return
	// */
	// @RequestMapping(value = "/bureveive", method = RequestMethod.GET)
	// @ResponseBody
	// public JsonApiResult bureveive(@RequestParam("CODE") String code,
	// @RequestParam("DATA") String data) {
	// logger.info("发送优惠券调用参数 code={},data={}",code,data);
	// try {
	// JSONObject jsonData = JSONObject.parseObject(data);
	// Long memberId = jsonData.getLong("memberId");
	// if (memberId == null || memberId.longValue() <= 0L) {
	// logger.info("补发券 参数错误 ! memberId={}",memberId);
	// return JsonApiResult.ofSuccessResult(true);
	// }
	// //发送kafka 信息
	// kafkaProducerClient.send("coupon_send_reissue",memberId);
	// return JsonApiResult.ofSuccessResult(true);
	// }catch (Exception e) {
	// logger.info("发券系统错误 e={}",e);
	// return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
	// ErrorCode.PARAMS_ILLEGAL.getMesage());
	// }
	// }

	/**
	 * 发送卡券给某个手机号 1.限制 只能发送一涨卡券 给到用户 （以后可以修改） 2.如果有手机没有注册成我们的会员 则我们自动帮其注册用户账号
	 * 注册的密码是随机密码 然后以短信发送给用户 3.发送某个指定的优惠券
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(value = "/receive", method = RequestMethod.GET)
	@ResponseBody
	public JsonApiResult receiveCoupon(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("发送优惠券调用参数 code={},data={}", code, data);
		try {
			JSONObject jsonData = JSONObject.parseObject(data);
			String mobile = jsonData.getString("mobile");
			Integer channel = jsonData.getInteger("channel");
			Integer type = jsonData.getInteger("type");
			Long couponSampleId = jsonData.getLong("couponSampleId");
			if (StringUtils.isBlank(mobile) || channel == null || type == null || couponSampleId == null) {
				return JsonApiResult.ofErrorResult(-10, "参数错误");
			}
			if (!isValidPhoneNumber(mobile)) {
				return JsonApiResult.ofErrorResult(-10, "手机号码格式错误");
			}
			MemberQueryCondDTO dto = new MemberQueryCondDTO();
			dto.setPhone(mobile);
			List<MemberVO> members = memberQueryService.getByCond(dto);
			if (CollectionUtils.isNotEmpty(members)) {
				// 已经是注册用户，则只发送已发放优惠券给用户
				for (MemberVO member : members) {
					JsonApiResult jar = sendCouponService
							.sendCoupon(convertSendCouponParam(member.getId(), couponSampleId, type, channel));
					if (null != jar && jar.getCode() != 0) {
						return jar;
					}
				}
				return JsonApiResult.ofSuccessResult(true);
			}
			RegisterDTO registerDTO = new RegisterDTO();
			registerDTO.setMobile(mobile);
			registerDTO.setNickName(mobile);
			registerDTO.setGender(GenderEnum.SECRET.getCode());
			registerDTO.setRegisterSource(RegisterSourceEnum.APP.getCode());
			// 设置生成的随机密码
			registerDTO.setPassword(getRandomPassword());
			registerDTO.setLoginId(mobile);
			registerDTO.setLoginType(LoginTypeEnum.MOBILE.getCode());
			registerDTO.setChannelCode(code);
			ServiceResp<MemberVO> resp = memberService.register(registerDTO);
			if (null != resp && resp.isSuccess() && resp.getBean() != null) {
				MemberVO result = resp.getBean();
				// 注册成功发送短信通知
				SingleSmsTemplateVO smsTemplateVO = new SingleSmsTemplateVO();
				smsTemplateVO.setMsgTo(mobile);
				Map<String, Object> params = new HashMap<String, Object>();
				params.put("passwd", registerDTO.getPassword());
				smsTemplateVO.setTemplateName("REGISTER_SUCCESS_BS");
				smsTemplateVO.setParams(params);
				smsTemplateVO.setMsgType(MsgTypeEnum.SmsMsg);
				smsTemplateVO.setPublishType(PublishTypeEnum.IDENTIFYING_CODE);
				msgSendService.sendInterfaceVOTemplate(Arrays.asList(smsTemplateVO));

				// 发送优惠券到用户的账户中
				JsonApiResult jar = sendCouponService
						.sendCoupon(convertSendCouponParam(result.getId(), couponSampleId, type, channel));
				return jar;
			}
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		} catch (Exception e) {
			logger.info("发券系统错误  e={}", e);
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
	}

	/**
	 * 发送套券给某个手机号 1.发送多张券 2.如果有手机没有注册成我们的会员 则我们自动帮其注册用户账号 注册的密码是随机密码 然后以短信发送给用户
	 * 3.发送某个指定的优惠套券
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(value = "/receiveGroup", method = RequestMethod.GET)
	@ResponseBody
	public JsonApiResult receiveCouponGroup(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("发送优惠套券调用参数 code={},data={}", code, data);
		try {
			JSONObject jsonData = JSONObject.parseObject(data);
			String mobile = jsonData.getString("mobile");
			Integer channel = jsonData.getInteger("channel");
			Integer type = jsonData.getInteger("type");
			Long couponGroupId = jsonData.getLong("couponGroupId");
			if (StringUtils.isBlank(mobile) || channel == null || type == null || couponGroupId == null) {
				return JsonApiResult.ofErrorResult(-10, "参数错误");
			}
			if (!isValidPhoneNumber(mobile)) {
				return JsonApiResult.ofErrorResult(-10, "手机号码格式错误");
			}
			MemberQueryCondDTO dto = new MemberQueryCondDTO();
			dto.setPhone(mobile);
			List<MemberVO> members = memberQueryService.getByCond(dto);
			if (CollectionUtils.isNotEmpty(members)) {
				// 已经是注册用户，则只发送已发放优惠券给用户
				for (MemberVO member : members) {
					JsonApiResult jar = sendCouponService
							.sendCouponGroup(covertSendCouponGroupParam(member.getId(), couponGroupId, type, channel));
					if (null != jar && jar.getCode() != 0) {
						return jar;
					}
				}
				return JsonApiResult.ofSuccessResult(true);
			}
			RegisterDTO registerDTO = new RegisterDTO();
			registerDTO.setMobile(mobile);
			registerDTO.setNickName(mobile);
			registerDTO.setGender(GenderEnum.SECRET.getCode());
			registerDTO.setRegisterSource(RegisterSourceEnum.APP.getCode());
			// 设置生成的随机密码
			registerDTO.setPassword(getRandomPassword());
			registerDTO.setLoginId(mobile);
			registerDTO.setLoginType(LoginTypeEnum.MOBILE.getCode());
			registerDTO.setChannelCode(code);
			ServiceResp<MemberVO> resp = memberService.register(registerDTO);
			if (null != resp && resp.isSuccess() && resp.getBean() != null) {
				MemberVO result = resp.getBean();
				// 注册成功发送短信通知
				SingleSmsTemplateVO smsTemplateVO = new SingleSmsTemplateVO();
				smsTemplateVO.setMsgTo(mobile);
				Map<String, Object> params = new HashMap<String, Object>();
				params.put("passwd", registerDTO.getPassword());
				smsTemplateVO.setTemplateName("REGISTER_SUCCESS_BS");
				smsTemplateVO.setParams(params);
				smsTemplateVO.setMsgType(MsgTypeEnum.SmsMsg);
				smsTemplateVO.setPublishType(PublishTypeEnum.IDENTIFYING_CODE);
				msgSendService.sendInterfaceVOTemplate(Arrays.asList(smsTemplateVO));

				// 发送优惠券到用户的账户中
				JsonApiResult jar = sendCouponService
						.sendCouponGroup(covertSendCouponGroupParam(result.getId(), couponGroupId, type, channel));
				return jar;
			}
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		} catch (Exception e) {
			logger.info("发券系统错误  e={}", e);
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
	}

	/**
	 * 转换 rabbit 发送卡券实体
	 * 
	 * @param mobile
	 * @param couponSampleId
	 * @param sendType
	 * @param channel
	 * @return
	 */
	private SendRabbitCouponParam covertSendRabbitCouponParam(String mobile, Long couponSampleId, Integer sendType,
			Integer channel) {
		SendRabbitCouponParam sendRabbitCouponParam = new SendRabbitCouponParam();
		if (StringUtils.isNotBlank(mobile)) {
			sendRabbitCouponParam.setMobile(mobile);
		}
		if (null != couponSampleId) {
			sendRabbitCouponParam.setCouponSampleId(couponSampleId);
		}
		if (null != sendType) {
			sendRabbitCouponParam.setType(sendType);
		}

		if (null != channel) {
			sendRabbitCouponParam.setChannel(channel);
		}
		return sendRabbitCouponParam;
	}

	/**
	 * 转换发套券的参数
	 * 
	 * @param memberId
	 *            会员ID
	 * @param couponGroupId
	 *            卡券Id
	 * @param sendType
	 *            发送类型
	 * @param channel
	 *            渠道
	 * @return
	 */
	private SendCouponGroupParam covertSendCouponGroupParam(Long memberId, Long couponGroupId, Integer sendType,
			Integer channel) {
		SendCouponGroupParam sendCouponGroupParam = new SendCouponGroupParam();
		if (null != memberId) {
			sendCouponGroupParam.setMemberId(memberId);
		}
		if (null != couponGroupId) {
			List<Long> couponGroupIds = new ArrayList<>();
			couponGroupIds.add(couponGroupId);
			sendCouponGroupParam.setCouponGroupId(couponGroupIds);
		}
		if (null != sendType) {
			sendCouponGroupParam.setType(sendType);
		}

		if (null != channel) {
			sendCouponGroupParam.setChannel(channel);
		}
		return sendCouponGroupParam;
	}

	/**
	 * 组合发券的参数
	 * 
	 * @return
	 */
	private SendCouponParam convertSendCouponParam(Long memberId, Long couponSampleId, Integer sendType,
			Integer channel) {

		SendCouponParam sendCouponParam = new SendCouponParam();
		if (null != memberId) {
			sendCouponParam.setMemberId(memberId);
		}
		if (null != couponSampleId) {
			sendCouponParam.setCouponSampleId(couponSampleId);
		}
		if (null != sendType) {
			sendCouponParam.setType(sendType);
		}

		if (null != channel) {
			sendCouponParam.setChannel(channel);
		}
		return sendCouponParam;
	}

	/***
	 * 代码优化 获取活动页面注册用户的随机生成密码 2-9之间6位
	 * 
	 * @return
	 */
	private String getRandomPassword() {
		char[] chr = { '2', '3', '4', '5', '6', '7', '8', '9' };
		int chrleng = chr.length;
		StringBuilder sb = new StringBuilder();
		Random random = new Random();
		// 六位随机密码
		for (int i = 0; i < 6; i++) {
			sb.append(chr[random.nextInt(chrleng)]);
		}
		return sb.toString();
	}

	/***
	 * 校验电话号码是否非法 只校验1开头 11位数字
	 *
	 * @param phone
	 * @return
	 */
	private boolean isValidPhoneNumber(String phone) {
		Pattern p = Pattern.compile("^(1[0-9])\\d{9}$");
		Matcher m = p.matcher(phone);
		return m.matches();
	}

}
