package com.thebeastshop.pegasus.channelservice.controller.activity;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.ServiceResp;

import com.thebeastshop.member.dto.MemberQueryCondDTO;
import com.thebeastshop.member.dto.RegisterDTO;
import com.thebeastshop.member.enums.GenderEnum;
import com.thebeastshop.member.enums.LoginTypeEnum;
import com.thebeastshop.member.enums.RegisterSourceEnum;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.service.MemberService;
import com.thebeastshop.member.vo.MemberVO;

import com.thebeastshop.message.enums.MsgTypeEnum;
import com.thebeastshop.message.enums.PublishTypeEnum;
import com.thebeastshop.message.service.MsgSendService;


import com.thebeastshop.coupon.service.CpCouponService;
import com.thebeastshop.coupon.vo.CpCouponVO;


import com.thebeastshop.message.vo.SingleSmsTemplateVO;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.component.support.service.RedisService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;



/**
 * Desc: 静态活动所需要的接口类
 * Created by hafiz.zhang on 2016/8/1.
 */
@Controller("activityController")
@RequestMapping("/api/activity")
public class ActivityController {
    private static Logger logger = LoggerFactory.getLogger(ActivityController.class);

    //private PegasusChannelServiceFacade pcInstance=PegasusChannelServiceFacade.getInstance();

    private RedisService redisService = ComponentServiceLoader.getBean(RedisService.class);
    
    @Autowired
    private MemberService memberService;
    
    @Autowired
    private MemberQueryService memberQueryService;

    @Autowired
    private MsgSendService msgSendService;

    @Autowired
    private CpCouponService cpCouponService;


    //@ApiAuth
    @RequestMapping(value = "/receive/coupon", method = RequestMethod.POST)
    @ResponseBody
    public JsonApiResult receiveCoupon(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
        logger.info("[post] receiveCoupon");
        JSONObject jsonData = JSONObject.parseObject(data);
        String mobile = jsonData.getString("mobile");
        Integer source = jsonData.getInteger("source");
        String key = (1 == source) ? "activity:WY" : "activity:FM";
        if(!isValidPhoneNumber(mobile)) {
            return JsonApiResult.ofErrorResult(-10, "手机号码格式错误");
        }
        MemberQueryCondDTO dto = new MemberQueryCondDTO();
    	dto.setPhone(mobile);
        List<MemberVO> members = memberQueryService.getByCond(dto);
        if(CollectionUtils.isNotEmpty(members)){
            //已经是注册用户，则只发送已发放优惠券给用户短信
            for (MemberVO member : members) {
                JsonApiResult jar = sendCoupons(member.getId(), source);
                if(null != jar) {
                    return jar;
                }
            }
            return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_EXIST.getCode(), ErrorCode.USER_LOGIN_EXIST.getMesage());
        }
        RegisterDTO registerDTO = new RegisterDTO();
        registerDTO.setMobile(mobile);
        registerDTO.setNickName(mobile);
        registerDTO.setGender(GenderEnum.SECRET.getCode());
        registerDTO.setRegisterSource(RegisterSourceEnum.UNKNOWN.getCode());
        //设置生成的随机密码
        registerDTO.setPassword(getRandomPassword());
        registerDTO.setLoginId(mobile);
        registerDTO.setLoginType(LoginTypeEnum.MOBILE.getCode());
        registerDTO.setChannelCode(code);
        ServiceResp<MemberVO> resp = memberService.register(registerDTO);
        if (null != resp && resp.isSuccess() && resp.getBean() != null) {
        	MemberVO result = resp.getBean();
            //分别存储网易或者红蜻蜓FM过来的注册总用户数
            if(!redisService.exists(key)) {
                redisService.set(key, 1);
            } else {
                redisService.incr(key);
            }
            // 注册成功发送短信通知
            logger.info("[post] receiveCoupon 发送验证码短信");
            SingleSmsTemplateVO smsTemplateVO  = new SingleSmsTemplateVO();
            smsTemplateVO.setMsgTo(mobile);
            Map<String, Object> params = new HashMap<String, Object>();
            params.put("passwd", registerDTO.getPassword());
            smsTemplateVO.setTemplateName("REGISTER_SUCCESS_BS");
            smsTemplateVO.setParams(params);
            smsTemplateVO.setMsgType(MsgTypeEnum.SmsMsg);
            smsTemplateVO.setPublishType(PublishTypeEnum.IDENTIFYING_CODE);
            msgSendService.sendInterfaceVOTemplate(Arrays.asList(smsTemplateVO));

            //发送优惠券到用户的账户中
            JsonApiResult jar = sendCoupons(result.getId(), source);
            if(null != jar) {
                return jar;
            }
            return JsonApiResult.ofSuccessResult(null);
        }
        return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
    }
    /***
     * 获取活动页面注册用户的随机生成密码 2-9之间6位
     * @return
     */
    private String getRandomPassword(){
        String IntString="23456789";//随机密码范围
        StringBuilder sb=new StringBuilder();
        Random random=new Random();
        //六位随机密码
        for(int i=0;i<6;i++){
            sb.append(IntString.charAt(random.nextInt(IntString.length())));
        }
        return sb.toString();
    }

    /**
     * 发送优惠券给指定用户
     *
     * @param userId
     *
     * @return
     */
    private JsonApiResult sendCoupons(Long userId, Integer source) {
        String key1 = ((1 == source) ? "activity:WY:coupon:152" : "activity:FM:coupon:152");
        String key2 = ((1 == source) ? "activity:WY:coupon:153" : "activity:FM:coupon:153");
        //查找该用户是否已经领取过指定的优惠券
        int count1 = cpCouponService.getCouponsCount(userId, 152L);
        int count2 = cpCouponService.getCouponsCount(userId, 153L);
        if(count1 > 0 && count2 > 0) {
            return JsonApiResult.ofErrorResult(2, "已领取优惠券");
        }
        if(count1 <= 0) {
            try {
                ServiceResp<CpCouponVO> resp = cpCouponService.send(152L, userId);
                CpCouponVO coupon1 = resp.getBean();
                if(resp.isFailure() || coupon1 == null) {
                    logger.info("发放优惠券1给userId=" + userId + "的用户失败");
                    return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
                            ErrorCode.DATA_NOT_FOUND.getMesage());
                } else {
                    //保存红包发放记录
                    if (redisService.lpush(key1, coupon1.getId().toString()) <= 0) {
                        logger.error("保存优惠券编号为:" + coupon1.getId() + "的记录到Redis失败");
                    }
                }
            } catch (Exception e){
                return JsonApiResult.ofErrorResult(3, e.getMessage());
            }
        }

        if(count2 <= 0) {
           try {
                ServiceResp<CpCouponVO> resp = cpCouponService.send(153L, userId);
                CpCouponVO coupon2 = resp.getBean();
                if(resp.isFailure() || coupon2 == null) {
                    logger.info("发放优惠券给userId=" + userId + "的用户失败");
                    return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
                            ErrorCode.DATA_NOT_FOUND.getMesage());
                } else {
                    //保存红包发放记录
                    if (redisService.lpush(key2, coupon2.getId().toString()) <= 0) {
                        logger.error("保存优惠券编号为:" + coupon2.getId() + "的记录到Redis失败");
                    }
                }
            } catch (Exception e ){
                return JsonApiResult.ofErrorResult(3, e.getMessage());
            }
        }
        return null;
    }


    /***
     * 校验电话号码是否非法 只校验1开头 11位数字
     *
     * @param phone
     * @return
     */
    private boolean isValidPhoneNumber(String phone) {
        Pattern p = Pattern.compile("^(1[0-9])\\d{9}$");
        Matcher m = p.matcher(phone);
        return m.matches();
    }
}
