package com.thebeastshop.pegasus.channelservice.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

public class HttpClientTest {
	public static void main(String args[]) {
        //创建HttpClientBuilder
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        //HttpClient
        CloseableHttpClient closeableHttpClient = httpClientBuilder.build();

        HttpPost httpPost = new HttpPost("http://dwz.cn/create.php");
        List<NameValuePair> params = new ArrayList<NameValuePair>();  
        params.add(new BasicNameValuePair("url", "http://image.baidu.com/i?ct=503316480&z=0&tn=baiduimagedetail&word=%B6%CC%CD%F8%D6%B7&in=25321&cl=2&lm=-1&pn=3&rn=1&di=4944614685&ln=1&fr=&ic=&s=0&se="));  
			
        //System.out.println(httpGet.getRequestLine());
        try {
        	 httpPost.setEntity(new UrlEncodedFormEntity(params,"UTF-8"));
            //执行get请求
            HttpResponse httpResponse = closeableHttpClient.execute(httpPost);
            //获取响应消息实体
            HttpEntity entity = httpResponse.getEntity();
            //响应状态
            System.out.println("status:" + httpResponse.getStatusLine());
            //判断响应实体是否为空
            if (entity != null) {
                //System.out.println("contentEncoding:" + entity.getContentEncoding());
               // System.out.println("response content:" + EntityUtils.toString(entity, "GBK"));
            	 JSONObject rootJsonObject = (JSONObject) JSON.parse(EntityUtils.toString(entity, "GBK"));
            	 int status = rootJsonObject.getIntValue("status");
            	 //失败
            	 if(status != 0) {
            		 
            	 } else { //成功
            		 System.out.println(rootJsonObject.getString("tinyurl"));
            	 }
                 
            }
            
           
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                //关闭流并释放资源
                closeableHttpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
