/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.channelservice.constants;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Royan
 * @version $Id: PegasusConstants.java, v 0.1 2015-07-07 下午2:30
 */
public class PegasusConstants {

    /**
     * 可用
     */
    public static final int STATUS_AVAILABLE = 1;

    /**
     * 禁用
     */
    public static final int STATUS_UNAVAILABLE = 0;

    public static final int YES = 1;

    public static final int NO = 0;
    
    public static final int CROSSGAOJIE = 1;//高捷订单
    
    public static final int CROSSDIRECTMAIL = 3;//海淘-e码头直邮
    
    public static final int CROSSSHWS = 4;//海淘-上海威盛
    
    public static final int CROSSEBONDEN = 5;//海淘-e码头店提
    
    public static final int CROSSBJWS = 6;//海淘-北京威盛

    /**
     * 性别
     */
    public static class Gender {
        /**
         * 男
         */
        public static final Integer MALE = 1;
        /**
         * 女
         */
        public static final Integer FEMALE = 2;
        /**
         * 保密or不详
         */
        public static final Integer UNKNOWN = 3;
    }

    /**
     * 付款方式
     */
    public static class Payment {
        /**
         * 付款方式~客服
         */
        public static final Integer TYPE_CUSTOMER_SERVICE = 0;
        /**
         * 付款方式~现金
         */
        public static final Integer TYPE_CASH = 1;
        /**
         * 付款方式~借记卡
         */
        public static final Integer TYPE_DEBIT_CARD = 2;
        /**
         * 付款方式~信用卡
         */
        public static final Integer TYPE_CREDIT_CARD = 3;
        /**
         * 付款方式~微信
         */
        public static final Integer TYPE_WEIXIN = 4;
        /**
         * 付款方式~支付宝
         */
        public static final Integer TYPE_ALIPAY = 5;
        /**
         * 付款方式~招行
         */
        public static final Integer TYPE_CMB = 6;
        /**
         * 付款方式~转账
         */
        public static final Integer TYPE_TRANSFER = 7;
        
        /**
         * 预存款
         */
        public static final Integer PRE_DEPOSIT = 8;
        
        /** 
         * 支付方式-业主
         */
        public static final Integer TYPE_PROPRIETOR = 9;
        
        /** 
         * 支付方式-礼品卡
         */
        public static final Integer TYPE_GIFT_CARD = 10;
        
        /**
         * 纯积分
         */
        public static final Integer TYPE_EXCHANGE = 11;
    }

    private static List<Map<String, String>> allPayment;
    public synchronized static List<Map<String, String>> getAllPayment() {
        if (allPayment != null) {
            return allPayment;
        }
        allPayment = new ArrayList<Map<String, String>>();
        Map<String, String> option;
        option = new HashMap<String, String>();
        option.put("text", "现金");
        option.put("value", Payment.TYPE_CASH.toString());
        allPayment.add(option);
        option = new HashMap<String, String>();
        option.put("text", "借记卡");
        option.put("value", Payment.TYPE_DEBIT_CARD.toString());
        allPayment.add(option);
        option = new HashMap<String, String>();
        option.put("text", "信用卡");
        option.put("value", Payment.TYPE_CREDIT_CARD.toString());
        allPayment.add(option);
        option = new HashMap<String, String>();
        option.put("text", "微信");
        option.put("value", Payment.TYPE_WEIXIN.toString());
        allPayment.add(option);
        option = new HashMap<String, String>();
        option.put("text", "支付宝");
        option.put("value", Payment.TYPE_ALIPAY.toString());
        allPayment.add(option);
        option = new HashMap<String, String>();
        option.put("text", "招行");
        option.put("value", Payment.TYPE_CMB.toString());
        allPayment.add(option);
        option = new HashMap<String, String>();
        option.put("text", "转账");
        option.put("value", Payment.TYPE_TRANSFER.toString());
        allPayment.add(option);
        option = new HashMap<String, String>();
        option.put("text", "余额抵扣");
        option.put("value", Payment.PRE_DEPOSIT.toString());
        allPayment.add(option);
        option = new HashMap<String, String>();
        option.put("text", "业主");
        option.put("value", Payment.TYPE_PROPRIETOR.toString());
        allPayment.add(option);
        return allPayment;
    }

    private static List<Map<String, String>> allGender;
    public synchronized static List<Map<String, String>> getAllGender() {
        if (allGender != null) {
            return allGender;
        }
        allGender = new ArrayList<Map<String, String>>();
        Map<String, String> option;
        option = new HashMap<String, String>();
        option.put("text", "男");
        option.put("value", Gender.MALE.toString());
        allGender.add(option);
        option = new HashMap<String, String>();
        option.put("text", "女");
        option.put("value", Gender.FEMALE.toString());
        allGender.add(option);
        option = new HashMap<String, String>();
        option.put("text", "保密");
        option.put("value", Gender.UNKNOWN.toString());
        allGender.add(option);
        return allGender;
    }

}