
package com.thebeastshop.pegasus.channelservice.constants;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.thebeastshop.scm.vo.lottery.DrawResultException;

/**
 * Created by feilong.gao on 2016/12/23.
 */
public enum  LotteryErrorCode {

    FREQUENCY_REQUEST("FREQUENCY_REQUEST","请求频繁，请稍后重试"),

    MEMBER_NOT_FOUND("MEMBER_NOT_FOUND","没有找到用户"),

    ACTIVITY_ERROR("ACTIVITY_ERROR","没有找到正在抽奖的活动"),

    NO_CHANCE("NO_CHANCE","没有抽奖资格"),

    POINT_INTERFACE_ERROR("POINT_INTERFACE_ERROR","积分接口异常"),

    POINT_NOT_ENOUGH("POINT_NOT_ENOUGH","积分不够"),

    ERROR("ERROR","程序异常");

    private String code;
    private String desc;

    private LotteryErrorCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(String code){
        if(StringUtils.isNotEmpty(code)){
            for(LotteryErrorCode value:LotteryErrorCode.values()){
                if(value.getCode().equalsIgnoreCase(code)){
                    return value.getDesc();
                }
            }
        }
        return "";
    }

}
