package com.thebeastshop.pegasus.channelservice.constants;

import com.alibaba.dubbo.common.utils.StringUtils;

/**
 * Created by feilong.gao on 2017/1/20.
 */
public enum InterestErrorCode {
    INTEREST_NOT_FOUND("INTEREST_NOT_FOUND", "该权益已失效"),//没有找到正在开始的权益记录
    NOT_STOCK("NOT_STOCK", "没有库存"),//没有库存
    OPTIMISTIC_LOCK_UPDATE_FAILURE("OPTIMISTIC_LOCK_UPDATE_FAILURE", "系统繁忙，请稍后重试");//乐观锁更新失败

    private String code;
    private String desc;

    private InterestErrorCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(String code) {
        if (StringUtils.isNotEmpty(code)) {
            for (InterestErrorCode value : InterestErrorCode.values()) {
                if (value.getCode().equalsIgnoreCase(code)) {
                    return value.getDesc();
                }
            }
        }
        return "";
    }

}
