package com.thebeastshop.pegasus.channelservice.constants;

/***
 * 返回哥渠道的响应码，延续老OE
 * @author fs
 *
 */
public enum ErrorCode {
	//1031 表示某个产品行上的产品单价变了
	//1030 是整个订单的总价变了              比方说 折扣啊 优惠券啊 导致整个订单总价不对了
	//1024 产品下架
	//1023 库存不足
	//-10 积分不足
	//OK 通用业务正常返回
    OPERATION_OK(0,"OK"),
    USER_LOGIN_EXIST(-1,"注册失败，用户名已存在"),
    USER_LOGIN_NOT_EXIST(-2,"登陆失败，用户名不存在"),
    //用户名密码验证失败、oe报（验证失败）
    USER_LOGIN_FAILED(-3,"登陆失败，用户名或密码错误"),
    USER_DISABLED(-5, "该账号已被禁止使用"),
    //-4 无效的数据请求地址
    PARAMS_ILLEGAL(-4,"数据请求错误"),
    USER_PASSWORD_FAILED(-3,"登陆失败，密码错误"),
    //内部exception
    DEFAULT_EXCEPTION(-40,"系统内部错误"),
    DATA_NOT_FOUND(404,"数据不存在"),

    ORDER_TIMEOUT(301,"订单超时未支付"),
    CHANNEL_CODE_EMPTY(303, "渠道编码为空"),
    ITEM_PRICE_CHANGE(1031,"商品价格发生变化"),
    ORDER_AMOUNT_CHANGE(1030,"订单价格发生变化"),
    ITEM_OFFSHELF(1024,"商品下架"),

    CONFIG_ERROR(1025,"商品配置异常"),
    ITEM_OUTOF_QUANTITY(1023,"商品库存不足"),
    LACKOF_POINT(-10,"积分不足"),
    //auth认证失败-签名非法  9999
    AUTHFAILED_SIGN_ILLEGAL(9999,"认证失败-签名非法"),
    //认证失败-参数缺失
    AUTHFAILED_MISS_PARAMS(9998,"认证失败-参数缺失"),
    //认证失败-签名过期
    AUTHFAILED_TIMESTAMP_EXPIRED(9996,"认证失败-签名过期"),
    USER_PAYPWD_ERR(10000,"支付密码有误"),
    NSUFFICIENT_FUND(10001,"未开通存款账号"),
    USER_NOT_HAS_PERMISSION(10002,"当前用户没有购买权限"),
    NOT_SUFFICIENT_FUND(10003,"余额不足"),
    CHECK_ADDRESS_NOT(409,"抱歉，该地区暂不支持配送"),
	CHECK_ADDRESS_NOT_LOGISTICS(410,"抱歉，该地区暂不支持家具配送");
	
  private ErrorCode(Integer code,String message){
	  this.code=code;
	  this.mesage=message;
  }
   public Integer getCode() {
	return code;
  	}
	public void setCode(Integer code) {
		this.code = code;
	}
	public String getMesage() {
		return mesage;
	}
	public void setMesage(String mesage) {
		this.mesage = mesage;
	}
	private Integer code;
	  private String mesage;
	}
