package com.thebeastshop.pegasus.channelservice.adapter.website;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.thebeastshop.common.utils.DateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.pegasus.channelservice.vo.AddressVO;
import com.thebeastshop.pegasus.channelservice.vo.IdCardVO;
import com.thebeastshop.pegasus.channelservice.vo.order.SoInvoiceInfoVO;
import com.thebeastshop.pegasus.channelservice.vo.website.order.OrderCreateDetailVO;
import com.thebeastshop.pegasus.channelservice.vo.website.order.OrderCreateVO;
import com.thebeastshop.pegasus.channelservice.vo.website.order.OrderLineVO;
import com.thebeastshop.pegasus.channelservice.vo.website.order.OrderQueryVO;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpIdCardVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoInvoiceInfoVO1;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageDeliveryInfoVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageSkuVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageVO;
import com.thebeastshop.pegasus.service.operation.model.OpProduct;
import com.thebeastshop.pegasus.service.operation.model.OpSalesOrder;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackage;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackageDeliveryInfo;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackageSku;
import com.thebeastshop.pegasus.service.operation.vo.OpPresaleSaleInvVO;
import com.thebeastshop.pegasus.service.operation.vo.OpPresaleVO;

@Service("orderAdapter")
public class OrderAdapter {
//
//    @Autowired
//    private McPsProductService mcPsProductService;
//    @Autowired
//    private McPsSkuService mcPsSkuService;
//    @Autowired
//    private McOpChannelService mcOpChannelService;
//    @Autowired
//	private MemberQueryService memberQueryService;
//
//    private final static Logger LOGGER = LoggerFactory.getLogger(OrderAdapter.class);
//
//    private final PegasusOperationServiceFacade poInstance = PegasusOperationServiceFacade.getInstance();
//    private final PegasusWarehouseInnerServiceFacade pwInstance = PegasusWarehouseInnerServiceFacade.getInstance();
//
//    /***
//     * 外部订单为通用订单对象
//     *
//     * @param orderQueryVO
//     */
//    public OpSalesOrderVO website2Common(final OrderQueryVO orderQueryVO) {
//        return new OpSalesOrderVO();
//    }
//
//    /***
//     * 根据通用的订单对象。封装成接口参数
//     *
//     * @return OrderQueryVO
//     */
    public OrderQueryVO common2website(final OpSalesOrderVO opSalesOrderVO) {

        final OrderQueryVO orderQueryVO = new OrderQueryVO();

        //整体订单解析
        orderQueryVO.setAmount_total(opSalesOrderVO.getNeedToPayAmount().doubleValue());
        //orderQueryVO.setDate_order(String.valueOf(opSalesOrderVO.getCreateTime()));
        orderQueryVO.setDate_order(DateUtil.format(opSalesOrderVO.getCreateTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
        orderQueryVO.setExpect_delivery_date(String.valueOf(opSalesOrderVO.getExpectReceiveDate()));
        orderQueryVO.setId(opSalesOrderVO.getId());
        orderQueryVO.setLimited_hour(opSalesOrderVO.getLimitDeliveryTimeDesc());
        orderQueryVO.setName(opSalesOrderVO.getCode());
        final AddressVO partner_shipping_id = new AddressVO();
        partner_shipping_id.setAddr_id(opSalesOrderVO.getAddressId());
        partner_shipping_id.setCircuit(opSalesOrderVO.getCircuitDesc());
        partner_shipping_id.setCity(opSalesOrderVO.getCity());
        partner_shipping_id.setDistrict(opSalesOrderVO.getDistrict());
        partner_shipping_id.setId(opSalesOrderVO.getAddressId());
        partner_shipping_id.setPhone(opSalesOrderVO.getReceiverPhone());
        partner_shipping_id.setName(opSalesOrderVO.getReceiver());
        partner_shipping_id.setStreet(opSalesOrderVO.getAddress());
        partner_shipping_id.setProvince(opSalesOrderVO.getProvince());
        partner_shipping_id.setZip(opSalesOrderVO.getZipCode());

        orderQueryVO.setPartner_shipping_id(partner_shipping_id);
        orderQueryVO.setOrder_out_state(orderStatusStr(opSalesOrderVO.getSalesOrderStatus()));
        orderQueryVO.setShop_id(String.valueOf(opSalesOrderVO.getShopId()));
        orderQueryVO.setShop_name(opSalesOrderVO.getShopName());

        if (opSalesOrderVO.getCrossBorderFlag() == null) {
            opSalesOrderVO.setCrossBorderFlag(0);
        }
        orderQueryVO.setCrossBorderFlag(opSalesOrderVO.getCrossBorderFlag());
        if (opSalesOrderVO.getCrossBorderFlag() == 1) {
            // 海淘身份证信息
            if (opSalesOrderVO.getOpIdCardVO() != null) {
                final IdCardVO idCardVO = new IdCardVO();
                idCardVO.setAuditStatus(opSalesOrderVO.getOpIdCardVO().getAuditStatus());
                idCardVO.setBackCardPhoto(opSalesOrderVO.getOpIdCardVO().getBackCardPhoto());
                idCardVO.setFrontCardPhoto(opSalesOrderVO.getOpIdCardVO().getFrontCardPhoto());
                idCardVO.setId(opSalesOrderVO.getOpIdCardVO().getId());
                idCardVO.setIdNumber(opSalesOrderVO.getOpIdCardVO().getIdNumber());
                idCardVO.setName(opSalesOrderVO.getOpIdCardVO().getName());
                idCardVO.setOrderId(opSalesOrderVO.getOpIdCardVO().getOrderId());
                orderQueryVO.setIdCardVO(idCardVO);
            }
        }

        return orderQueryVO;
    }

    public String orderStatusStr(final Integer orderStatus) {
        final String result;

        if (orderStatus == 0) {
            result = "取消";
        } else if (orderStatus == 1 || orderStatus == 2) {
            result = "未支付";
        } else {
            result = "已支付";
        }

        return result;
    }
//
//    /***
//     * 根据通用的订单对象。封装成接口参数
//     *
//     * @return OrderQueryVO
//     */
//    public OrderLineVO common2website(final OpSoPackageSkuVO opSoPackageSkuVO, final String channelCode) {
//        final OrderLineVO orderLineVO = new OrderLineVO();
//        final PsProductVO productVO = mcPsProductService.findProdByChnCodeSkuCode(channelCode, opSoPackageSkuVO.getSkuCode());
//        if (productVO != null) {
//            orderLineVO.setImg_url(imageUrl(productVO.getPicThumb()));
//            orderLineVO.setProduct_name(productVO.getNameCn());
//            final String[] product_id = new String[2];
//            product_id[0] = productVO.getId();
//            product_id[1] = productVO.getNameCn();
//            orderLineVO.setProduct_id(product_id);
//        }
//        orderLineVO.setPoint_price(
//                opSoPackageSkuVO.getUnitPrice().subtract(opSoPackageSkuVO.getUnitPointDeduction()).doubleValue());
//        orderLineVO.setPoint_value(opSoPackageSkuVO.getUnitPoint().doubleValue());
//        orderLineVO.setPrice_subtotal(opSoPackageSkuVO.getUnitPrice().subtract(opSoPackageSkuVO.getUnitDiscount())
//                .subtract(opSoPackageSkuVO.getUnitPointDeduction()).doubleValue()
//                * opSoPackageSkuVO.getQuantity());
//        orderLineVO.setPrice_unit(opSoPackageSkuVO.getUnitPrice().doubleValue());
//
//        orderLineVO.setProduct_uom_qty(opSoPackageSkuVO.getQuantity());
//        orderLineVO.setSku(opSoPackageSkuVO.getSkuCode());
//
//        return orderLineVO;
//    }
//
//    public String imageUrl(final String imageUrl) {
//        String url = imageUrl;
//        if (!StringUtils.isBlank(imageUrl)) {
//
//            if (imageUrl.contains("http://")) {
//                url = imageUrl;
//            } else {
//                url = "http://oss.thebeastshop.com/" + imageUrl;
//            }
//
//        }
//
//        return url;
//    }
//
//    /***
//     * 外部订单为通用订单对象
//     */
//    public OpSalesOrderVO website2Common(final OrderCreateVO orderCreateVO) {
//         boolean isforceaudit = false;
//        //订单VO
//        final OpSalesOrderVO opSalesOrderVO = new OpSalesOrderVO();
//        //包裹VO
//        final List<OpSoPackageVO> opSoPackageVOs = new ArrayList<>();
//        //官网默认是一个包裹
//        final OpSoPackageVO opSoPackage = new OpSoPackageVO();
//        //包裹地址信息
//        final OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO = new OpSoPackageDeliveryInfoVO();
//        //包裹sku信息
//        final List<OpSoPackageSkuVO> opSoPackageSkuVOs = new ArrayList<>();
//        //OpMemberVO memberVo=null;
//        final MemberVO memberVo = memberQueryService.getById(orderCreateVO.getCustomer_id());
//        //配送仓
//        OpChannelVO opChannel = mcOpChannelService.findByCode(orderCreateVO.getChannel_code());
//        if (opChannel != null) {
//            opSoPackage.setDispatchWarehouseCode(opChannel.getWarehouseForSales());
//        }
//
//        orderPreCheck(orderCreateVO.getChannel_code(), orderCreateVO, opChannel);//下单之前的预判 校验价格 校验库存 校验是否下架
//
//        // 订单来源渠道编码
//        opSalesOrderVO.setChannelCode(orderCreateVO.getChannel_code());
//        //会员id
//        if (memberVo != null) {
//            opSalesOrderVO.setMemberId(memberVo.getId());
//            // 会员code
//            opSalesOrderVO.setMemberCode(memberVo.getCode());
//        }
//
//        // 卡片类型，0不需要1空白2代写
//        opSoPackage.setCardType(orderCreateVO.getNote_card());
//        // 卡片内容
//        opSoPackage.setCardContent(orderCreateVO.getNote_card_message());
//        //配送方式
//        opSoPackage.setDeliveryType(getDeliveryType(orderCreateVO.getDelivery_type()));
//        //限时配送
//        opSoPackage.setLimitDeliveryTimeDesc(orderCreateVO.getLimited_hour());
//        //期望收货时间
//        if (StringUtils.isNotBlank(orderCreateVO.getDelivery_date())) {
//            opSoPackage.setExpectReceiveDate(
//                    DateUtil.parse(orderCreateVO.getDelivery_date(), DateUtil.DEFAULT_DATE_FORMAT));
//        } else {
//            opSoPackage.setPlanedDeliveryDate(new Date());
//        }
//
//        // ztq 20160505 身份证信息保存 start
//        final Integer crossBorderFlag = orderCreateVO.getCrossBorderFlag();
//        if (crossBorderFlag != null && crossBorderFlag == OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA) {
//
//            opSalesOrderVO.setCrossFree(orderCreateVO.getCrossFree());
//            opSalesOrderVO.setCrossBorderFlag(OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA);
//            if (orderCreateVO.getIdCardVO() != null) {
//
//                final OpIdCardVO opIdCardVO = new OpIdCardVO();
//
//                opIdCardVO.setBackCardPhoto(orderCreateVO.getIdCardVO().getBackCardPhoto());
//                opIdCardVO.setFrontCardPhoto(orderCreateVO.getIdCardVO().getFrontCardPhoto());
//                opIdCardVO.setIdNumber(orderCreateVO.getIdCardVO().getIdNumber());
//                opIdCardVO.setName(orderCreateVO.getIdCardVO().getName());
//                opIdCardVO.setAuditStatus(orderCreateVO.getIdCardVO().getAuditStatus());
////                // 判断身份证照片是否存在，如果两张照片都存在状态设为2，如果任何一张或两张不存在时判断是否有其它相同身份证号的订单
////                if (StringUtils.isBlank(orderCreateVO.getIdCardVO().getBackCardPhoto()) || StringUtils
////                        .isBlank(orderCreateVO.getIdCardVO().getFrontCardPhoto())) {
////                	
////                	// 判断其它订单是否有相同的身份证号
////                	List<OpSaleOrderIdentityVO> list = pcInstance.findOrderIdentityByMember(opSalesOrderVO.getMemberCode(), opIdCardVO.getName(), opIdCardVO.getIdNumber());
////                	if(CollectionUtils.isEmpty(list)){
////                		 opIdCardVO.setAuditStatus(0);
////                	}else{
////                		
////                		OpSaleOrderIdentityVO vo = list.get(0);
////                        opIdCardVO.setBackCardPhoto(vo.getImgBack());
////                        opIdCardVO.setFrontCardPhoto(vo.getImgFront());
////                        opIdCardVO.setAuditStatus(vo.getAuditStatus());
////                	}
////                	
////                   
////                } else {
////                    opIdCardVO.setAuditStatus(2);
////                }
//
//                opSalesOrderVO.setOpIdCardVO(opIdCardVO);
//            }
//        } else {
//            opSalesOrderVO.setCrossBorderFlag(OrderCreateVO.CROSS_BOARDER_FLAG_NOT_OVERSEA);
//            opSalesOrderVO.setCrossFree(BigDecimal.ZERO);
//        }
//        // ztq 20160505 身份证信息保存 end
//
//        //预期发货时间
//        //内部备注
//        opSalesOrderVO.setInnerRemark(orderCreateVO.getInnerRemark());
//        //设置订单来源 refer
//        opSalesOrderVO.setRefer(orderCreateVO.getRefer());
//        //设置配送地址
//        final AddressVO address = orderCreateVO.getDelivery_address();
//        //详细地址
//        opSoPackageDeliveryInfoVO.setAddress(address.getStreet());
//        //环线
//        opSoPackageDeliveryInfoVO.setCircuitDesc(address.getCircuit());
//        //公司名称
//        opSoPackageDeliveryInfoVO.setCompanyName(address.getCompany_name());
//        //收货的区县ID
//        opSoPackageDeliveryInfoVO.setDistrictId(address.getDistrict_id());
//        //收件人
//        opSoPackageDeliveryInfoVO.setReceiver(address.getName());
//        //邮编
//        opSoPackageDeliveryInfoVO.setZipCode(address.getZip());
//        //称谓
//        opSoPackageDeliveryInfoVO.setTitle(address.getMagento_title());
//        //收件人电话
//        opSoPackageDeliveryInfoVO.setReceiverPhone(address.getPhone());
//        //订单行
//        final List<OrderCreateDetailVO> orderCreateDetails = orderCreateVO.getItems();
//        //配送方式，判断是否需要强制审单
//        final Map<String, Boolean> deliveryTypes = new HashMap<>();
//        for (final OrderCreateDetailVO detail : orderCreateDetails) {
//            final OpSoPackageSkuVO packageSku = new OpSoPackageSkuVO();
//            final PsProductVO productVO = mcPsProductService
//                    .findProdByChnCodeSkuCode(orderCreateVO.getChannel_code(), detail.getSku());
//            if (null == productVO) {
//                throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(), "商品已下架 " + detail.getSku());
//            }
//
//            final PsSkuVO skuVO = mcPsSkuService.findBySkuCode(detail.getSku());
//            
//            
//            // @auhtor lijing end
//            //判断是否是官网渠道且sku是来单制作
//
//    		if("CHN2018".equals(opSalesOrderVO.getChannelCode()) && !isforceaudit){
//        		if("1".equals(skuVO.getIsJit())){
//    		            isforceaudit = true;
//    			}
//
//    		}
//
//            packageSku.setWeight(skuVO.getWeight());
//            packageSku.setTaxNo(skuVO.getTaxNo());
//
//
//            // 跨境购标注 0普通１跨境购
//            packageSku.setCrossBorderFlag(detail.getCrossBorderFlag());
//
//            packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);//默认会员添加
//            packageSku.setSkuCode(detail.getSku());
//            packageSku.setBrandId(detail.getBrandId());
//            packageSku.setCategroyId(detail.getCategroyId());
//            packageSku.setMainSkuCode(detail.getMainSkuId());
//            //TODO
//            // todo what?
//            packageSku.setIsJit(detail.getIsJit());//是否来单制作
//            packageSku.setQuantity(detail.getQuantity());//数量
//            if (detail.getPoint_value() == null) {
//                packageSku.setUnitPoint(BigDecimal.ZERO);//单品积分
//            } else {
//                packageSku.setUnitPoint(BigDecimal.valueOf(detail.getPoint_value()));//单品积分
//            }
//            //判断是否包含两种以上配送方式，如果是，则需要强制审单
//            final int expressType = productVO.getExpressType();
//            if (OpProduct.EP_TYPE_SELF == expressType) {
//                deliveryTypes.put("SELF", true);
//            } else if (OpProduct.EP_TYPE_FED == expressType) {
//                deliveryTypes.put("FEDX24", true);
//            } else if (OpProduct.EP_TYPE_Sf_AIR == expressType) {
//                deliveryTypes.put("SF_AIR", true);
//            } else if (OpProduct.EP_TYPE_Sf_LAND == expressType) {
//                deliveryTypes.put("SF_LAND", true);
//            } else if (OpProduct.EP_TYPE_YTO == expressType) {//圆通
//                deliveryTypes.put("YTO", true);
//            } else if (OpProduct.EP_TYPE_DEPPON == expressType) {
//                deliveryTypes.put("DEPPON", true);
//            }
//
//            // 特价
//            if (detail.getDiscountPrice() == null) {
//                detail.setDiscountPrice(0.0D);
//            }
//
//            if (productVO.getAllowVipDiscount() == 1) {//官网计算价格，不判断是否匿名购买
//                packageSku.setUnitDiscount(getUnitDiscount(BigDecimal.valueOf(detail.getPrice()),//
//                        memberVo.getMemberLevel(),//TODO:memberVo可能为null
//                        orderCreateVO.getPresent_cards(), BigDecimal.valueOf(detail.getDiscountPrice())));//单品折扣
//            } else {
//                if (detail.getDiscountPrice() > 0) {
//                    final BigDecimal unitDiscount = BigDecimal.valueOf(detail.getPrice())
//                            .subtract(BigDecimal.valueOf(detail.getDiscountPrice()));
//                    packageSku.setUnitDiscount(unitDiscount);
//
//                } else {
//                    packageSku.setUnitDiscount(BigDecimal.ZERO);
//                }
//            }
//
//            // 折扣后金额
//            packageSku.setUnitAmountAfterDiscount(
//                    BigDecimal.valueOf(detail.getPrice()).subtract(packageSku.getUnitDiscount()));
//
//            // 特价
//            packageSku.setDiscountPrice(BigDecimal.valueOf(detail.getDiscountPrice()));
//
//            if (detail.getPoint_price() != null) {
//                packageSku.setUnitPointDeduction(
//                        BigDecimal.valueOf(detail.getPrice()).subtract(packageSku.getUnitDiscount())
//                                .subtract(BigDecimal.valueOf(detail.getPoint_price())));//折扣后的价格减去积分价格
//            } else {
//                packageSku.setUnitPointDeduction(BigDecimal.ZERO);
//            }
//            packageSku.setUnitPrice(BigDecimal.valueOf(detail.getPrice()));
//            //TODO 是否赠品，0否1是
//            packageSku.setIsGift(0);//底层暂不支持赠品
//            // 分类
//            packageSku.setCategoryCods(detail.getCategoryCods());
//
//            opSoPackageSkuVOs.add(packageSku);
//        }
//
//        // 发票是否随同货物发送，0否1是
//        opSalesOrderVO.setIsInvoiceInSamePackage(OpSalesOrder.IS_INVOICE_IN_SAME_PACKAGE_FALSE);
//
//        // @auhtor lijing start
//        // 是否需要发票
//        opSalesOrderVO.setNeedInvoice(orderCreateVO.getNeedInvoice());
//        if (orderCreateVO.getIsInvoiceInSamePackage() == null) {
//            opSalesOrderVO.setIsInvoiceInSamePackage(OpSalesOrder.IS_INVOICE_IN_SAME_PACKAGE_FALSE);
//        } else {
//            opSalesOrderVO.setIsInvoiceInSamePackage(orderCreateVO.getIsInvoiceInSamePackage());
//        }
//        // 判断发票是否同货物发送
//        // 设置发票
//        if (orderCreateVO.getNeedInvoice() != null
//                && orderCreateVO.getNeedInvoice() == OrderCreateVO.NEED_INVOICE_TRUE) {
//            LOGGER.info("设置发票 orderCreateVO.getSoInvoiceInfoVO={}", orderCreateVO.getSoInvoiceInfoVO());
//            final OpSoInvoiceInfoVO opSoInvoiceInfo = new OpSoInvoiceInfoVO();
//            final SoInvoiceInfoVO soInvoiceInfoVO = orderCreateVO.getSoInvoiceInfoVO();
//            if (soInvoiceInfoVO != null) {
//                LOGGER.info("设置发票 ");
//                opSoInvoiceInfo.setInnerRemark(soInvoiceInfoVO.getInnerRemark());
//                opSoInvoiceInfo.setAddress(soInvoiceInfoVO.getAddress());
//                opSoInvoiceInfo.setDistrictId(soInvoiceInfoVO.getDistrictId());
//                opSoInvoiceInfo.setInvoiceType(soInvoiceInfoVO.getInvoiceType());
//                opSoInvoiceInfo.setInvoiceTitle(soInvoiceInfoVO.getInvoiceTitle());
//                opSoInvoiceInfo.setInvoiceAmount(soInvoiceInfoVO.getInvoiceAmount());
//                opSoInvoiceInfo.setReceiver(soInvoiceInfoVO.getReceiver());
//                opSoInvoiceInfo.setReceiverPhone(soInvoiceInfoVO.getReceiverPhone());
//                opSoInvoiceInfo.setInvoiceStatus(soInvoiceInfoVO.getInvoiceStatus());
//                opSoInvoiceInfo.setApplyTime(soInvoiceInfoVO.getApplyTime());
//                opSoInvoiceInfo.setApplyOperatorId(soInvoiceInfoVO.getApplyOperatorId());
//                opSoInvoiceInfo.setApplyOperatorName(soInvoiceInfoVO.getApplyOperatorName());
//                opSoInvoiceInfo.setIsEmergency(soInvoiceInfoVO.getIsEmergency());
//                opSalesOrderVO.setSoInvoiceInfoVO(opSoInvoiceInfo);
//            }
//        }
//        // @auhtor lijing end
//
//        //是否审单,有两种不同的运输方式或者有自送的。需要审单
//        if (deliveryTypes.size() > 1 || (deliveryTypes.get("SELF") != null && deliveryTypes.get("SELF")) || isforceaudit) {
//            opSalesOrderVO.setIsForceAudit(PegasusConstants.YES);
//        } else {
//            opSalesOrderVO.setIsForceAudit(PegasusConstants.NO);
//        }
//        //设置配送信息的快递方式，当只有一种配送方式时，设置
//        if (deliveryTypes.size() == 1) {
//            if (deliveryTypes.get("SELF") != null && deliveryTypes.get("SELF")) {
//                opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SHOP);
//            } else if (deliveryTypes.get("FEDX24") != null && deliveryTypes.get("FEDX24")) {
//                opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_FEDEX);
//            } else if (deliveryTypes.get("SF_AIR") != null && deliveryTypes.get("SF_AIR")) {
//                opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_AIR);
//            } else if (deliveryTypes.get("SF_LAND") != null && deliveryTypes.get("SF_LAND")) {
//                opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_LAND);
//            } else if (deliveryTypes.get("YTO") != null && deliveryTypes.get("YTO")) {
//                opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_YTO);
//            } else if (deliveryTypes.get("DEPPON") != null && deliveryTypes.get("DEPPON")) {
//                opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_DEPPON);
//            }
//        }
//
//        opSoPackage.setOpSoPackageSkuVOs(opSoPackageSkuVOs);
//        opSoPackageVOs.add(opSoPackage);
//        //设置包裹配送信息
//        opSoPackage.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
//        //设置订单关联包裹
//        opSalesOrderVO.setOpSoPackageVOs(opSoPackageVOs);
//
//        //服务费
//        opSalesOrderVO.setServiceFeeAmount(BigDecimal.valueOf(orderCreateVO.getService_fee()));
//        // 用户备注
//        opSalesOrderVO.setRemark(orderCreateVO.getNote());
//        // 订单类型，1渠道销售单2渠道退货单3渠道换货单4集团订单11礼品订单12样品订单
//        opSalesOrderVO.setSalesOrderType(OpSalesOrder.ORDER_TYPE_SALES);
//        // COUPON编码
//        opSalesOrderVO.setCouponCode(orderCreateVO.getCoupon_code());
//        //头折扣
//        opSalesOrderVO.setDiscountOnHead(BigDecimal.valueOf(orderCreateVO.getOther_discount()));
//        //礼品卡
//        opSalesOrderVO.setGiftCardDesc(orderCreateVO.getPresent_cards());
//        //礼品卡金额
//        if (orderCreateVO.getCardFee_discount() != null) {
//            opSalesOrderVO.setGiftCardAmount(BigDecimal.valueOf(orderCreateVO.getCardFee_discount()));
//        } else {
//            opSalesOrderVO.setGiftCardAmount(BigDecimal.ZERO);
//        }
//        //是否匿名
//        opSalesOrderVO.setIsAnonymous(
//                orderCreateVO.getAnonymous() ? OpSalesOrder.IS_ANONYMOUS_TRUE : OpSalesOrder.IS_ANONYMOUS_FALSE);
//        //预售拆包裹  TODO
//        final List<OpSoPackageVO> splitPackages = splitPackageNew(opSalesOrderVO, opChannel);
//        if (CollectionUtils.isNotEmpty(splitPackages)) {
//
////        	// 设置卡片
////        	for(OpSoPackageVO opSoPackageVO:splitPackages){
////        		
////        		List<OpSoPackageSkuVO> skuList = opSoPackageVO.getOpSoPackageSkuVOs();
////				if (CollectionUtils.isNotEmpty(skuList)) {
//
////					if (orderCreateVO.getIsGiftCard() != null
////							&& orderCreateVO.getIsGiftCard() == 1) {
////
////						for(OpSoPackageSkuVO sku:skuList){
////	        				
////	        				if(!StringUtils.isEmpty(sku.getCategoryCods()) && (sku.getCategoryCods().indexOf("102,")>=0 || sku.getCategoryCods().indexOf("101,")>=0 )){
////
////	        		            final OpSoPackageSkuVO packageSku = new OpSoPackageSkuVO();
////
////	        		            // 跨境购标注 0普通１跨境购
////	        		            packageSku.setCrossBorderFlag(opSoPackageVO.getCrossBorderFlag());
////
////	        		            packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);//默认会员添加
////	        		            packageSku.setSkuCode("101160538");//905160570
////
////	        		            packageSku.setIsJit(1);// 是否来单制作
////	        		            packageSku.setQuantity(1);//数量
////	        		          
////	        		            packageSku.setUnitPoint(BigDecimal.ZERO);//单品积分
////	        		           
////	        		            //判断是否包含两种以上配送方式，如果是，则需要强制审单
////	        		            packageSku.setUnitDiscount(BigDecimal.ZERO);
////	        		            
////	        		            // 折扣后金额
////	        		            packageSku.setUnitAmountAfterDiscount(
////	        		                    BigDecimal.ZERO);
////
////	        		            // 特价
////	        		            packageSku.setDiscountPrice(BigDecimal.ZERO);
////
////	        		  
////	        		            packageSku.setUnitPointDeduction(BigDecimal.ZERO);
////	        		            
////	        		            packageSku.setUnitPrice(BigDecimal.ZERO);
////	        	
////	        		            // 是否赠品，0否1是
////	        		            packageSku.setIsGift(1);//底层暂不支持赠品
////	        		            opSoPackageSkuVOs.add(packageSku);
////	        					
////	        					
////	        					skuList.add(packageSku);
////	        					break;
////	        					
////	        				}
////	        				
////	        			}
////						
////					}
////
////				}
////        		
////        	}
//
//            opSalesOrderVO.setOpSoPackageVOs(splitPackages);
//        }
//        return opSalesOrderVO;
//    }
//
//    /***
//     * 配送方式
//     *
//     * @param deliveryTypeStr
//     * @return
//     */
//    private static Integer getDeliveryType(final String deliveryTypeStr) {
//        if ("online-pick".equals(deliveryTypeStr)) {
//            return OpSoPackage.DELIVERY_TYPE_EXPRESS;//快递
//        }
//        return OpSoPackage.DELIVERY_TYPE_NOT_EXPRESS;//非快递
//    }
//
//    /***
//     * 根据用户等级。计算单价折扣
//     *
//     * @param unitPrice
//     * @param memberLevel
//     */
//    private static BigDecimal getUnitDiscount(final BigDecimal unitPrice, final Integer memberLevel,
//                                              final String giftCard, final BigDecimal salePrice) {
//        final BigDecimal unitDiscount;
//        if (StringUtils.isNotBlank(giftCard)) {
//
//            if (salePrice.doubleValue() > 0) {
//
//                // 特价折扣
//                unitDiscount = unitPrice.subtract(salePrice);
//
//                return unitDiscount;
//            } else {
//                return BigDecimal.ZERO;//礼品卡不打折
//            }
//
//        }
//
//        if (salePrice.doubleValue() > 0) {
//            final BigDecimal discountPrice = PriceUtil.getLevelPrice(salePrice, memberLevel);
//            // 特价折扣+会员折扣
//            unitDiscount = unitPrice.subtract(discountPrice);
//
//        } else {
//            final BigDecimal discountPrice = PriceUtil.getLevelPrice(unitPrice, memberLevel);
//
//            // 会员折扣
//            unitDiscount = unitPrice.subtract(discountPrice);
//        }
//
//        return unitDiscount;
//    }
//
//    /***
//     * 下单前的校验，校验积分、校验价格是否变化,校验库存是否不足
//     *
//     * @param orderCreateVO
//     * @return
//     */
//    private void orderPreCheck(final String channelCode, final OrderCreateVO orderCreateVO, final OpChannelVO opChannel) {
//        final List<OrderCreateDetailVO> details = orderCreateVO.getItems();
//        for (final OrderCreateDetailVO detail : details) {
//            //判断商品是否可售
//            final PsProductVO prod = mcPsProductService.findProdByChnCodeSkuCode(channelCode, detail.getSku());
//            if (prod == null || CollectionUtils.isEmpty(prod.getChnCanSaleSKu()) || !prod.getCanSaleSku(channelCode)
//                    .contains(detail.getSku())) {
//                throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(), ErrorCode.ITEM_OFFSHELF.getMesage());
//            }
//
//            final PsSkuVO psSkuVO = mcPsSkuService.findBySkuCode(detail.getSku());
//            detail.setIsJit(psSkuVO.getIsJit());//是否来单制作
//            //检查价格是否发生变化
//            //赠品不校验价格
//            if (PegasusConstants.YES != detail.getIsGift()
//                    && psSkuVO.getSalesPrice().compareTo(detail.getPrice()) != 0) {
//                throw new ChannelException(ErrorCode.ITEM_PRICE_CHANGE.getCode(),
//                        ErrorCode.ITEM_PRICE_CHANGE.getMesage() + ": " + psSkuVO.getSkuCode() + " " + psSkuVO
//                                .getSkuName() + ": " + psSkuVO.getSalesPrice());
//            }
//            //设置分类id和品牌id coupon使用
//            detail.setBrandId(psSkuVO.getBrandId());
//            detail.setCategroyId(psSkuVO.getCategoryId());
//            //JIT商品不校验库存
//            if (detail.getIsJit() == null || PegasusConstants.NO == detail.getIsJit()) {
//                //检查商品库存
//                final WhInvVO whInvVO = pwInstance
//                        .findCanUseQttBySkuCodeAndWarehouseCode(detail.getSku(), opChannel.getWarehouseForSales());
//                Integer quantity = whInvVO.getCanUseInv();
//                //增加预售判断。先判断物理库存，再判断预售库存，返回的库存为两个值之和 added by fs 20151127
//                final OpPresaleSaleInvVO preSaleVO = poInstance.findCanUseQttBySkuCode(detail.getSku(), null);
//                quantity += preSaleVO.getCanUseInv();
//                if (quantity < detail.getQuantity()) {
//                    throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
//                            ErrorCode.ITEM_OUTOF_QUANTITY.getMesage() + ": " + psSkuVO.getSkuCode() + " " + psSkuVO
//                                    .getSkuName() + ": " + whInvVO.getSkuCode());
//                }
//            }
//        }
//    }
//
//    /***
//     * 判断是否需要拆分包裹，
//     *
//     * @param opChannel
//     * @return
//     */
//    @Deprecated
//    private List<OpSoPackageVO> splitPackage(final OpSalesOrderVO opSalesOrderVO, final OpChannelVO opChannel) {
//        final List<OpSoPackageVO> preSalePackageVos;//预售的包裹集合
//        List<OpSoPackageVO> sourcesPackages;//初始包裹集合
//        final List<OpSoPackageSkuVO> sourcePackageSkus;//默认第一次进来的sku集合
//        final List<OpSoPackageSkuVO> giftPackageSkus;//赠品集合
//        final List<WhAllotRcdVO> whAllotList = new ArrayList<>(2);//待调拨列表 --一般是从正常销售仓 调拨到预售仓
//        if (opSalesOrderVO != null && CollectionUtils.isNotEmpty(opSalesOrderVO.getOpSoPackageVOs())
//                && opSalesOrderVO.getOpSoPackageVOs().size() == 1) {
//            preSalePackageVos = new ArrayList<>();//拆分后 新的包裹集合
//            sourcesPackages = opSalesOrderVO.getOpSoPackageVOs();//拆包裹之前 所有的包裹集合(实际上只有一个)
//            final OpSoPackageVO sourcesPackageVO = sourcesPackages.get(0);//初始包裹
//            sourcePackageSkus = sourcesPackageVO.getOpSoPackageSkuVOs();//包裹中的sku集合
//            giftPackageSkus = new ArrayList<>();
//            //重新取出所有的sku 重新分配包裹
//            if (CollectionUtils.isNotEmpty(sourcePackageSkus)) {
//                for (final OpSoPackageSkuVO packageSkuVO : sourcePackageSkus) {
//                    //判断是否是赠品
//                    if (StringUtils.isNotBlank(packageSkuVO.getMainSkuCode())) {
//                        packageSkuVO.setIsGift(PegasusConstants.YES);
//                        giftPackageSkus.add(packageSkuVO);
//                    }
//                    //默认给所有的sku设置发货仓 就是渠道对应的销售仓,如果是预售 后面会重新设置发货仓
//                    packageSkuVO.setDispatchWarehouseCode(opChannel.getWarehouseForSales());
//                    final OpPresaleVO presaleVO = poInstance.findAvaliableBySkuCode(packageSkuVO.getSkuCode());
//                    if (presaleVO != null) {
//                        //有预售。再判断物理库存是否可卖。
//                        //物理库存不足，则拆包裹，物理库存足够，则不拆包裹
//                        final WhInvVO whInvVO = pwInstance
//                                .findCanUseQttBySkuCodeAndWarehouseCode(packageSkuVO.getSkuCode(),
//                                        opChannel.getWarehouseForSales());
//                        final Integer quantity = whInvVO.getCanUseInv();
//                        final OpPresaleSaleInvVO preSaleInvVO = poInstance
//                                .findCanUseQttBySkuCode(packageSkuVO.getSkuCode(), null);
//                        final Integer preSaleQuantity = preSaleInvVO.getCanUseInv();
//                        if (packageSkuVO.getQuantity() > quantity && packageSkuVO.getQuantity() <= preSaleQuantity) {
//                            final OpSoPackageVO preSalePackage = new OpSoPackageVO();
//                            preSalePackage.setCardContent(sourcesPackageVO.getCardContent());
//                            preSalePackage.setCardType(sourcesPackageVO.getCardType());
//                            preSalePackage.setDeliveryType(sourcesPackageVO.getDeliveryType());
//                            preSalePackage.setDispatchWarehouseCode(presaleVO.getDispatchWarehouseCode());
//                            preSalePackage.setPlanedDeliveryDate(presaleVO.getPlanedDeliveryDate());
//                            preSalePackage.setDeliveryType(sourcesPackageVO.getDeliveryType());
////							preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//                            preSalePackage
//                                    .setOpSoPackageDeliveryInfoVO(sourcesPackageVO.getOpSoPackageDeliveryInfoVO());
//                            final List<OpSoPackageSkuVO> preSalePackageSkus = new ArrayList<>();
//                            packageSkuVO.setPresaleId(presaleVO.getId());
//                            packageSkuVO.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
//                            packageSkuVO.setDispatchWarehouseCode(presaleVO.getDispatchWarehouseCode());//冗余发货仓字段
//                            packageSkuVO.setPresaleVO(presaleVO);//冗余整个预售对象VO
//                            preSalePackageSkus.add(packageSkuVO);
//                            preSalePackage.setOpSoPackageSkuVOs(preSalePackageSkus);
//                            preSalePackageVos.add(preSalePackage);
//                        } else if (packageSkuVO.getQuantity() > quantity
//                                && packageSkuVO.getQuantity() > preSaleQuantity) {
//                            throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
//                                    ErrorCode.ITEM_OUTOF_QUANTITY.getMesage() + ": " + packageSkuVO.getSkuCode() + ": "
//                                            + whInvVO.getSkuCode());
//                        }
//                    }
//                }
//            }
//        } else {
//            throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
//        }
//        if (CollectionUtils.isNotEmpty(preSalePackageVos)) {
//            for (final OpSoPackageVO preSalePackage : preSalePackageVos) {
//                final List<OpSoPackageSkuVO> preSalePackageSkus = preSalePackage.getOpSoPackageSkuVOs();
//                if (CollectionUtils.isNotEmpty(preSalePackageSkus)) {
//                    sourcePackageSkus.removeAll(preSalePackageSkus);
//                }
//            }
//            sourcesPackages.addAll(preSalePackageVos);
//        }
//        //先从之前拆好的包裹中，删除所有的赠品，重新将赠品sku 绑定到主商品的package中
//        if (CollectionUtils.isNotEmpty(giftPackageSkus)) {
//            for (final OpSoPackageSkuVO giftSku : giftPackageSkus) {
//                for (final OpSoPackageVO sourcePackage : sourcesPackages) {
//                    if (null != sourcePackage) {
//                        final List<OpSoPackageSkuVO> sourcePackageSkusList = sourcePackage.getOpSoPackageSkuVOs();
//                        if (CollectionUtils.isNotEmpty(sourcePackageSkusList)) {
//                            final Iterator<OpSoPackageSkuVO> packageSkuVOIt = sourcePackageSkusList.iterator();
//                            while (packageSkuVOIt.hasNext()) {
//                                final OpSoPackageSkuVO tmpPackageSkuVO = packageSkuVOIt.next();
//                                if (giftSku.getSkuCode().equals(tmpPackageSkuVO.getSkuCode())) {
//                                    packageSkuVOIt.remove();
//                                }
//                            }
//                        }
//                    }
//                }
//            }
//        }
//        //将赠品和主商品放在一个包裹
//        //重新分配包裹
//        final List<OpSoPackageVO> reSplitSourcesPackages = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(giftPackageSkus)) {
//            for (final OpSoPackageVO sourcePackage : sourcesPackages) {
//                if (sourcePackage != null && CollectionUtils.isNotEmpty(sourcePackage.getOpSoPackageSkuVOs())) {
//                    final List<OpSoPackageSkuVO> sourcePackageSkusList = sourcePackage.getOpSoPackageSkuVOs();
//                    final List<OpSoPackageSkuVO> reSplitSourcePackageSkusList = new ArrayList<>();
//                    for (final OpSoPackageSkuVO tmpPackageSkuVO : sourcePackageSkusList) {
//                        for (final OpSoPackageSkuVO giftSku : giftPackageSkus) {
//                            if (giftSku.getMainSkuCode().equals(tmpPackageSkuVO.getSkuCode())) {
//                                reSplitSourcePackageSkusList.add(giftSku);
//                                //如果主品是预售，赠品不是预售，需要生产赠品的调拨，将赠品从正常销售仓，调拨到预售仓
//                                if (tmpPackageSkuVO.getPresaleId() != null && tmpPackageSkuVO.getPresaleId() > 0
//                                        && giftSku.getPresaleId() == null) {
//                                    final WhAllotRcdVO whAllotVO = new WhAllotRcdVO();
//                                    whAllotVO.setPlanAmount(giftSku.getQuantity());
//                                    whAllotVO.setSkuCode(giftSku.getSkuCode());
//                                    whAllotVO.setSourceWarehouseCode(giftSku.getDispatchWarehouseCode());
//                                    whAllotVO.setTargetWarehouseCode(tmpPackageSkuVO.getDispatchWarehouseCode());
//                                    whAllotList.add(whAllotVO);
//                                }
//                            }
//                        }
//                        reSplitSourcePackageSkusList.add(tmpPackageSkuVO);
//                    }
//                    sourcePackage.setOpSoPackageSkuVOs(reSplitSourcePackageSkusList);
//                    reSplitSourcesPackages.add(sourcePackage);
//                }
//            }
//
//        }
//        if (CollectionUtils.isNotEmpty(reSplitSourcesPackages)) {
//            sourcesPackages = reSplitSourcesPackages;
//        }
//        //删掉分包裹之后的空包裹
//        final List<OpSoPackageVO> emptyPackages = new ArrayList<>();
//        for (final OpSoPackageVO emptyPackage : sourcesPackages) {
//            if (emptyPackage == null || CollectionUtils.isEmpty(emptyPackage.getOpSoPackageSkuVOs())) {
//                emptyPackages.add(emptyPackage);
//            }
//        }
//        if (CollectionUtils.isNotEmpty(emptyPackages)) {
//            sourcesPackages.removeAll(emptyPackages);
//        }
//        //设置订单对应的调拨
//        if (CollectionUtils.isNotEmpty(whAllotList)) {
//            opSalesOrderVO.setWhAllotList(whAllotList);
//        }
//
//        return sourcesPackages;
//    }
//
//    /***
//     * 普通商品放在一个单独的包裹
//     * 1 合并包裹逻辑
//     * 为了保证主品和赠品同时发货、下述情况系统将自动将主品和赠品进行包裹的处理
//     * ① 主品（现货）+赠品（现货）
//     * 包裹发货仓：[WH020600010102]元电路 – 官网渠道销售仓
//     * ② 主品（预售）+赠品（现货）
//     * 自动合并包裹
//     * 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓
//     * 预计发货时间：预售品的计划发货时间
//     * ③ 主品（现货）+赠品（预售）
//     * 赠品单独拆除包裹
//     * 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓
//     * 赠品包裹包裹预计发货时间：预售品的计划发货时间
//     * ④ 主品（预售）+赠品（预售）
//     * a)主品预售预计发货时间<赠品预售预计发货时间: 拆 两个包裹
//     * 包裹预计发货时间：各自预售的预计发货时间
//     * 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓
//     * b)主品预售预计发货时间>赠品预售预计发货时间: 合并包裹
//     * 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓
//     * 包裹预计发货时间：主品预售预计发货时间
//     * <p/>
//     * /***
//     * 判断是否需要拆分包裹，
//     *
//     * @param opChannel
//     * @return
//     */
//    public List<OpSoPackageVO> splitPackageNew(final OpSalesOrderVO opSalesOrderVO, final OpChannelVO opChannel) {
//
//        final BigDecimal crossfinalFee=BigDecimal.valueOf(1000);
//
//        final List<OpSoPackageVO> allPackageVOs = new ArrayList<>(4);//所有的包裹集合
//        final List<OpSoPackageVO> preSalePackageVOs = new ArrayList<>(2);//预售的商品
//
//        final List<OpSoPackageSkuVO> defaultPackageSkuVOs = new ArrayList<>(2);//默认包裹的sku集合
//
//        List<OpSoPackageSkuVO> crossSalePackageSkus = new ArrayList<>();//海淘默认包裹的sku集合
//        // 海淘包裹集
//        final List<List<OpSoPackageSkuVO>> crossSalePackages= new ArrayList<>();
//        // 海淘总费用
//        BigDecimal crossPackageTotalFee = BigDecimal.ZERO;
//
//        final List<WhAllotRcdVO> whAllotList = new ArrayList<>(2);//待调拨列表 --一般是从正常销售仓 调拨到预售仓
//
//        final List<OpSoPackageVO> sourcesPackages = opSalesOrderVO.getOpSoPackageVOs();//初始包裹集合
//        //原始订单中 包裹集合只有一个
//        if (!CollectionUtils.isNotEmpty(sourcesPackages) || sourcesPackages.size() != 1) {
//            //原始订单中，包裹数量不等于1
//            throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
//        }
//
//        final OpSoPackageVO sourcePackageVO = sourcesPackages.get(0);//默认的包裹对象
//        final List<OpSoPackageSkuVO> sourcePackageSkus = sourcePackageVO.getOpSoPackageSkuVOs();//为拆包裹之前 原始包裹中的sku集合
//        if (!CollectionUtils.isNotEmpty(sourcePackageSkus)) {
//            //原始订单包裹中商品为空
//            throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
//        }
//
//        final List<OpSoPackageSkuVO> noneGiftPackageSkuVOs = getAllNoneGiftPackageSkuVOs(opChannel, sourcePackageSkus);
//        final List<OpSoPackageSkuVO> giftPackageSkuVOs = getAllGiftPackageSkuVOs(opChannel, sourcePackageSkus);
//
//        final OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO = sourcePackageVO.getOpSoPackageDeliveryInfoVO();
//
//
//        // 海淘1000块标准拆单
//        List<OpSoPackageSkuVO> crossSaleSkus = null;
//
//        BigDecimal crossSkuFee = BigDecimal.ZERO;
//
//        OpSoPackageSkuVO skuVOspit= null;
//
//        boolean giftbool = false;
//
//        for (final OpSoPackageSkuVO skuVO : noneGiftPackageSkuVOs) {
//
//            // ztq 20160517  海淘商品拆包裹 start
//            if (skuVO.getCrossBorderFlag() != null
//                    && skuVO.getCrossBorderFlag() == OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA) {
//
//                BigDecimal skuFee = skuVO.getUnitAmountAfterDiscount().multiply(BigDecimal.valueOf(skuVO.getQuantity()));
//                // 判断价格是否大于2000
//                if(skuFee.compareTo(crossfinalFee)<0){
//                    crossSalePackageSkus.add(skuVO);
//                    if(skuFee.add(crossPackageTotalFee).compareTo(crossfinalFee)<0){
//                        // 计算海淘商品总价格
//                        crossPackageTotalFee = crossPackageTotalFee.add(skuVO.getUnitAmountAfterDiscount().multiply(BigDecimal.valueOf(skuVO.getQuantity())));
//                    }else{
//                        crossSalePackages.add(crossSalePackageSkus);
//                        crossSalePackageSkus = new ArrayList<>();
//                        crossPackageTotalFee = skuFee;
//                    }
//
//                }else{
//
//                    // 当同一商品购买多件时
//                    if(skuVO.getQuantity()!=null && skuVO.getQuantity()>1){
//
//                        // 商品单价大于1000时
//                        if(skuVO.getUnitAmountAfterDiscount().compareTo(crossfinalFee)>=0){
//
//                            for(int i=0;i<skuVO.getQuantity();i++){
//                                crossSaleSkus = new ArrayList<>();
//
//                                if(i==0){
//                                    //判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
//                                    final OpSoPackageSkuVO giftSkuVO = getGiftSkuByMainSkuCode(skuVO.getSkuCode(), giftPackageSkuVOs);
//                                    if (giftSkuVO != null) {
//                                        //如果带赠品，但是主品不预售，赠品也不预售，则赠品和主品在一个包裹
//                                        if (!isPresale(opChannel, giftSkuVO)) {
//                                            crossSaleSkus.add(giftSkuVO);
//
//                                        } else {
//                                            //如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
//                                            final List<OpSoPackageSkuVO> preSalePackageSkuVOs = new ArrayList<>(2);//预售的包裹sku集合
//                                            preSalePackageSkuVOs.add(giftSkuVO);
//                                            final OpSoPackageVO preSalePackageVo = new OpSoPackageVO();//预售的包裹
//                                            preSalePackageVo.setCardContent(sourcePackageVO.getCardContent());
//                                            preSalePackageVo.setCardType(sourcePackageVO.getCardType());
//                                            preSalePackageVo.setDeliveryType(sourcePackageVO.getDeliveryType());
//                                            final OpPresaleVO presellVO = giftSkuVO.getPresaleVO();
//                                            preSalePackageVo.setDispatchWarehouseCode(presellVO.getDispatchWarehouseCode());
//                                            preSalePackageVo.setPlanedDeliveryDate(presellVO.getPlanedDeliveryDate());
////            											preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//                                            preSalePackageVo.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
//                                            preSalePackageVo.setOpSoPackageSkuVOs(preSalePackageSkuVOs);
//                                            preSalePackageVOs.add(preSalePackageVo);
//                                        }
//                                    }
//
//                                }
//
//
//                                skuVOspit = new OpSoPackageSkuVO();
//                                BeanUtils.copyProperties(skuVO, skuVOspit);
//                                skuVOspit.setQuantity(1);
//                                crossSaleSkus.add(skuVOspit);
//                                crossSalePackages.add(crossSaleSkus);
//
//                            }
//
//                        }else{
//
//                            int count=0;
//                            for(int i=0;i<skuVO.getQuantity();i++){
//                                // 判断赠品
//                                if(i==0){
//                                    crossSaleSkus = new ArrayList<>();
//                                    giftbool = true;
//                                    //判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
//                                    final OpSoPackageSkuVO giftSkuVO = getGiftSkuByMainSkuCode(skuVO.getSkuCode(), giftPackageSkuVOs);
//                                    if (giftSkuVO != null) {
//                                        //如果带赠品，但是主品不预售，赠品也不预售，则赠品和主品在一个包裹
//                                        if (!isPresale(opChannel, giftSkuVO)) {
//                                            crossSaleSkus.add(giftSkuVO);
//
//                                        } else {
//                                            //如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
//                                            final List<OpSoPackageSkuVO> preSalePackageSkuVOs = new ArrayList<>(2);//预售的包裹sku集合
//                                            preSalePackageSkuVOs.add(giftSkuVO);
//                                            final OpSoPackageVO preSalePackageVo = new OpSoPackageVO();//预售的包裹
//                                            preSalePackageVo.setCardContent(sourcePackageVO.getCardContent());
//                                            preSalePackageVo.setCardType(sourcePackageVO.getCardType());
//                                            preSalePackageVo.setDeliveryType(sourcePackageVO.getDeliveryType());
//                                            final OpPresaleVO presellVO = giftSkuVO.getPresaleVO();
//                                            preSalePackageVo.setDispatchWarehouseCode(presellVO.getDispatchWarehouseCode());
//                                            preSalePackageVo.setPlanedDeliveryDate(presellVO.getPlanedDeliveryDate());
////            											preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//                                            preSalePackageVo.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
//                                            preSalePackageVo.setOpSoPackageSkuVOs(preSalePackageSkuVOs);
//                                            preSalePackageVOs.add(preSalePackageVo);
//                                        }
//                                    }
//                                }
//
//                                count++;
//                                crossSkuFee = skuVO.getUnitAmountAfterDiscount().multiply(BigDecimal.valueOf(count));
//
//                                // 大于1000时生成一个包裹
//                                if(crossSkuFee.compareTo(crossfinalFee)>=0){
//                                    if(!giftbool){
//                                        crossSaleSkus = new ArrayList<>();
//                                    }
//
//                                    skuVOspit = new OpSoPackageSkuVO();
//                                    BeanUtils.copyProperties(skuVO, skuVOspit);
//                                    skuVOspit.setQuantity(count-1);
//                                    crossSaleSkus.add(skuVOspit);
//                                    crossSalePackages.add(crossSaleSkus);
//                                    giftbool=false;
//                                    count = 0;
//                                    i = i - 1;
//                                }else{
//                                    // 最后一个商品
//                                    if(i==skuVO.getQuantity()-1){
//                                        if(!giftbool){
//                                            crossSaleSkus = new ArrayList<>();
//                                        }
//                                        crossSaleSkus = new ArrayList<>();
//                                        skuVOspit = new OpSoPackageSkuVO();
//                                        BeanUtils.copyProperties(skuVO, skuVOspit);
//                                        skuVOspit.setQuantity(count);
//                                        crossSaleSkus.add(skuVOspit);
//                                        crossSalePackages.add(crossSaleSkus);
//                                        giftbool=false;
//
//                                    }
//                                }
//
//
//                            }
//                        }
//
//
//
////            				 crossSalePackageSkus = new ArrayList<>();
////            				 crossPackageTotalFee = BigDecimal.ZERO;
//
//                        continue;
//                    }else{
//                        crossSaleSkus = new ArrayList<>();
//                        crossSaleSkus.add(skuVO);
//                        crossSalePackages.add(crossSaleSkus);
//                        //crossSalePackageSkus = new ArrayList<>();
//                        //crossPackageTotalFee = BigDecimal.ZERO;
//                    }
//
//
//                }
//
//                //判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
//                final OpSoPackageSkuVO giftSkuVO = getGiftSkuByMainSkuCode(skuVO.getSkuCode(), giftPackageSkuVOs);
//                if (giftSkuVO != null) {
//                    //如果带赠品，但是主品不预售，赠品也不预售，则赠品和主品在一个包裹
//                    if (!isPresale(opChannel, giftSkuVO)) {
//                        crossSalePackageSkus.add(giftSkuVO);
//                    } else {
//                        //如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
//                        final List<OpSoPackageSkuVO> preSalePackageSkuVOs = new ArrayList<>(2);//预售的包裹sku集合
//                        preSalePackageSkuVOs.add(giftSkuVO);
//                        final OpSoPackageVO preSalePackageVo = new OpSoPackageVO();//预售的包裹
//                        preSalePackageVo.setCardContent(sourcePackageVO.getCardContent());
//                        preSalePackageVo.setCardType(sourcePackageVO.getCardType());
//                        preSalePackageVo.setDeliveryType(sourcePackageVO.getDeliveryType());
//                        final OpPresaleVO presellVO = giftSkuVO.getPresaleVO();
//                        preSalePackageVo.setDispatchWarehouseCode(presellVO.getDispatchWarehouseCode());
//                        preSalePackageVo.setPlanedDeliveryDate(presellVO.getPlanedDeliveryDate());
////								preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//                        preSalePackageVo.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
//                        preSalePackageVo.setOpSoPackageSkuVOs(preSalePackageSkuVOs);
//                        preSalePackageVOs.add(preSalePackageVo);
//                    }
//                }
//
//                continue;
//            }
//            //非赠品
//            if (isPresale(opChannel, skuVO)) {
//                //如果主商品是预售，同时赠品不是预售，则产生一个调拨，
//                final List<OpSoPackageSkuVO> preSalePackageSkuVOs = new ArrayList<>(2);//预售的包裹sku集合
//                preSalePackageSkuVOs.add(skuVO);
//
//                final OpSoPackageVO preSalePackageVo = new OpSoPackageVO();//预售的包裹
//                preSalePackageVo.setCardContent(sourcePackageVO.getCardContent());
//                preSalePackageVo.setCardType(sourcePackageVO.getCardType());
//                preSalePackageVo.setDeliveryType(sourcePackageVO.getDeliveryType());
//                preSalePackageVo.setDispatchWarehouseCode(skuVO.getPresaleVO().getDispatchWarehouseCode());
//                preSalePackageVo.setPlanedDeliveryDate(skuVO.getPresaleVO().getPlanedDeliveryDate());
//                preSalePackageVo.setDeliveryType(sourcePackageVO.getDeliveryType());
////						preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//                preSalePackageVo.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
//                preSalePackageVo.setOpSoPackageSkuVOs(preSalePackageSkuVOs);
//
//                //判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
//                final OpSoPackageSkuVO giftSkuVO = getGiftSkuByMainSkuCode(skuVO.getSkuCode(), giftPackageSkuVOs);
//                if (giftSkuVO != null) {
//                    //判断赠品是否是预售
//                    if (isPresale(opChannel, giftSkuVO)) {
//                        //如果主品和赠品都是预售
//                        final Date mainSkuPlanedDate = skuVO.getPresaleVO().getPlanedDeliveryDate();
//                        final Date giftSkuPlanedDate = giftSkuVO.getPresaleVO().getPlanedDeliveryDate();
//                        if (mainSkuPlanedDate.before(giftSkuPlanedDate)) {
//                            //主品预计发货时间早 赠品预计发货时间晚  拆成两单
//                            final List<OpSoPackageSkuVO> preSalePackageGiftSkuVOs = new ArrayList<>(2);//预售的包裹sku集合
//                            preSalePackageGiftSkuVOs.add(giftSkuVO);
//
//                            final OpSoPackageVO preSalePackageGiftVO = new OpSoPackageVO();//预售的包裹
//                            preSalePackageGiftVO.setCardContent(sourcePackageVO.getCardContent());
//                            preSalePackageGiftVO.setCardType(sourcePackageVO.getCardType());
//                            preSalePackageGiftVO.setDeliveryType(sourcePackageVO.getDeliveryType());
//                            preSalePackageGiftVO
//                                    .setDispatchWarehouseCode(giftSkuVO.getPresaleVO().getDispatchWarehouseCode());
//                            preSalePackageGiftVO
//                                    .setPlanedDeliveryDate(giftSkuVO.getPresaleVO().getPlanedDeliveryDate());
//                            preSalePackageGiftVO.setDeliveryType(sourcePackageVO.getDeliveryType());
////	    								preSalePackageGiftVO.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//                            preSalePackageGiftVO
//                                    .setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
//                            preSalePackageGiftVO.setOpSoPackageSkuVOs(preSalePackageGiftSkuVOs);
//                            preSalePackageVOs.add(preSalePackageGiftVO);
//
//                        } else {
//                            //主品预计发货时间晚 赠品预计发货时间早  合在一个订单 预计发货时间是主品的发货时间
//                            preSalePackageSkuVOs.add(giftSkuVO);
//                        }
//                    } else {
//                        //赠品不是预售，则将赠品和预售的主品放在一个包裹,同时将赠品产生一条调拨
//                        final WhAllotRcdVO whAllotVO = new WhAllotRcdVO();
//                        whAllotVO.setPlanAmount(giftSkuVO.getQuantity());
//                        whAllotVO.setSkuCode(giftSkuVO.getSkuCode());
//                        whAllotVO.setSourceWarehouseCode(giftSkuVO.getDispatchWarehouseCode());
//                        whAllotVO.setTargetWarehouseCode(skuVO.getDispatchWarehouseCode());
//                        whAllotList.add(whAllotVO);
//                        preSalePackageSkuVOs.add(giftSkuVO);//将赠品和主品放在一个包裹
//                    }
//                }
//                preSalePackageVOs.add(preSalePackageVo);
//            } else {
//                //非赠品并且不是预售
//                defaultPackageSkuVOs.add(skuVO);
//                //判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
//                final OpSoPackageSkuVO giftSkuVO = getGiftSkuByMainSkuCode(skuVO.getSkuCode(), giftPackageSkuVOs);
//                if (giftSkuVO != null) {
//                    if (isPresale(opChannel, giftSkuVO)) {
//                        //如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
//                        final List<OpSoPackageSkuVO> preSalePackageSkuVOs = new ArrayList<>(2);//预售的包裹sku集合
//                        preSalePackageSkuVOs.add(giftSkuVO);
//                        final OpSoPackageVO preSalePackageVo = new OpSoPackageVO();//预售的包裹
//                        preSalePackageVo.setCardContent(sourcePackageVO.getCardContent());
//                        preSalePackageVo.setCardType(sourcePackageVO.getCardType());
//                        preSalePackageVo.setDeliveryType(sourcePackageVO.getDeliveryType());
//                        preSalePackageVo.setDispatchWarehouseCode(giftSkuVO.getPresaleVO().getDispatchWarehouseCode());
//                        preSalePackageVo.setPlanedDeliveryDate(giftSkuVO.getPresaleVO().getPlanedDeliveryDate());
//                        preSalePackageVo.setDeliveryType(sourcePackageVO.getDeliveryType());
////								preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//                        preSalePackageVo.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
//                        preSalePackageVo.setOpSoPackageSkuVOs(preSalePackageSkuVOs);
//                        preSalePackageVOs.add(preSalePackageVo);
//                    } else {
//                        //如果带赠品，但是主品不预售，赠品也不预售，则赠品和主平在一个包裹
//                        defaultPackageSkuVOs.add(giftSkuVO);
//                    }
//                }
//            }
//        }// for noneGiftPackageSkuVOs
//
//        // 海淘包裹
//        if (CollectionUtils.isNotEmpty(crossSalePackageSkus)) {
//
//
//            final OpSoPackageVO crossSalePackage = new OpSoPackageVO();
//            crossSalePackage.setOpSoPackageSkuVOs(crossSalePackageSkus);
//            crossSalePackage.setCardContent(sourcePackageVO.getCardContent());
//            crossSalePackage.setCardType(sourcePackageVO.getCardType());
//            crossSalePackage.setDeliveryType(sourcePackageVO.getDeliveryType());
//            // 海淘包裹
//            crossSalePackage.setCrossBorderFlag(OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA);
//            crossSalePackage.setDispatchWarehouseCode(sourcePackageVO.getDispatchWarehouseCode());
//            crossSalePackage.setPlanedDeliveryDate(sourcePackageVO.getPlanedDeliveryDate());
//
////						preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//
//            if (opSoPackageDeliveryInfoVO != null) {
//
//                OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVOCross = new OpSoPackageDeliveryInfoVO();
//                opSoPackageDeliveryInfoVOCross.setAddress(opSoPackageDeliveryInfoVO.getAddress());
//                opSoPackageDeliveryInfoVOCross.setCircuitDesc(opSoPackageDeliveryInfoVO.getCircuitDesc());
//                opSoPackageDeliveryInfoVOCross.setCity(opSoPackageDeliveryInfoVO.getCity());
//                opSoPackageDeliveryInfoVOCross.setCompanyName(opSoPackageDeliveryInfoVO.getCompanyName());
//                opSoPackageDeliveryInfoVOCross.setDeliveryCode(opSoPackageDeliveryInfoVO.getDeliveryCode());
//                opSoPackageDeliveryInfoVOCross.setDistrict(opSoPackageDeliveryInfoVO.getDistrict());
//                opSoPackageDeliveryInfoVOCross.setDistrictId(opSoPackageDeliveryInfoVO.getDistrictId());
//                // 海淘专用
//                opSoPackageDeliveryInfoVOCross.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_HT);
//                opSoPackageDeliveryInfoVOCross.setProvince(opSoPackageDeliveryInfoVO.getProvince());
//                opSoPackageDeliveryInfoVOCross.setReceiver(opSoPackageDeliveryInfoVO.getReceiver());
//                opSoPackageDeliveryInfoVOCross.setReceiverPhone(opSoPackageDeliveryInfoVO.getReceiverPhone());
//                opSoPackageDeliveryInfoVOCross.setTitle(opSoPackageDeliveryInfoVO.getTitle());
//                opSoPackageDeliveryInfoVOCross.setZipCode(opSoPackageDeliveryInfoVO.getZipCode());
//
//
//                crossSalePackage.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVOCross);
//            }
//
//
//
//            //preSalePackageVOs.add(crossSalePackage);
//            allPackageVOs.add(crossSalePackage);
//        }
//
//        // 海淘多个包裹的时候
//        if(CollectionUtils.isNotEmpty(crossSalePackages)){
//
//            for(List<OpSoPackageSkuVO> list:crossSalePackages ){
//
//                final OpSoPackageVO crossSalePackage = new OpSoPackageVO();
//                crossSalePackage.setOpSoPackageSkuVOs(list);
//                crossSalePackage.setCardContent(sourcePackageVO.getCardContent());
//                crossSalePackage.setCardType(sourcePackageVO.getCardType());
//                crossSalePackage.setDeliveryType(sourcePackageVO.getDeliveryType());
//                // 海淘包裹
//                crossSalePackage.setCrossBorderFlag(OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA);
//                crossSalePackage.setDispatchWarehouseCode(sourcePackageVO.getDispatchWarehouseCode());
//                crossSalePackage.setPlanedDeliveryDate(sourcePackageVO.getPlanedDeliveryDate());
//
//                if (opSoPackageDeliveryInfoVO != null) {
//
//                    OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVOCross = new OpSoPackageDeliveryInfoVO();
//                    opSoPackageDeliveryInfoVOCross.setAddress(opSoPackageDeliveryInfoVO.getAddress());
//                    opSoPackageDeliveryInfoVOCross.setCircuitDesc(opSoPackageDeliveryInfoVO.getCircuitDesc());
//                    opSoPackageDeliveryInfoVOCross.setCity(opSoPackageDeliveryInfoVO.getCity());
//                    opSoPackageDeliveryInfoVOCross.setCompanyName(opSoPackageDeliveryInfoVO.getCompanyName());
//                    opSoPackageDeliveryInfoVOCross.setDeliveryCode(opSoPackageDeliveryInfoVO.getDeliveryCode());
//                    opSoPackageDeliveryInfoVOCross.setDistrict(opSoPackageDeliveryInfoVO.getDistrict());
//                    opSoPackageDeliveryInfoVOCross.setDistrictId(opSoPackageDeliveryInfoVO.getDistrictId());
//                    // 海淘专用
//                    opSoPackageDeliveryInfoVOCross.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_HT);
//                    opSoPackageDeliveryInfoVOCross.setProvince(opSoPackageDeliveryInfoVO.getProvince());
//                    opSoPackageDeliveryInfoVOCross.setReceiver(opSoPackageDeliveryInfoVO.getReceiver());
//                    opSoPackageDeliveryInfoVOCross.setReceiverPhone(opSoPackageDeliveryInfoVO.getReceiverPhone());
//                    opSoPackageDeliveryInfoVOCross.setTitle(opSoPackageDeliveryInfoVO.getTitle());
//                    opSoPackageDeliveryInfoVOCross.setZipCode(opSoPackageDeliveryInfoVO.getZipCode());
//
//
//                    crossSalePackage.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVOCross);
//                }
//
//                //preSalePackageVOs.add(crossSalePackage);
//                allPackageVOs.add(crossSalePackage);
//
//
//            }
//
//        }
//
//
//        if (CollectionUtils.isNotEmpty(defaultPackageSkuVOs)) {
//            sourcePackageVO.setOpSoPackageSkuVOs(defaultPackageSkuVOs);
//            allPackageVOs.add(sourcePackageVO);
//        }
//        if (CollectionUtils.isNotEmpty(preSalePackageVOs)) {
//            allPackageVOs.addAll(preSalePackageVOs);
//        }
//        //设置订单对应的调拨
//        if (CollectionUtils.isNotEmpty(whAllotList)) {
//            opSalesOrderVO.setWhAllotList(whAllotList);
//        }
//
//        return allPackageVOs;
//    }
//
//    /***
//     * 查询出所有的非赠品，包含普通商品、已经买赠的主商品 (包含了预售)
//     *
//     * @param sourcePackageVOs
//     * @return
//     */
//    private static List<OpSoPackageSkuVO> getAllNoneGiftPackageSkuVOs(final OpChannelVO opChannel,
//                                                                      final List<OpSoPackageSkuVO> sourcePackageVOs) {
//        final String warehouseCode = opChannel.getWarehouseForSales();
//        final List<OpSoPackageSkuVO> noneGiftPackageSkuVOs = new ArrayList<>(2);//默认包裹的sku集合
//        for (final OpSoPackageSkuVO skuVO : sourcePackageVOs) {
//            if (StringUtils.isBlank(skuVO.getMainSkuCode())) {
//                skuVO.setDispatchWarehouseCode(warehouseCode);//冗余发货仓字段，调拨时使用
//                noneGiftPackageSkuVOs.add(skuVO);
//            }
//        }
//        return noneGiftPackageSkuVOs;
//    }
//
//    /***
//     * 查询出所有的赠品(包含预售的赠品)
//     *
//     * @param sourcePackageVOs
//     * @return
//     */
//    private static List<OpSoPackageSkuVO> getAllGiftPackageSkuVOs(final OpChannelVO opChannel,
//                                                                  final List<OpSoPackageSkuVO> sourcePackageVOs) {
//        final List<OpSoPackageSkuVO> giftPackageSkuVOs = new ArrayList<>(2);//默认包裹的sku集合
//        for (final OpSoPackageSkuVO skuVO : sourcePackageVOs) {
//            if (StringUtils.isNotBlank(skuVO.getMainSkuCode())) {
//                skuVO.setIsGift(PegasusConstants.YES);
//                skuVO.setDispatchWarehouseCode(opChannel.getWarehouseForSales());//冗余发货仓字段，调拨时使用
//                giftPackageSkuVOs.add(skuVO);
//            }
//        }
//        return giftPackageSkuVOs;
//    }
//
//    private static OpSoPackageSkuVO getGiftSkuByMainSkuCode(final String mainSkuCode,
//                                                            final List<OpSoPackageSkuVO> giftPackageSkuVOs) {
//        if (CollectionUtils.isEmpty(giftPackageSkuVOs)) {
//            return null;
//        }
//        for (final OpSoPackageSkuVO giftSkuVO : giftPackageSkuVOs) {
//            if (mainSkuCode.equals(giftSkuVO.getMainSkuCode())) {
//                return giftSkuVO;
//            }
//        }
//        return null;
//    }
//
//    /***
//     * 判断是否是预售，如果是预售
//     *
//     * @param skuVO
//     * @return
//     */
//    private boolean isPresale(final OpChannelVO opChannel, final OpSoPackageSkuVO skuVO) {
//        boolean isPresale = false;
//        final OpPresaleVO presaleVO = poInstance.findAvaliableBySkuCode(skuVO.getSkuCode());
//        if (presaleVO != null) {
//            //有预售。再判断物理库存是否可卖。
//            //物理库存不足，则拆包裹，物理库存足够，则不拆包裹
//            final WhInvVO whInvVO = pwInstance
//                    .findCanUseQttBySkuCodeAndWarehouseCode(skuVO.getSkuCode(), opChannel.getWarehouseForSales());
//            final Integer quantity = whInvVO.getCanUseInv();
//            final OpPresaleSaleInvVO preSaleInvVO = poInstance.findCanUseQttBySkuCode(skuVO.getSkuCode(), null);
//            final Integer preSaleQuantity = preSaleInvVO.getCanUseInv();
//            if (skuVO.getQuantity() > quantity && skuVO.getQuantity() <= preSaleQuantity) {
//
//                skuVO.setPresaleId(presaleVO.getId());
//                skuVO.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
//                skuVO.setDispatchWarehouseCode(presaleVO.getDispatchWarehouseCode());//冗余发货仓字段
//                skuVO.setPresaleVO(presaleVO);//冗余整个预售对象VO
//                isPresale = true;
//            } else if (skuVO.getQuantity() > quantity && skuVO.getQuantity() > preSaleQuantity) {
//                throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
//                        ErrorCode.ITEM_OUTOF_QUANTITY.getMesage() + ": " + skuVO.getSkuCode() + ": " + whInvVO
//                                .getSkuCode());
//            }
//        }
//        return isPresale;
//    }
}
