package com.thebeastshop.pegasus.channelservice.adapter.website;

import javax.annotation.Resource;

import com.thebeastshop.commdata.service.CommAddressService;
import com.thebeastshop.commdata.vo.CommDistrictVO;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.member.enums.ConstellationTypeEnum;
import com.thebeastshop.member.enums.DegreeTypeEnum;
import com.thebeastshop.member.enums.LoginTypeEnum;
import com.thebeastshop.member.enums.TitleEnum;
import com.thebeastshop.member.service.point.MemberPointService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.member.vo.point.MemberPointVO;
import com.thebeastshop.pegasus.channelservice.vo.website.user.UserProfileVO;
import com.thebeastshop.pegasus.channelservice.vo.website.user.UserQueryVO;

/***
 * 用户相关adapter
 * @author fs
 *
 */
@Service("memberAdapter")
public class MemberAdapter {
	@Resource
    private MemberPointService memberPointService;

	@Autowired
	private CommAddressService commAddressService;
	
	/***
	 * 通用用户转换成官网接口
	 * @param opMemberVO
	 * @return
	 */
	public UserQueryVO common2website(MemberVO opMemberVO){
		return common2website(opMemberVO, null);
	}
	
	/***
	 * 通用用户转换成官网接口
	 * @param opMemberVO
	 * @param loginType
	 * @return
	 */
	public UserQueryVO common2website(MemberVO opMemberVO, Integer loginType){
		MemberPointVO memberPointVO = memberPointService.getMemberPointVO(opMemberVO.getId(), opMemberVO.getCode());
		UserQueryVO userVO=new UserQueryVO();
		userVO.setAvatar(opMemberVO.getAvatarUrl());
		userVO.setConstellation(ConstellationTypeEnum.getEnumByCode(opMemberVO.getConstellation()).getName_en());
		userVO.setCust_level(getCustLevel(opMemberVO.getMemberLevel()));
		userVO.setMemberLevel(opMemberVO.getMemberLevel());
		userVO.setDegree(DegreeTypeEnum.getEnumByCode(opMemberVO.getDegree()).getName_en());
		userVO.setEmail(opMemberVO.getEmail());
		userVO.setIdentity_type(getIdentityType(loginType));
		userVO.setMagento_phone(opMemberVO.getPhone());
		userVO.setMember_point(memberPointVO.getCommonMemberPointValid().doubleValue());
		userVO.setHistory_point(memberPointVO.getExpirelevelMemberPoint().doubleValue());
		userVO.setMobile(opMemberVO.getMobile());
		userVO.setPartner_id(opMemberVO.getId());
		userVO.setMemberCode(opMemberVO.getCode());
		userVO.setProfession(opMemberVO.getJob());
		userVO.setWeibo(opMemberVO.getAccountWeibo());
		userVO.setWeixin(opMemberVO.getAccountWechat());
		userVO.setVerifiedMobile(opMemberVO.getVerifiedMobile());
		UserProfileVO profile=new UserProfileVO();
		if(opMemberVO.getDistrictId()!=null&&opMemberVO.getDistrictId()>0){
			CommDistrictVO commonDistrict=commAddressService.findDistrictById(opMemberVO.getDistrictId().intValue());
			if(commonDistrict!=null){
				//FULL_NAME 全名，国家-省-市-区
			  String fullName=	commonDistrict.getFullName();
			  if(StringUtils.isNotBlank(fullName)){
				String []names=  fullName.split("-");
				if(names!=null&&names.length==4){
					profile.setProvince(names[1]);
					profile.setCity(names[2]);
					profile.setDistrict(names[3]);
				}
			  }
			}
		}
		profile.setName(opMemberVO.getNickName());
		profile.setStreet(opMemberVO.getAddress());
		profile.setBirthday(opMemberVO.getBirthday());
		if(opMemberVO.getTitle()==null){
			profile.setTitle(TitleEnum.UNKNOWN.getName());
		}else{
			profile.setTitle(TitleEnum.getEnumByCode(opMemberVO.getTitle()).getName());
		}
		
		profile.setZip(opMemberVO.getZipCode());
		userVO.setProfile(profile);
		
		userVO.setBirthdayDiscountYear(opMemberVO.getBirthdayDiscountYear());
		return userVO;
	}
	
	
	
	/**
	 * 获取用户等级名称
	 * @param memberLevel
	 * @return
	 */
	private String getCustLevel(Integer memberLevel){
		if(memberLevel == MemberLevelEnum.VIP.getCode()){
			return "ip";
		}
		if(memberLevel==MemberLevelEnum.VIP2.getCode()){
			return "vip";
		}
		if(memberLevel==MemberLevelEnum.VIP3.getCode()){
			return "vvip";
		}
		if(memberLevel==MemberLevelEnum.VIP4.getCode()){
			return "3vip";
		}
		return "";
	}
	
	/***
	 * 获取用户类型
	 * @param loginType
	 * @return
	 */
	private String getIdentityType(Integer loginType){
		if(LoginTypeEnum.EMAIL.getCode()==loginType){
			return "mail";
		}
		
		if(LoginTypeEnum.MOBILE.getCode()==loginType){
			return "mobile";
		}
		if(LoginTypeEnum.WEIBO.getCode()==loginType){
			return "weibo";
		}
		
		if(LoginTypeEnum.WEIXIN.getCode()==loginType){
			return "weixin";
		}
		
		return "";
	}
	
}
