package com.thebeastshop.pegasus.channelservice.adapter.website;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.wms.constant.PegasusConstants;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.channelservice.vo.website.item.ItemDescVO;
import com.thebeastshop.pegasus.channelservice.vo.website.item.ItemImage;
import com.thebeastshop.pegasus.channelservice.vo.website.item.ItemSubProd;
import com.thebeastshop.pegasus.channelservice.vo.website.item.ItemVO;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PsCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PsDynmContentVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.service.operation.model.OpProduct;

@Service("itemAdpter")
public class ItemAdpter {
	@Autowired
	private McPsProductService mcPsProductService;

	@Autowired
	private McPsSkuService mcPsSkuService;

	public String imageUrl(String imageUrl){
		String url=imageUrl;
		if(!StringUtils.isBlank(imageUrl)){
			
			if(imageUrl.indexOf("http://")>=0){
				url=imageUrl;
			}else{
			//	url="http://oss.thebeastshop.com/"+imageUrl;
				url="http://img.thebeastshop.com/"+imageUrl;
			}
			
		}
		
		return url;
	}
	
	/***
	 * 多张图片url，合并成一张url。使用逗号分隔
	 * @param imageUrls
	 * @return
	 */
	public String imageUrlString(List<String> imageUrls){
		if(CollectionUtils.isEmpty(imageUrls)){
			return null;
		}
		StringBuilder sb=new StringBuilder();
		for(String imageUrl:imageUrls){
			if(imageUrl.indexOf("http://")>=0){
				sb.append(imageUrl).append(",");
			}else{
				//sb.append("http://oss.thebeastshop.com/"+imageUrl).append(",");
				sb.append("http://img.thebeastshop.com/"+imageUrl).append(",");
			}
		}

		
		return sb.toString();
	}

	/**
	 * 获取渠道可售prod的 可售skus 的 价格区间
	 *
	 * @param productVO
	 * @param chnCode
	 * @return 返回的list，list[0]--min,list[1]--max，如果为空，就代表这个prod下，没有sku（或者可售）
	 */
	public List<Double> findMinMaxListPriceFromProd(final PsProductVO productVO, final String chnCode) {
		List<String> skuCodes;
		if (StringUtils.isBlank(chnCode)) {
			skuCodes = productVO.getSkuCodes();
		} else {
			skuCodes = productVO.getCanSaleSku(chnCode);
		}
		final List<PsSkuVO> skuVOs = mcPsSkuService.findBySkuCodes(skuCodes);
		if (CollectionUtils.isEmpty(skuVOs)) {
			return Collections.emptyList();
		}
		Double min = skuVOs.get(0).getSalesPrice();
		Double max = skuVOs.get(0).getSalesPrice();
		for (final PsSkuVO skuVO : skuVOs) {
			if (min > skuVO.getSalesPrice()) {
				min = skuVO.getSalesPrice();
			}
			if (max < skuVO.getSalesPrice()) {
				max = skuVO.getSalesPrice();
			}
		}

		return Arrays.asList(min, max);
	}

	/***
	 * 官网商品同步接口
	 * @param psProductVOs
	 * @param channelCode
	 * @return
	 * 如果product对应的sku只有一个，则sku没有父sku，如果有多个。则有根据product，封装一个父的sku
	 */
	public List<ItemVO>  common2website(List<PsProductVO> psProductVOs,String channelCode) {
		List<ItemVO> items=new ArrayList<ItemVO>();
		List<String> skuCodes = new ArrayList<>();
		for(PsProductVO product:psProductVOs){
			
			if(!product.getCombined()){
				for(String skuCode : product.getSkuCodes()){
					skuCodes.add(skuCode);
				}
				
			}
			
		}
		
		Map<String,PsSkuVO> skuMap = new HashMap<>();
		List<PsSkuVO> skuVOs = mcPsSkuService.findBySkuCodes(skuCodes);
		
		if(CollectionUtils.isNotEmpty(skuVOs)){
			for(PsSkuVO sku:skuVOs){
				skuMap.put(sku.getSkuCode(), sku);
			}
			
		}
		
		
		for(PsProductVO product:psProductVOs){
			List<String> allSkuCodes=product.getSkuCodes();
			if(CollectionUtils.isNotEmpty(allSkuCodes)){

				if(product.getCombined()){
					groupProd(items,product,channelCode,skuMap);
					continue;
				}

			  //如果只有一个sku，则没有父sku，否则，封装一个父的sku
				//根据 skuCategoryDesc 来判断是否是多个sku还是有个sku 
				if(allSkuCodes.size()==1){
					String skuCode=allSkuCodes.get(0);
					//PsSkuVO skuVO=mcPsSkuService.findBySkuCode(skuCode);
					PsSkuVO skuVO = skuMap.get(skuCode);
					if(skuVO!=null){
						ItemVO item=getSubItem(product,skuVO,false,channelCode);
						//设置手机端多张大图
						item.setWapDetailImages(imageUrlString(product.getPicDetailMuls()));
						item.setShortDescription(product.getDescription());//一句话描述
						
						// 标签
						if(!CollectionUtils.isEmpty(product.getSmallIconList())){
							String listIcon="";
							for(String icon:product.getSmallIconList()){
								
								listIcon += icon+",";
							}
							item.setListIcon(listIcon);
						}
						if (!CollectionUtils.isEmpty(product.getLargeIconList())) {
							String detailIcon = "";
							for (String icon : product.getLargeIconList()) {

								detailIcon += icon + ",";
							}
							item.setDetailIcon(detailIcon);
						}

						if(!CollectionUtils.isEmpty(product.getPsTags())){
							
							item.setTagList(JSON.toJSONString(product.getPsTags()));
						}
						
						
						items.add(item);
					}
				}else{
					//有多个sku，即有子商品。需要根据product，封装一个父sku
					ItemVO parentItem=new ItemVO();

					parentItem.setDefault_code(product.getCode());//parent sku的code就是新系统的product的code
					parentItem.setProductCode(product.getCode());
					parentItem.setDelivery_city_ids(null);//指定自送的配送城市 ,目前官网子维护
					parentItem.setDelivery_dates(null);//指定配送天数，暂时不处理
					parentItem.setId(Long.valueOf(product.getId()));//父sku的ID，对应product的ID
					parentItem.setImages(getItemImages(product));//设置父商品的图片。子商品图片为null

					//网站单独不可见。 1可见。0 不可见. 父商品根据product设置，子商品默认都不可见
//					if(CollectionUtils.isNotEmpty(product.getCanSeeSku(channelCode))&&product.getCanSeeSku(channelCode).contains(product.getCode())){
//						parentItem.setInvisible_on_web(1);
//					}else{
//						parentItem.setInvisible_on_web(0);
//					}
					parentItem.setInvisible_on_web(1);//父sku默认可见
					parentItem.setIsJit(0);//官网弃用
					//设置最大价格 只有包含多个sku的product才有价格区间
					List<Double> priceList= findMinMaxListPriceFromProd(product, channelCode);
					if(CollectionUtils.isNotEmpty(priceList)){
						parentItem.setList_price(priceList.get(0));
						parentItem.setMaxPrice(priceList.get(1));
						product.setListPrice(BigDecimal.valueOf(priceList.get(0)));//将product的listprice，设置为最低价
					}else{
						parentItem.setList_price(product.getListPrice().doubleValue());//列表价格
					}
					parentItem.setName(product.getNameCn());//中文名称
					parentItem.setPick_scope(getPickScope(product.getExpressType()));//配送方式
//					parentItem.setPoint_change_enable(0);//是否可以使用积分  积分抵扣规则，0不可抵扣1部分抵扣2全部抵扣  product不支持积分设置
					parentItem.setProd_brand(null);//品牌信息,product 默认取第一个sku的品牌信息
					parentItem.setProduct_description(getItemDesc(product));//商品描述
					parentItem.setProduct_en_name(product.getName());//英文名称
					parentItem.setRelated_prod_ids(null);//关联商品，暂时不处理
					parentItem.setRemark_enable(1);//是否可备注。在sku上。 product默认设置为不可备注 // 官网销售时是否可以备注，0表示可以，1表示不可以
					parentItem.setSale_ok(getSaleOK(product,null, channelCode));//是否上架  官网0是正常。1是下架
					parentItem.setShop_ids(getShopIds(product, channelCode));//获取销售渠道
					parentItem.setSub_prods(getSubprods(product,skuMap));//设置关联的子商品信息
					parentItem.setSubstitute_prod(-1l);//单个商品的。无parentId,默认为-1
					parentItem.setSubstitute_type(product.getSkuCategoryDesc());//关联的子商品的类型

//					parentItem.setSubstituteName(null);//子商品的具体“型号”值
					//该产品是否可以VIP打折,官网 0表示可以打折,1表示不可以打折
					if(product.getAllowVipDiscount()==PegasusConstants.YES){
						parentItem.setVip_enable(0);
						parentItem.setVip_price(getLevelPrice(product.getListPrice(),1).doubleValue());//vip价格
						parentItem.setVvip_price(getLevelPrice(product.getListPrice(),2).doubleValue());//vvip价格
					}else{
						parentItem.setVip_enable(1);
						parentItem.setVip_price(product.getListPrice().doubleValue());//vip价格
						parentItem.setVvip_price(product.getListPrice().doubleValue());//vvip价格
					}
					
					parentItem.setShortDescription(product.getDescription());//一句话描述
					
					// 标签
					if(!CollectionUtils.isEmpty(product.getSmallIconList())){
						String listIcon="";
						for(String icon:product.getSmallIconList()){
							
							listIcon += icon+",";
						}
						parentItem.setListIcon(listIcon);
					}
					if (!CollectionUtils.isEmpty(product.getLargeIconList())) {
						String detailIcon = "";
						for (String icon : product.getLargeIconList()) {

							detailIcon += icon + ",";
						}
						parentItem.setDetailIcon(detailIcon);
					}
					
					if(!CollectionUtils.isEmpty(product.getPsTags())){
						
						parentItem.setTagList(JSON.toJSONString(product.getPsTags()));
					}
					
//					if(!CollectionUtils.isEmpty(product.getCampaignList())){
//						
//						List<PsCampaignVO> prodList = product.getCampaignList();
//				        if(!CollectionUtils.isEmpty(prodList)){
//				        	List<ProductCampaignVO> pcs = new ArrayList<>();
//				        	ProductCampaignVO pc = null;
//				        	 for(PsCampaignVO bean:prodList){
//				        		 pc = new ProductCampaignVO();
//				        		 pc.setCreateTime(bean.getCreateTime());
//				        		 pc.setCumulative(bean.getCumulative());
//				        		 pc.setDiscountTypeId(bean.getDiscountTypeId());
//				        		 pc.setDiscountTypeName(bean.getDiscountTypeName());
//				        		 pc.setExpireTime(bean.getExpireTime());
//				        		 pc.setId(bean.getId());
//				        		 pc.setName(bean.getName());
//				        		 pc.setProductScopeId(bean.getProductScopeId());
//				        		 pc.setSkuCode(product.getCode());
//				        		 pc.setStartTime(bean.getStartTime());
//				        		 pc.setTitle(bean.getTitle());
//			                     pcs.add(pc);
//			                     
//			                     //设置特价
//			                     if(bean.getDiscountTypeId()!=null && bean.getDiscountTypeId()==1 && bean.getProductScopeId()!=null && bean.getProductScopeId()==1){
//			                    	if(!CollectionUtils.isEmpty(bean.getCampaignSectionList())){
//			                         	BigDecimal factor = bean.getCampaignSectionList().get(0).getFactor();
//				                    	long discountPrice = factor.multiply(BigDecimal.valueOf(100)).multiply(new BigDecimal(String.valueOf(parentItem.getList_price())).setScale(2, RoundingMode.HALF_UP)).longValue();
//				                    	parentItem.setDiscountPrice(discountPrice);
//				                    	parentItem.setDiscountLevel(JSON.toJSONString(bean.getMemberLevels()));
//				                    	parentItem.setDiscountStartTime(bean.getStartTime());
//				                    	parentItem.setDiscountEndTime(bean.getExpireTime());
//			                    	}
//			           
//			                     }
//			                     
//					         }
//				        	 
//				        	 parentItem.setCampaignListJson(JSON.toJSONString(pcs));//活动列表
//				         }

				       
					//}

					//封装子商品
					for(String skuCode:allSkuCodes){
						PsSkuVO skuVO=skuMap.get(skuCode);//mcPsSkuService.findBySkuCode(skuCode);
						if(skuVO!=null){
							ItemVO item=getSubItem(product,skuVO,true,channelCode);
							item.setSubstitute_prod(parentItem.getId());
							items.add(item);
							//设置父商品的品牌信息。取第一个sku的品牌信息
							if(skuCode.equals(allSkuCodes.get(0))){
								parentItem.setProd_brand(getProdbrand(skuVO));
								parentItem.setCrossBorderFlag(skuVO.getCrossBorderFlag());//是否跨境商品
								parentItem.setPlaceOfOrigin(skuVO.getBrandCountryName());//产地
								
							}
						}
					}
					//设置手机端多张大图
					parentItem.setWapDetailImages(imageUrlString(product.getPicDetailMuls()));

					// 品类名称;
			        if(!CollectionUtils.isEmpty(product.getFrontCategories())){
						String categoryCodes = "";
						parentItem.setFrontCategories(JSON.toJSONString(product.getFrontCategories()));
						
						for(PsCategoryVO psCategoryVO:product.getFrontCategories()){
							categoryCodes+=psCategoryVO.getCategoryCode()+",";
						}
						parentItem.setCategoryCods(categoryCodes);
					}
					
					items.add(parentItem);
				}
			}
		}
		return items;
	}

	/***
	 * 官网商品同步接口
	 * @param psProductVOs
	 * @param channelCode
	 * @return
	 * 如果product对应的sku只有一个，则sku没有父sku，如果有多个。则有根据product，封装一个父的sku
	 */
	public List<ItemVO>  common2website2(List<PsProductVO> psProductVOs,String channelCode) {
		List<ItemVO> items=new ArrayList<ItemVO>();
		for(PsProductVO product:psProductVOs){
			List<String> allSkuCodes=product.getSkuCodes();
			if(CollectionUtils.isNotEmpty(allSkuCodes)){

				if(product.getCombined()){
					groupProd(items,product,channelCode);
					continue;
				}

			  //如果只有一个sku，则没有父sku，否则，封装一个父的sku
				//根据 skuCategoryDesc 来判断是否是多个sku还是有个sku 
				if(allSkuCodes.size()==1){
					String skuCode=allSkuCodes.get(0);
					PsSkuVO skuVO=mcPsSkuService.findBySkuCode(skuCode);
					if(skuVO!=null){
						ItemVO item=getSubItem(product,skuVO,false,channelCode);
						//设置手机端多张大图
						item.setWapDetailImages(imageUrlString(product.getPicDetailMuls()));
						item.setShortDescription(product.getDescription());//一句话描述
						
						// 标签
						if(!CollectionUtils.isEmpty(product.getSmallIconList())){
							String listIcon="";
							for(String icon:product.getSmallIconList()){
								
								listIcon += icon+",";
							}
							item.setListIcon(listIcon);
						}
						if (!CollectionUtils.isEmpty(product.getLargeIconList())) {
							String detailIcon = "";
							for (String icon : product.getLargeIconList()) {

								detailIcon += icon + ",";
							}
							item.setDetailIcon(detailIcon);
						}

						if(!CollectionUtils.isEmpty(product.getPsTags())){
							
							item.setTagList(JSON.toJSONString(product.getPsTags()));
						}
						
						
						items.add(item);
					}
				}else{
					//有多个sku，即有子商品。需要根据product，封装一个父sku
					ItemVO parentItem=new ItemVO();

					parentItem.setDefault_code(product.getCode());//parent sku的code就是新系统的product的code
					parentItem.setProductCode(product.getCode());
					parentItem.setDelivery_city_ids(null);//指定自送的配送城市 ,目前官网子维护
					parentItem.setDelivery_dates(null);//指定配送天数，暂时不处理
					parentItem.setId(Long.valueOf(product.getId()));//父sku的ID，对应product的ID
					parentItem.setImages(getItemImages(product));//设置父商品的图片。子商品图片为null

					//网站单独不可见。 1可见。0 不可见. 父商品根据product设置，子商品默认都不可见
//					if(CollectionUtils.isNotEmpty(product.getCanSeeSku(channelCode))&&product.getCanSeeSku(channelCode).contains(product.getCode())){
//						parentItem.setInvisible_on_web(1);
//					}else{
//						parentItem.setInvisible_on_web(0);
//					}
					parentItem.setInvisible_on_web(1);//父sku默认可见
					parentItem.setIsJit(0);//官网弃用
					//设置最大价格 只有包含多个sku的product才有价格区间
					List<Double> priceList= findMinMaxListPriceFromProd(product, channelCode);
					if(CollectionUtils.isNotEmpty(priceList)){
						parentItem.setList_price(priceList.get(0));
						parentItem.setMaxPrice(priceList.get(1));
						product.setListPrice(BigDecimal.valueOf(priceList.get(0)));//将product的listprice，设置为最低价
					}else{
						parentItem.setList_price(product.getListPrice().doubleValue());//列表价格
					}
					parentItem.setName(product.getNameCn());//中文名称
					parentItem.setPick_scope(getPickScope(product.getExpressType()));//配送方式
//					parentItem.setPoint_change_enable(0);//是否可以使用积分  积分抵扣规则，0不可抵扣1部分抵扣2全部抵扣  product不支持积分设置
					parentItem.setProd_brand(null);//品牌信息,product 默认取第一个sku的品牌信息
					parentItem.setProduct_description(getItemDesc(product));//商品描述
					parentItem.setProduct_en_name(product.getName());//英文名称
					parentItem.setRelated_prod_ids(null);//关联商品，暂时不处理
					parentItem.setRemark_enable(1);//是否可备注。在sku上。 product默认设置为不可备注 // 官网销售时是否可以备注，0表示可以，1表示不可以
					parentItem.setSale_ok(getSaleOK(product,null, channelCode));//是否上架  官网0是正常。1是下架
					parentItem.setShop_ids(getShopIds(product, channelCode));//获取销售渠道
					parentItem.setSub_prods(getSubprods(product));//设置关联的子商品信息
					parentItem.setSubstitute_prod(-1l);//单个商品的。无parentId,默认为-1
					parentItem.setSubstitute_type(product.getSkuCategoryDesc());//关联的子商品的类型

//					parentItem.setSubstituteName(null);//子商品的具体“型号”值
					//该产品是否可以VIP打折,官网 0表示可以打折,1表示不可以打折
					if(product.getAllowVipDiscount()==PegasusConstants.YES){
						parentItem.setVip_enable(0);
						parentItem.setVip_price(getLevelPrice(product.getListPrice(),1).doubleValue());//vip价格
						parentItem.setVvip_price(getLevelPrice(product.getListPrice(),2).doubleValue());//vvip价格
					}else{
						parentItem.setVip_enable(1);
						parentItem.setVip_price(product.getListPrice().doubleValue());//vip价格
						parentItem.setVvip_price(product.getListPrice().doubleValue());//vvip价格
					}
					
					parentItem.setShortDescription(product.getDescription());//一句话描述
					
					// 标签
					if(!CollectionUtils.isEmpty(product.getSmallIconList())){
						String listIcon="";
						for(String icon:product.getSmallIconList()){
							
							listIcon += icon+",";
						}
						parentItem.setListIcon(listIcon);
					}
					if (!CollectionUtils.isEmpty(product.getLargeIconList())) {
						String detailIcon = "";
						for (String icon : product.getLargeIconList()) {

							detailIcon += icon + ",";
						}
						parentItem.setDetailIcon(detailIcon);
					}
					
					if(!CollectionUtils.isEmpty(product.getPsTags())){
						
						parentItem.setTagList(JSON.toJSONString(product.getPsTags()));
					}
					
//					if(!CollectionUtils.isEmpty(product.getCampaignList())){
//						
//						List<PsCampaignVO> prodList = product.getCampaignList();
//				        if(!CollectionUtils.isEmpty(prodList)){
//				        	List<ProductCampaignVO> pcs = new ArrayList<>();
//				        	ProductCampaignVO pc = null;
//				        	 for(PsCampaignVO bean:prodList){
//				        		 pc = new ProductCampaignVO();
//				        		 pc.setCreateTime(bean.getCreateTime());
//				        		 pc.setCumulative(bean.getCumulative());
//				        		 pc.setDiscountTypeId(bean.getDiscountTypeId());
//				        		 pc.setDiscountTypeName(bean.getDiscountTypeName());
//				        		 pc.setExpireTime(bean.getExpireTime());
//				        		 pc.setId(bean.getId());
//				        		 pc.setName(bean.getName());
//				        		 pc.setProductScopeId(bean.getProductScopeId());
//				        		 pc.setSkuCode(product.getCode());
//				        		 pc.setStartTime(bean.getStartTime());
//				        		 pc.setTitle(bean.getTitle());
//			                     pcs.add(pc);
//			                     
//			                     //设置特价
//			                     if(bean.getDiscountTypeId()!=null && bean.getDiscountTypeId()==1 && bean.getProductScopeId()!=null && bean.getProductScopeId()==1){
//			                    	if(!CollectionUtils.isEmpty(bean.getCampaignSectionList())){
//			                         	BigDecimal factor = bean.getCampaignSectionList().get(0).getFactor();
//				                    	long discountPrice = factor.multiply(BigDecimal.valueOf(100)).multiply(new BigDecimal(String.valueOf(parentItem.getList_price())).setScale(2, RoundingMode.HALF_UP)).longValue();
//				                    	parentItem.setDiscountPrice(discountPrice);
//				                    	parentItem.setDiscountLevel(JSON.toJSONString(bean.getMemberLevels()));
//				                    	parentItem.setDiscountStartTime(bean.getStartTime());
//				                    	parentItem.setDiscountEndTime(bean.getExpireTime());
//			                    	}
//			           
//			                     }
//			                     
//					         }
//				        	 
//				        	 parentItem.setCampaignListJson(JSON.toJSONString(pcs));//活动列表
//				         }

				       
					//}

					//封装子商品
					for(String skuCode:allSkuCodes){
						PsSkuVO skuVO=mcPsSkuService.findBySkuCode(skuCode);
						if(skuVO!=null){
							ItemVO item=getSubItem(product,skuVO,true,channelCode);
							item.setSubstitute_prod(parentItem.getId());
							items.add(item);
							//设置父商品的品牌信息。取第一个sku的品牌信息
							if(skuCode.equals(allSkuCodes.get(0))){
								parentItem.setProd_brand(getProdbrand(skuVO));
								parentItem.setCrossBorderFlag(skuVO.getCrossBorderFlag());//是否跨境商品
								parentItem.setPlaceOfOrigin(skuVO.getBrandCountryName());//产地
								
							}
						}
					}
					//设置手机端多张大图
					parentItem.setWapDetailImages(imageUrlString(product.getPicDetailMuls()));

					// 品类名称;
			        if(!CollectionUtils.isEmpty(product.getFrontCategories())){
						String categoryCodes = "";
						parentItem.setFrontCategories(JSON.toJSONString(product.getFrontCategories()));
						
						for(PsCategoryVO psCategoryVO:product.getFrontCategories()){
							categoryCodes+=psCategoryVO.getCategoryCode()+",";
						}
						parentItem.setCategoryCods(categoryCodes);
					}
					
					items.add(parentItem);
				}
			}
		}
		return items;
	}

	/**
	 * 根据等级取得相应的折扣
	 * @param price
	 * @param leavl
	 * @return BigDecimal
	 */
	public static BigDecimal getLevelPrice(BigDecimal price, int leavl) {

		BigDecimal discountPrice=price;
		if (discountPrice == null) {

			return new BigDecimal(0);
		}

		// vip
		if (leavl == 1) {
			discountPrice= price.multiply(new BigDecimal(0.95));
			// vvip
		} else if (leavl == 2 || leavl==3) {

			discountPrice= price.multiply(new BigDecimal(0.9));
		}
		discountPrice=discountPrice.setScale(2, RoundingMode.HALF_UP);
		return discountPrice;
	}

	/**
	 * 组合商品只同步prod
	 * @param items
	 * @param product
	 * @param channelCode
	 */
	private void groupProd(List<ItemVO> items,PsProductVO product,String channelCode,Map<String,PsSkuVO> skuMap){

		//有多个sku，即有子商品。需要根据product，封装一个父sku
		ItemVO parentItem=new ItemVO();

		parentItem.setDefault_code(product.getCode());//parent sku的code就是新系统的product的code
		parentItem.setProductCode(product.getCode());
		parentItem.setDelivery_city_ids(null);//指定自送的配送城市 ,目前官网子维护
		parentItem.setDelivery_dates(null);//指定配送天数，暂时不处理
		parentItem.setId(Long.valueOf(product.getId()));//父sku的ID，对应product的ID
		parentItem.setImages(getItemImages(product));//设置父商品的图片。子商品图片为null

		parentItem.setInvisible_on_web(1);//父sku默认可见
		parentItem.setIsJit(0);//官网弃用

		parentItem.setName(product.getNameCn());//中文名称
		parentItem.setPick_scope(getPickScope(product.getExpressType()));//配送方式
		parentItem.setProd_brand(null);//品牌信息,product 默认取第一个sku的品牌信息
		parentItem.setProduct_description(getItemDesc(product));//商品描述
		parentItem.setProduct_en_name(product.getName());//英文名称
		parentItem.setRelated_prod_ids(null);//关联商品，暂时不处理
		parentItem.setRemark_enable(1);//是否可备注。在sku上。 product默认设置为不可备注 // 官网销售时是否可以备注，0表示可以，1表示不可以
		parentItem.setSale_ok(getSaleOK(product,null, channelCode));//是否上架  官网0是正常。1是下架
		parentItem.setShop_ids(getShopIds(product, channelCode));//获取销售渠道
		parentItem.setSub_prods(getSubprods(product,skuMap));//设置关联的子商品信息
		parentItem.setSubstitute_prod(-1l);//单个商品的。无parentId,默认为-1
		parentItem.setSubstitute_type(product.getSkuCategoryDesc());//关联的子商品的类型
		parentItem.setShortDescription(product.getDescription());//一句话描述
		
		if(product.getCrossBorderFlag()!=null && product.getCrossBorderFlag()==1){
			//海淘产品
			parentItem.setCrossBorderFlag(1);
		}else{
			//海淘产品
			parentItem.setCrossBorderFlag(0);
		}

		// 标签
		if(!CollectionUtils.isEmpty(product.getSmallIconList())){
			String listIcon="";
			for(String icon:product.getSmallIconList()){

				listIcon += icon+",";
			}
			parentItem.setListIcon(listIcon);
		}
		if (!CollectionUtils.isEmpty(product.getLargeIconList())) {
			String detailIcon = "";
			for (String icon : product.getLargeIconList()) {

				detailIcon += icon + ",";
			}
			parentItem.setDetailIcon(detailIcon);
		}

		if(!CollectionUtils.isEmpty(product.getPsTags())){

			parentItem.setTagList(JSON.toJSONString(product.getPsTags()));
		}


		//设置手机端多张大图
		parentItem.setWapDetailImages(imageUrlString(product.getPicDetailMuls()));

		// 品类名称;
        if(!CollectionUtils.isEmpty(product.getFrontCategories())){
			String categoryCodes = "";
			parentItem.setFrontCategories(JSON.toJSONString(product.getFrontCategories()));

			for(PsCategoryVO psCategoryVO:product.getFrontCategories()){
				categoryCodes+=psCategoryVO.getCategoryCode()+",";
			}
			parentItem.setCategoryCods(categoryCodes);
		}
        
        if(CollectionUtils.isNotEmpty(product.getBrands())){

			String[] prod_brand=new String[2];
			prod_brand[0]=String.valueOf(product.getBrands().get(0).getBrandId());
			prod_brand[1]=product.getBrands().get(0).getBrandName();
			parentItem.setProd_brand(prod_brand);//获取品牌信息
		}

        
		items.add(parentItem);
	}
	/***
	 * //根据sku，封装item,只封装子sku和无父sku的商品
	 * @param product
	 * @param skuVO
	 * @param multiple
	 * @param channelCode
	 * @return
	 */
	private ItemVO getSubItem(PsProductVO product,PsSkuVO skuVO,boolean multiple,String channelCode){
		ItemVO item=new ItemVO();

//		if(!CollectionUtils.isEmpty(product.getCampaignList())){
//			
//			List<PsCampaignVO> prodList = product.getCampaignList();
//	        if(!CollectionUtils.isEmpty(prodList)){
//	        	List<ProductCampaignVO> pcs = new ArrayList<>();
//	        	ProductCampaignVO pc = null;
//	        	 for(PsCampaignVO bean:prodList){
//	        		 pc = new ProductCampaignVO();
//	        		 pc.setCreateTime(bean.getCreateTime());
//	        		 pc.setCumulative(bean.getCumulative());
//	        		 pc.setDiscountTypeId(bean.getDiscountTypeId());
//	        		 pc.setDiscountTypeName(bean.getDiscountTypeName());
//	        		 pc.setExpireTime(bean.getExpireTime());
//	        		 pc.setId(bean.getId());
//	        		 pc.setName(bean.getName());
//	        		 pc.setProductScopeId(bean.getProductScopeId());
//	        		 pc.setSkuCode(product.getCode());
//	        		 pc.setStartTime(bean.getStartTime());
//	        		 pc.setTitle(bean.getTitle());
//                     pcs.add(pc);
//                     
//                     //设置特价
//                     if(bean.getDiscountTypeId()!=null && bean.getDiscountTypeId()==1 && bean.getProductScopeId()!=null && bean.getProductScopeId()==1){
//                    	if(!CollectionUtils.isEmpty(bean.getCampaignSectionList())){
//                         	BigDecimal factor = bean.getCampaignSectionList().get(0).getFactor();
//	                    	long discountPrice = factor.multiply(BigDecimal.valueOf(100)).multiply(new BigDecimal(String.valueOf(item.getList_price())).setScale(2, RoundingMode.HALF_UP)).longValue();
//	                    	item.setDiscountPrice(discountPrice);
//	                    	item.setDiscountLevel(JSON.toJSONString(bean.getMemberLevels()));
//	                    	item.setDiscountStartTime(bean.getStartTime());
//	                    	item.setDiscountEndTime(bean.getExpireTime());
//                    	}
//           
//                     }
//                     
//		         }
//	        	 item.setCampaignListJson(JSON.toJSONString(pcs));//活动列表
//	         }
//
//		}
		
		
		item.setDefault_code(skuVO.getSkuCode());//skuCode
		item.setProductCode(product.getCode());
		item.setDelivery_city_ids(null);//指定自送城市,目前默认不处理
		item.setDelivery_dates(null);//指定配送天数  目前默认不处理
		item.setId(skuVO.getSkuId());//id 
		item.setCrossBorderFlag(skuVO.getCrossBorderFlag());//设置是否跨境通
		
		item.setPlaceOfOrigin(skuVO.getBrandCountryName());//产地
		
		if(!multiple){//子商品无需设置图片
			item.setImages(getItemImages(product));//设置图片
		}

		//网站单独不可见。 1可见。0 不可见
		//如果是子商品。直接设为不可见
		if(multiple){
			item.setInvisible_on_web(0);
		}else{
			//if(CollectionUtils.isNotEmpty(product.getCanSeeSku(channelCode))&&product.getCanSeeSku(channelCode).contains(skuVO.getSkuCode())){
				item.setInvisible_on_web(1);
			//}else{
				//item.setInvisible_on_web(0);
			//}
		}
		item.setIsJit(skuVO.getIsJit());//官网不不处理，字段作废
		item.setList_price(skuVO.getSalesPrice());//列表价,对外展示的价格
		item.setName(product.getNameCn());//中文名称
		item.setProduct_en_name(product.getName());//英文名称
		item.setPick_scope(getPickScope(product.getExpressType()));//根据快递方式，获取配送方式
		//是否可以使用积分  积分抵扣规则，0不可抵扣1部分抵扣2全部抵扣
		item.setPoint_change_enable(skuVO.getPointDeductRule());//积分兑换规则,官网已经修改boolean 为 Integer
		item.setPoint_price(skuVO.getPointDuductPrice().doubleValue());//积分价格
		item.setPoint_value(skuVO.getPointDeductRule().doubleValue());//积分分值
		item.setProd_brand(getProdbrand(skuVO));//获取品牌信息
		if(!multiple){
			item.setProduct_description(getItemDesc(product));//获取商品描述
		}
		item.setRelated_prod_ids(null);//关联产品。目前没有维护
		//销售时是否可以备注，官网0表示可以，1表示不可以
		if(PegasusConstants.YES==skuVO.getCanRemark()){
			item.setRemark_enable(0);
		}else{
			item.setRemark_enable(1);
		}
		item.setSale_ok(getSaleOK(product,skuVO,channelCode));//是否下架  官网0是正常。1是下架
		item.setShop_ids(getShopIds(product, channelCode));//shopIds，官网固定设置为18
		item.setSub_prods(null);//非父SKu无子商品
		item.setSubstitute_prod(-1l);//单个商品的。无parentId,默认为-1
		item.setSubstitute_type(null);//单个商品或子商品。无需设置子类型
		//当为子商品的时候，设置子商品的型号值
		if(multiple){
			item.setSubstitute_name(skuVO.getSkuCateName());//子商品的具体“型号”值
		}
		//该产品是否可以VIP打折,官网 0表示可以打折,1表示不可以打折
		if(product.getAllowVipDiscount()==PegasusConstants.YES){
			item.setVip_enable(0);
			item.setVip_price(getLevelPrice(BigDecimal.valueOf(skuVO.getSalesPrice()),1).doubleValue());//vip价格
			item.setVvip_price(getLevelPrice(BigDecimal.valueOf(skuVO.getSalesPrice()),2).doubleValue());//vvip价格
		}else{
			item.setVip_enable(1);
			item.setVip_price(skuVO.getSalesPrice());//vip价格
			item.setVvip_price(skuVO.getSalesPrice());//vvip价格
		}
		// 品类名称;
        if(!CollectionUtils.isEmpty(product.getFrontCategories())){
			String categoryCodes = "";
			item.setFrontCategories(JSON.toJSONString(product.getFrontCategories()));
			
			for(PsCategoryVO psCategoryVO:product.getFrontCategories()){
				categoryCodes+=psCategoryVO.getCategoryCode()+",";
			}
			item.setCategoryCods(categoryCodes);
		}
		return item;
	}
	
	/***
	 * 设置商品图片- 列表图，缩略图，详情图
	 * @param psProductVO
	 * @return
	 */
	private List<ItemImage> getItemImages(PsProductVO psProductVO){
		// 产品图片
		List<ItemImage> images = new ArrayList<ItemImage>();
		// 网站列表图片
		ItemImage itemImage = new ItemImage();
		itemImage.setCode("NEW_SITE_LIST_IMG");
		itemImage.setFull_url(imageUrl(psProductVO.getPicList()));
		images.add(itemImage);
		// 网站详情大图
		itemImage = new ItemImage();
		itemImage.setCode("NEW_SITE_CONTENT_IMG");
		itemImage.setFull_url(imageUrl(psProductVO.getPicDetail()));
		images.add(itemImage);
		// 网站推荐商品图
		itemImage = new ItemImage();
		itemImage.setCode("NEW_SITE_RECOMMEND_IMG");
		itemImage.setFull_url(imageUrl(psProductVO.getPicThumb()));
		images.add(itemImage);
		return images;
	}
	
	
	
	/***
	 * 获取支持的配送方式
	 * @param deliveryType
	 * @return
	 */
	private String getPickScope(Integer deliveryType){
		if(OpProduct.EP_TYPE_SELF==deliveryType){
			return "SELF";
		}else if(OpProduct.EP_TYPE_FED==deliveryType){
			return "FEDEX24";
		}
		return null;
	}
	
	/***
	 * 获取品牌信息
	 * @param skuVO
	 * @return
	 */
	private String[] getProdbrand(PsSkuVO skuVO){
		String[] prod_brand=new String[2];
		if(skuVO.getBrandId()!=null&&StringUtils.isNotBlank(skuVO.getBrandNameCN())){
			prod_brand[0]=String.valueOf(skuVO.getBrandId());
			prod_brand[1]=skuVO.getBrandNameCN();
			return prod_brand;
		}
		
		return null;
	}
	
	/***
	 * 获取商品描述
	 * @param psProductVO
	 * @return
	 */
	private List<ItemDescVO> getItemDesc(PsProductVO psProductVO){
		
		List<PsDynmContentVO> listDynmContent= psProductVO.getDynmContents();
		List<String> exitisDesc = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(listDynmContent)){
			List<ItemDescVO> product_description = new ArrayList<ItemDescVO>();
			for (PsDynmContentVO entity : listDynmContent) {
				if(exitisDesc.contains(entity.getContentType())){
					continue;
				}
				ItemDescVO itemDescVO = new ItemDescVO();
				// 描述内容
				itemDescVO.setContent(entity.getContent());
				// 描述类型名称
				itemDescVO.setEnglish_name(entity.getTitleEn());
				// 描述类型英文名称
				itemDescVO.setName(entity.getTitleCn());
				// 排序
				itemDescVO.setOrder(entity.getSort());
				// 描述类型对应的magento的字段
				itemDescVO.setMagento_field(entity.getContentType());
				exitisDesc.add(entity.getContentType());
				product_description.add(itemDescVO);
			}

			return product_description;
		}
		return null;
	}
	
	
	
	/***
	 * 获取saleOK,官网0是正常。1是下架
	 * @param psProductVO
	 * @param channelCode
	 * @return
	 */
	private int getSaleOK(PsProductVO psProductVO,PsSkuVO skuVO,String channelCode){
		List<String> onShelfChnCodes=psProductVO.getOnShelfChnCodes();
		if(CollectionUtils.isEmpty(onShelfChnCodes)){
			return 1;//不在上架渠道列表
		}
		if (CollectionUtils.isNotEmpty(onShelfChnCodes)) {
			if(skuVO==null){
				if (!onShelfChnCodes.contains(channelCode)) {
					return 1;
				}
			}else{
				if (!onShelfChnCodes.contains(channelCode)||!psProductVO.getCanSaleSku(channelCode).contains(skuVO.getSkuCode())) {
					return 1;
				}
			}

		}
		return 0;
	}
	
	/***
	 * 获取shopids，如果是官网可售，返回18
	 * @param psProductVO
	 * @param channelCode
	 * @return
	 */
	private String[] getShopIds(PsProductVO psProductVO,String channelCode){
		List<String> channelCodes=psProductVO.getChnSaleChnCodes();
		if(CollectionUtils.isNotEmpty(channelCodes)){
			if(channelCodes.contains(channelCode)){
				return new String[]{"18"};
			}
		}
		return null;
	}
	
	/***
	 * 封装父商品关联的子商品
	 * @param product
	 * @return
	 */
	private List<ItemSubProd> getSubprods(PsProductVO product,Map<String,PsSkuVO> skuMap){
		List<String> skuCodes= product.getSkuCodes();
		if(CollectionUtils.isNotEmpty(skuCodes)){
			List<ItemSubProd> sub_prods = new ArrayList<ItemSubProd>();
			for(String skuCode:skuCodes){
				PsSkuVO skuVO=skuMap.get(skuCode);//mcPsSkuService.findBySkuCode(skuCode);
				if(skuVO!=null){
					ItemSubProd subProd=new ItemSubProd();
					subProd.setProduct_tmpl_id(Long.valueOf(skuVO.getSkuId()));
					subProd.setId(Long.valueOf(skuVO.getSkuId()));
					subProd.setDefault_code(skuVO.getSkuCode());
					subProd.setSubstitute_name(skuVO.getSkuCateName());
					sub_prods.add(subProd);
				}
			}
			return sub_prods;
		}
		
		return null;
	}
	/**
	 * 组合商品只同步prod
	 * @param items
	 * @param product
	 * @param channelCode
	 */
	private void groupProd(List<ItemVO> items,PsProductVO product,String channelCode){

		//有多个sku，即有子商品。需要根据product，封装一个父sku
		ItemVO parentItem=new ItemVO();

		parentItem.setDefault_code(product.getCode());//parent sku的code就是新系统的product的code
		parentItem.setProductCode(product.getCode());
		parentItem.setDelivery_city_ids(null);//指定自送的配送城市 ,目前官网子维护
		parentItem.setDelivery_dates(null);//指定配送天数，暂时不处理
		parentItem.setId(Long.valueOf(product.getId()));//父sku的ID，对应product的ID
		parentItem.setImages(getItemImages(product));//设置父商品的图片。子商品图片为null

		parentItem.setInvisible_on_web(1);//父sku默认可见
		parentItem.setIsJit(0);//官网弃用

		parentItem.setName(product.getNameCn());//中文名称
		parentItem.setPick_scope(getPickScope(product.getExpressType()));//配送方式
		parentItem.setProd_brand(null);//品牌信息,product 默认取第一个sku的品牌信息
		parentItem.setProduct_description(getItemDesc(product));//商品描述
		parentItem.setProduct_en_name(product.getName());//英文名称
		parentItem.setRelated_prod_ids(null);//关联商品，暂时不处理
		parentItem.setRemark_enable(1);//是否可备注。在sku上。 product默认设置为不可备注 // 官网销售时是否可以备注，0表示可以，1表示不可以
		parentItem.setSale_ok(getSaleOK(product,null, channelCode));//是否上架  官网0是正常。1是下架
		parentItem.setShop_ids(getShopIds(product, channelCode));//获取销售渠道
		parentItem.setSub_prods(getSubprods(product));//设置关联的子商品信息
		parentItem.setSubstitute_prod(-1l);//单个商品的。无parentId,默认为-1
		parentItem.setSubstitute_type(product.getSkuCategoryDesc());//关联的子商品的类型
		parentItem.setShortDescription(product.getDescription());//一句话描述
		
		if(product.getCrossBorderFlag()!=null && product.getCrossBorderFlag()==1){
			//海淘产品
			parentItem.setCrossBorderFlag(1);
		}else{
			//海淘产品
			parentItem.setCrossBorderFlag(0);
		}

		// 标签
		if(!CollectionUtils.isEmpty(product.getSmallIconList())){
			String listIcon="";
			for(String icon:product.getSmallIconList()){

				listIcon += icon+",";
			}
			parentItem.setListIcon(listIcon);
		}
		if (!CollectionUtils.isEmpty(product.getLargeIconList())) {
			String detailIcon = "";
			for (String icon : product.getLargeIconList()) {

				detailIcon += icon + ",";
			}
			parentItem.setDetailIcon(detailIcon);
		}

		if(!CollectionUtils.isEmpty(product.getPsTags())){

			parentItem.setTagList(JSON.toJSONString(product.getPsTags()));
		}


		//设置手机端多张大图
		parentItem.setWapDetailImages(imageUrlString(product.getPicDetailMuls()));

		// 品类名称;
        if(!CollectionUtils.isEmpty(product.getFrontCategories())){
			String categoryCodes = "";
			parentItem.setFrontCategories(JSON.toJSONString(product.getFrontCategories()));

			for(PsCategoryVO psCategoryVO:product.getFrontCategories()){
				categoryCodes+=psCategoryVO.getCategoryCode()+",";
			}
			parentItem.setCategoryCods(categoryCodes);
		}
        
        if(CollectionUtils.isNotEmpty(product.getBrands())){

			String[] prod_brand=new String[2];
			prod_brand[0]=String.valueOf(product.getBrands().get(0).getBrandId());
			prod_brand[1]=product.getBrands().get(0).getBrandName();
			parentItem.setProd_brand(prod_brand);//获取品牌信息
		}

        
		items.add(parentItem);
	}
	
	/***
	 * 封装父商品关联的子商品
	 * @param product
	 * @return
	 */
	private List<ItemSubProd> getSubprods(PsProductVO product){
		List<String> skuCodes= product.getSkuCodes();
		if(CollectionUtils.isNotEmpty(skuCodes)){
			List<ItemSubProd> sub_prods = new ArrayList<ItemSubProd>();
			for(String skuCode:skuCodes){
				PsSkuVO skuVO=mcPsSkuService.findBySkuCode(skuCode);
				if(skuVO!=null){
					ItemSubProd subProd=new ItemSubProd();
					subProd.setProduct_tmpl_id(Long.valueOf(skuVO.getSkuId()));
					subProd.setId(Long.valueOf(skuVO.getSkuId()));
					subProd.setDefault_code(skuVO.getSkuCode());
					subProd.setSubstitute_name(skuVO.getSkuCateName());
					sub_prods.add(subProd);
				}
			}
			return sub_prods;
		}
		
		return null;
	}
	

}
