package com.thebeastshop.pegasus.channelservice.adapter.website;

import com.thebeastshop.commdata.service.CommAddressService;
import com.thebeastshop.commdata.vo.CommDistrictVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import com.thebeastshop.member.vo.MemberAddressVO;
import com.thebeastshop.pegasus.channelservice.vo.AddressVO;

/***
 * 地址addapter。做接口之间参数转换
 * 
 * @author fs
 *
 */
@Service("addressAdapter")
public class AddressAdapter {

	@Autowired
	private CommAddressService commAddressService;

	/***
	 * 外部地址转换为通用地址对象
	 * 
	 * @param addressVo
	 */
	public MemberAddressVO website2Common(AddressVO addressVo) {
		MemberAddressVO opMemberAddressVo = new MemberAddressVO();
		if (!StringUtils.isEmpty(addressVo.getStreet())
				&& !"null".equals(addressVo.getStreet())) {
			opMemberAddressVo.setAddress(addressVo.getStreet());
		}

		if (!StringUtils.isEmpty(addressVo.getCircuit())
				&& !"null".equals(addressVo.getCircuit())) {
			opMemberAddressVo.setCircuit(addressVo.getCircuit());
			opMemberAddressVo.setCircuitDesc(addressVo.getCircuit());
		}

		if (!StringUtils.isEmpty(addressVo.getCity())
				&& !"null".equals(addressVo.getCity())) {
			opMemberAddressVo.setCity(addressVo.getCity());
		}

		if (!StringUtils.isEmpty(addressVo.getCompany_name())
				&& !"null".equals(addressVo.getCompany_name())) {
			opMemberAddressVo.setCompanyName(addressVo.getCompany_name());
		}

		if (!StringUtils.isEmpty(addressVo.getDistrict())
				&& !"null".equals(addressVo.getDistrict())) {
			opMemberAddressVo.getDistrict().setName(addressVo.getDistrict());
		}

		if (!StringUtils.isEmpty(addressVo.getProvince())
				&& !"null".equals(addressVo.getProvince())) {
			opMemberAddressVo.setProvince(addressVo.getProvince());
		}

		// opMemberAddressVo.setId(addressVo.getId());

		opMemberAddressVo.getDistrict().setId(addressVo.getDistrict_id());
		opMemberAddressVo.setDistrictId(addressVo.getDistrict_id());

		//opMemberAddressVo.setMemberId(addressVo.getPartner_id());
		if (!StringUtils.isEmpty(addressVo.getZip())
				&& !"null".equals(addressVo.getZip())) {
			opMemberAddressVo.setZipCode(addressVo.getZip());
		}

		if (!StringUtils.isEmpty(addressVo.getName())
				&& !"null".equals(addressVo.getName())) {
			opMemberAddressVo.setReceiver(addressVo.getName());
		}

		if (!StringUtils.isEmpty(addressVo.getPhone())
				&& !"null".equals(addressVo.getPhone())) {
			opMemberAddressVo.setReceiverPhone(addressVo.getPhone());
		}

		opMemberAddressVo.setTitle(addressVo.getMagento_title());
		

		opMemberAddressVo.setId(addressVo.getAddr_id());
		opMemberAddressVo.setMemberId(addressVo.getMemberId());
		return opMemberAddressVo;
	}

	/***
	 * 根据通用的address对象。封装成接口参数
	 * 
	 * @param opAddressVO
	 * @return
	 */
	public AddressVO common2website(MemberAddressVO opAddressVO) {
		AddressVO addressVo = new AddressVO();
		addressVo.setMagento_title(opAddressVO.getTitle());
		addressVo.setStreet(opAddressVO.getAddress());
		//addressVo.setCircuit(opAddressVO.getCircuit());
		addressVo.setCircuit(opAddressVO.getCircuitDesc());
		addressVo.setCity(opAddressVO.getCity());
		addressVo.setCompany_name(opAddressVO.getCompanyName());
		if(opAddressVO.getDistrict()!=null){
			addressVo.setDistrict(opAddressVO.getDistrict().getName());
			addressVo.setDistrict_id(opAddressVO.getDistrict().getId());
			
			CommDistrictVO dt=commAddressService.findDistrictById(opAddressVO.getDistrict().getId().intValue());
			if(dt!=null){
				addressVo.setCityId(dt.getCityId().longValue());
			}
			
		}

		addressVo.setProvince(opAddressVO.getProvince());
		addressVo.setId(opAddressVO.getId());
		addressVo.setName(opAddressVO.getReceiver());
		addressVo.setPhone(opAddressVO.getReceiverPhone());
		addressVo.setAddr_id(opAddressVO.getId());
		
		
		addressVo.setPartner_id(opAddressVO.getMemberId());
		addressVo.setZip(opAddressVO.getZipCode());
		addressVo.setAsdefault(opAddressVO.getAsDefault() !=null && opAddressVO.getAsDefault()? 1 : 0);
		return addressVo;
	}
}
