package com.thebeastshop.pegasus.channelservice.adapter.redenvelope;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.google.common.collect.Lists;
import com.thebeastshop.common.ServiceResp;

import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.member.dto.MemberLoginQueryCondDTO;
import com.thebeastshop.member.dto.RegisterDTO;
import com.thebeastshop.member.enums.GenderEnum;
import com.thebeastshop.member.enums.LoginTypeEnum;
import com.thebeastshop.member.enums.RegisterSourceEnum;
import com.thebeastshop.member.service.MemberLoginQueryService;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.service.MemberService;
import com.thebeastshop.member.vo.MemberLoginVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.message.enums.MsgTypeEnum;
import com.thebeastshop.message.enums.PublishTypeEnum;
import com.thebeastshop.message.service.MsgSendService;
import com.thebeastshop.message.vo.SingleSmsTemplateVO;
import com.thebeastshop.pegasus.channelservice.controller.activity.ActivityController;


import com.thebeastshop.coupon.service.CpCouponSampleService;
import com.thebeastshop.coupon.service.CpCouponService;
import com.thebeastshop.coupon.vo.CpCouponSampleVO;
import com.thebeastshop.coupon.vo.CpCouponVO;
import com.thebeastshop.coupon.vo.CpFullCutPriceVO;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.exception.WrongStateException;
import com.thebeastshop.support.vo.coupon.CouponVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 红包领取适配适配层
 *
 * @author Wangyawei
 */
@Component
public class RedEnvelopeReceivedAdapter {


	private static Logger logger = LoggerFactory.getLogger(ActivityController.class);

	@Autowired
    private MemberService memberService;
    
    @Autowired
    private MemberQueryService memberQueryService;


    //private PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();
    //private PegasusMemberServiceFacade memberFacade = PegasusMemberServiceFacade.getInstance();

    @Autowired
    private CpCouponSampleService cpCouponSampleService;

    @Autowired
    private CpCouponService cpCouponService;

    private static Map<String, CpCouponSampleVO> couponMap = new HashMap<>();


	@Resource
	private MemberLoginQueryService memberLoginQueryService;



	@Autowired
	private MsgSendService msgSendService;

	/**
	 * 获取领取红包手机号
	 *
	 * @param memberId
	 * @param receivedMobile
	 * @return
	 */
	public String getReceivedMobile(Long memberId, String receivedMobile) {
		String mobile = "";
		if (!NumberUtil.isNullOrZero(memberId) && StringUtils.isBlank(receivedMobile)) {
			MemberVO member = memberQueryService.getById(memberId);
			if (member == null) {
				return null;
			}
			mobile = member.getRedenvelopeMobileWechat();
		}
		if (StringUtils.isNotEmpty(receivedMobile)) {
			mobile = receivedMobile;
		}
		logger.info("领取人手机号：" + mobile);
		return mobile;
	}


	 /**
	 * 获取领取手机号对应的会员
	 * 
	 * @param mobile
	 * @return
	 */
	public MemberVO getMemberByMobile(String mobile, String channelCode) {
		MemberVO member = null;
		if (StringUtils.isNotEmpty(mobile) && isValidPhoneNumber(mobile)) {
			MemberLoginQueryCondDTO loginCondition = new MemberLoginQueryCondDTO();
			loginCondition.setLoginType(LoginTypeEnum.MOBILE.getCode());
			loginCondition.setLoginId(mobile);
			List<MemberLoginVO> list = memberLoginQueryService.getByCond(loginCondition);
			if (CollectionUtils.isEmpty(list)) {
				RegisterDTO registerDTO = new RegisterDTO();
				registerDTO.setMobile(mobile);
				registerDTO.setNickName(mobile);
				registerDTO.setGender(GenderEnum.SECRET.getCode());
		        registerDTO.setRegisterSource(RegisterSourceEnum.UNKNOWN.getCode());
				// 设置生成的随机密码
				registerDTO.setPassword(getRandomPassword());
				registerDTO.setLoginId(mobile);
				registerDTO.setLoginType(LoginTypeEnum.MOBILE.getCode());
				registerDTO.setChannelCode(channelCode);
				logger.info("注册新会员登陆账号为{}", mobile);
				ServiceResp<MemberVO> resp = memberService.register(registerDTO);
		        if (null != resp && resp.isSuccess() && resp.getBean() != null) {
		        	MemberVO result = resp.getBean();
					logger.info("注册账号为{}新会员成功:", mobile, result);
					// 注册成功发送短信通知
					SingleSmsTemplateVO smsTemplateVO  = new SingleSmsTemplateVO();
					smsTemplateVO.setMsgTo(mobile);
					Map<String, Object> params = new HashMap<String, Object>();
					params.put("passwd", registerDTO.getPassword());
					smsTemplateVO.setTemplateName("REGISTER_SUCCESS_BS");
					smsTemplateVO.setParams(params);
					smsTemplateVO.setMsgType(MsgTypeEnum.SmsMsg);
					smsTemplateVO.setPublishType(PublishTypeEnum.IDENTIFYING_CODE);
					msgSendService.sendInterfaceVOTemplate(Arrays.asList(smsTemplateVO));

					member = memberQueryService.getById(result.getId());
				} else {
					logger.info("注册账号为{}新会员失败", mobile);
				}
			} else {
				member = memberQueryService.getById(list.get(0).getMemberId());
			}
		}
		return member;
	}

    /**
     * 发送优惠券给指定用户
     *
     * @param userId
     * @return
     */
    public CouponVO sendCoupons(Long userId, Long couponId) {
        logger.info("发送优惠券：用户id[{}]优惠券模板[{}]", userId, couponId);
        CouponVO couponVO = null;
        try {
            //获取优惠券模板
            CpCouponSampleVO couponSample = cpCouponSampleService.getCouponSampleById(couponId);
            //发放优惠券
            ServiceResp<CpCouponVO> resp = cpCouponService.send(couponSample.getId(), userId);
            if (resp.isFailure() || resp.getBean() == null) {
                logger.info("发放优惠券[{}]给userId[{}]的用户失败,"+resp.getRespMsg(), couponId, userId);
            }
            couponVO = converByCoupon(couponSample,null);
            logger.info("发放优惠券[{}]给userId[{}]的用户成功", couponId, userId);
        } catch (WrongArgException wae) {
            logger.error("发送优惠券失败：", wae);
        } catch (WrongStateException wse) {
            logger.error("发送优惠券失败：", wse);
        } catch (Exception e) {
            logger.error("发送优惠券失败：", e);
        }
		 return couponVO;
		}

	public Long getMemberIdByUnionId(String unionId) {
		MemberLoginQueryCondDTO loginCondition = new MemberLoginQueryCondDTO();
		loginCondition.setLoginTypes(Lists.newArrayList(LoginTypeEnum.WEIXIN.getCode(),LoginTypeEnum.WEIXIN_APP.getCode()));
		loginCondition.setUnionId(unionId);
		List<MemberLoginVO> list = memberLoginQueryService.getByCond(loginCondition);
		if (CollectionUtils.isEmpty(list)) {
			return null;
		} else {
			return list.get(0).getMemberId();
		}
	}


    /**
     * 发送优惠券给指定用户
     *
     * @param sampleId
     * @return
     */
    public CouponVO getCouponsBySampleId(Long sampleId,Date receiveDate) {
        logger.info("获取优惠价信息模板id：[{}]", sampleId);
        CouponVO couponVO = null;
        try {
            CpCouponSampleVO couponSample = couponMap.get(sampleId.toString());
            if(null ==couponSample){
                couponSample = cpCouponSampleService.getCouponSampleById(sampleId);
                couponMap.put(sampleId.toString(),couponSample);
            }
            //获取优惠券模板
            couponVO = converByCoupon(couponSample,receiveDate);
            logger.info("获取优惠券成功");
        } catch (WrongArgException wae) {
            logger.error("获取优惠券失败：", wae);
        } catch (Exception e) {
            logger.error("获取优惠券失败：", e);
        }
        return couponVO;
    }





	/***
	 * 获取活动页面注册用户的随机生成密码 2-9之间6位
	 * 
	 * @return
	 */
	private String getRandomPassword() {
		String IntString = "23456789";// 随机密码范围
		StringBuilder sb = new StringBuilder();
		Random random = new Random();
		// 六位随机密码
		for (int i = 0; i < 6; i++) {
			sb.append(IntString.charAt(random.nextInt(IntString.length())));
		}
		return sb.toString();
	}


	/***
	 * 校验电话号码是否非法 只校验1开头 11位数字
	 *
	 * @param phone
	 * @return
	 */
	private boolean isValidPhoneNumber(String phone) {
		Pattern p = Pattern.compile("^(1[0-9])\\d{9}$");
		Matcher m = p.matcher(phone);
		return m.matches();
	}

    /**
     * 转换优惠券
     *
     * @param couponSample
     * @return
     */
    private CouponVO converByCoupon(CpCouponSampleVO couponSample, Date receiveDate) {
        CouponVO rt = new CouponVO();
        CpFullCutPriceVO fullCutCoupon = (CpFullCutPriceVO) couponSample.getCouponContent();
        rt.setThreshold(fullCutCoupon.getFullPrice());
        rt.setThresholdDesc(fullCutCoupon.getDescription());
        rt.setDiscount(fullCutCoupon.getCutPrice());
        if(couponSample.getDateWay() != null && couponSample.getDateWay() == 2) {
            try {
                if(null == receiveDate){
                    receiveDate = new Date();
                }
                rt.setStartTime(receiveDate);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String currDateStr = dateFormat.format(receiveDate);
                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = dateFormat.parse(currDateStr + " 23:59:59");
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                cal.add(Calendar.DATE, couponSample.getDateNum());
                rt.setExpireTime(cal.getTime());
            } catch (Exception e) {
            }
        }else{
            rt.setStartTime(couponSample.getStartTime());
            rt.setExpireTime(couponSample.getExpireTime());
        }
        rt.setTitle(couponSample.getTitle());
        rt.setDescription(couponSample.getDescription());
        rt.setProductDesc(couponSample.getProductDesc());
        rt.setNote(couponSample.getNote());
        return rt;
    }

}
