package com.thebeastshop.pegasus.channelservice.adapter.redenvelope;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.google.gson.GsonBuilder;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.service.MemberService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.enums.OrderFlowState;
import com.thebeastshop.pegasus.channelservice.enums.OrderParcelState;
import com.thebeastshop.pegasus.channelservice.model.OrderRedEnvelope;
import com.thebeastshop.pegasus.component.redenvelope.business.IRedEnvelopeShareService;
import com.thebeastshop.pegasus.component.redenvelope.domain.RedEnvelopeDTO;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelope;
import com.thebeastshop.pegasus.component.redenvelope.service.RedEnvelopeService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.component.support.Res;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageDeliveryInfoVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageVO;
import com.thebeastshop.pegasus.service.operation.model.OpSalesOrder;
import com.thebeastshop.support.util.EnumUtil;
import com.thebeastshop.support.util.JsonUtil;
import com.thebeastshop.support.vo.redenvelope.RedEnvelopeConfig;

/**
 * 红包适配层
 *
 * @author Wangyawei
 */
@Component
public class RedEnvelopeAdapter {

	protected Logger logger = LoggerFactory.getLogger(getClass());

	private RedEnvelopeService redEnveloperService = ComponentServiceLoader.getBean(RedEnvelopeService.class);
	private IRedEnvelopeShareService iRedEnvelopeShareService = ComponentServiceLoader
			.getBean(IRedEnvelopeShareService.class);

	private final PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();

	@Autowired
	private MemberQueryService memberQueryService;

	@Autowired
	private MemberService memberService;

	private String reDesc = "满200 减 20"; // 红包描述
	private String reName = "刮刮乐后分享红包"; // 红包名字

	// private String redEnvelopeFlower_desc = "月送鲜花红包描述"; // 月送鲜花红包描述
	// private String redEnvelopeFlower_name = "月送鲜花红包名字"; // 红包名字
	// private String redEnvelopeFlower_id = "315"; // 优惠券id
	// private Integer redEnvelopeFlower_amount = 10; // 优惠券数量

	private String redEnvelopeFlower_desc = ""; // 月送鲜花红包描述
	private String redEnvelopeFlower_name = ""; // 月送鲜花红包名字
	private String redEnvelopeFlower_id = ""; // 月送鲜花优惠券id
	private Integer redEnvelopeFlower_amount;// 月送鲜花优惠券数量

	private Integer templateId = 1; // 模板id

	/**
	 * 验证订单是否可创建红包 (付款成功并且不为取消状态的情况)
	 *
	 * @param orderId
	 * @param memberCode
	 * @return
	 */
	public OrderRedEnvelope getOrderState(String orderId, String memberCode) {
		OrderRedEnvelope result = new OrderRedEnvelope();

		String startTime = "2017-1-5 10:00:00";
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date date = new Date();
		try {
			date = dateFormat.parse(startTime);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// 根据订单id查询订单
		OpSalesOrderVO order = pcInstance.orderDetail(memberCode, orderId);
		Boolean state = false;
		// 验证订单是否是本人的
		if (order != null && order.getMemberCode().equals(memberCode) && null != order.getPayTime()) {
			if (order.getPayTime().compareTo(date) > 0) {
				OrderFlowState flowState = EnumUtil.valueOf(order.getSalesOrderStatus(), OrderFlowState.class);
				switch (flowState) {
				case CREATED:
				case CUSTOMER_HUNG_UP:
				case CONFIRMED:
					state = false;
					break;
				case AUDIT_HUNG_UP:
				case PAID:
					state = true;
					break;
				case DONE:
					state = true;
					break;
				case CANCELLED:
					state = false;
					break;
				default:
					boolean isDelivering = false;
					List<OpSoPackageVO> parcels = order.getOpSoPackageVOs();
					for (OpSoPackageVO parcel : parcels) {
						OrderParcelState parcelState = EnumUtil.valueOf(parcel.getPackageStatus(),
								OrderParcelState.class);
						if (parcelState != null && (parcelState.equals(OrderParcelState.WAITING_RECEIVE)
								|| parcelState.equals(OrderParcelState.ALREADY_RECEIVE)
								|| parcelState.equals(OrderParcelState.ALREADY_DELIVER))) {
							isDelivering = true;
						}
					}
					if (isDelivering) {
						state = true;
					} else {
						state = true;
					}
					break;
				}
			}
		}
		result.setOrderCode(orderId);
		result.setCanDraw(state);
		if (state) {
			logger.info("订单[{}] 是否海淘：{}", order.getCode(), order.getCrossBorderFlag());
			result.setOverSea(order.getCrossBorderFlag() == 1);
			
			if(order.getOpSoPackageVOs().get(0).getOpSoPackageDeliveryInfoVO() != null){
				try {
					OpSoPackageDeliveryInfoVO deliveryInfoVO = order.getOpSoPackageVOs().get(0)
							.getOpSoPackageDeliveryInfoVO();
					result.setDistrictId(deliveryInfoVO.getDistrictId().toString());
					result.setOrderCityName(deliveryInfoVO.getCity());
				} catch (Exception e) {
					logger.warn("获取订单地址信息异常：", e);
				}
			}
			
			
		}

		logger.info("获取订单红包抽奖信息：{}", result);
		return result;
	}

	/**
	 * 验证是否存在红包
	 *
	 * @param orderId
	 * @return
	 */
	private String getRedEnvelope(String orderId, String memberCode) {
		String id = "";
		RedEnvelopeDTO red = new RedEnvelopeDTO();
		red = redEnveloperService.getRedEnvelopeByOrder(orderId, memberCode);
		if (null != red) {
			id = red.getId().toString();
		}
		return id;
	}

	/**
	 * 创建一个新红包
	 *
	 * @param orderId
	 *            ,memberCode
	 * @return record
	 */
	private RedEnvelope newRedEnvelope(String orderId, String memberCode, Long memberId) {
		RedEnvelope record = new RedEnvelope();
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date sdate = new Date();
		Date edate = new Date();
		String tempConfig = PropConstants.getProperties("redEnvelope.template.config","");
		logger.info("redEnvelope.template.config ={}", tempConfig);
		if (StringUtils.isNotEmpty(tempConfig) && !StringUtils.isEquals(tempConfig.trim(), "null")) {
			logger.info("生成随机红包红包");
			RedEnvelopeConfig config = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create()
					.fromJson(tempConfig, RedEnvelopeConfig.class);
			if (null != config) {
				MemberVO member = new MemberVO();
				member.setId(memberId);
				member.setCode(memberCode);
				Res<Long> result = iRedEnvelopeShareService.createRedEnvelopeActivity(config, member, orderId);
				record.setId(result.getData());
				return record;
			}
		} else {
			logger.info("生成固定红包");
			try {
				String startTime = PropConstants.getProperties("reStartTime","2017-1-5 10:00:00");
				String endTime = PropConstants.getProperties("reEndTime","2017-12-31 23:59:59");
				sdate = dateFormat.parse(startTime);
				edate = dateFormat.parse(endTime);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			record.setCreateTime(Calendar.getInstance().getTime());
			record.setMemberCode(memberCode);
			record.setMemberId(memberId.toString());
			record.setBindId(orderId);
			String reAmount = PropConstants.getProperties("reAmount","20");
			record.setReAmount(Integer.valueOf(reAmount));
			record.setReDesc(reDesc);
			record.setReleasedCount(0);// 新建，已发放0
			record.setReName(reName);
			record.setReType(1);// 优惠券1
			String reValue =  PropConstants.getProperties("reValue","224");
			record.setReValue(reValue);
			record.setStartTime(sdate);
			record.setEndTime(edate);
			record.setType("1");// 订单红包
			redEnveloperService.newRedEnvelopeByOrder(record);
		}
		logger.info("生成红包信息 ={}", JsonUtil.toJson(record));
		return record;
	}

	/**
	 * 更新会员领微信手机号
	 *
	 * @param mobile
	 *            ,memberId
	 * @return
	 */
	public Boolean updateMobile(String mobile, Long memberId) {
		MemberVO member = memberQueryService.getById(memberId);
		member.setRedenvelopeMobileWechat(mobile);
		Boolean status = false;
		ServiceResp<Object> rt = memberService.modifyMember(member);
		if (rt != null && rt.isSuccess()) {
			status = true;
		}
		return status;
	}

	/**
	 * 根据订单号创建一个分享红包
	 *
	 * @param orderId
	 * @return
	 */
	public RedEnvelope createRedEnvenlope(String orderId, String memberCode, Long memberId) {
		String id = "";
		RedEnvelope redEnvelope = new RedEnvelope();
		// 验证订单是否有效
		OrderRedEnvelope status = getOrderState(orderId, memberCode);
		if (status.isCanDraw()) {
			RedEnvelopeDTO red = redEnveloperService.getRedEnvelopeByOrder(orderId, memberCode);
			if (null != red && null != red.getId()) {
				redEnvelope.setId(red.getId());
				redEnvelope.setTemplateId(red.getTemplateId());
				id = red.getId().toString();
			}
			if (null == id || id.equals("")) {
				redEnvelope = newRedEnvelope(orderId, memberCode, memberId);
			}
		} else {
			RedEnvelopeDTO red = redEnveloperService.getRedEnvelopeByOrder(orderId, memberCode);
			if (null != red && null != red.getId()) {
				redEnvelope.setId(red.getId());
				redEnvelope.setTemplateId(red.getTemplateId());
			}
		}
		return redEnvelope;
	}

	// public static void main(String[] args) {
	// System.out.printf("——————————————————————————");
	//
	// String tempConfig =
	// "{ \"activityType\": \"1\", \"reEndTime\": \"2017-12-31 23: 59: 59\",
	// \"reStartTime\": \"2017-01-01 00: 00: 00\", \"redGroup\": [ {
	// \"cutPrice\": 1, \"redDesc\": \"12元随机金额红包\", \"redName\": \"满200减1\",
	// \"redValue\": \"246\" }, { \"cutPrice\": 2, \"redDesc\": \"12元随机金额红包\",
	// \"redName\": \"满300减2\", \"redValue\": \"247\" }, { \"cutPrice\": 3,
	// \"redDesc\": \"12元随机金额红包\", \"redName\": \"满400减3\", \"redValue\":
	// \"248\" }, { \"cutPrice\": 4, \"redDesc\": \"12元随机金额红包\", \"redName\":
	// \"满500减20\", \"redValue\": \"249\" } ], \"redTotalNum\": 5, \"redType\":
	// 1, \"templateId\": 2, \"templateType\": 2, \"totalCutPrice\": 12 }";
	// RedEnvelopeConfig config = new
	// GsonBuilder().setDateFormat("yyyy-MM-dd
	// HH:mm:ss").create().fromJson(tempConfig,RedEnvelopeConfig.class);
	// JSONArray array = com.alibaba.fastjson.JSON.parseArray(tempConfig);
	// array.getString("")
	// System.out.println(config.toString());
	// }

	/**
	 * 创建一个新红包
	 *
	 * @param orderId
	 *            ,memberCode
	 * @return record
	 */
	private RedEnvelope newRedEnvelopeForFlowerOrder(String orderId, String memberCode, Long memberId) {
		//initFlowerRedConfig();
		RedEnvelope record = new RedEnvelope();
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date sdate = new Date();
		Date edate = new Date();
		logger.info("月送鲜花红包");
		try {
			String startTime = "2017-1-5 10:00:00";
			String endTime = "2017-12-31 23:59:59";
			sdate = dateFormat.parse(startTime);
			edate = dateFormat.parse(endTime);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		record.setCreateTime(Calendar.getInstance().getTime());
		record.setMemberCode(memberCode);
		record.setMemberId(memberId.toString());
		record.setBindId(orderId);
		record.setReAmount(redEnvelopeFlower_amount);
		record.setReDesc(redEnvelopeFlower_desc);
		record.setReleasedCount(0);// 新建，已发放0
		record.setReName(redEnvelopeFlower_name);
		record.setReType(1);// 优惠券1
		record.setReValue(redEnvelopeFlower_id);
		record.setStartTime(sdate);
		record.setEndTime(edate);
		record.setType("1");// 订单红包
		record.setTemplateId(templateId);
		redEnveloperService.newRedEnvelopeByOrder(record);
		logger.info("生成红包信息 ={}", JsonUtil.toJson(record));

		return record;
	}

//	private void initFlowerRedConfig() {
//		redEnvelopeFlower_desc = configurer.getProperty("redEnvelopeFlower_desc", ""); // 月送鲜花红包描述
//		redEnvelopeFlower_name = configurer.getProperty("redEnvelopeFlower_name", ""); // 月送鲜花红包名字
//		redEnvelopeFlower_id = configurer.getProperty("redEnvelopeFlower_id", ""); // 月送鲜花优惠券id
//		redEnvelopeFlower_amount = Integer.parseInt(configurer.getProperty("redEnvelopeFlower_amount", "0"));// 月送鲜花优惠券数量
//
//	}
}
